/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.sandbox.layer;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class NoiseLayerSelector {
    private final DensityFunction[] densities;

    public NoiseLayerSelector(List<DensityFunction> densities, RandomSource random) {
        if (densities.isEmpty()) {
            throw new IllegalArgumentException("No elements");
        }
        this.densities = new DensityFunction[densities.size()];
        for (int i = 0; i < this.densities.length; ++i) {
            this.densities[i] = this.createDensity(densities.get(i), random);
        }
    }

    public int sample(int x, int y, int z, boolean[] allow) {
        DensityFunction.SinglePointContext context = new DensityFunction.SinglePointContext(x, y, z);
        double max = Double.NEGATIVE_INFINITY;
        int maxIdx = 0;
        for (int i = 0; i < this.densities.length; ++i) {
            double v;
            if (!allow[i] || !((v = this.densities[i].m_207386_((DensityFunction.FunctionContext)context)) > max)) continue;
            max = v;
            maxIdx = i;
        }
        return maxIdx;
    }

    private DensityFunction createDensity(DensityFunction density, RandomSource random) {
        final long seed = random.m_188505_() ^ 0x1E6AC71A7E85E1ECL;
        final HashMap wrappedDensities = new HashMap();
        return density.m_207456_(new DensityFunction.Visitor(){

            @Nonnull
            public DensityFunction m_214017_(@Nonnull DensityFunction density) {
                return wrappedDensities.computeIfAbsent(density, k -> {
                    if (density instanceof DensityFunctions.HolderHolder) {
                        DensityFunctions.HolderHolder holder = (DensityFunctions.HolderHolder)density;
                        return (DensityFunction)holder.f_208636_().m_203334_();
                    }
                    if (density instanceof DensityFunctions.MarkerOrMarked) {
                        DensityFunctions.MarkerOrMarked marker = (DensityFunctions.MarkerOrMarked)density;
                        return marker.m_207056_();
                    }
                    return density;
                });
            }

            @Nonnull
            public DensityFunction.NoiseHolder m_213918_(@Nonnull DensityFunction.NoiseHolder noise) {
                long xor = noise.f_223997_().m_203543_().map(key -> (long)key.m_135782_().m_135827_().hashCode() << 32 | (long)key.m_135782_().m_135815_().hashCode()).orElse(42L);
                return new DensityFunction.NoiseHolder(noise.f_223997_(), NormalNoise.m_230511_((RandomSource)RandomSource.m_216335_((long)(seed ^ xor)), (NormalNoise.NoiseParameters)((NormalNoise.NoiseParameters)noise.f_223997_().get())));
            }
        });
    }
}

