/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.datagen.registries;

import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.moddingx.libx.datagen.DatagenStage;
import org.moddingx.libx.datagen.DatagenSystem;
import org.moddingx.libx.datagen.PackTarget;
import org.moddingx.libx.datagen.RegistrySet;
import org.moddingx.libx.impl.datagen.load.DatagenRegistryLoader;
import org.moddingx.libx.impl.datagen.registries.DatagenRegistry;

public class DatagenRegistrySet
implements RegistrySet {
    private final RegistryAccess rootAccess;
    private final DatagenRegistrySet root;
    private final List<DatagenRegistrySet> parents;
    private final List<DatagenRegistrySet> children;
    private final Map<Holder.Reference<?>, ResourceKey<? extends Registry<?>>> holderMap;
    private DatagenStage stage;
    private final Map<ResourceKey<? extends Registry<?>>, DatagenRegistry<?>> registries;
    private RegistryAccess localAccess;

    public DatagenRegistrySet(RegistryAccess access) {
        this.rootAccess = access;
        this.root = this;
        this.parents = List.of();
        this.children = new ArrayList<DatagenRegistrySet>();
        this.holderMap = new HashMap();
        this.stage = DatagenStage.REGISTRY_SETUP;
        this.registries = new HashMap();
        this.localAccess = null;
    }

    public DatagenRegistrySet(List<DatagenRegistrySet> parents) {
        if (parents.isEmpty()) {
            throw new IllegalArgumentException("Registry set needs at least one parent");
        }
        this.parents = List.copyOf(parents);
        this.children = new ArrayList<DatagenRegistrySet>();
        List<DatagenRegistrySet> roots = this.parents.stream().map(set -> set.root).distinct().toList();
        if (roots.size() != 1) {
            throw new IllegalArgumentException("Registry set can only have a single root");
        }
        this.root = roots.get(0);
        this.rootAccess = this.root.rootAccess;
        for (DatagenRegistrySet parent : this.parents) {
            if (parent.stage != DatagenStage.REGISTRY_SETUP) {
                throw new IllegalStateException("New registry sets ca only be created in registry setup phase");
            }
            parent.children.add(this);
        }
        this.holderMap = new HashMap();
        this.stage = DatagenStage.REGISTRY_SETUP;
        this.registries = new HashMap();
        this.localAccess = null;
    }

    public boolean isRoot() {
        return this.root == this;
    }

    public List<DatagenRegistrySet> getDirectParents() {
        return this.parents;
    }

    public List<DatagenRegistrySet> getDirectChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public <T> Registry<T> registry(ResourceKey<? extends Registry<T>> registryKey) {
        Optional<DatagenRegistry<T>> writable = this.getDatagenRegistry(registryKey, false);
        if (writable.isPresent()) {
            return (Registry)writable.get();
        }
        return (Registry)this.rootAccess.m_6632_(registryKey).orElseThrow(() -> new NoSuchElementException("Registry not known: " + registryKey));
    }

    @Override
    public <T> WritableRegistry<T> writableRegistry(ResourceKey<? extends Registry<T>> registryKey) {
        if (this.isRoot()) {
            throw new IllegalStateException("The root registry set can't be used to query writeable registries");
        }
        return (WritableRegistry)this.getDatagenRegistry(registryKey, true).orElseThrow(() -> new IllegalStateException("Can't write to registry " + registryKey + " during " + this.stage + " phase"));
    }

    @Override
    public RegistryAccess registryAccess() {
        if (this.localAccess == null) {
            throw new IllegalStateException("Can't query datagen registry access in " + this.stage + " stage.");
        }
        return this.localAccess;
    }

    @Override
    @Nullable
    public <T> ResourceKey<? extends Registry<T>> findRegistryFor(Holder.Reference<T> holder) {
        return this.holderMap.getOrDefault(holder, null);
    }

    public <T> Optional<DatagenRegistry<T>> getDatagenRegistry(ResourceKey<? extends Registry<T>> registryKey, boolean forWrite) {
        if (forWrite && this.stage == DatagenStage.DATAGEN) {
            return Optional.empty();
        }
        Optional<RegistryDataLoader.RegistryData> data = DatagenRegistryLoader.getDataPackRegistries(null).stream().filter(rd -> Objects.equals(rd.f_243794_(), registryKey)).findFirst();
        if (data.isEmpty()) {
            return Optional.empty();
        }
        if (forWrite && DatagenSystem.extensionRegistries().contains(registryKey) != (this.stage == DatagenStage.EXTENSION_SETUP)) {
            return Optional.empty();
        }
        if (this.isRoot()) {
            return Optional.of(this.registries.computeIfAbsent(registryKey, k -> {
                DatagenRegistry reg = DatagenRegistry.createRoot(registryKey, this, ((RegistryDataLoader.RegistryData)data.get()).f_244580_(), (Registry)this.rootAccess.m_6632_(registryKey).orElseThrow(() -> new IllegalStateException("Could not setup " + registryKey + " registry: Root registry not available")));
                reg.m_203521_();
                return reg;
            }));
        }
        return Optional.of(this.registries.computeIfAbsent(registryKey, k -> {
            DatagenRegistry reg = DatagenRegistry.create(registryKey, this, ((RegistryDataLoader.RegistryData)data.get()).f_244580_(), this.getDirectParents().stream().map(parent -> parent.getDatagenRegistry(registryKey, false).orElseThrow(() -> new IllegalStateException("Could not setup " + registryKey + " registry: Parent registry not available"))).toList());
            if (this.shouldBeFrozen(this.stage, registryKey)) {
                reg.m_203521_();
            }
            return reg;
        }));
    }

    public <T> Set<DatagenRegistry<T>> collectActiveChildRegistries(ResourceKey<? extends Registry<T>> registryKey) {
        HashSet<DatagenRegistry<T>> registries = new HashSet<DatagenRegistry<T>>();
        this.addActiveChildRegistries(registryKey, registries);
        return Collections.unmodifiableSet(registries);
    }

    private <T> void addActiveChildRegistries(ResourceKey<? extends Registry<T>> registryKey, Set<DatagenRegistry<T>> registries) {
        for (DatagenRegistrySet child : this.getDirectChildren()) {
            if (child.registries.containsKey(registryKey)) {
                registries.add(child.registries.get(registryKey));
            }
            child.addActiveChildRegistries(registryKey, registries);
        }
    }

    public <T> void trackHolderTarget(Holder.Reference<T> holder, ResourceKey<? extends Registry<T>> registryKey) {
        this.holderMap.put(holder, registryKey);
    }

    public void transition(DatagenStage stage) {
        if (!this.isRoot()) {
            throw new IllegalStateException("Stage transitions must happen on the root registry set");
        }
        this.doTransitionSelf(stage);
        this.doTransitionChildrenAfterSelf();
        this.checkTransition(stage);
    }

    private void checkTransition(DatagenStage newStage) {
        if (this.stage != newStage) {
            throw new IllegalStateException("Datagen registry stage transition failed on " + this + " (root=" + this.root + ").");
        }
        for (DatagenRegistrySet set : this.getDirectChildren()) {
            set.checkTransition(newStage);
        }
    }

    private void doTransitionSelf(DatagenStage newStage) {
        DatagenStage oldStage = this.stage;
        if (oldStage.ordinal() == 0 && newStage.ordinal() == 0) {
            return;
        }
        if (oldStage.ordinal() + 1 != newStage.ordinal()) {
            throw new IllegalArgumentException("Invalid transition: " + oldStage + " -> " + newStage);
        }
        for (DatagenRegistry<?> registry : this.registries.values()) {
            if (!this.shouldBeFrozen(newStage, registry.m_123023_())) continue;
            registry.m_203521_();
        }
        this.stage = newStage;
        if (newStage == DatagenStage.DATAGEN) {
            this.localAccess = RegistryAccess.m_206165_(this.makeRegistryOfRegistries());
        }
    }

    private void doTransitionChildrenAfterSelf() {
        List<DatagenRegistrySet> allChildrenToTransition = this.getDirectChildren().stream().filter(child -> child.stage != this.stage).toList();
        ArrayList<DatagenRegistrySet> childrenLeft = new ArrayList<DatagenRegistrySet>(allChildrenToTransition);
        while (!childrenLeft.isEmpty()) {
            boolean deadCycle = true;
            Iterator itr = childrenLeft.iterator();
            while (itr.hasNext()) {
                DatagenRegistrySet set = (DatagenRegistrySet)itr.next();
                if (!set.getDirectParents().stream().allMatch(parent -> parent.stage == this.stage)) continue;
                set.doTransitionSelf(this.stage);
                deadCycle = false;
                itr.remove();
            }
            if (!deadCycle) continue;
            throw new IllegalStateException("Dead cycle in datagen registry state transition detected.");
        }
        for (DatagenRegistrySet set : allChildrenToTransition) {
            set.doTransitionChildrenAfterSelf();
        }
    }

    private boolean shouldBeFrozen(DatagenStage stage, ResourceKey<? extends Registry<?>> registryKey) {
        return switch (stage) {
            default -> throw new IncompatibleClassChangeError();
            case DatagenStage.REGISTRY_SETUP -> false;
            case DatagenStage.EXTENSION_SETUP -> {
                if (!DatagenSystem.extensionRegistries().contains(registryKey)) {
                    yield true;
                }
                yield false;
            }
            case DatagenStage.DATAGEN -> true;
        };
    }

    private Registry<? extends Registry<?>> makeRegistryOfRegistries() {
        MappedRegistry rootRegistry = new MappedRegistry(ResourceKey.m_135788_((ResourceLocation)BuiltInRegistries.f_256779_), Lifecycle.stable());
        for (ResourceKey key : this.rootAccess.m_206193_().map(RegistryAccess.RegistryEntry::f_206233_).toList()) {
            rootRegistry.m_255290_(key, this.registry(key), Lifecycle.stable());
        }
        return rootRegistry;
    }

    public void writeElements(PackTarget target, CachedOutput output) {
        if (this.isRoot()) {
            throw new IllegalStateException("The root registry set can't write elements.");
        }
        if (this.stage != DatagenStage.DATAGEN) {
            throw new IllegalStateException("Can't serialize registries during " + this.stage + " phase.");
        }
        for (DatagenRegistry<?> registry : this.registries.values()) {
            registry.writeOwnElements(target, output);
        }
    }
}

