/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import lombok.Generated;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class OverlayingFluidStorage
implements IFluidHandlerModifiable,
IFluidTank {
    private final IFluidHandlerModifiable handler;
    private final int tank;

    @NotNull
    public FluidStack getFluid() {
        return this.handler.getFluidInTank(this.tank);
    }

    public int getFluidAmount() {
        return this.getFluid().getAmount();
    }

    public int getCapacity() {
        return this.handler.getTankCapacity(this.tank);
    }

    public int getTankCapacity(int tank) {
        return this.getCapacity();
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    @Override
    public void setFluidInTank(int tank, FluidStack stack) {
        this.handler.setFluidInTank(tank, stack);
    }

    public int getTanks() {
        return 1;
    }

    public boolean isFluidValid(FluidStack stack) {
        return this.isFluidValid(this.tank, stack);
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.handler.isFluidValid(tank, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        IFluidHandlerModifiable iFluidHandlerModifiable = this.handler;
        if (iFluidHandlerModifiable instanceof NotifiableFluidTank) {
            NotifiableFluidTank notifiable = (NotifiableFluidTank)iFluidHandlerModifiable;
            return notifiable.getStorages()[this.tank].fill(resource, action);
        }
        return this.handler.fill(resource, action);
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        IFluidHandlerModifiable iFluidHandlerModifiable = this.handler;
        if (iFluidHandlerModifiable instanceof NotifiableFluidTank) {
            NotifiableFluidTank notifiable = (NotifiableFluidTank)iFluidHandlerModifiable;
            return notifiable.getStorages()[this.tank].drain(resource, action);
        }
        return this.handler.drain(resource, action);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        IFluidHandlerModifiable iFluidHandlerModifiable = this.handler;
        if (iFluidHandlerModifiable instanceof NotifiableFluidTank) {
            NotifiableFluidTank notifiable = (NotifiableFluidTank)iFluidHandlerModifiable;
            return notifiable.getStorages()[this.tank].drain(maxDrain, action);
        }
        return this.handler.drain(maxDrain, action);
    }

    @Generated
    public OverlayingFluidStorage(IFluidHandlerModifiable handler, int tank) {
        this.handler = handler;
        this.tank = tank;
    }
}

