/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.top.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.steam.SteamMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.integration.top.provider.CapabilityInfoProvider;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class RecipeLogicInfoProvider
extends CapabilityInfoProvider<RecipeLogic> {
    public ResourceLocation getID() {
        return GTCEu.id("recipe_logic_provider");
    }

    @Override
    @Nullable
    protected RecipeLogic getCapability(Level level, BlockPos pos, @Nullable Direction side) {
        return GTCapabilityHelper.getRecipeLogic(level, pos, side);
    }

    @Override
    protected void addProbeInfo(RecipeLogic capability, IProbeInfo probeInfo, Player player, BlockEntity blockEntity, IProbeHitData data) {
        GTRecipe recipe;
        if (capability.isWorking() && (recipe = capability.getLastRecipe()) != null) {
            IMachineBlockEntity machineBlockEntity;
            MetaMachine machine;
            long EUt = RecipeHelper.getInputEUt(recipe);
            boolean isInput = true;
            if (EUt == 0L) {
                isInput = false;
                EUt = RecipeHelper.getOutputEUt(recipe);
            }
            long absEUt = Math.abs(EUt);
            String text = null;
            if (blockEntity instanceof IMachineBlockEntity && (machine = (machineBlockEntity = (IMachineBlockEntity)blockEntity).getMetaMachine()) instanceof SteamMachine) {
                text = ChatFormatting.RED.toString() + absEUt + String.valueOf(TextStyleClass.INFO) + " mB/t " + LocalizationUtils.format((String)"material.steam", (Object[])new Object[0]);
            }
            if (text == null) {
                text = ChatFormatting.RED.toString() + absEUt + String.valueOf(TextStyleClass.INFO) + " EU/t" + String.valueOf(ChatFormatting.GREEN) + " (" + GTValues.VNF[GTUtil.getTierByVoltage(absEUt)] + String.valueOf(ChatFormatting.GREEN) + ")";
            }
            if (EUt > 0L) {
                if (isInput) {
                    probeInfo.text(CompoundText.create().text((Component)Component.m_237115_((String)"gtceu.top.energy_consumption").m_130946_(" ").m_130946_(text)).style(TextStyleClass.INFO));
                } else {
                    probeInfo.text(CompoundText.create().text((Component)Component.m_237115_((String)"gtceu.top.energy_production").m_130946_(" ").m_130946_(text)).style(TextStyleClass.INFO));
                }
            }
        }
    }
}

