/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.map.xaeros.minimap.ore;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconType;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVeinMetadata;
import com.gregtechceu.gtceu.client.util.DrawUtil;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.integration.map.GroupingMapRenderer;
import com.gregtechceu.gtceu.integration.map.xaeros.minimap.ore.OreVeinElement;
import com.gregtechceu.gtceu.integration.map.xaeros.minimap.ore.OreVeinElementContext;
import com.gregtechceu.gtceu.integration.map.xaeros.minimap.ore.OreVeinElementReader;
import com.gregtechceu.gtceu.integration.map.xaeros.minimap.ore.OreVeinElementRenderProvider;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.hud.minimap.element.render.MinimapElementReader;
import xaero.hud.minimap.element.render.MinimapElementRenderInfo;
import xaero.hud.minimap.element.render.MinimapElementRenderLocation;
import xaero.hud.minimap.element.render.MinimapElementRenderProvider;
import xaero.hud.minimap.element.render.MinimapElementRenderer;

public class OreVeinElementRenderer
extends MinimapElementRenderer<OreVeinElement, OreVeinElementContext> {
    protected static final ResourceLocation STONE = new ResourceLocation("block/stone");

    private OreVeinElementRenderer(OreVeinElementReader elementReader, OreVeinElementRenderProvider provider, OreVeinElementContext context) {
        super((MinimapElementReader)elementReader, (MinimapElementRenderProvider)provider, (Object)context);
    }

    public void preRender(MinimapElementRenderInfo renderInfo, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers) {
    }

    public boolean renderElement(OreVeinElement element, boolean highlit, boolean outOfBounds, double optionalDepth, float optionalScale, double partialX, double partialY, MinimapElementRenderInfo renderInfo, GuiGraphics graphics, MultiBufferSource.BufferSource renderTypeBuffers) {
        GeneratedVeinMetadata vein = element.getVein();
        int iconSize = ConfigHolder.INSTANCE.compat.minimap.oreIconSize;
        Material firstMaterial = vein.definition().veinGenerator().getAllMaterials().get(0);
        int materialARGB = firstMaterial.getMaterialARGB();
        float[] colors = DrawUtil.floats(materialARGB);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceLocation oreTexture = MaterialIconType.rawOre.getItemTexturePath(firstMaterial.getMaterialIconSet(), true);
        if (oreTexture != null) {
            TextureAtlasSprite oreSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(oreTexture);
            graphics.m_280565_(-iconSize / 2, -iconSize / 2, 0, iconSize, iconSize, oreSprite, colors[0], colors[1], colors[2], 1.0f);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int borderColor = ConfigHolder.INSTANCE.compat.minimap.getBorderColor(materialARGB | 0xFF000000);
        if ((borderColor & 0xFF000000) != 0) {
            int thickness = iconSize / 16;
            graphics.m_280509_(-iconSize / 2, -iconSize / 2, iconSize, thickness, borderColor);
            graphics.m_280509_(-iconSize / 2, -iconSize / 2 - thickness, iconSize, thickness, borderColor);
            graphics.m_280509_(-iconSize / 2, -iconSize / 2, thickness, iconSize, borderColor);
            graphics.m_280509_(-iconSize / 2 - thickness, -iconSize / 2, thickness, iconSize, borderColor);
        }
        return true;
    }

    public void postRender(MinimapElementRenderInfo renderInfo, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers) {
    }

    public boolean shouldRender(MinimapElementRenderLocation location) {
        return GroupingMapRenderer.getInstance().doShowLayer("ore_veins") && location == MinimapElementRenderLocation.IN_MINIMAP;
    }

    public static final class Builder {
        private Builder() {
        }

        public OreVeinElementRenderer build() {
            return new OreVeinElementRenderer(new OreVeinElementReader(), new OreVeinElementRenderProvider(), new OreVeinElementContext());
        }

        public static Builder begin() {
            return new Builder();
        }
    }
}

