/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.map.journeymap;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconType;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVeinMetadata;
import com.gregtechceu.gtceu.api.gui.misc.ProspectorMode;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.integration.map.GenericMapRenderer;
import com.gregtechceu.gtceu.integration.map.WaypointManager;
import com.gregtechceu.gtceu.integration.map.journeymap.JourneyMapPlugin;
import com.gregtechceu.gtceu.integration.map.layer.builtin.FluidRenderLayer;
import com.gregtechceu.gtceu.integration.map.layer.builtin.OreRenderLayer;
import com.gregtechceu.gtceu.utils.GradientUtil;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.display.DisplayType;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.IOverlayListener;
import journeymap.client.api.display.MarkerOverlay;
import journeymap.client.api.display.ModPopupMenu;
import journeymap.client.api.display.Overlay;
import journeymap.client.api.display.PolygonOverlay;
import journeymap.client.api.model.MapImage;
import journeymap.client.api.model.MapPolygon;
import journeymap.client.api.model.ShapeProperties;
import journeymap.client.api.util.PolygonHelper;
import journeymap.client.api.util.UIState;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;

public class JourneymapRenderer
extends GenericMapRenderer {
    protected static final ResourceLocation STONE = new ResourceLocation("block/stone");
    protected static final Map<Material, NativeImage> MATERIAL_ICONS = new HashMap<Material, NativeImage>();
    private static final Map<String, Overlay> markers = new Object2ObjectOpenHashMap();

    @Override
    public boolean addMarker(String name, String id, ResourceKey<Level> dim, ChunkPos pos, ProspectorMode.FluidInfo fluid) {
        IClientAPI api = JourneyMapPlugin.getJmApi();
        if (!api.playerAccepts("gtceu", DisplayType.Image)) {
            return false;
        }
        PolygonOverlay marker = this.createMarker(name, id, dim, pos, fluid);
        markers.put(id, (Overlay)marker);
        if (this.doShowLayer("bedrock_fluids")) {
            try {
                api.show((Displayable)marker);
            }
            catch (Exception e) {
                GTCEu.LOGGER.error("Failed to enable marker with name {}", (Object)name, (Object)e);
            }
        }
        return true;
    }

    @Override
    public boolean addMarker(String name, ResourceKey<Level> dim, GeneratedVeinMetadata vein, String id) {
        IClientAPI api = JourneyMapPlugin.getJmApi();
        if (!api.playerAccepts("gtceu", DisplayType.Image)) {
            return false;
        }
        MarkerOverlay marker = this.createMarker(name, id, dim, vein);
        markers.put(id, (Overlay)marker);
        if (this.doShowLayer("ore_veins")) {
            try {
                api.show((Displayable)marker);
            }
            catch (Exception e) {
                GTCEu.LOGGER.error("Failed to enable marker with name {}", (Object)name, (Object)e);
            }
        }
        return true;
    }

    @Override
    public boolean removeMarker(ResourceKey<Level> dim, String id) {
        Overlay marker = markers.remove(id);
        if (marker == null) {
            return false;
        }
        IClientAPI api = JourneyMapPlugin.getJmApi();
        api.remove((Displayable)marker);
        return true;
    }

    @Override
    public boolean doShowLayer(String name) {
        return JourneyMapPlugin.getOptions().showLayer(name);
    }

    @Override
    public void setLayerActive(String name, boolean active) {
        JourneyMapPlugin.getOptions().toggleLayer(name, active);
    }

    @Override
    public void clear() {
        IClientAPI api = JourneyMapPlugin.getJmApi();
        markers.forEach((id, marker) -> api.remove((Displayable)marker));
        markers.clear();
    }

    private MarkerOverlay createMarker(String name, String id, ResourceKey<Level> dim, GeneratedVeinMetadata vein) {
        BlockPos center = vein.center();
        MapImage image = new MapImage(JourneymapRenderer.createOreImage(vein));
        image.centerAnchors().setDisplayWidth((double)ConfigHolder.INSTANCE.compat.minimap.oreIconSize).setDisplayHeight((double)ConfigHolder.INSTANCE.compat.minimap.oreIconSize);
        MarkerOverlay overlay = new MarkerOverlay("gtceu", id, center, image);
        overlay.setDimension(dim);
        overlay.setLabel("").setTitle(OreRenderLayer.getTooltip(name, vein).stream().map(Component::getString).reduce("", (s1, s2) -> {
            if (s1.isEmpty()) {
                return s2;
            }
            if (s2.isEmpty()) {
                return s1;
            }
            return String.join((CharSequence)"\n", s1, s2);
        })).setOverlayListener((IOverlayListener)new MarkerListener(vein, name));
        return overlay;
    }

    private static NativeImage createOreImage(GeneratedVeinMetadata vein) {
        Material firstMaterial = null;
        if (!vein.definition().indicatorGenerators().isEmpty()) {
            Either<BlockState, Material> blockOrMaterial = vein.definition().indicatorGenerators().get(0).block();
            Material material = firstMaterial = blockOrMaterial == null ? null : (Material)blockOrMaterial.map(state -> {
                MaterialStack matStack = ChemicalHelper.getMaterial((ItemLike)state.m_60734_());
                return matStack == null ? null : matStack.material();
            }, Function.identity());
        }
        if (firstMaterial == null && !vein.definition().veinGenerator().getAllMaterials().isEmpty()) {
            firstMaterial = vein.definition().veinGenerator().getAllMaterials().get(0);
        }
        if (firstMaterial == null) {
            return null;
        }
        if (MATERIAL_ICONS.containsKey(firstMaterial)) {
            return MATERIAL_ICONS.get(firstMaterial);
        }
        int materialABGR = GradientUtil.argbToAbgr(firstMaterial.getMaterialARGB());
        ResourceLocation layer1 = MaterialIconType.rawOre.getItemTexturePath(firstMaterial.getMaterialIconSet(), true);
        TextureAtlasSprite baseTexture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(layer1);
        if (baseTexture == null) {
            return null;
        }
        int width = baseTexture.m_245424_().m_246492_();
        int height = baseTexture.m_245424_().m_245330_();
        NativeImage result = new NativeImage(NativeImage.Format.RGBA, width, height, false);
        for (int x = 0; x < result.m_84982_(); ++x) {
            for (int y = 0; y < result.m_85084_(); ++y) {
                int color2 = baseTexture.getPixelRGBA(0, x, y);
                result.m_84988_(x, y, GradientUtil.multiplyBlendWithAlpha(color2, materialABGR));
            }
        }
        if (firstMaterial.getMaterialSecondaryARGB() != -1) {
            int materialSecondaryABGR = GradientUtil.argbToAbgr(firstMaterial.getMaterialSecondaryARGB());
            ResourceLocation layer2 = MaterialIconType.rawOre.getItemTexturePath(firstMaterial.getMaterialIconSet(), "secondary", true);
            if (layer2 == null) {
                return result;
            }
            TextureAtlasSprite image2 = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(layer2);
            for (int x = 0; x < result.m_84982_(); ++x) {
                for (int y = 0; y < result.m_85084_(); ++y) {
                    int color3 = image2.getPixelRGBA(0, x, y);
                    result.m_166411_(x, y, GradientUtil.multiplyBlendWithAlpha(color3, materialSecondaryABGR));
                }
            }
        }
        result.m_284481_(color -> {
            if ((color & 0xFF000000) != 0) {
                return color | 0xFF000000;
            }
            return color;
        });
        MATERIAL_ICONS.put(firstMaterial, result);
        return result;
    }

    private PolygonOverlay createMarker(String name, String id, ResourceKey<Level> dim, ChunkPos pos, ProspectorMode.FluidInfo vein) {
        ResourceLocation texture = IClientFluidTypeExtensions.of((Fluid)vein.fluid()).getStillTexture();
        int color = IClientFluidTypeExtensions.of((Fluid)vein.fluid()).getTintColor();
        Material material = ChemicalHelper.getMaterial(vein.fluid());
        if (material != null) {
            color = material.getMaterialARGB();
        }
        ShapeProperties shapeProps = new ShapeProperties().setStrokeWidth(0.0f).setStrokeColor(color).setFillColor(color).setFillOpacity(0.4f).setImageLocation(texture);
        MapPolygon polygon = PolygonHelper.createChunkPolygon((int)pos.f_45578_, (int)0, (int)pos.f_45579_);
        PolygonOverlay overlay = new PolygonOverlay("gtceu", id, dim, shapeProps, polygon);
        overlay.setDimension(dim);
        overlay.setLabel("").setTitle(FluidRenderLayer.getTooltip(vein).stream().map(Component::getString).reduce("", (s1, s2) -> {
            if (s1.isEmpty()) {
                return s2;
            }
            if (s2.isEmpty()) {
                return s1;
            }
            return String.join((CharSequence)"\n", s1, s2);
        })).setOverlayListener((IOverlayListener)new MarkerListener(pos, vein, name));
        return overlay;
    }

    @Generated
    public static Map<String, Overlay> getMarkers() {
        return markers;
    }

    @ParametersAreNonnullByDefault
    private static class MarkerListener
    implements IOverlayListener {
        private final GeneratedVeinMetadata oreVein;
        private final String label;
        private final ChunkPos fluidCenterPos;
        private final ProspectorMode.FluidInfo fluidInfo;

        private MarkerListener(GeneratedVeinMetadata oreVein, String label) {
            this.oreVein = oreVein;
            this.label = label;
            this.fluidCenterPos = null;
            this.fluidInfo = null;
        }

        private MarkerListener(ChunkPos fluidCenterPos, ProspectorMode.FluidInfo fluidInfo, String label) {
            this.fluidCenterPos = fluidCenterPos;
            this.fluidInfo = fluidInfo;
            this.label = label;
            this.oreVein = null;
        }

        public void onActivate(UIState uiState) {
        }

        public void onDeactivate(UIState uiState) {
        }

        public void onMouseMove(UIState uiState, Point2D.Double mousePosition, BlockPos blockPosition) {
        }

        public void onMouseOut(UIState mapState, Point2D.Double mousePosition, BlockPos blockPosition) {
        }

        public boolean onMouseClick(UIState uiState, Point2D.Double mousePosition, BlockPos blockPosition, int button, boolean doubleClick) {
            if (button == 0 && doubleClick) {
                if (this.oreVein != null) {
                    Material firstMaterial = this.oreVein.definition().veinGenerator().getAllMaterials().get(0);
                    int color = firstMaterial.getMaterialARGB();
                    BlockPos center = this.oreVein.center();
                    WaypointManager.toggleWaypoint("ore_veins", this.label, color, null, center.m_123341_(), center.m_123342_(), center.m_123343_());
                } else if (this.fluidCenterPos != null && this.fluidInfo != null) {
                    int color = IClientFluidTypeExtensions.of((Fluid)this.fluidInfo.fluid()).getTintColor();
                    BlockPos center = this.fluidCenterPos.m_151394_(0);
                    WaypointManager.toggleWaypoint("ore_veins", this.label, color, null, center.m_123341_(), center.m_123342_(), center.m_123343_());
                }
                return false;
            }
            return true;
        }

        public void onOverlayMenuPopup(UIState mapState, Point2D.Double mousePosition, BlockPos blockPosition, ModPopupMenu modPopupMenu) {
            modPopupMenu.addMenuItem("button.gtceu.mark_as_depleted.name", b -> {
                if (this.oreVein != null) {
                    this.oreVein.depleted(!this.oreVein.depleted());
                } else if (this.fluidInfo != null) {
                    this.fluidInfo.left(0);
                }
            });
            modPopupMenu.addMenuItem("button.gtceu.toggle_waypoint.name", b -> {
                if (this.oreVein != null) {
                    Material firstMaterial = this.oreVein.definition().veinGenerator().getAllMaterials().get(0);
                    int color = firstMaterial.getMaterialARGB();
                    BlockPos center = this.oreVein.center();
                    WaypointManager.toggleWaypoint("ore_veins", this.label, color, null, center.m_123341_(), center.m_123342_(), center.m_123343_());
                } else if (this.fluidCenterPos != null && this.fluidInfo != null) {
                    int color = IClientFluidTypeExtensions.of((Fluid)this.fluidInfo.fluid()).getTintColor();
                    BlockPos center = this.fluidCenterPos.m_151394_(0);
                    WaypointManager.toggleWaypoint("ore_veins", this.label, color, null, center.m_123341_(), center.m_123342_(), center.m_123343_());
                }
            });
        }
    }
}

