/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.map.cache.server;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVeinMetadata;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.network.GTNetwork;
import com.gregtechceu.gtceu.common.network.packets.prospecting.SPacketProspectOre;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.integration.map.cache.DimensionCache;
import com.gregtechceu.gtceu.integration.map.cache.WorldCache;
import com.gregtechceu.gtceu.integration.map.cache.server.ServerCacheSavedData;
import com.lowdragmc.lowdraglib.networking.IPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ServerCache
extends WorldCache {
    public static final ServerCache instance = new ServerCache();
    private final Map<ResourceKey<Level>, ServerCacheSavedData> saveData = new HashMap<ResourceKey<Level>, ServerCacheSavedData>();

    public void maybeInitWorld(ServerLevel world) {
        ResourceKey dim = world.m_46472_();
        if (!this.cache.containsKey(dim)) {
            this.cache.put(dim, new DimensionCache());
        }
        if (!this.saveData.containsKey(dim)) {
            this.saveData.put((ResourceKey<Level>)dim, ServerCacheSavedData.init(world, (DimensionCache)this.cache.get(dim)));
        }
    }

    public void invalidateWorld(ServerLevel world) {
        ResourceKey dim = world.m_46472_();
        this.cache.remove(dim);
        this.saveData.remove(dim);
    }

    @Override
    public boolean addVein(ResourceKey<Level> dim, int gridX, int gridZ, GeneratedVeinMetadata name) {
        boolean added = super.addVein(dim, gridX, gridZ, name);
        if (added && this.saveData.containsKey(dim)) {
            this.saveData.get(dim).m_77762_();
        }
        return added;
    }

    @Override
    public void clear() {
        super.clear();
        this.saveData.clear();
    }

    public void prospectSurfaceRockMaterial(ResourceKey<Level> dim, Material material, BlockPos pos, ServerPlayer player) {
        this.prospectBySurfaceRockMaterial(dim, material, pos, player, ConfigHolder.INSTANCE.compat.minimap.surfaceRockProspectRange);
    }

    public void prospectBySurfaceRockMaterial(ResourceKey<Level> dim, Material material, BlockPos pos, ServerPlayer player, int radius) {
        if (radius < 0) {
            return;
        }
        List<GeneratedVeinMetadata> nearbyVeins = this.getNearbyVeins(dim, pos, radius);
        ArrayList<GeneratedVeinMetadata> foundVeins = new ArrayList<GeneratedVeinMetadata>();
        for (GeneratedVeinMetadata nearbyVein : nearbyVeins) {
            if (!nearbyVein.definition().indicatorGenerators().stream().anyMatch(generator -> generator.block() != null && (Boolean)Objects.requireNonNull(generator.block()).map(state -> {
                MaterialStack mat = ChemicalHelper.getMaterial((ItemLike)state.m_60734_().m_5456_());
                if (mat == null) {
                    return false;
                }
                return mat.material() == material;
            }, mat -> mat == material) != false)) continue;
            foundVeins.add(nearbyVein);
        }
        GTNetwork.NETWORK.sendToPlayer((IPacket)new SPacketProspectOre(dim, foundVeins), player);
    }

    public void prospectByOreMaterial(ResourceKey<Level> dim, Material material, BlockPos origin, ServerPlayer player, int radius) {
        if (radius < 0) {
            return;
        }
        List<GeneratedVeinMetadata> nearbyVeins = this.getNearbyVeins(dim, origin, radius);
        ArrayList<GeneratedVeinMetadata> foundVeins = new ArrayList<GeneratedVeinMetadata>();
        for (GeneratedVeinMetadata nearbyVein : nearbyVeins) {
            if (!nearbyVein.definition().veinGenerator().getAllMaterials().contains(material)) continue;
            foundVeins.add(nearbyVein);
        }
        GTNetwork.NETWORK.sendToPlayer((IPacket)new SPacketProspectOre(dim, foundVeins), player);
    }

    public void prospectByDepositName(ResourceKey<Level> dim, String depositName, BlockPos origin, ServerPlayer player, int radius) {
        if (radius < 0) {
            return;
        }
        List<GeneratedVeinMetadata> nearbyVeins = this.getNearbyVeins(dim, origin, radius);
        ArrayList<GeneratedVeinMetadata> foundVeins = new ArrayList<GeneratedVeinMetadata>();
        for (GeneratedVeinMetadata nearbyVein : nearbyVeins) {
            if (!((ResourceLocation)GTRegistries.ORE_VEINS.getKey(nearbyVein.definition())).toString().equals(depositName)) continue;
            foundVeins.add(nearbyVein);
        }
        GTNetwork.NETWORK.sendToPlayer((IPacket)new SPacketProspectOre(dim, foundVeins), player);
    }

    public void prospectAllInChunk(ResourceKey<Level> dim, ChunkPos pos, ServerPlayer player) {
        if (this.cache.containsKey(dim)) {
            GTNetwork.NETWORK.sendToPlayer((IPacket)new SPacketProspectOre(dim, ((DimensionCache)this.cache.get(dim)).getVeinsInChunk(pos)), player);
        }
    }

    public void removeAllInChunk(ResourceKey<Level> dim, ChunkPos pos) {
        if (this.cache.containsKey(dim)) {
            ((DimensionCache)this.cache.get(dim)).removeAllInChunk(pos);
        }
    }
}

