/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.map.cache;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVeinMetadata;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import org.slf4j.Logger;

public class GridCache {
    private final List<GeneratedVeinMetadata> veins = new ArrayList<GeneratedVeinMetadata>();

    public boolean addVein(GeneratedVeinMetadata vein) {
        if (this.veins.contains(vein)) {
            return false;
        }
        this.veins.add(vein);
        return true;
    }

    public ListTag toNBT(boolean isClient) {
        ListTag result = new ListTag();
        for (GeneratedVeinMetadata pos : this.veins) {
            result.add((Object)((Tag)(isClient ? GeneratedVeinMetadata.CLIENT_CODEC : GeneratedVeinMetadata.CODEC).encodeStart((DynamicOps)NbtOps.f_128958_, (Object)pos).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0))));
        }
        return result;
    }

    public void fromNBT(ListTag tag, boolean isClient) {
        for (Tag veinTag : tag) {
            GeneratedVeinMetadata vein = (GeneratedVeinMetadata)(isClient ? GeneratedVeinMetadata.CLIENT_CODEC : GeneratedVeinMetadata.CODEC).parse((DynamicOps)NbtOps.f_128958_, (Object)veinTag).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0));
            if (this.veins.contains(vein)) continue;
            this.veins.add(vein);
        }
    }

    public List<GeneratedVeinMetadata> getVeinsMatching(Predicate<GeneratedVeinMetadata> predicate) {
        return this.veins.stream().filter(predicate).collect(Collectors.toList());
    }

    public void removeVeinsMatching(Predicate<GeneratedVeinMetadata> predicate) {
        for (int i = 0; i < this.veins.size(); ++i) {
            if (!predicate.test(this.veins.get(i))) continue;
            this.veins.remove(i);
            --i;
        }
    }

    @Generated
    public List<GeneratedVeinMetadata> getVeins() {
        return this.veins;
    }
}

