/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.recipe.components;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.gregtechceu.gtceu.api.addon.AddonFinder;
import com.gregtechceu.gtceu.api.addon.events.KJSRecipeKeyEvent;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.chance.logic.ChanceLogic;
import com.gregtechceu.gtceu.api.recipe.condition.RecipeConditionType;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderIngredient;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTRecipeCapabilities;
import com.gregtechceu.gtceu.integration.kjs.recipe.components.CapabilityMapComponent;
import com.gregtechceu.gtceu.integration.kjs.recipe.components.ContentJS;
import com.gregtechceu.gtceu.integration.kjs.recipe.components.ExtendedOutputItem;
import com.gregtechceu.gtceu.integration.kjs.recipe.components.JavaMapRecipeComponent;
import com.mojang.datafixers.util.Pair;
import dev.latvian.mods.kubejs.fluid.FluidLike;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.fluid.InputFluid;
import dev.latvian.mods.kubejs.fluid.OutputFluid;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.ItemMatch;
import dev.latvian.mods.kubejs.recipe.OutputReplacement;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.component.ComponentRole;
import dev.latvian.mods.kubejs.recipe.component.ItemComponents;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.typings.desc.DescriptionContext;
import dev.latvian.mods.kubejs.typings.desc.TypeDescJS;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.rhino.mod.util.NBTUtils;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;

public class GTRecipeComponents {
    public static final RecipeComponent<CompoundTag> TAG = new RecipeComponent<CompoundTag>(){

        public String componentType() {
            return "nbt";
        }

        public Class<?> componentClass() {
            return CompoundTag.class;
        }

        public JsonElement write(RecipeJS recipe, CompoundTag value) {
            return NBTUtils.toJson((Tag)value);
        }

        public CompoundTag read(RecipeJS recipe, Object from) {
            return NBTUtils.toTagCompound((Object)from);
        }
    };
    public static final RecipeComponent<ResourceLocation> RESOURCE_LOCATION = new RecipeComponent<ResourceLocation>(){

        public String componentType() {
            return "resource_location";
        }

        public Class<?> componentClass() {
            return ResourceLocation.class;
        }

        public TypeDescJS constructorDescription(DescriptionContext ctx) {
            return TypeDescJS.STRING;
        }

        public JsonElement write(RecipeJS recipe, ResourceLocation value) {
            return new JsonPrimitive(value.toString());
        }

        public ResourceLocation read(RecipeJS recipe, Object from) {
            ResourceLocation resourceLocation;
            if (from instanceof CharSequence) {
                CharSequence c = (CharSequence)from;
                resourceLocation = ResourceLocation.m_135820_((String)c.toString());
            } else {
                resourceLocation = ResourceLocation.m_135820_((String)String.valueOf(from));
            }
            return resourceLocation;
        }

        public String toString() {
            return this.componentType();
        }
    };
    public static final RecipeComponent<RecipeCapability<?>> RECIPE_CAPABILITY = new RecipeComponent<RecipeCapability<?>>(){

        public String componentType() {
            return "recipe_capability";
        }

        public Class<?> componentClass() {
            return RecipeCapability.class;
        }

        public TypeDescJS constructorDescription(DescriptionContext ctx) {
            return TypeDescJS.STRING;
        }

        public JsonElement write(RecipeJS recipe, RecipeCapability<?> value) {
            return new JsonPrimitive((String)GTRegistries.RECIPE_CAPABILITIES.getKey(value));
        }

        public RecipeCapability<?> read(RecipeJS recipe, Object from) {
            RecipeCapability recipeCapability;
            if (from instanceof RecipeCapability) {
                RecipeCapability capability = (RecipeCapability)from;
                return capability;
            }
            if (from instanceof CharSequence) {
                CharSequence c = (CharSequence)from;
                recipeCapability = (RecipeCapability)GTRegistries.RECIPE_CAPABILITIES.get(c.toString());
            } else {
                recipeCapability = (RecipeCapability)GTRegistries.RECIPE_CAPABILITIES.get(String.valueOf(from));
            }
            return recipeCapability;
        }

        public String toString() {
            return this.componentType();
        }
    };
    public static final RecipeComponent<ChanceLogic> CHANCE_LOGIC = new RecipeComponent<ChanceLogic>(){

        public String componentType() {
            return "chance_logic";
        }

        public Class<?> componentClass() {
            return ChanceLogic.class;
        }

        public TypeDescJS constructorDescription(DescriptionContext ctx) {
            return TypeDescJS.STRING;
        }

        public JsonElement write(RecipeJS recipe, ChanceLogic value) {
            return new JsonPrimitive((String)GTRegistries.CHANCE_LOGICS.getKey(value));
        }

        public ChanceLogic read(RecipeJS recipe, Object from) {
            ChanceLogic chanceLogic;
            if (from instanceof ChanceLogic) {
                ChanceLogic capability = (ChanceLogic)from;
                return capability;
            }
            if (from instanceof CharSequence) {
                CharSequence c = (CharSequence)from;
                chanceLogic = (ChanceLogic)GTRegistries.CHANCE_LOGICS.get(c.toString());
            } else {
                chanceLogic = (ChanceLogic)GTRegistries.CHANCE_LOGICS.get(String.valueOf(from));
            }
            return chanceLogic;
        }

        public String toString() {
            return this.componentType();
        }
    };
    public static final RecipeComponent<RecipeCondition> RECIPE_CONDITION = new RecipeComponent<RecipeCondition>(){

        public String componentType() {
            return "recipe_condition";
        }

        public Class<?> componentClass() {
            return RecipeCondition.class;
        }

        public JsonElement write(RecipeJS recipe, RecipeCondition value) {
            JsonObject object = new JsonObject();
            object.addProperty("type", (String)GTRegistries.RECIPE_CONDITIONS.getKey(value.getType()));
            object.add("data", (JsonElement)value.serialize());
            return object;
        }

        public RecipeCondition read(RecipeJS recipe, Object from) {
            String conditionKey;
            RecipeConditionType type;
            if (from instanceof CharSequence && (type = (RecipeConditionType)GTRegistries.RECIPE_CONDITIONS.get(conditionKey = from.toString())) != null) {
                return type.factory.createDefault();
            }
            if (from instanceof JsonPrimitive) {
                JsonPrimitive primitive = (JsonPrimitive)from;
                String conditionKey2 = primitive.getAsString();
                RecipeConditionType type2 = (RecipeConditionType)GTRegistries.RECIPE_CONDITIONS.get(conditionKey2);
                if (type2 != null) {
                    return type2.factory.createDefault();
                }
            } else if (from instanceof JsonObject) {
                Object condition;
                JsonObject jsonObject = (JsonObject)from;
                String conditionKey3 = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"type", (String)"");
                RecipeConditionType type3 = (RecipeConditionType)GTRegistries.RECIPE_CONDITIONS.get(conditionKey3);
                if (type3 != null && (condition = type3.factory.createDefault()) != null) {
                    return ((RecipeCondition)condition).deserialize(jsonObject);
                }
            } else if (from instanceof Tag) {
                Tag tag = (Tag)from;
                return this.read(recipe, NBTUtils.toJson((Tag)tag));
            }
            return null;
        }

        public String toString() {
            return this.componentType();
        }
    };
    public static final RecipeComponent<FluidIngredientJS> FLUID_INGREDIENT = new RecipeComponent<FluidIngredientJS>(){

        public String componentType() {
            return "input_fluid";
        }

        public Class<?> componentClass() {
            return FluidIngredientJS.class;
        }

        public ComponentRole role() {
            return ComponentRole.INPUT;
        }

        public boolean isInput(RecipeJS recipe, FluidIngredientJS value, ReplacementMatch match) {
            FluidLike m;
            return match instanceof FluidLike && value.matches(m = (FluidLike)match);
        }

        public JsonElement write(RecipeJS recipe, FluidIngredientJS value) {
            return value.ingredient.toJson();
        }

        public FluidIngredientJS read(RecipeJS recipe, Object from) {
            return FluidIngredientJS.of(from);
        }
    };
    public static final RecipeComponent<FluidIngredientJS> FLUID_INGREDIENT_OUT = new RecipeComponent<FluidIngredientJS>(){

        public String componentType() {
            return "output_fluid";
        }

        public Class<?> componentClass() {
            return FluidIngredientJS.class;
        }

        public ComponentRole role() {
            return ComponentRole.OUTPUT;
        }

        public boolean isOutput(RecipeJS recipe, FluidIngredientJS value, ReplacementMatch match) {
            FluidLike m;
            return match instanceof FluidLike && value.matches(m = (FluidLike)match);
        }

        public JsonElement write(RecipeJS recipe, FluidIngredientJS value) {
            return value.ingredient.toJson();
        }

        public FluidIngredientJS read(RecipeJS recipe, Object from) {
            return FluidIngredientJS.of(from);
        }
    };
    public static final RecipeComponent<ExtendedOutputItem> EXTENDED_OUTPUT = new RecipeComponent<ExtendedOutputItem>(){

        public String componentType() {
            return "extended_output_item";
        }

        public ComponentRole role() {
            return ComponentRole.OUTPUT;
        }

        public Class<?> componentClass() {
            return OutputItem.class;
        }

        public boolean hasPriority(RecipeJS recipe, Object from) {
            return recipe.outputItemHasPriority(from);
        }

        public JsonElement write(RecipeJS recipe, ExtendedOutputItem value) {
            return recipe.writeOutputItem((OutputItem)value);
        }

        public ExtendedOutputItem read(RecipeJS recipe, Object from) {
            if (from instanceof IntProviderIngredient) {
                IntProviderIngredient intProvider = (IntProviderIngredient)((Object)from);
                return new ExtendedOutputItem(intProvider, 1);
            }
            return ExtendedOutputItem.fromOutputItem(recipe.readOutputItem(from));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isOutput(RecipeJS recipe, ExtendedOutputItem value, ReplacementMatch match) {
            if (!(match instanceof ItemMatch)) return false;
            ItemMatch m = (ItemMatch)match;
            if (value.isEmpty()) return false;
            if (!m.contains((Ingredient)value.ingredient)) return false;
            return true;
        }

        public ExtendedOutputItem replaceOutput(RecipeJS recipe, ExtendedOutputItem original, ReplacementMatch match, OutputReplacement with) {
            return this.isOutput(recipe, original, match) ? this.read(recipe, with.replaceOutput(recipe, match, (OutputReplacement)original)) : original;
        }

        public String checkEmpty(RecipeKey<ExtendedOutputItem> key, ExtendedOutputItem value) {
            if (value.isEmpty()) {
                return "Ingredient '" + key.name + "' can't be empty!";
            }
            return "";
        }

        public String toString() {
            return this.componentType();
        }
    };
    public static final ContentJS<InputItem> ITEM_IN = new ContentJS(ItemComponents.INPUT, GTRecipeCapabilities.ITEM, false);
    public static final ContentJS<ExtendedOutputItem> ITEM_OUT = new ContentJS<ExtendedOutputItem>(EXTENDED_OUTPUT, GTRecipeCapabilities.ITEM, true);
    public static final ContentJS<FluidIngredientJS> FLUID_IN = new ContentJS<FluidIngredientJS>(FLUID_INGREDIENT, GTRecipeCapabilities.FLUID, false);
    public static final ContentJS<FluidIngredientJS> FLUID_OUT = new ContentJS<FluidIngredientJS>(FLUID_INGREDIENT_OUT, GTRecipeCapabilities.FLUID, true);
    public static final ContentJS<Long> EU_IN = new ContentJS(NumberComponent.ANY_LONG, GTRecipeCapabilities.EU, false);
    public static final ContentJS<Long> EU_OUT = new ContentJS(NumberComponent.ANY_LONG, GTRecipeCapabilities.EU, true);
    public static final ContentJS<Integer> CWU_IN = new ContentJS(NumberComponent.ANY_INT, GTRecipeCapabilities.CWU, false);
    public static final ContentJS<Integer> CWU_OUT = new ContentJS(NumberComponent.ANY_INT, GTRecipeCapabilities.CWU, true);
    public static final CapabilityMapComponent IN = new CapabilityMapComponent(false);
    public static final CapabilityMapComponent TICK_IN = new CapabilityMapComponent(false);
    public static final CapabilityMapComponent OUT = new CapabilityMapComponent(true);
    public static final CapabilityMapComponent TICK_OUT = new CapabilityMapComponent(true);
    public static final RecipeComponent<Map<RecipeCapability<?>, ChanceLogic>> CHANCE_LOGIC_MAP = new JavaMapRecipeComponent(RECIPE_CAPABILITY, CHANCE_LOGIC);
    public static final Map<RecipeCapability<?>, Pair<ContentJS<?>, ContentJS<?>>> VALID_CAPS = new IdentityHashMap();

    static {
        VALID_CAPS.put(GTRecipeCapabilities.ITEM, Pair.of(ITEM_IN, ITEM_OUT));
        VALID_CAPS.put(GTRecipeCapabilities.FLUID, Pair.of(FLUID_IN, FLUID_OUT));
        VALID_CAPS.put(GTRecipeCapabilities.EU, Pair.of(EU_IN, EU_OUT));
        VALID_CAPS.put(GTRecipeCapabilities.CWU, Pair.of(CWU_IN, CWU_OUT));
        KJSRecipeKeyEvent event = new KJSRecipeKeyEvent();
        AddonFinder.getAddons().forEach(addon -> addon.registerRecipeKeys(event));
        VALID_CAPS.putAll(event.getRegisteredKeys());
    }

    public static class FluidIngredientJS
    implements InputFluid,
    OutputFluid {
        private final FluidIngredient ingredient;

        public FluidIngredientJS(FluidIngredient ingredient) {
            this.ingredient = ingredient;
        }

        public long kjs$getAmount() {
            return this.ingredient.getAmount();
        }

        public FluidIngredientJS kjs$copy(long amount) {
            FluidIngredient ingredient1 = this.ingredient.copy();
            ingredient1.setAmount((int)amount);
            return new FluidIngredientJS(ingredient1);
        }

        public boolean matches(FluidLike other) {
            if (other instanceof FluidStackJS) {
                FluidStackJS fluidStack = (FluidStackJS)other;
                return this.ingredient.test(new FluidStack(fluidStack.getFluid(), (int)fluidStack.getAmount(), fluidStack.getNbt()));
            }
            return other.matches((FluidLike)this);
        }

        public static FluidIngredientJS of(Object o) {
            if (o instanceof FluidIngredientJS) {
                FluidIngredientJS ingredientJS = (FluidIngredientJS)o;
                return ingredientJS;
            }
            if (o instanceof FluidIngredient) {
                FluidIngredient ingredient = (FluidIngredient)o;
                return new FluidIngredientJS(ingredient);
            }
            if (o instanceof JsonElement) {
                JsonElement json = (JsonElement)o;
                return new FluidIngredientJS(FluidIngredient.fromJson(json));
            }
            if (o instanceof FluidStackJS) {
                FluidStackJS fluidStackJS = (FluidStackJS)o;
                return new FluidIngredientJS(FluidIngredient.of(new FluidStack(fluidStackJS.getFluid(), (int)fluidStackJS.getAmount(), fluidStackJS.getNbt())));
            }
            List list = ListJS.of((Object)o);
            if (list != null && !list.isEmpty()) {
                ArrayList<FluidStack> stacks = new ArrayList<FluidStack>();
                for (Object object : list) {
                    FluidStackJS stackJS = FluidStackJS.of(object);
                    stacks.add(new FluidStack(stackJS.getFluid(), (int)stackJS.getAmount(), stackJS.getNbt()));
                }
                return new FluidIngredientJS(FluidIngredient.of((FluidStack[])stacks.toArray(FluidStack[]::new)));
            }
            FluidStackJS stackJS = FluidStackJS.of((Object)o);
            return new FluidIngredientJS(FluidIngredient.of(new FluidStack(stackJS.getFluid(), (int)stackJS.getAmount(), stackJS.getNbt())));
        }
    }
}

