/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.events;

import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTOres;
import dev.latvian.mods.kubejs.event.EventJS;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;

public class GTOreVeinEventJS
extends EventJS {
    public void add(ResourceLocation id, Consumer<GTOreDefinition> consumer) {
        GTOreDefinition vein = GTOres.blankOreDefinition();
        consumer.accept(vein);
        vein.register(id);
    }

    public void modify(ResourceLocation id, Consumer<GTOreDefinition> consumer) {
        GTOreDefinition vein = (GTOreDefinition)GTRegistries.ORE_VEINS.get(id);
        if (vein == null) {
            throw new IllegalArgumentException("Ore vein doesn't exist: " + String.valueOf(id));
        }
        consumer.accept(vein);
        vein.register(id);
    }

    public void modifyAll(BiConsumer<ResourceLocation, GTOreDefinition> consumer) {
        Set keys = Set.copyOf(GTRegistries.ORE_VEINS.keys());
        keys.forEach(key -> this.modify((ResourceLocation)key, vein -> consumer.accept((ResourceLocation)key, (GTOreDefinition)vein)));
    }

    public void remove(ResourceLocation id) {
        GTRegistries.ORE_VEINS.remove(id);
    }

    public void removeAll() {
        Set keys = Set.copyOf(GTRegistries.ORE_VEINS.keys());
        keys.forEach(this::remove);
    }

    public void removeAll(BiPredicate<ResourceLocation, GTOreDefinition> predicate) {
        Set keys = Set.copyOf(GTRegistries.ORE_VEINS.keys());
        keys.stream().filter(key -> predicate.test((ResourceLocation)key, (GTOreDefinition)GTRegistries.ORE_VEINS.get(key))).forEach(this::remove);
    }
}

