/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.builders.block;

import com.gregtechceu.gtceu.api.block.ActiveBlock;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.client.VariantBlockStateGenerator;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;

public class ActiveBlockBuilder
extends BlockBuilder {
    private transient Type type = Type.CUSTOM;

    public ActiveBlockBuilder(ResourceLocation id) {
        super(id);
        this.property((Property)ActiveBlock.ACTIVE);
        this.renderType("cutout_mipped");
    }

    public ActiveBlockBuilder simple(String base) {
        this.textures.addProperty("base", base);
        this.textures.addProperty("active", base + "_active");
        this.type = Type.SIMPLE;
        return this;
    }

    public ActiveBlockBuilder firebox(String bottom, String side, String top) {
        this.textures.addProperty("bottom", bottom);
        this.textures.addProperty("side", side);
        this.textures.addProperty("top", top);
        this.type = Type.FIREBOX;
        return this;
    }

    public ActiveBlockBuilder bloom(String base) {
        this.textures.addProperty("base", base);
        this.textures.addProperty("bloom", base + "_bloom");
        this.type = Type.BLOOM;
        return this;
    }

    protected void generateBlockStateJson(VariantBlockStateGenerator bs) {
        bs.simpleVariant("active=false", this.newID("block/", "").toString());
        bs.simpleVariant("active=true", this.newID("block/", "_active").toString());
    }

    protected void generateBlockModelJsons(AssetJsonGenerator generator) {
        ResourceLocation activeID = this.id.m_266382_("_active");
        if (this.type == Type.SIMPLE) {
            String base = this.textures.get("base").getAsString();
            String active = this.textures.get("active").getAsString();
            generator.blockModel(this.id, m -> {
                m.parent("minecraft:block/cube_all");
                m.texture("all", base);
            });
            generator.blockModel(activeID, m -> {
                m.parent("minecraft:block/cube_all");
                m.texture("all", active);
            });
        } else if (this.type == Type.FIREBOX) {
            String bottom = this.textures.get("bottom").getAsString();
            String side = this.textures.get("side").getAsString();
            String top = this.textures.get("top").getAsString();
            generator.blockModel(this.id, m -> {
                m.parent("minecraft:block/cube_bottom_top");
                m.texture("bottom", bottom);
                m.texture("side", side);
                m.texture("top", top);
            });
            generator.blockModel(activeID, m -> {
                m.parent("gtceu:block/fire_box_active");
                m.texture("bottom", bottom);
                m.texture("side", side);
                m.texture("top", top);
            });
        } else if (this.type == Type.BLOOM) {
            String base = this.textures.get("base").getAsString();
            String bloom = this.textures.get("bloom").getAsString();
            generator.blockModel(this.id, m -> {
                m.parent("minecraft:block/cube_all");
                m.texture("all", base);
            });
            generator.blockModel(activeID, m -> {
                m.parent("gtceu:block/cube_2_layer/all");
                m.texture("bot_all", base);
                m.texture("top_all", bloom);
            });
        }
    }

    public Block createObject() {
        return new ActiveBlock(this.createProperties());
    }

    private static enum Type {
        SIMPLE,
        BLOOM,
        FIREBOX,
        CUSTOM;

    }
}

