/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.machine.trait;

import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.trait.IRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.machine.trait.MachineTrait;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.integration.ae2.machine.MEPatternBufferPartMachine;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class MEPatternBufferRecipeHandler
extends MachineTrait {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MEPatternBufferPartMachine.class);
    private ResourceLocation lockedRecipeId;
    private int lockedSlot;
    protected List<Runnable> listeners = new ArrayList<Runnable>();
    protected final NotifiableRecipeHandlerTrait<Ingredient> itemInputHandler;
    protected final NotifiableRecipeHandlerTrait<FluidIngredient> fluidInputHandler;

    public MEPatternBufferRecipeHandler(MEPatternBufferPartMachine ioBuffer) {
        super(ioBuffer);
        this.itemInputHandler = new ItemInputHandler(ioBuffer);
        this.fluidInputHandler = new FluidInputHandler(ioBuffer);
    }

    @Override
    public void onChanged() {
        this.listeners.forEach(Runnable::run);
    }

    @Override
    public MEPatternBufferPartMachine getMachine() {
        return (MEPatternBufferPartMachine)super.getMachine();
    }

    public List<Ingredient> handleItemInner(GTRecipe recipe, List<Ingredient> left, boolean simulate) {
        MEPatternBufferPartMachine.InternalSlot[] internalInv = this.getMachine().getInternalInventory();
        if (recipe.id.equals((Object)this.lockedRecipeId) && this.lockedSlot >= 0) {
            return internalInv[this.lockedSlot].handleItemInternal(left, simulate);
        }
        this.lockedRecipeId = recipe.id;
        List<Ingredient> contents = left;
        for (int i = 0; i < internalInv.length; ++i) {
            if (internalInv[i].isItemEmpty()) continue;
            if ((contents = internalInv[i].handleItemInternal(contents, simulate)) == null) {
                this.lockedSlot = i;
                return contents;
            }
            contents = MEPatternBufferRecipeHandler.copyIngredients(left);
        }
        this.lockedSlot = -1;
        return left;
    }

    public List<FluidIngredient> handleFluidInner(GTRecipe recipe, List<FluidIngredient> left, boolean simulate) {
        MEPatternBufferPartMachine.InternalSlot[] internalInv = this.getMachine().getInternalInventory();
        if (recipe.id.equals((Object)this.lockedRecipeId) && this.lockedSlot >= 0) {
            return internalInv[this.lockedSlot].handleFluidInternal(left, simulate);
        }
        this.lockedRecipeId = recipe.id;
        List<FluidIngredient> contents = left;
        for (int i = 0; i < internalInv.length; ++i) {
            if (internalInv[i].isFluidEmpty()) continue;
            if ((contents = internalInv[i].handleFluidInternal(contents, simulate)) == null) {
                this.lockedSlot = i;
                return contents;
            }
            contents = MEPatternBufferRecipeHandler.copyFluidIngredients(left);
        }
        this.lockedSlot = -1;
        return left;
    }

    public List<IRecipeHandlerTrait> getRecipeHandlers() {
        return List.of(this.fluidInputHandler, this.itemInputHandler);
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    private static List<Ingredient> copyIngredients(List<Ingredient> ingredients) {
        ObjectArrayList result = new ObjectArrayList(ingredients.size());
        for (Ingredient ingredient : ingredients) {
            result.add(ItemRecipeCapability.CAP.copyInner(ingredient));
        }
        return result;
    }

    private static List<FluidIngredient> copyFluidIngredients(List<FluidIngredient> ingredients) {
        ObjectArrayList result = new ObjectArrayList(ingredients.size());
        for (FluidIngredient ingredient : ingredients) {
            result.add(FluidRecipeCapability.CAP.copyInner(ingredient));
        }
        return result;
    }

    public static Pair<Object2LongOpenHashMap<Item>, Object2LongOpenHashMap<Fluid>> mergeInternalSlot(MEPatternBufferPartMachine.InternalSlot[] internalSlots) {
        Object2LongOpenHashMap items = new Object2LongOpenHashMap();
        Object2LongOpenHashMap fluids = new Object2LongOpenHashMap();
        for (MEPatternBufferPartMachine.InternalSlot internalSlot : internalSlots) {
            for (ItemStack itemStack : internalSlot.getItemInputs()) {
                items.addTo((Object)itemStack.m_41720_(), (long)itemStack.m_41613_());
            }
            for (ItemStack itemStack : internalSlot.getFluidInputs()) {
                fluids.addTo((Object)itemStack.getFluid(), (long)itemStack.getAmount());
            }
        }
        return new ImmutablePair((Object)items, (Object)fluids);
    }

    @Generated
    public NotifiableRecipeHandlerTrait<Ingredient> getItemInputHandler() {
        return this.itemInputHandler;
    }

    @Generated
    public NotifiableRecipeHandlerTrait<FluidIngredient> getFluidInputHandler() {
        return this.fluidInputHandler;
    }

    public class ItemInputHandler
    extends NotifiableRecipeHandlerTrait<Ingredient> {
        public ItemInputHandler(MEPatternBufferPartMachine machine) {
            super(machine);
        }

        @Override
        public MEPatternBufferPartMachine getMachine() {
            return (MEPatternBufferPartMachine)this.machine;
        }

        @Override
        public IO getHandlerIO() {
            return IO.IN;
        }

        @Override
        public ISubscription addChangedListener(Runnable listener) {
            this.listeners.add(listener);
            return () -> this.listeners.remove(listener);
        }

        @Override
        public List<Ingredient> handleRecipeInner(IO io, GTRecipe recipe, List<Ingredient> left, @Nullable String slotName, boolean simulate) {
            if (io != IO.IN) {
                return left;
            }
            MEPatternBufferPartMachine machine = this.getMachine();
            machine.getCircuitInventorySimulated().handleRecipeInner(io, recipe, left, slotName, simulate);
            machine.getShareInventory().handleRecipeInner(io, recipe, left, slotName, simulate);
            return MEPatternBufferRecipeHandler.this.handleItemInner(recipe, left, simulate);
        }

        @Override
        public List<Object> getContents() {
            return Arrays.stream(this.getMachine().getInternalInventory()).map(MEPatternBufferPartMachine.InternalSlot::getItemInputs).flatMap(Arrays::stream).collect(Collectors.toList());
        }

        @Override
        public double getTotalContentAmount() {
            return Arrays.stream(this.getMachine().getInternalInventory()).map(MEPatternBufferPartMachine.InternalSlot::getItemInputs).flatMap(Arrays::stream).mapToLong(ItemStack::m_41613_).sum();
        }

        @Override
        public int getPriority() {
            return Integer.MAX_VALUE;
        }

        @Override
        public boolean isDistinct() {
            return true;
        }

        @Override
        public RecipeCapability<Ingredient> getCapability() {
            return ItemRecipeCapability.CAP;
        }

        @Override
        public void preWorking(IRecipeCapabilityHolder holder, IO io, GTRecipe recipe) {
            super.preWorking(holder, io, recipe);
            MEPatternBufferRecipeHandler.this.lockedRecipeId = null;
        }
    }

    public class FluidInputHandler
    extends NotifiableRecipeHandlerTrait<FluidIngredient> {
        public FluidInputHandler(MEPatternBufferPartMachine machine) {
            super(machine);
        }

        @Override
        public MEPatternBufferPartMachine getMachine() {
            return (MEPatternBufferPartMachine)this.machine;
        }

        @Override
        public IO getHandlerIO() {
            return IO.IN;
        }

        @Override
        public ISubscription addChangedListener(Runnable listener) {
            this.listeners.add(listener);
            return () -> this.listeners.remove(listener);
        }

        @Override
        public List<FluidIngredient> handleRecipeInner(IO io, GTRecipe recipe, List<FluidIngredient> left, @Nullable String slotName, boolean simulate) {
            if (io != IO.IN) {
                return left;
            }
            this.getMachine().getShareTank().handleRecipeInner(io, recipe, left, slotName, simulate);
            return MEPatternBufferRecipeHandler.this.handleFluidInner(recipe, left, simulate);
        }

        @Override
        public List<Object> getContents() {
            return Arrays.stream(this.getMachine().getInternalInventory()).map(MEPatternBufferPartMachine.InternalSlot::getFluidInputs).flatMap(Arrays::stream).collect(Collectors.toList());
        }

        @Override
        public double getTotalContentAmount() {
            return Arrays.stream(this.getMachine().getInternalInventory()).map(MEPatternBufferPartMachine.InternalSlot::getFluidInputs).flatMap(Arrays::stream).mapToLong(FluidStack::getAmount).sum();
        }

        @Override
        public int getPriority() {
            return Integer.MAX_VALUE;
        }

        @Override
        public boolean isDistinct() {
            return true;
        }

        @Override
        public RecipeCapability<FluidIngredient> getCapability() {
            return FluidRecipeCapability.CAP;
        }

        @Override
        public void preWorking(IRecipeCapabilityHolder holder, IO io, GTRecipe recipe) {
            super.preWorking(holder, io, recipe);
            MEPatternBufferRecipeHandler.this.lockedRecipeId = null;
        }
    }
}

