/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.misc;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.MarkerMaterial;
import com.gregtechceu.gtceu.api.data.chemical.material.MarkerMaterials;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.multiblock.CleanroomType;
import com.gregtechceu.gtceu.common.block.LampBlock;
import com.gregtechceu.gtceu.common.block.StoneBlockType;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.data.machines.GTAEMachines;
import com.gregtechceu.gtceu.common.data.machines.GTMachineUtils;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.data.recipe.misc.ComputerRecipes;
import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;

public class MachineRecipeLoader {
    private static final MaterialStack[][] alloySmelterList = new MaterialStack[][]{{new MaterialStack(GTMaterials.Copper, 3L), new MaterialStack(GTMaterials.Tin, 1L), new MaterialStack(GTMaterials.Bronze, 4L)}, {new MaterialStack(GTMaterials.Copper, 3L), new MaterialStack(GTMaterials.Zinc, 1L), new MaterialStack(GTMaterials.Brass, 4L)}, {new MaterialStack(GTMaterials.Copper, 1L), new MaterialStack(GTMaterials.Nickel, 1L), new MaterialStack(GTMaterials.Cupronickel, 2L)}, {new MaterialStack(GTMaterials.Copper, 1L), new MaterialStack(GTMaterials.Redstone, 4L), new MaterialStack(GTMaterials.RedAlloy, 1L)}, {new MaterialStack(GTMaterials.AnnealedCopper, 3L), new MaterialStack(GTMaterials.Tin, 1L), new MaterialStack(GTMaterials.Bronze, 4L)}, {new MaterialStack(GTMaterials.AnnealedCopper, 3L), new MaterialStack(GTMaterials.Zinc, 1L), new MaterialStack(GTMaterials.Brass, 4L)}, {new MaterialStack(GTMaterials.AnnealedCopper, 1L), new MaterialStack(GTMaterials.Nickel, 1L), new MaterialStack(GTMaterials.Cupronickel, 2L)}, {new MaterialStack(GTMaterials.AnnealedCopper, 1L), new MaterialStack(GTMaterials.Redstone, 4L), new MaterialStack(GTMaterials.RedAlloy, 1L)}, {new MaterialStack(GTMaterials.Iron, 1L), new MaterialStack(GTMaterials.Tin, 1L), new MaterialStack(GTMaterials.TinAlloy, 2L)}, {new MaterialStack(GTMaterials.WroughtIron, 1L), new MaterialStack(GTMaterials.Tin, 1L), new MaterialStack(GTMaterials.TinAlloy, 2L)}, {new MaterialStack(GTMaterials.Iron, 2L), new MaterialStack(GTMaterials.Nickel, 1L), new MaterialStack(GTMaterials.Invar, 3L)}, {new MaterialStack(GTMaterials.WroughtIron, 2L), new MaterialStack(GTMaterials.Nickel, 1L), new MaterialStack(GTMaterials.Invar, 3L)}, {new MaterialStack(GTMaterials.Lead, 4L), new MaterialStack(GTMaterials.Antimony, 1L), new MaterialStack(GTMaterials.BatteryAlloy, 5L)}, {new MaterialStack(GTMaterials.Gold, 1L), new MaterialStack(GTMaterials.Silver, 1L), new MaterialStack(GTMaterials.Electrum, 2L)}, {new MaterialStack(GTMaterials.Magnesium, 1L), new MaterialStack(GTMaterials.Aluminium, 2L), new MaterialStack(GTMaterials.Magnalium, 3L)}, {new MaterialStack(GTMaterials.Silver, 1L), new MaterialStack(GTMaterials.Electrotine, 4L), new MaterialStack(GTMaterials.BlueAlloy, 1L)}};

    private MachineRecipeLoader() {
    }

    public static void init(Consumer<FinishedRecipe> provider) {
        ComputerRecipes.init(provider);
        MachineRecipeLoader.registerDecompositionRecipes(provider);
        MachineRecipeLoader.registerBlastFurnaceRecipes(provider);
        MachineRecipeLoader.registerAssemblerRecipes(provider);
        MachineRecipeLoader.registerAlloyRecipes(provider);
        MachineRecipeLoader.registerBendingCompressingRecipes(provider);
        MachineRecipeLoader.registerCokeOvenRecipes(provider);
        MachineRecipeLoader.registerFluidRecipes(provider);
        MachineRecipeLoader.registerMixingCrystallizationRecipes(provider);
        MachineRecipeLoader.registerPrimitiveBlastFurnaceRecipes(provider);
        MachineRecipeLoader.registerRecyclingRecipes(provider);
        MachineRecipeLoader.registerStoneBricksRecipes(provider);
        MachineRecipeLoader.registerNBTRemoval(provider);
        MachineRecipeLoader.registerHatchConversion(provider);
    }

    private static void registerBendingCompressingRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("compressed_fireclay", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Fireclay).outputItems((Supplier<? extends ItemLike>)GTItems.COMPRESSED_FIRECLAY).duration(80).EUt(4L).save(provider);
        GTRecipeTypes.FORMING_PRESS_RECIPES.recipeBuilder("credit_cupronickel", new Object[0]).duration(100).EUt(16L).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_CREDIT).inputItems(TagPrefix.plate, GTMaterials.Cupronickel, 1).outputItems((Supplier<? extends ItemLike>)GTItems.CREDIT_CUPRONICKEL, 4).save(provider);
        GTRecipeTypes.FORMING_PRESS_RECIPES.recipeBuilder("doge_coin", new Object[0]).duration(100).EUt(16L).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_CREDIT).inputItems(TagPrefix.plate, GTMaterials.Brass, 1).outputItems((Supplier<? extends ItemLike>)GTItems.COIN_DOGE, 4).save(provider);
        for (ItemEntry<Item> shapeMold : GTItems.SHAPE_MOLDS) {
            GTRecipeTypes.FORMING_PRESS_RECIPES.recipeBuilder("copy_mold_" + String.valueOf(shapeMold.get()), new Object[0]).duration(120).EUt(22L).notConsumable((Supplier<? extends Item>)shapeMold).inputItems((Supplier<? extends Item>)GTItems.SHAPE_EMPTY).outputItems((Supplier<? extends ItemLike>)shapeMold).save(provider);
        }
        for (ItemEntry<Item> shapeExtruder : GTItems.SHAPE_EXTRUDERS) {
            if (shapeExtruder == null) continue;
            GTRecipeTypes.FORMING_PRESS_RECIPES.recipeBuilder("copy_shape_" + String.valueOf(shapeExtruder.get()), new Object[0]).duration(120).EUt(22L).notConsumable((Supplier<? extends Item>)shapeExtruder).inputItems((Supplier<? extends Item>)GTItems.SHAPE_EMPTY).outputItems((Supplier<? extends ItemLike>)shapeExtruder).save(provider);
        }
        GTRecipeTypes.BENDER_RECIPES.recipeBuilder("empty_shape", new Object[0]).circuitMeta(4).inputItems(TagPrefix.plate, GTMaterials.Steel, 4).outputItems((Supplier<? extends ItemLike>)GTItems.SHAPE_EMPTY).duration(180).EUt(12L).save(provider);
        GTRecipeTypes.BENDER_RECIPES.recipeBuilder("fluid_cell_tin", new Object[0]).circuitMeta(12).inputItems(TagPrefix.plate, GTMaterials.Tin, 2).outputItems((Supplier<? extends ItemLike>)GTItems.FLUID_CELL).duration(200).EUt(GTValues.VA[0]).save(provider);
        GTRecipeTypes.BENDER_RECIPES.recipeBuilder("fluid_cell_steel", new Object[0]).circuitMeta(12).inputItems(TagPrefix.plate, GTMaterials.Steel).outputItems((Supplier<? extends ItemLike>)GTItems.FLUID_CELL).duration(100).EUt(GTValues.VA[0]).save(provider);
        GTRecipeTypes.BENDER_RECIPES.recipeBuilder("fluid_cell_ptfe", new Object[0]).circuitMeta(12).inputItems(TagPrefix.plate, GTMaterials.Polytetrafluoroethylene).outputItems((Supplier<? extends ItemLike>)GTItems.FLUID_CELL, 4).duration(100).EUt(GTValues.VA[0]).save(provider);
        GTRecipeTypes.BENDER_RECIPES.recipeBuilder("fluid_cell_pbi", new Object[0]).circuitMeta(12).inputItems(TagPrefix.plate, GTMaterials.Polybenzimidazole).outputItems((Supplier<? extends ItemLike>)GTItems.FLUID_CELL, 16).duration(100).EUt(GTValues.VA[0]).save(provider);
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("fluid_cell_tin", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.Tin, 2).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_CELL).outputItems((Supplier<? extends ItemLike>)GTItems.FLUID_CELL).duration(128).EUt(GTValues.VA[1]).save(provider);
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("fluid_cell_steel", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.Steel).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_CELL).outputItems((Supplier<? extends ItemLike>)GTItems.FLUID_CELL).duration(128).EUt(GTValues.VA[1]).save(provider);
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("fluid_cell_ptfe", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.Polytetrafluoroethylene).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_CELL).outputItems((Supplier<? extends ItemLike>)GTItems.FLUID_CELL, 4).duration(128).EUt(GTValues.VA[1]).save(provider);
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("fluid_cell_pbi", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.Polybenzimidazole).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_CELL).outputItems((Supplier<? extends ItemLike>)GTItems.FLUID_CELL, 16).duration(128).EUt(GTValues.VA[1]).save(provider);
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("glass_vial", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Glass).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_CELL).outputItems((Supplier<? extends ItemLike>)GTItems.FLUID_CELL_GLASS_VIAL, 4).duration(128).EUt(GTValues.VA[1]).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("nether_quartz_plate", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.NetherQuartz).outputItems(TagPrefix.plate, GTMaterials.NetherQuartz).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("certus_quartz_plate", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.CertusQuartz).outputItems(TagPrefix.plate, GTMaterials.CertusQuartz).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("quartzite_plate", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Quartzite).outputItems(TagPrefix.plate, GTMaterials.Quartzite).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("coke_bricks", new Object[0]).inputItems((Supplier<? extends Item>)GTItems.COKE_OVEN_BRICK, 4).outputItems(GTBlocks.CASING_COKE_BRICKS.asStack()).duration(300).EUt(2L).save(provider);
    }

    private static void registerPrimitiveBlastFurnaceRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coal_gem", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.Iron).inputItems(TagPrefix.gem, GTMaterials.Coal, 2).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.DarkAsh, 2).duration(1800).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coal_dust", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.Iron).inputItems(TagPrefix.dust, GTMaterials.Coal, 2).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.DarkAsh, 2).duration(1800).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_charcoal_gem", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.Iron).inputItems(TagPrefix.gem, GTMaterials.Charcoal, 2).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.DarkAsh, 2).duration(1800).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_charcoal_dust", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.Iron).inputItems(TagPrefix.dust, GTMaterials.Charcoal, 2).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.DarkAsh, 2).duration(1800).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coke_gem", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.Iron).inputItems(TagPrefix.gem, GTMaterials.Coke).outputItems(TagPrefix.ingot, GTMaterials.Steel).chancedOutput(TagPrefix.dust, GTMaterials.Ash, "1/9", 0).duration(1500).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coke_dust", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.Iron).inputItems(TagPrefix.dust, GTMaterials.Coke).outputItems(TagPrefix.ingot, GTMaterials.Steel).chancedOutput(TagPrefix.dust, GTMaterials.Ash, "1/9", 0).duration(1500).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coal_block", new Object[0]).inputItems(TagPrefix.block, GTMaterials.Iron).inputItems(TagPrefix.block, GTMaterials.Coal, 2).outputItems(TagPrefix.block, GTMaterials.Steel).outputItems(TagPrefix.dust, GTMaterials.DarkAsh, 2).duration(16200).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_charcoal_block", new Object[0]).inputItems(TagPrefix.block, GTMaterials.Iron).inputItems(TagPrefix.block, GTMaterials.Charcoal, 2).outputItems(TagPrefix.block, GTMaterials.Steel).outputItems(TagPrefix.dust, GTMaterials.DarkAsh, 2).duration(16200).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coke_block", new Object[0]).inputItems(TagPrefix.block, GTMaterials.Iron).inputItems(TagPrefix.block, GTMaterials.Coke).outputItems(TagPrefix.block, GTMaterials.Steel).outputItems(TagPrefix.dust, GTMaterials.Ash).duration(13500).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coal_gem_wrought", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.WroughtIron).inputItems(TagPrefix.gem, GTMaterials.Coal, 2).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.DarkAsh, 2).duration(800).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coal_dust_wrought", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.WroughtIron).inputItems(TagPrefix.dust, GTMaterials.Coal, 2).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.DarkAsh, 2).duration(800).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_charcoal_gem_wrought", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.WroughtIron).inputItems(TagPrefix.gem, GTMaterials.Charcoal, 2).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.DarkAsh, 2).duration(800).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_charcoal_dust_wrought", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.WroughtIron).inputItems(TagPrefix.dust, GTMaterials.Charcoal, 2).outputItems(TagPrefix.ingot, GTMaterials.Steel).outputItems(TagPrefix.dustTiny, GTMaterials.DarkAsh, 2).duration(800).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coke_gem_wrought", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.WroughtIron).inputItems(TagPrefix.gem, GTMaterials.Coke).outputItems(TagPrefix.ingot, GTMaterials.Steel).chancedOutput(TagPrefix.dust, GTMaterials.Ash, "1/9", 0).duration(600).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coke_dust_wrought", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.WroughtIron).inputItems(TagPrefix.dust, GTMaterials.Coke).outputItems(TagPrefix.ingot, GTMaterials.Steel).chancedOutput(TagPrefix.dust, GTMaterials.Ash, "1/9", 0).duration(600).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coal_block_wrought", new Object[0]).inputItems(TagPrefix.block, GTMaterials.WroughtIron).inputItems(TagPrefix.block, GTMaterials.Coal, 2).outputItems(TagPrefix.block, GTMaterials.Steel).outputItems(TagPrefix.dust, GTMaterials.DarkAsh, 2).duration(7200).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_charcoal_block_wrought", new Object[0]).inputItems(TagPrefix.block, GTMaterials.WroughtIron).inputItems(TagPrefix.block, GTMaterials.Charcoal, 2).outputItems(TagPrefix.block, GTMaterials.Steel).outputItems(TagPrefix.dust, GTMaterials.DarkAsh, 2).duration(7200).save(provider);
        GTRecipeTypes.PRIMITIVE_BLAST_FURNACE_RECIPES.recipeBuilder("steel_from_coke_block_wrought", new Object[0]).inputItems(TagPrefix.block, GTMaterials.WroughtIron).inputItems(TagPrefix.block, GTMaterials.Coke).outputItems(TagPrefix.block, GTMaterials.Steel).outputItems(TagPrefix.dust, GTMaterials.Ash).duration(5400).save(provider);
    }

    private static void registerCokeOvenRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.COKE_OVEN_RECIPES.recipeBuilder("log_to_charcoal", new Object[0]).inputItems((TagKey<Item>)ItemTags.f_13181_).outputItems(TagPrefix.gem, GTMaterials.Charcoal).outputFluids(GTMaterials.Creosote.getFluid(250)).duration(900).save(provider);
        GTRecipeTypes.COKE_OVEN_RECIPES.recipeBuilder("coal_to_coke", new Object[0]).inputItems(TagPrefix.gem, GTMaterials.Coal).outputItems(TagPrefix.gem, GTMaterials.Coke).outputFluids(GTMaterials.Creosote.getFluid(500)).duration(900).save(provider);
        GTRecipeTypes.COKE_OVEN_RECIPES.recipeBuilder("coal_to_coke_block", new Object[0]).inputItems(TagPrefix.block, GTMaterials.Coal).outputItems(TagPrefix.block, GTMaterials.Coke).outputFluids(GTMaterials.Creosote.getFluid(4500)).duration(8100).save(provider);
    }

    private static void registerStoneBricksRecipes(Consumer<FinishedRecipe> provider) {
        List<ItemStack> cobbles = GTBlocks.STONE_BLOCKS.row((Object)StoneBlockType.COBBLE).values().stream().map(ItemStack::new).toList();
        List<ItemStack> mossCobbles = GTBlocks.STONE_BLOCKS.row((Object)StoneBlockType.COBBLE_MOSSY).values().stream().map(ItemStack::new).toList();
        List<ItemStack> stones = GTBlocks.STONE_BLOCKS.row((Object)StoneBlockType.STONE).values().stream().map(ItemStack::new).toList();
        List<ItemStack> polisheds = GTBlocks.STONE_BLOCKS.row((Object)StoneBlockType.POLISHED).values().stream().map(ItemStack::new).toList();
        List<ItemStack> bricks = GTBlocks.STONE_BLOCKS.row((Object)StoneBlockType.BRICKS).values().stream().map(ItemStack::new).toList();
        List<ItemStack> crackedBricks = GTBlocks.STONE_BLOCKS.row((Object)StoneBlockType.BRICKS_CRACKED).values().stream().map(ItemStack::new).toList();
        List<ItemStack> mossBricks = GTBlocks.STONE_BLOCKS.row((Object)StoneBlockType.BRICKS_MOSSY).values().stream().map(ItemStack::new).toList();
        List<ItemStack> chiseledBricks = GTBlocks.STONE_BLOCKS.row((Object)StoneBlockType.CHISELED).values().stream().map(ItemStack::new).toList();
        List<ItemStack> tiledBricks = GTBlocks.STONE_BLOCKS.row((Object)StoneBlockType.TILED).values().stream().map(ItemStack::new).toList();
        List<ItemStack> smallTiledBricks = GTBlocks.STONE_BLOCKS.row((Object)StoneBlockType.TILED_SMALL).values().stream().map(ItemStack::new).toList();
        List<ItemStack> windmillA = GTBlocks.STONE_BLOCKS.row((Object)StoneBlockType.WINDMILL_A).values().stream().map(ItemStack::new).toList();
        List<ItemStack> windmillB = GTBlocks.STONE_BLOCKS.row((Object)StoneBlockType.WINDMILL_B).values().stream().map(ItemStack::new).toList();
        List<ItemStack> squareBricks = GTBlocks.STONE_BLOCKS.row((Object)StoneBlockType.BRICKS_SQUARE).values().stream().map(ItemStack::new).toList();
        List<ItemStack> smallBricks = GTBlocks.STONE_BLOCKS.row((Object)StoneBlockType.BRICKS_SMALL).values().stream().map(ItemStack::new).toList();
        MachineRecipeLoader.registerSmoothRecipe(provider, cobbles, stones);
        MachineRecipeLoader.registerCobbleRecipe(provider, stones, cobbles);
        MachineRecipeLoader.registerMossRecipe(provider, cobbles, mossCobbles);
        MachineRecipeLoader.registerSmoothRecipe(provider, stones, polisheds);
        MachineRecipeLoader.registerBricksRecipe(provider, polisheds, bricks, MarkerMaterials.Color.LightBlue);
        MachineRecipeLoader.registerCobbleRecipe(provider, bricks, crackedBricks);
        MachineRecipeLoader.registerMossRecipe(provider, bricks, mossBricks);
        MachineRecipeLoader.registerBricksRecipe(provider, polisheds, chiseledBricks, MarkerMaterials.Color.White);
        MachineRecipeLoader.registerBricksRecipe(provider, polisheds, tiledBricks, MarkerMaterials.Color.Red);
        MachineRecipeLoader.registerBricksRecipe(provider, tiledBricks, smallTiledBricks, MarkerMaterials.Color.Red);
        MachineRecipeLoader.registerBricksRecipe(provider, polisheds, windmillA, MarkerMaterials.Color.Blue);
        MachineRecipeLoader.registerBricksRecipe(provider, polisheds, windmillB, MarkerMaterials.Color.Yellow);
        MachineRecipeLoader.registerBricksRecipe(provider, polisheds, squareBricks, MarkerMaterials.Color.Green);
        MachineRecipeLoader.registerBricksRecipe(provider, polisheds, smallBricks, MarkerMaterials.Color.Pink);
        for (int i = 0; i < stones.size(); ++i) {
            ResourceLocation bricksId = BuiltInRegistries.f_257033_.m_7981_((Object)bricks.get(i).m_41720_());
            GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + bricksId.m_135815_(), new Object[0]).inputItems(stones.get(i)).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_INGOT).outputItems(bricks.get(i)).duration(24).EUt(8L).save(provider);
        }
    }

    private static void registerMixingCrystallizationRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.AUTOCLAVE_RECIPES.recipeBuilder("silicon_dioxide_to_quartzite_gem", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.SiliconDioxide).inputFluids(GTMaterials.DistilledWater.getFluid(250)).chancedOutput(ChemicalHelper.get(TagPrefix.gem, GTMaterials.Quartzite), 1000, 1000).duration(1200).EUt(24L).save(provider);
        GTRecipeTypes.MIXER_RECIPES.recipeBuilder("indium_concentrate", new Object[0]).inputItems(TagPrefix.crushedPurified, GTMaterials.Sphalerite).inputItems(TagPrefix.crushedPurified, GTMaterials.Galena).inputFluids(GTMaterials.SulfuricAcid.getFluid(4000)).outputFluids(GTMaterials.IndiumConcentrate.getFluid(1000)).duration(60).EUt(150L).save(provider);
    }

    private static void registerAlloyRecipes(Consumer<FinishedRecipe> provider) {
        for (MaterialStack[] stack : alloySmelterList) {
            String recipeNape = stack[0].material().getName() + "_%s_and_" + stack[1].material().getName() + "_%s_into_" + stack[2].material().getName();
            if (stack[0].material().hasProperty(PropertyKey.INGOT)) {
                GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder(String.format(recipeNape, "ingot", "dust"), new Object[0]).duration((int)stack[2].amount() * 50).EUt(16L).inputItems(TagPrefix.ingot, stack[0].material(), (int)stack[0].amount()).inputItems(TagPrefix.dust, stack[1].material(), (int)stack[1].amount()).outputItems(ChemicalHelper.get(TagPrefix.ingot, stack[2].material(), (int)stack[2].amount())).save(provider);
            }
            if (stack[1].material().hasProperty(PropertyKey.INGOT)) {
                GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder(String.format(recipeNape, "dust", "ingot"), new Object[0]).duration((int)stack[2].amount() * 50).EUt(16L).inputItems(TagPrefix.dust, stack[0].material(), (int)stack[0].amount()).inputItems(TagPrefix.ingot, stack[1].material(), (int)stack[1].amount()).outputItems(ChemicalHelper.get(TagPrefix.ingot, stack[2].material(), (int)stack[2].amount())).save(provider);
            }
            if (stack[0].material().hasProperty(PropertyKey.INGOT) && stack[1].material().hasProperty(PropertyKey.INGOT)) {
                GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder(String.format(recipeNape, "ingot", "ingot"), new Object[0]).duration((int)stack[2].amount() * 50).EUt(16L).inputItems(TagPrefix.ingot, stack[0].material(), (int)stack[0].amount()).inputItems(TagPrefix.ingot, stack[1].material(), (int)stack[1].amount()).outputItems(ChemicalHelper.get(TagPrefix.ingot, stack[2].material(), (int)stack[2].amount())).save(provider);
            }
            GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder(String.format(recipeNape, "dust", "dust"), new Object[0]).duration((int)stack[2].amount() * 50).EUt(16L).inputItems(TagPrefix.dust, stack[0].material(), (int)stack[0].amount()).inputItems(TagPrefix.dust, stack[1].material(), (int)stack[1].amount()).outputItems(ChemicalHelper.get(TagPrefix.ingot, stack[2].material(), (int)stack[2].amount())).save(provider);
        }
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("carbon_mesh", new Object[0]).inputItems((Supplier<? extends Item>)GTItems.CARBON_FIBERS, 2).outputItems((Supplier<? extends ItemLike>)GTItems.CARBON_MESH).duration(100).EUt(2L).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("carbon_fiber_plate", new Object[0]).inputItems((Supplier<? extends Item>)GTItems.CARBON_MESH).outputItems((Supplier<? extends ItemLike>)GTItems.CARBON_FIBER_PLATE).duration(200).EUt(2L).save(provider);
        GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("rubber_sheet", new Object[0]).duration(10).EUt(GTValues.VA[0]).inputItems(TagPrefix.ingot, GTMaterials.Rubber, 2).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_PLATE).outputItems(TagPrefix.plate, GTMaterials.Rubber).save(provider);
        GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("rubber_bar", new Object[0]).duration(100).EUt(GTValues.VA[0]).inputItems(TagPrefix.dust, GTMaterials.Sulfur).inputItems(TagPrefix.dust, GTMaterials.RawRubber, 3).outputItems(TagPrefix.ingot, GTMaterials.Rubber).save(provider);
        GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("coke_oven_brick", new Object[0]).duration(150).EUt(GTValues.VA[0]).inputItems((TagKey<Item>)Tags.Items.SAND).inputItems(new ItemStack((ItemLike)Items.f_42461_)).outputItems((Supplier<? extends ItemLike>)GTItems.COKE_OVEN_BRICK, 2).save(provider);
    }

    private static void registerAssemblerRecipes(Consumer<FinishedRecipe> provider) {
        for (int i = 0; i < GTMaterials.CHEMICAL_DYES.length; ++i) {
            int lampMeta;
            GTRecipeTypes.CANNER_RECIPES.recipeBuilder("spray_can_" + GTMaterials.CHEMICAL_DYES[i].getName(), new Object[0]).inputItems((Supplier<? extends Item>)GTItems.SPRAY_EMPTY).inputFluids(GTMaterials.CHEMICAL_DYES[i].getFluid(576)).outputItems((Supplier<? extends ItemLike>)GTItems.SPRAY_CAN_DYES[i]).EUt(GTValues.VA[0]).duration(200).save(provider);
            DyeColor color = DyeColor.m_41053_((int)i);
            LampBlock lamp = (LampBlock)((Object)GTBlocks.LAMPS.get(color).get());
            for (lampMeta = 0; lampMeta < 8; ++lampMeta) {
                GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("lamp_" + String.valueOf(color) + "_" + lampMeta, new Object[0]).inputItems(TagPrefix.plate, GTMaterials.Glass, 6).inputItems(TagPrefix.dust, GTMaterials.Glowstone, 1).inputFluids(GTMaterials.CHEMICAL_DYES[i].getFluid(144)).outputItems(lamp.getStackFromIndex(lampMeta)).circuitMeta(lampMeta + 1).EUt(GTValues.VA[0]).duration(40).save(provider);
            }
            lamp = (LampBlock)((Object)GTBlocks.BORDERLESS_LAMPS.get(color).get());
            for (lampMeta = 0; lampMeta < 8; ++lampMeta) {
                GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("borderless_lamp_" + String.valueOf(color) + "_" + lampMeta, new Object[0]).inputItems(TagPrefix.plate, GTMaterials.Glass, 6).inputItems(TagPrefix.dust, GTMaterials.Glowstone, 1).inputFluids(GTMaterials.CHEMICAL_DYES[i].getFluid(144)).outputItems(lamp.getStackFromIndex(lampMeta)).circuitMeta(lampMeta + 9).EUt(GTValues.VA[0]).duration(40).save(provider);
            }
        }
        GTRecipeTypes.CANNER_RECIPES.recipeBuilder("spray_can_solvent", new Object[0]).inputItems((Supplier<? extends Item>)GTItems.SPRAY_EMPTY).inputFluids(GTMaterials.Acetone.getFluid(1000)).outputItems((Supplier<? extends ItemLike>)GTItems.SPRAY_SOLVENT).EUt(GTValues.VA[0]).duration(200).save(provider);
        GTRecipeTypes.CANNER_RECIPES.recipeBuilder("mask_filter", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.Polyethylene, 4).inputItems(TagPrefix.dust, GTMaterials.ActivatedCarbon, 2).outputItems((Supplier<? extends ItemLike>)GTItems.MASK_FILTER).duration(100).EUt(2L).save(provider);
        GTRecipeTypes.CANNER_RECIPES.recipeBuilder("pack_paracetamol", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Paracetamol, 16).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_PILL).outputItems(GTItems.PARACETAMOL_PILL.asStack(16)).duration(60).EUt(GTValues.VA[1]).save(provider);
        GTRecipeTypes.CANNER_RECIPES.recipeBuilder("pack_rad_away", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.RadAway, 16).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_PILL).outputItems(GTItems.RAD_AWAY_PILL.asStack(16)).duration(60).EUt(GTValues.VA[1]).save(provider);
        Material material = GTMaterials.Iron;
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_shutter", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42341_)).inputItems(TagPrefix.plate, material, 2).outputItems((Supplier<? extends ItemLike>)GTItems.COVER_SHUTTER, 2).EUt(16L).duration(100).save(provider);
        FluidStack solder = GTMaterials.SolderingAlloy.getFluid(72);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_machine_controller", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50164_)).inputItems(TagPrefix.plate, material).inputFluids(solder).outputItems((Supplier<? extends ItemLike>)GTItems.COVER_MACHINE_CONTROLLER).EUt(16L).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_energy_detector", new Object[0]).inputItems(TagPrefix.cableGtSingle, GTMaterials.Copper, 4).inputItems(CustomTags.LV_CIRCUITS).inputItems(TagPrefix.plate, material).inputFluids(solder).outputItems((Supplier<? extends ItemLike>)GTItems.COVER_ENERGY_DETECTOR).EUt(16L).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_advanced_energy_detector", new Object[0]).inputItems((Supplier<? extends Item>)GTItems.COVER_ENERGY_DETECTOR).inputItems((Supplier<? extends Item>)GTItems.SENSOR_HV).inputFluids(solder).outputItems((Supplier<? extends ItemLike>)GTItems.COVER_ENERGY_DETECTOR_ADVANCED).EUt(16L).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_activity_detector", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50174_)).inputItems(TagPrefix.plate, material).inputFluids(solder).outputItems((Supplier<? extends ItemLike>)GTItems.COVER_ACTIVITY_DETECTOR).EUt(16L).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_advanced_activity_cover", new Object[0]).inputItems(TagPrefix.wireFine, GTMaterials.Gold, 4).inputItems(CustomTags.HV_CIRCUITS).inputItems(TagPrefix.plate, GTMaterials.Aluminium).inputFluids(solder).outputItems((Supplier<? extends ItemLike>)GTItems.COVER_ACTIVITY_DETECTOR_ADVANCED).EUt(16L).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_fluid_detector", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50327_)).inputItems(TagPrefix.plate, material).inputFluids(solder).outputItems((Supplier<? extends ItemLike>)GTItems.COVER_FLUID_DETECTOR).EUt(16L).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_item_detector", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50326_)).inputItems(TagPrefix.plate, material).inputFluids(solder).outputItems((Supplier<? extends ItemLike>)GTItems.COVER_ITEM_DETECTOR).EUt(16L).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_advanced_fluid_detector", new Object[0]).inputItems((Supplier<? extends Item>)GTItems.COVER_FLUID_DETECTOR).inputItems((Supplier<? extends Item>)GTItems.SENSOR_HV).inputFluids(solder).outputItems((Supplier<? extends ItemLike>)GTItems.COVER_FLUID_DETECTOR_ADVANCED).EUt(16L).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_advanced_item_detector", new Object[0]).inputItems((Supplier<? extends Item>)GTItems.COVER_ITEM_DETECTOR).inputItems((Supplier<? extends Item>)GTItems.SENSOR_HV).inputFluids(solder).outputItems((Supplier<? extends ItemLike>)GTItems.COVER_ITEM_DETECTOR_ADVANCED).EUt(16L).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_maintenance_detector", new Object[0]).inputItems((Supplier<? extends Item>)GTItems.EMITTER_LV).inputItems(TagPrefix.plate, GTMaterials.Steel).inputFluids(solder).outputItems((Supplier<? extends ItemLike>)GTItems.COVER_MAINTENANCE_DETECTOR).EUt(16L).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_screen", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.Glass).inputItems(TagPrefix.foil, GTMaterials.Aluminium, 4).inputItems(CustomTags.LV_CIRCUITS).inputItems(TagPrefix.wireFine, GTMaterials.Copper, 4).outputItems((Supplier<? extends ItemLike>)GTItems.COVER_SCREEN).EUt(16L).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_infinite_water", new Object[0]).inputItems((Supplier<? extends Item>)GTItems.ELECTRIC_PUMP_HV, 2).inputItems(new ItemStack((ItemLike)Items.f_42544_)).inputItems(CustomTags.HV_CIRCUITS).outputItems((Supplier<? extends ItemLike>)GTItems.COVER_INFINITE_WATER).EUt(GTValues.VA[3]).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_ender_fluid_link", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.EnderPearl, 9).inputItems(TagPrefix.plateDouble, GTMaterials.StainlessSteel).inputItems((Supplier<? extends Item>)GTItems.SENSOR_HV).inputItems((Supplier<? extends Item>)GTItems.EMITTER_HV).inputItems((Supplier<? extends Item>)GTItems.ELECTRIC_PUMP_HV).inputFluids(GTMaterials.Polyethylene.getFluid(288)).outputItems((Supplier<? extends ItemLike>)GTItems.COVER_ENDER_FLUID_LINK).EUt(GTValues.VA[3]).duration(320).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cover_storage", new Object[0]).inputItems(Tags.Blocks.CHESTS_WOODEN).inputItems((Supplier<? extends Item>)GTItems.ELECTRIC_PISTON_LV).inputItems(TagPrefix.plate, GTMaterials.Iron).inputFluids(GTMaterials.SolderingAlloy.getFluid(72)).outputItems((Supplier<? extends ItemLike>)GTItems.COVER_STORAGE).EUt(16L).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_ulv", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.WroughtIron, 8).outputItems(GTBlocks.MACHINE_CASING_ULV.asStack()).circuitMeta(8).duration(25).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_lv", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Steel, 8).outputItems(GTBlocks.MACHINE_CASING_LV.asStack()).circuitMeta(8).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_mv", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Aluminium, 8).outputItems(GTBlocks.MACHINE_CASING_MV.asStack()).circuitMeta(8).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_hv", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.StainlessSteel, 8).outputItems(GTBlocks.MACHINE_CASING_HV.asStack()).circuitMeta(8).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_ev", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Titanium, 8).outputItems(GTBlocks.MACHINE_CASING_EV.asStack()).circuitMeta(8).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_iv", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.TungstenSteel, 8).outputItems(GTBlocks.MACHINE_CASING_IV.asStack()).circuitMeta(8).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_luv", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.RhodiumPlatedPalladium, 8).outputItems(GTBlocks.MACHINE_CASING_LuV.asStack()).circuitMeta(8).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_zpm", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.NaquadahAlloy, 8).outputItems(GTBlocks.MACHINE_CASING_ZPM.asStack()).circuitMeta(8).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_uv", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Darmstadtium, 8).outputItems(GTBlocks.MACHINE_CASING_UV.asStack()).circuitMeta(8).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_uhv", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Neutronium, 8).outputItems(GTBlocks.MACHINE_CASING_UHV.asStack()).circuitMeta(8).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("coil_cupronickel", new Object[0]).EUt(GTValues.VA[1]).inputItems(TagPrefix.wireGtDouble, GTMaterials.Cupronickel, 8).inputItems(TagPrefix.foil, GTMaterials.Bronze, 8).inputFluids(GTMaterials.TinAlloy.getFluid(144)).outputItems(GTBlocks.COIL_CUPRONICKEL.asStack()).duration(200).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("coil_kanthal", new Object[0]).EUt(GTValues.VA[2]).inputItems(TagPrefix.wireGtDouble, GTMaterials.Kanthal, 8).inputItems(TagPrefix.foil, GTMaterials.Aluminium, 8).inputFluids(GTMaterials.Copper.getFluid(144)).outputItems(GTBlocks.COIL_KANTHAL.asStack()).duration(300).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("coil_nichrome", new Object[0]).EUt(GTValues.VA[3]).inputItems(TagPrefix.wireGtDouble, GTMaterials.Nichrome, 8).inputItems(TagPrefix.foil, GTMaterials.StainlessSteel, 8).inputFluids(GTMaterials.Aluminium.getFluid(144)).outputItems(GTBlocks.COIL_NICHROME.asStack()).duration(400).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("coil_rtm_alloy", new Object[0]).EUt(GTValues.VA[4]).inputItems(TagPrefix.wireGtDouble, GTMaterials.RTMAlloy, 8).inputItems(TagPrefix.foil, GTMaterials.VanadiumSteel, 8).inputFluids(GTMaterials.Nichrome.getFluid(144)).outputItems(GTBlocks.COIL_RTMALLOY.asStack()).duration(500).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("coil_hssg", new Object[0]).EUt(GTValues.VA[5]).inputItems(TagPrefix.wireGtDouble, GTMaterials.HSSG, 8).inputItems(TagPrefix.foil, GTMaterials.TungstenCarbide, 8).inputFluids(GTMaterials.Tungsten.getFluid(144)).outputItems(GTBlocks.COIL_HSSG.asStack()).duration(600).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("coil_naquadah", new Object[0]).EUt(GTValues.VA[6]).inputItems(TagPrefix.wireGtDouble, GTMaterials.Naquadah, 8).inputItems(TagPrefix.foil, GTMaterials.Osmium, 8).inputFluids(GTMaterials.TungstenSteel.getFluid(144)).outputItems(GTBlocks.COIL_NAQUADAH.asStack()).duration(700).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("coil_trinium", new Object[0]).EUt(GTValues.VA[7]).inputItems(TagPrefix.wireGtDouble, GTMaterials.Trinium, 8).inputItems(TagPrefix.foil, GTMaterials.NaquadahEnriched, 8).inputFluids(GTMaterials.Naquadah.getFluid(144)).outputItems(GTBlocks.COIL_TRINIUM.asStack()).duration(800).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("coil_tritanium", new Object[0]).EUt(GTValues.VA[8]).inputItems(TagPrefix.wireGtDouble, GTMaterials.Tritanium, 8).inputItems(TagPrefix.foil, GTMaterials.Naquadria, 8).inputFluids(GTMaterials.Trinium.getFluid(144)).outputItems(GTBlocks.COIL_TRITANIUM.asStack()).duration(900).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_bronze_bricks", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Bronze, 6).inputItems(new ItemStack((ItemLike)Blocks.f_50076_)).circuitMeta(6).outputItems(GTBlocks.CASING_BRONZE_BRICKS.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_invar_heatproof", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Invar, 6).inputItems(TagPrefix.frameGt, GTMaterials.Invar).circuitMeta(6).outputItems(GTBlocks.CASING_INVAR_HEATPROOF.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_steel_solid", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Steel, 6).inputItems(TagPrefix.frameGt, GTMaterials.Steel).circuitMeta(6).outputItems(GTBlocks.CASING_STEEL_SOLID.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_aluminium_frostproof", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Aluminium, 6).inputItems(TagPrefix.frameGt, GTMaterials.Aluminium).circuitMeta(6).outputItems(GTBlocks.CASING_ALUMINIUM_FROSTPROOF.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_tungsteensteel_robust", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.TungstenSteel, 6).inputItems(TagPrefix.frameGt, GTMaterials.TungstenSteel).circuitMeta(6).outputItems(GTBlocks.CASING_TUNGSTENSTEEL_ROBUST.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_stainless_clean", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.StainlessSteel, 6).inputItems(TagPrefix.frameGt, GTMaterials.StainlessSteel).circuitMeta(6).outputItems(GTBlocks.CASING_STAINLESS_CLEAN.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_titanium_stable", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Titanium, 6).inputItems(TagPrefix.frameGt, GTMaterials.Titanium).circuitMeta(6).outputItems(GTBlocks.CASING_TITANIUM_STABLE.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_hsse_sturdy", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.HSSE, 6).inputItems(TagPrefix.frameGt, GTMaterials.Europium).circuitMeta(6).outputItems(GTBlocks.CASING_HSSE_STURDY.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_palladium_substation", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Palladium, 6).inputItems(TagPrefix.frameGt, GTMaterials.Iridium).circuitMeta(6).outputItems(GTBlocks.CASING_PALLADIUM_SUBSTATION.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_stainless_evaporation", new Object[0]).inputItems(GTBlocks.CASING_STAINLESS_CLEAN.asStack(1)).inputItems(TagPrefix.wireGtDouble, GTMaterials.AnnealedCopper, 4).inputFluids(GTMaterials.PolyvinylChloride.getFluid(288)).outputItems(GTBlocks.CASING_STAINLESS_EVAPORATION.asStack(1)).duration(30).EUt(GTValues.VA[3]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_ptfe_inert", new Object[0]).EUt(16L).inputItems(GTBlocks.CASING_STEEL_SOLID.asStack()).inputFluids(GTMaterials.Polytetrafluoroethylene.getFluid(216)).circuitMeta(6).outputItems(GTBlocks.CASING_PTFE_INERT.asStack()).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("superconducting_coil_luv", new Object[0]).EUt(GTValues.VA[6]).inputItems(TagPrefix.wireGtDouble, GTMaterials.IndiumTinBariumTitaniumCuprate, 32).inputItems(TagPrefix.foil, GTMaterials.NiobiumTitanium, 32).inputFluids(GTMaterials.Trinium.getFluid(3456)).outputItems(GTBlocks.SUPERCONDUCTING_COIL.asStack()).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("superconducting_coil_zpm", new Object[0]).EUt(GTValues.VA[7]).inputItems(TagPrefix.wireGtDouble, GTMaterials.UraniumRhodiumDinaquadide, 16).inputItems(TagPrefix.foil, GTMaterials.NiobiumTitanium, 16).inputFluids(GTMaterials.Trinium.getFluid(2304)).outputItems(GTBlocks.SUPERCONDUCTING_COIL.asStack()).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("superconducting_coil_uv", new Object[0]).EUt(GTValues.VA[8]).inputItems(TagPrefix.wireGtDouble, GTMaterials.EnrichedNaquadahTriniumEuropiumDuranide, 8).inputItems(TagPrefix.foil, GTMaterials.NiobiumTitanium, 8).inputFluids(GTMaterials.Trinium.getFluid(1152)).outputItems(GTBlocks.SUPERCONDUCTING_COIL.asStack()).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fusion_coil", new Object[0]).EUt(GTValues.VA[7]).inputItems(GTBlocks.SUPERCONDUCTING_COIL.asStack()).inputItems(GTItems.FIELD_GENERATOR_IV.asStack(2)).inputItems((Supplier<? extends Item>)GTItems.ELECTRIC_PUMP_IV).inputItems(GTItems.NEUTRON_REFLECTOR.asStack(2)).inputItems(CustomTags.LuV_CIRCUITS, 4).inputItems(TagPrefix.pipeSmallFluid, GTMaterials.Naquadah, 4).inputItems(TagPrefix.plate, GTMaterials.Europium, 4).inputFluids(GTMaterials.VanadiumGallium.getFluid(576)).outputItems(GTBlocks.FUSION_COIL.asStack()).duration(100).cleanroom(CleanroomType.CLEANROOM).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fusion_glass", new Object[0]).EUt(GTValues.VA[6]).inputItems(GTBlocks.CASING_LAMINATED_GLASS.asStack()).inputItems(TagPrefix.plate, GTMaterials.Naquadah, 4).inputItems(GTItems.NEUTRON_REFLECTOR.asStack(4)).outputItems(GTBlocks.FUSION_GLASS.asStack(2)).inputFluids(GTMaterials.Polybenzimidazole.getFluid(144)).duration(50).cleanroom(CleanroomType.CLEANROOM).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fusion_casing", new Object[0]).EUt(GTValues.VA[6]).inputItems(GTBlocks.MACHINE_CASING_LuV.asStack()).inputItems(GTBlocks.SUPERCONDUCTING_COIL.asStack()).inputItems((Supplier<? extends Item>)GTItems.NEUTRON_REFLECTOR).inputItems((Supplier<? extends Item>)GTItems.ELECTRIC_PUMP_LuV).inputItems(TagPrefix.plate, GTMaterials.TungstenSteel, 6).inputFluids(GTMaterials.Polybenzimidazole.getFluid(144)).outputItems(GTBlocks.FUSION_CASING.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(100).cleanroom(CleanroomType.CLEANROOM).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fusion_casing_mk2", new Object[0]).EUt(GTValues.VA[7]).inputItems(GTBlocks.MACHINE_CASING_ZPM.asStack()).inputItems(GTBlocks.FUSION_COIL.asStack()).inputItems(GTItems.VOLTAGE_COIL_ZPM.asStack(2)).inputItems((Supplier<? extends Item>)GTItems.FIELD_GENERATOR_LuV).inputItems(TagPrefix.plate, GTMaterials.Europium, 6).inputFluids(GTMaterials.Polybenzimidazole.getFluid(288)).outputItems(GTBlocks.FUSION_CASING_MK2.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(100).cleanroom(CleanroomType.CLEANROOM).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fusion_casing_mk3", new Object[0]).EUt(GTValues.VA[8]).inputItems(GTBlocks.MACHINE_CASING_UV.asStack()).inputItems(GTBlocks.FUSION_COIL.asStack()).inputItems(GTItems.VOLTAGE_COIL_UV.asStack(2)).inputItems((Supplier<? extends Item>)GTItems.FIELD_GENERATOR_ZPM).inputItems(TagPrefix.plate, GTMaterials.Americium, 6).inputFluids(GTMaterials.Polybenzimidazole.getFluid(576)).outputItems(GTBlocks.FUSION_CASING_MK3.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(100).cleanroom(CleanroomType.CLEANROOM).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_steel_turbine", new Object[0]).EUt(16L).inputItems(TagPrefix.plate, GTMaterials.Magnalium, 6).inputItems(TagPrefix.frameGt, GTMaterials.BlueSteel, 1).circuitMeta(6).outputItems(GTBlocks.CASING_STEEL_TURBINE.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_stainless_steel_turbine", new Object[0]).EUt(16L).inputItems(GTBlocks.CASING_STEEL_TURBINE.asStack()).inputItems(TagPrefix.plate, GTMaterials.StainlessSteel, 6).circuitMeta(6).outputItems(GTBlocks.CASING_STAINLESS_TURBINE.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_titanium_turbine", new Object[0]).EUt(16L).inputItems(GTBlocks.CASING_STEEL_TURBINE.asStack()).inputItems(TagPrefix.plate, GTMaterials.Titanium, 6).circuitMeta(6).outputItems(GTBlocks.CASING_TITANIUM_TURBINE.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("casing_tungstensteel_turbine", new Object[0]).EUt(16L).inputItems(GTBlocks.CASING_STEEL_TURBINE.asStack()).inputItems(TagPrefix.plate, GTMaterials.TungstenSteel, 6).circuitMeta(6).outputItems(GTBlocks.CASING_TUNGSTENSTEEL_TURBINE.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(50).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("plascrete", new Object[0]).EUt(48L).inputItems(TagPrefix.frameGt, GTMaterials.Steel).inputItems(TagPrefix.plate, GTMaterials.Polyethylene, 6).inputFluids(GTMaterials.Concrete.getFluid(144)).outputItems(GTBlocks.PLASTCRETE.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(200).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cleanroom_glass", new Object[0]).EUt(48L).inputItems(TagPrefix.frameGt, GTMaterials.Steel).inputItems(TagPrefix.plate, GTMaterials.Polyethylene, 6).inputFluids(GTMaterials.Glass.getFluid(144)).outputItems(GTBlocks.CLEANROOM_GLASS.asStack(ConfigHolder.INSTANCE.recipes.casingsPerCraft)).duration(200).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hull_ulv", new Object[0]).duration(25).EUt(16L).inputItems(GTBlocks.MACHINE_CASING_ULV.asStack()).inputItems(TagPrefix.cableGtSingle, GTMaterials.RedAlloy, 2).inputFluids(GTMaterials.Polyethylene.getFluid(288)).outputItems(GTMachines.HULL[0]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hull_lv", new Object[0]).duration(50).EUt(16L).inputItems(GTBlocks.MACHINE_CASING_LV.asStack()).inputItems(TagPrefix.cableGtSingle, GTMaterials.Tin, 2).inputFluids(GTMaterials.Polyethylene.getFluid(288)).outputItems(GTMachines.HULL[1]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hull_mv", new Object[0]).duration(50).EUt(16L).inputItems(GTBlocks.MACHINE_CASING_MV.asStack()).inputItems(TagPrefix.cableGtSingle, GTMaterials.Copper, 2).inputFluids(GTMaterials.Polyethylene.getFluid(288)).outputItems(GTMachines.HULL[2]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hull_mv_annealed", new Object[0]).duration(50).EUt(16L).inputItems(GTBlocks.MACHINE_CASING_MV.asStack()).inputItems(TagPrefix.cableGtSingle, GTMaterials.AnnealedCopper, 2).inputFluids(GTMaterials.Polyethylene.getFluid(288)).outputItems(GTMachines.HULL[2]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hull_hv", new Object[0]).duration(50).EUt(16L).inputItems(GTBlocks.MACHINE_CASING_HV.asStack()).inputItems(TagPrefix.cableGtSingle, GTMaterials.Gold, 2).inputFluids(GTMaterials.Polyethylene.getFluid(288)).outputItems(GTMachines.HULL[3]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hull_ev", new Object[0]).duration(50).EUt(16L).inputItems(GTBlocks.MACHINE_CASING_EV.asStack()).inputItems(TagPrefix.cableGtSingle, GTMaterials.Aluminium, 2).inputFluids(GTMaterials.Polyethylene.getFluid(288)).outputItems(GTMachines.HULL[4]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hull_iv", new Object[0]).duration(50).EUt(16L).inputItems(GTBlocks.MACHINE_CASING_IV.asStack()).inputItems(TagPrefix.cableGtSingle, GTMaterials.Platinum, 2).inputFluids(GTMaterials.Polytetrafluoroethylene.getFluid(288)).outputItems(GTMachines.HULL[5]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hull_luv", new Object[0]).duration(50).EUt(16L).inputItems(GTBlocks.MACHINE_CASING_LuV.asStack()).inputItems(TagPrefix.cableGtSingle, GTMaterials.NiobiumTitanium, 2).inputFluids(GTMaterials.Polytetrafluoroethylene.getFluid(288)).outputItems(GTMachines.HULL[6]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hull_zpm", new Object[0]).duration(50).EUt(16L).inputItems(GTBlocks.MACHINE_CASING_ZPM.asStack()).inputItems(TagPrefix.cableGtSingle, GTMaterials.VanadiumGallium, 2).inputFluids(GTMaterials.Polybenzimidazole.getFluid(288)).outputItems(GTMachines.HULL[7]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hull_uv", new Object[0]).duration(50).EUt(16L).inputItems(GTBlocks.MACHINE_CASING_UV.asStack()).inputItems(TagPrefix.cableGtSingle, GTMaterials.YttriumBariumCuprate, 2).inputFluids(GTMaterials.Polybenzimidazole.getFluid(288)).outputItems(GTMachines.HULL[8]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hull_uhv", new Object[0]).duration(50).EUt(16L).inputItems(GTBlocks.MACHINE_CASING_UHV.asStack()).inputItems(TagPrefix.cableGtSingle, GTMaterials.Europium, 2).inputFluids(GTMaterials.Polybenzimidazole.getFluid(288)).outputItems(GTMachines.HULL[9]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hopper_iron", new Object[0]).EUt(2L).inputItems((TagKey<Item>)Tags.Items.CHESTS_WOODEN).inputItems(TagPrefix.plate, GTMaterials.Iron, 5).outputItems(new ItemStack((ItemLike)Blocks.f_50332_)).duration(800).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hopper_wrought_iron", new Object[0]).EUt(2L).inputItems((TagKey<Item>)Tags.Items.CHESTS_WOODEN).inputItems(TagPrefix.plate, GTMaterials.WroughtIron, 5).outputItems(new ItemStack((ItemLike)Blocks.f_50332_)).duration(800).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("wooden_crate", new Object[0]).EUt(16L).inputItems((TagKey<Item>)ItemTags.f_13168_, 4).inputItems(TagPrefix.screw, GTMaterials.Iron, 4).outputItems(GTMachines.WOODEN_CRATE).duration(100).circuitMeta(5).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("bronze_crate", new Object[0]).EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.Bronze, 4).inputItems(TagPrefix.plate, GTMaterials.Bronze, 4).outputItems(GTMachines.BRONZE_CRATE).duration(200).circuitMeta(1).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("steel_crate", new Object[0]).EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.Steel, 4).inputItems(TagPrefix.plate, GTMaterials.Steel, 4).outputItems(GTMachines.STEEL_CRATE).duration(200).circuitMeta(1).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("aluminium_crate", new Object[0]).EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.Aluminium, 4).inputItems(TagPrefix.plate, GTMaterials.Aluminium, 4).outputItems(GTMachines.ALUMINIUM_CRATE).duration(200).circuitMeta(1).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("stainless_steel_crate", new Object[0]).EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.StainlessSteel, 4).inputItems(TagPrefix.plate, GTMaterials.StainlessSteel, 4).outputItems(GTMachines.STAINLESS_STEEL_CRATE).circuitMeta(1).duration(200).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("titanium_crate", new Object[0]).EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.Titanium, 4).inputItems(TagPrefix.plate, GTMaterials.Titanium, 4).outputItems(GTMachines.TITANIUM_CRATE).duration(200).circuitMeta(1).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("tungstensteel_crate", new Object[0]).EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.TungstenSteel, 4).inputItems(TagPrefix.plate, GTMaterials.TungstenSteel, 4).outputItems(GTMachines.TUNGSTENSTEEL_CRATE).duration(200).circuitMeta(1).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("wood_barrel", new Object[0]).EUt(16L).inputItems((TagKey<Item>)ItemTags.f_13168_, 4).inputItems(TagPrefix.rodLong, GTMaterials.Iron, 2).outputItems(GTMachines.WOODEN_DRUM).duration(200).circuitMeta(2).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("bronze_drum", new Object[0]).EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.Bronze, 2).inputItems(TagPrefix.plate, GTMaterials.Bronze, 4).outputItems(GTMachines.BRONZE_DRUM).duration(200).circuitMeta(2).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("steel_drum", new Object[0]).EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.Steel, 2).inputItems(TagPrefix.plate, GTMaterials.Steel, 4).outputItems(GTMachines.STEEL_DRUM).duration(200).circuitMeta(2).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("aluminium_drum", new Object[0]).EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.Aluminium, 2).inputItems(TagPrefix.plate, GTMaterials.Aluminium, 4).outputItems(GTMachines.ALUMINIUM_DRUM).duration(200).circuitMeta(2).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("stainless_steel_drum", new Object[0]).EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.StainlessSteel, 2).inputItems(TagPrefix.plate, GTMaterials.StainlessSteel, 4).outputItems(GTMachines.STAINLESS_STEEL_DRUM).duration(200).circuitMeta(2).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("gold_drum", new Object[0]).EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.Gold, 2).inputItems(TagPrefix.plate, GTMaterials.Gold, 4).outputItems(GTMachines.GOLD_DRUM).duration(200).circuitMeta(2).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("titanium_drum", new Object[0]).EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.Titanium, 2).inputItems(TagPrefix.plate, GTMaterials.Titanium, 4).outputItems(GTMachines.TITANIUM_DRUM).duration(200).circuitMeta(2).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("tungstensteel_drum", new Object[0]).EUt(16L).inputItems(TagPrefix.rodLong, GTMaterials.TungstenSteel, 2).inputItems(TagPrefix.plate, GTMaterials.TungstenSteel, 4).outputItems(GTMachines.TUNGSTENSTEEL_DRUM).duration(200).circuitMeta(2).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("duct_tape_polyethylene", new Object[0]).EUt(GTValues.VA[1]).inputItems(TagPrefix.foil, GTMaterials.Polyethylene, 4).inputItems((Supplier<? extends Item>)GTItems.CARBON_MESH).inputFluids(GTMaterials.Polyethylene.getFluid(288)).outputItems((Supplier<? extends ItemLike>)GTItems.DUCT_TAPE).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("duct_tape_silicone_rubber", new Object[0]).EUt(GTValues.VA[1]).inputItems(TagPrefix.foil, GTMaterials.SiliconeRubber, 2).inputItems((Supplier<? extends Item>)GTItems.CARBON_MESH).inputFluids(GTMaterials.Polyethylene.getFluid(288)).outputItems((Supplier<? extends ItemLike>)GTItems.DUCT_TAPE, 2).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("duct_tape_polycaprolactam", new Object[0]).EUt(GTValues.VA[1]).inputItems(TagPrefix.foil, GTMaterials.Polycaprolactam, 2).inputItems((Supplier<? extends Item>)GTItems.CARBON_MESH).inputFluids(GTMaterials.Polyethylene.getFluid(144)).outputItems((Supplier<? extends ItemLike>)GTItems.DUCT_TAPE, 4).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("duct_tape_polybenzimidazole", new Object[0]).EUt(GTValues.VA[1]).inputItems(TagPrefix.foil, GTMaterials.Polybenzimidazole).inputItems((Supplier<? extends Item>)GTItems.CARBON_MESH).inputFluids(GTMaterials.Polyethylene.getFluid(72)).outputItems((Supplier<? extends ItemLike>)GTItems.DUCT_TAPE, 8).duration(100).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, "basic_tape", GTItems.BASIC_TAPE.asStack(), " P ", "PSP", " P ", Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Paper), Character.valueOf('S'), GTItems.STICKY_RESIN.m_5456_());
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("basic_tape", new Object[0]).EUt(GTValues.VA[0]).inputItems(TagPrefix.plate, GTMaterials.Paper, 2).inputItems((Supplier<? extends Item>)GTItems.STICKY_RESIN).outputItems((Supplier<? extends ItemLike>)GTItems.BASIC_TAPE, 2).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fluid_cell_large_steel", new Object[0]).inputItems(TagPrefix.plateDouble, GTMaterials.Steel, 2).inputItems(TagPrefix.ring, GTMaterials.Bronze, 2).outputItems((Supplier<? extends ItemLike>)GTItems.FLUID_CELL_LARGE_STEEL).duration(200).EUt(GTValues.VA[1]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fluid_cell_large_aluminium", new Object[0]).inputItems(TagPrefix.plateDouble, GTMaterials.Aluminium, 2).inputItems(TagPrefix.ring, GTMaterials.Silver, 2).outputItems((Supplier<? extends ItemLike>)GTItems.FLUID_CELL_LARGE_ALUMINIUM).duration(200).EUt(64L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fluid_cell_large_stainless_steel", new Object[0]).inputItems(TagPrefix.plateDouble, GTMaterials.StainlessSteel, 3).inputItems(TagPrefix.ring, GTMaterials.Electrum, 3).outputItems((Supplier<? extends ItemLike>)GTItems.FLUID_CELL_LARGE_STAINLESS_STEEL).duration(200).EUt(GTValues.VA[2]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fluid_cell_large_titanium", new Object[0]).inputItems(TagPrefix.plateDouble, GTMaterials.Titanium, 3).inputItems(TagPrefix.ring, GTMaterials.RoseGold, 3).outputItems((Supplier<? extends ItemLike>)GTItems.FLUID_CELL_LARGE_TITANIUM).duration(200).EUt(256L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("fluid_cell_large_tungstensteel", new Object[0]).inputItems(TagPrefix.plateDouble, GTMaterials.TungstenSteel, 4).inputItems(TagPrefix.ring, GTMaterials.Platinum, 4).outputItems((Supplier<? extends ItemLike>)GTItems.FLUID_CELL_LARGE_TUNGSTEN_STEEL).duration(200).EUt(GTValues.VA[3]).save(provider);
    }

    private static void registerBlastFurnaceRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("aluminium_from_ruby_dust", new Object[0]).duration(400).EUt(100L).inputItems(TagPrefix.dust, GTMaterials.Ruby).outputItems(TagPrefix.nugget, GTMaterials.Aluminium, 3).chancedOutput(TagPrefix.dust, GTMaterials.Ash, "1/9", 0).blastFurnaceTemp(1200).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("aluminium_from_ruby_gem", new Object[0]).duration(320).EUt(100L).inputItems(TagPrefix.gem, GTMaterials.Ruby).outputItems(TagPrefix.nugget, GTMaterials.Aluminium, 3).chancedOutput(TagPrefix.dust, GTMaterials.Ash, "1/9", 0).blastFurnaceTemp(1200).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("aluminium_from_green_sapphire_dust", new Object[0]).duration(400).EUt(100L).inputItems(TagPrefix.dust, GTMaterials.GreenSapphire).outputItems(TagPrefix.nugget, GTMaterials.Aluminium, 3).chancedOutput(TagPrefix.dust, GTMaterials.Ash, "1/9", 0).blastFurnaceTemp(1200).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("aluminium_from_green_sapphire_gem", new Object[0]).duration(320).EUt(100L).inputItems(TagPrefix.gem, GTMaterials.GreenSapphire).outputItems(TagPrefix.nugget, GTMaterials.Aluminium, 3).chancedOutput(TagPrefix.dust, GTMaterials.Ash, "1/9", 0).blastFurnaceTemp(1200).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("aluminium_from_sapphire_dust", new Object[0]).duration(400).EUt(100L).inputItems(TagPrefix.dust, GTMaterials.Sapphire).outputItems(TagPrefix.nugget, GTMaterials.Aluminium, 3).blastFurnaceTemp(1200).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("aluminium_from_sapphire_gem", new Object[0]).duration(320).EUt(100L).inputItems(TagPrefix.gem, GTMaterials.Sapphire).outputItems(TagPrefix.nugget, GTMaterials.Aluminium, 3).blastFurnaceTemp(1200).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("titanium_from_tetrachloride", new Object[0]).duration(800).EUt(GTValues.VA[3]).inputItems(TagPrefix.dust, GTMaterials.Magnesium, 2).inputFluids(GTMaterials.TitaniumTetrachloride.getFluid(1000)).outputItems(TagPrefix.ingotHot, GTMaterials.Titanium).outputItems(TagPrefix.dust, GTMaterials.MagnesiumChloride, 6).blastFurnaceTemp(GTMaterials.Titanium.getBlastTemperature() + 200).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("steel_from_iron", new Object[0]).duration(500).EUt(GTValues.VA[2]).inputItems(TagPrefix.ingot, GTMaterials.Iron).inputFluids(GTMaterials.Oxygen.getFluid(200)).outputItems(TagPrefix.ingot, GTMaterials.Steel).chancedOutput(TagPrefix.dust, GTMaterials.Ash, "1/9", 0).blastFurnaceTemp(1000).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("steel_from_wrought_iron", new Object[0]).duration(300).EUt(GTValues.VA[2]).inputItems(TagPrefix.ingot, GTMaterials.WroughtIron).inputFluids(GTMaterials.Oxygen.getFluid(200)).outputItems(TagPrefix.ingot, GTMaterials.Steel).chancedOutput(TagPrefix.dust, GTMaterials.Ash, "1/9", 0).blastFurnaceTemp(1000).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("rutile_from_ilmenite", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Ilmenite, 10).inputItems(TagPrefix.dust, GTMaterials.Carbon, 4).outputItems(TagPrefix.ingot, GTMaterials.WroughtIron, 2).outputItems(TagPrefix.dust, GTMaterials.Rutile, 4).outputFluids(GTMaterials.CarbonDioxide.getFluid(2000)).blastFurnaceTemp(1700).duration(1600).EUt(GTValues.VA[3]).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("tempered_glass_blasting", new Object[0]).inputItems(TagPrefix.block, GTMaterials.Glass).inputFluids(GTMaterials.Oxygen.getFluid(100)).outputItems(GTBlocks.CASING_TEMPERED_GLASS.asStack()).blastFurnaceTemp(1000).duration(200).EUt(GTValues.VA[2]).save(provider);
        MachineRecipeLoader.registerBlastFurnaceMetallurgyRecipes(provider);
    }

    private static void registerBlastFurnaceMetallurgyRecipes(Consumer<FinishedRecipe> provider) {
        MachineRecipeLoader.createSulfurDioxideRecipe(provider, GTMaterials.Stibnite, GTMaterials.AntimonyTrioxide, 1500);
        MachineRecipeLoader.createSulfurDioxideRecipe(provider, GTMaterials.Sphalerite, GTMaterials.Zincite, 1000);
        MachineRecipeLoader.createSulfurDioxideRecipe(provider, GTMaterials.Pyrite, GTMaterials.Hematite, 2000);
        MachineRecipeLoader.createSulfurDioxideRecipe(provider, GTMaterials.Pentlandite, GTMaterials.Garnierite, 1000);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("tetrahedrite_metallurgy", new Object[0]).duration(120).EUt(GTValues.VA[2]).blastFurnaceTemp(1200).inputItems(TagPrefix.dust, GTMaterials.Tetrahedrite).inputFluids(GTMaterials.Oxygen.getFluid(3000)).outputItems(TagPrefix.dust, GTMaterials.CupricOxide).outputItems(TagPrefix.dustTiny, GTMaterials.AntimonyTrioxide, 3).outputFluids(GTMaterials.SulfurDioxide.getFluid(2000)).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("cobaltite_metallurgy", new Object[0]).duration(120).EUt(GTValues.VA[2]).blastFurnaceTemp(1200).inputItems(TagPrefix.dust, GTMaterials.Cobaltite).inputFluids(GTMaterials.Oxygen.getFluid(3000)).outputItems(TagPrefix.dust, GTMaterials.CobaltOxide).outputItems(TagPrefix.dust, GTMaterials.ArsenicTrioxide).outputFluids(GTMaterials.SulfurDioxide.getFluid(1000)).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("galena_metallurgy", new Object[0]).duration(120).EUt(GTValues.VA[2]).blastFurnaceTemp(1200).inputItems(TagPrefix.dust, GTMaterials.Galena).inputFluids(GTMaterials.Oxygen.getFluid(3000)).outputItems(TagPrefix.dust, GTMaterials.Massicot).outputItems(TagPrefix.nugget, GTMaterials.Silver, 6).outputFluids(GTMaterials.SulfurDioxide.getFluid(1000)).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("chalcopyrite_metallurgy", new Object[0]).duration(120).EUt(GTValues.VA[2]).blastFurnaceTemp(1200).inputItems(TagPrefix.dust, GTMaterials.Chalcopyrite).inputItems(TagPrefix.dust, GTMaterials.SiliconDioxide).inputFluids(GTMaterials.Oxygen.getFluid(3000)).outputItems(TagPrefix.dust, GTMaterials.CupricOxide).outputItems(TagPrefix.dust, GTMaterials.Ferrosilite).outputFluids(GTMaterials.SulfurDioxide.getFluid(2000)).save(provider);
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder("blast_silicon_dioxide", new Object[0]).duration(240).EUt(GTValues.VA[2]).blastFurnaceTemp(2273).inputItems(TagPrefix.dust, GTMaterials.SiliconDioxide, 3).inputItems(TagPrefix.dust, GTMaterials.Carbon, 2).outputItems(TagPrefix.ingotHot, GTMaterials.Silicon).chancedOutput(TagPrefix.dust, GTMaterials.Ash, "1/9", 0).outputFluids(GTMaterials.CarbonMonoxide.getFluid(2000)).save(provider);
    }

    private static void createSulfurDioxideRecipe(Consumer<FinishedRecipe> provider, Material inputMaterial, Material outputMaterial, int sulfurDioxideAmount) {
        GTRecipeTypes.BLAST_RECIPES.recipeBuilder(inputMaterial.getName() + "_metallurgy", new Object[0]).duration(120).EUt(GTValues.VA[2]).blastFurnaceTemp(1200).inputItems(TagPrefix.dust, inputMaterial).inputFluids(GTMaterials.Oxygen.getFluid(3000)).outputItems(TagPrefix.dust, outputMaterial).chancedOutput(TagPrefix.dust, GTMaterials.Ash, "1/9", 0).outputFluids(GTMaterials.SulfurDioxide.getFluid(sulfurDioxideAmount)).save(provider);
    }

    private static void registerDecompositionRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("raw_rubber_from_resin", new Object[0]).inputItems((Supplier<? extends Item>)GTItems.STICKY_RESIN).outputItems(TagPrefix.dust, GTMaterials.RawRubber, 3).duration(150).EUt(2L).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("raw_rubber_from_leaves", new Object[0]).duration(300).EUt(2L).inputItems(GTBlocks.RUBBER_LEAVES.asStack(16)).outputItems(TagPrefix.dust, GTMaterials.RawRubber).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("raw_rubber_from_log", new Object[0]).duration(300).EUt(2L).inputItems(GTBlocks.RUBBER_LOG.asStack()).outputItems(TagPrefix.dust, GTMaterials.RawRubber).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("raw_rubber_from_sapling", new Object[0]).duration(300).EUt(2L).inputItems(GTBlocks.RUBBER_SAPLING.asStack()).outputItems(TagPrefix.dust, GTMaterials.RawRubber).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("raw_rubber_from_slime", new Object[0]).duration(150).EUt(2L).inputItems(new ItemStack((ItemLike)Items.f_42518_)).outputItems(TagPrefix.dust, GTMaterials.RawRubber, 2).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_sapling", new Object[0]).duration(300).EUt(2L).inputItems((TagKey<Item>)ItemTags.f_13180_).outputItems((Supplier<? extends ItemLike>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_wheat", new Object[0]).duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Items.f_42405_, 8)).outputItems((Supplier<? extends ItemLike>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_potato", new Object[0]).duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Items.f_42620_, 8)).outputItems((Supplier<? extends ItemLike>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_carrot", new Object[0]).duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Items.f_42619_, 8)).outputItems((Supplier<? extends ItemLike>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_cactus", new Object[0]).duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Blocks.f_50128_, 8)).outputItems((Supplier<? extends ItemLike>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_sugar_cane", new Object[0]).duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Items.f_41909_, 8)).outputItems((Supplier<? extends ItemLike>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_brown_mushroom", new Object[0]).duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Blocks.f_50072_, 8)).outputItems((Supplier<? extends ItemLike>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_red_mushroom", new Object[0]).duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Blocks.f_50073_, 8)).outputItems((Supplier<? extends ItemLike>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_beetroot", new Object[0]).duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Items.f_42732_, 8)).outputItems((Supplier<? extends ItemLike>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_moss", new Object[0]).duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Items.f_151016_, 8)).outputItems((Supplier<? extends ItemLike>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_nether_wart", new Object[0]).duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Items.f_42259_, 8)).outputItems((Supplier<? extends ItemLike>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_crimson_stem", new Object[0]).duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Items.f_41843_, 8)).outputItems((Supplier<? extends ItemLike>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_warped_stem", new Object[0]).duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Items.f_41844_, 8)).outputItems((Supplier<? extends ItemLike>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_brain_coral", new Object[0]).duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Items.f_42291_, 8)).outputItems((Supplier<? extends ItemLike>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_bubble_coral", new Object[0]).duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Items.f_42292_, 8)).outputItems((Supplier<? extends ItemLike>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_fire_coral", new Object[0]).duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Items.f_42293_, 8)).outputItems((Supplier<? extends ItemLike>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_tube_coral", new Object[0]).duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Items.f_42290_, 8)).outputItems((Supplier<? extends ItemLike>)GTItems.PLANT_BALL).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("plant_ball_from_horn_coral", new Object[0]).duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Items.f_42294_, 8)).outputItems((Supplier<? extends ItemLike>)GTItems.PLANT_BALL).save(provider);
    }

    private static void registerRecyclingRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_end_stone", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50259_)).outputItems(TagPrefix.dust, GTMaterials.Endstone).chancedOutput(TagPrefix.dust, GTMaterials.Tungstate, 130, 30).duration(150).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_netherrack", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50134_)).outputItems(TagPrefix.dust, GTMaterials.Netherrack).chancedOutput(TagPrefix.nugget, GTMaterials.Gold, 500, 120).duration(150).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_obsidian", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50080_)).outputItems(TagPrefix.dust, GTMaterials.Obsidian).duration(150).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_marble", new Object[0]).inputItems(TagPrefix.rock, GTMaterials.Marble).outputItems(TagPrefix.dust, GTMaterials.Marble).chancedOutput(TagPrefix.dust, GTMaterials.Marble, 1000, 380).duration(150).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_basalt", new Object[0]).inputItems(Blocks.f_50137_.m_5456_()).outputItems(TagPrefix.dust, GTMaterials.Basalt).chancedOutput(TagPrefix.dust, GTMaterials.Basalt, 1000, 380).duration(150).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_deepslate", new Object[0]).inputItems(Blocks.f_152550_.m_5456_()).outputItems(TagPrefix.dust, GTMaterials.Deepslate).chancedOutput(TagPrefix.dust, GTMaterials.Thorium, 100, 40).duration(150).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_red_granite", new Object[0]).inputItems(TagPrefix.rock, GTMaterials.GraniteRed).outputItems(TagPrefix.dust, GTMaterials.GraniteRed).chancedOutput(TagPrefix.dust, GTMaterials.Uranium238, 10, 5).duration(150).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_andesite", new Object[0]).inputItems(Blocks.f_50334_.m_5456_()).outputItems(TagPrefix.dust, GTMaterials.Andesite).chancedOutput(TagPrefix.dust, GTMaterials.Stone, 10, 5).duration(150).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_diorite", new Object[0]).inputItems(Blocks.f_50228_.m_5456_()).outputItems(TagPrefix.dust, GTMaterials.Diorite).chancedOutput(TagPrefix.dust, GTMaterials.Stone, 10, 5).duration(150).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_granite", new Object[0]).inputItems(Blocks.f_50122_.m_5456_()).outputItems(TagPrefix.dust, GTMaterials.Granite).chancedOutput(TagPrefix.dust, GTMaterials.Stone, 10, 5).duration(150).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_calcite", new Object[0]).inputItems(Blocks.f_152497_.m_5456_()).outputItems(TagPrefix.dust, GTMaterials.Calcite).chancedOutput(TagPrefix.dust, GTMaterials.Stone, 10, 5).duration(150).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_pork_chop", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42485_)).outputItems(TagPrefix.dust, GTMaterials.Meat).chancedOutput(TagPrefix.dust, GTMaterials.Meat, 5000, 0).outputItems(TagPrefix.dustTiny, GTMaterials.Bone).duration(102).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_fish", new Object[0]).inputItems((TagKey<Item>)ItemTags.f_13156_).outputItems(TagPrefix.dust, GTMaterials.Meat).chancedOutput(TagPrefix.dust, GTMaterials.Meat, 5000, 0).outputItems(TagPrefix.dustTiny, GTMaterials.Bone).duration(102).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_chicken", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42581_)).outputItems(TagPrefix.dust, GTMaterials.Meat).outputItems(TagPrefix.dustTiny, GTMaterials.Bone).duration(102).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_steak", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42579_)).outputItems(TagPrefix.dust, GTMaterials.Meat).chancedOutput(TagPrefix.dust, GTMaterials.Meat, 5000, 0).outputItems(TagPrefix.dustTiny, GTMaterials.Bone).duration(102).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_rabbit", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42697_)).outputItems(TagPrefix.dust, GTMaterials.Meat).chancedOutput(TagPrefix.dust, GTMaterials.Meat, 5000, 0).outputItems(TagPrefix.dustTiny, GTMaterials.Bone).duration(102).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_mutton", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42658_)).outputItems(TagPrefix.dust, GTMaterials.Meat).outputItems(TagPrefix.dustTiny, GTMaterials.Bone).duration(102).EUt(2L).save(provider);
    }

    private static void registerFluidRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.FLUID_HEATER_RECIPES.recipeBuilder("heat_ice_to_water", new Object[0]).duration(32).EUt(4L).inputFluids(GTMaterials.Ice.getFluid(144)).circuitMeta(1).outputFluids(GTMaterials.Water.getFluid(144)).save(provider);
        GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_gelled_toluene", new Object[0]).inputFluids(GTMaterials.Toluene.getFluid(100)).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_BALL).outputItems((Supplier<? extends ItemLike>)GTItems.GELLED_TOLUENE).duration(100).EUt(16L).save(provider);
        for (int i = 0; i < GTMaterials.CHEMICAL_DYES.length; ++i) {
            GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_" + GTMaterials.CHEMICAL_DYES[i].getName() + "_to_ball", new Object[0]).inputFluids(GTMaterials.CHEMICAL_DYES[i].getFluid(72)).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_BALL).outputItems((Supplier<? extends ItemLike>)GTItems.DYE_ONLY_ITEMS[i]).duration(100).EUt(16L).save(provider);
        }
        GTRecipeTypes.FLUID_HEATER_RECIPES.recipeBuilder("heat_water_to_steam", new Object[0]).duration(30).EUt(GTValues.VA[1]).inputFluids(GTMaterials.Water.getFluid(6)).circuitMeta(1).outputFluids(GTMaterials.Steam.getFluid(960)).save(provider);
        GTRecipeTypes.FLUID_HEATER_RECIPES.recipeBuilder("heat_distilled_to_steam", new Object[0]).duration(30).EUt(GTValues.VA[1]).inputFluids(GTMaterials.DistilledWater.getFluid(6)).circuitMeta(1).outputFluids(GTMaterials.Steam.getFluid(960)).save(provider);
    }

    private static void registerSmoothRecipe(Consumer<FinishedRecipe> provider, List<ItemStack> roughStack, List<ItemStack> stoneStack) {
        for (int i = 0; i < roughStack.size(); ++i) {
            ResourceLocation stoneId = BuiltInRegistries.f_257033_.m_7981_((Object)stoneStack.get(i).m_41720_());
            VanillaRecipeHelper.addSmeltingRecipe(provider, "smelt_" + stoneId.m_135815_(), roughStack.get(i), stoneStack.get(i), 0.1f);
            GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + stoneId.m_135815_(), new Object[0]).inputItems(roughStack.get(i)).notConsumable(GTItems.SHAPE_EXTRUDER_BLOCK.asStack()).outputItems(stoneStack.get(i)).duration(24).EUt(8L).save(provider);
        }
    }

    private static void registerCobbleRecipe(Consumer<FinishedRecipe> provider, List<ItemStack> stoneStack, List<ItemStack> cobbleStack) {
        for (int i = 0; i < stoneStack.size(); ++i) {
            ResourceLocation cobbleId = BuiltInRegistries.f_257033_.m_7981_((Object)cobbleStack.get(i).m_41720_());
            GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("hammer_" + cobbleId.m_135815_(), new Object[0]).inputItems(stoneStack.get(i)).outputItems(cobbleStack.get(i)).duration(12).EUt(4L).save(provider);
        }
    }

    private static void registerBricksRecipe(Consumer<FinishedRecipe> provider, List<ItemStack> polishedStack, List<ItemStack> brickStack, MarkerMaterial color) {
        for (int i = 0; i < polishedStack.size(); ++i) {
            ResourceLocation brickId = BuiltInRegistries.f_257033_.m_7981_((Object)brickStack.get(i).m_41720_());
            GTRecipeTypes.LASER_ENGRAVER_RECIPES.recipeBuilder("engrave_" + brickId.m_135815_(), new Object[0]).inputItems(polishedStack.get(i)).notConsumable(TagPrefix.lens, color).outputItems(brickStack.get(i)).duration(50).EUt(16L).save(provider);
        }
    }

    private static void registerMossRecipe(Consumer<FinishedRecipe> provider, List<ItemStack> regularStack, List<ItemStack> mossStack) {
        for (int i = 0; i < regularStack.size(); ++i) {
            ResourceLocation mossId = BuiltInRegistries.f_257033_.m_7981_((Object)mossStack.get(i).m_41720_());
            GTRecipeTypes.MIXER_RECIPES.recipeBuilder(mossId.m_135815_() + "_from_moss_block", new Object[0]).inputItems(regularStack.get(i)).inputItems(new ItemStack((ItemLike)Blocks.f_152544_)).inputFluids(GTMaterials.Water.getFluid(250)).outputItems(mossStack.get(i)).duration(40).EUt(1L).save(provider);
            GTRecipeTypes.MIXER_RECIPES.recipeBuilder(mossId.m_135815_() + "_from_vine", new Object[0]).inputItems(regularStack.get(i)).inputItems(new ItemStack((ItemLike)Blocks.f_50191_)).inputFluids(GTMaterials.Water.getFluid(250)).outputItems(mossStack.get(i)).duration(40).EUt(1L).save(provider);
        }
    }

    private static void registerNBTRemoval(Consumer<FinishedRecipe> provider) {
        for (MachineDefinition chest : GTMachines.SUPER_CHEST) {
            if (chest == null) continue;
            VanillaRecipeHelper.addShapelessNBTClearingRecipe(provider, "super_chest_nbt_" + chest.getTier(), chest.asStack(), chest.asStack());
        }
        for (MachineDefinition tank : GTMachines.SUPER_TANK) {
            if (tank == null) continue;
            VanillaRecipeHelper.addShapelessNBTClearingRecipe(provider, "super_tank_nbt_" + tank.getTier(), tank.asStack(), tank.asStack());
        }
        for (MachineDefinition chest : GTMachines.QUANTUM_CHEST) {
            if (chest == null) continue;
            VanillaRecipeHelper.addShapelessNBTClearingRecipe(provider, "quantum_chest_nbt_" + chest.getTier(), chest.asStack(), chest.asStack());
        }
        for (MachineDefinition tank : GTMachines.QUANTUM_TANK) {
            if (tank == null) continue;
            VanillaRecipeHelper.addShapelessNBTClearingRecipe(provider, "quantum_tank_nbt_" + tank.getTier(), tank.asStack(), tank.asStack());
        }
        VanillaRecipeHelper.addShapelessNBTClearingRecipe(provider, "drum_nbt_wood", GTMachines.WOODEN_DRUM.asStack(), GTMachines.WOODEN_DRUM.asStack());
        VanillaRecipeHelper.addShapelessNBTClearingRecipe(provider, "drum_nbt_bronze", GTMachines.BRONZE_DRUM.asStack(), GTMachines.BRONZE_DRUM.asStack());
        VanillaRecipeHelper.addShapelessNBTClearingRecipe(provider, "drum_nbt_steel", GTMachines.STEEL_DRUM.asStack(), GTMachines.STEEL_DRUM.asStack());
        VanillaRecipeHelper.addShapelessNBTClearingRecipe(provider, "drum_nbt_aluminium", GTMachines.ALUMINIUM_DRUM.asStack(), GTMachines.ALUMINIUM_DRUM.asStack());
        VanillaRecipeHelper.addShapelessNBTClearingRecipe(provider, "drum_nbt_stainless_steel", GTMachines.STAINLESS_STEEL_DRUM.asStack(), GTMachines.STAINLESS_STEEL_DRUM.asStack());
        VanillaRecipeHelper.addShapelessNBTClearingRecipe(provider, "drum_nbt_gold", GTMachines.GOLD_DRUM.asStack(), GTMachines.GOLD_DRUM.asStack());
        VanillaRecipeHelper.addShapelessNBTClearingRecipe(provider, "drum_nbt_titanium", GTMachines.TITANIUM_DRUM.asStack(), GTMachines.TITANIUM_DRUM.asStack());
        VanillaRecipeHelper.addShapelessNBTClearingRecipe(provider, "drum_nbt_tungstensteel", GTMachines.TUNGSTENSTEEL_DRUM.asStack(), GTMachines.TUNGSTENSTEEL_DRUM.asStack());
        VanillaRecipeHelper.addShapedNBTClearingRecipe(provider, "cell_nbt_regular", GTItems.FLUID_CELL.asStack(), " C", "  ", Character.valueOf('C'), GTItems.FLUID_CELL.asStack());
        VanillaRecipeHelper.addShapedNBTClearingRecipe(provider, "cell_nbt_universal", GTItems.FLUID_CELL_UNIVERSAL.asStack(), " C", "  ", Character.valueOf('C'), GTItems.FLUID_CELL_UNIVERSAL.asStack());
        VanillaRecipeHelper.addShapelessNBTClearingRecipe(provider, "cell_nbt_steel", GTItems.FLUID_CELL_LARGE_STEEL.asStack(), GTItems.FLUID_CELL_LARGE_STEEL.asStack());
        VanillaRecipeHelper.addShapelessNBTClearingRecipe(provider, "cell_nbt_aluminium", GTItems.FLUID_CELL_LARGE_ALUMINIUM.asStack(), GTItems.FLUID_CELL_LARGE_ALUMINIUM.asStack());
        VanillaRecipeHelper.addShapelessNBTClearingRecipe(provider, "cell_nbt_stainless_steel", GTItems.FLUID_CELL_LARGE_STAINLESS_STEEL.asStack(), GTItems.FLUID_CELL_LARGE_STAINLESS_STEEL.asStack());
        VanillaRecipeHelper.addShapelessNBTClearingRecipe(provider, "cell_nbt_titanium", GTItems.FLUID_CELL_LARGE_TITANIUM.asStack(), GTItems.FLUID_CELL_LARGE_TITANIUM.asStack());
        VanillaRecipeHelper.addShapelessNBTClearingRecipe(provider, "cell_nbt_tungstensteel", GTItems.FLUID_CELL_LARGE_TUNGSTEN_STEEL.asStack(), GTItems.FLUID_CELL_LARGE_TUNGSTEN_STEEL.asStack());
        VanillaRecipeHelper.addShapelessNBTClearingRecipe(provider, "cell_vial_nbt", GTItems.FLUID_CELL_GLASS_VIAL.asStack(), GTItems.FLUID_CELL_GLASS_VIAL.asStack());
        VanillaRecipeHelper.addShapelessNBTClearingRecipe(provider, "data_stick_nbt", GTItems.TOOL_DATA_STICK.asStack(), GTItems.TOOL_DATA_STICK.asStack());
        VanillaRecipeHelper.addShapelessNBTClearingRecipe(provider, "data_orb_nbt", GTItems.TOOL_DATA_ORB.asStack(), GTItems.TOOL_DATA_ORB.asStack());
        VanillaRecipeHelper.addShapelessNBTClearingRecipe(provider, "data_module_nbt", GTItems.TOOL_DATA_MODULE.asStack(), GTItems.TOOL_DATA_MODULE.asStack());
        VanillaRecipeHelper.addShapelessRecipe(provider, "fluid_jetpack_clear", GTItems.LIQUID_FUEL_JETPACK.asStack(), GTItems.LIQUID_FUEL_JETPACK.asStack());
        VanillaRecipeHelper.addShapelessRecipe(provider, "item_filter_nbt", GTItems.ITEM_FILTER.asStack(), GTItems.ITEM_FILTER.asStack());
        VanillaRecipeHelper.addShapelessRecipe(provider, "fluid_filter_nbt", GTItems.FLUID_FILTER.asStack(), GTItems.FLUID_FILTER.asStack());
        VanillaRecipeHelper.addShapelessRecipe(provider, "item_tag_filter_nbt", GTItems.TAG_FILTER.asStack(), GTItems.TAG_FILTER.asStack());
        VanillaRecipeHelper.addShapelessRecipe(provider, "fluid_tag_filter_nbt", GTItems.TAG_FLUID_FILTER.asStack(), GTItems.TAG_FLUID_FILTER.asStack());
    }

    private static void registerHatchConversion(Consumer<FinishedRecipe> provider) {
        String tierName;
        int i;
        for (i = 0; i < GTMachines.FLUID_IMPORT_HATCH.length; ++i) {
            if (GTMachines.FLUID_IMPORT_HATCH[i] == null || GTMachines.FLUID_EXPORT_HATCH[i] == null) continue;
            VanillaRecipeHelper.addShapedRecipe(provider, "fluid_hatch_output_to_input_" + GTMachines.FLUID_IMPORT_HATCH[i].getTier(), GTMachines.FLUID_IMPORT_HATCH[i].asStack(), "d", "B", Character.valueOf('B'), GTMachines.FLUID_EXPORT_HATCH[i].asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, "fluid_hatch_input_to_output_" + GTMachines.FLUID_EXPORT_HATCH[i].getTier(), GTMachines.FLUID_EXPORT_HATCH[i].asStack(), "d", "B", Character.valueOf('B'), GTMachines.FLUID_IMPORT_HATCH[i].asStack());
        }
        for (i = 0; i < GTMachines.ITEM_IMPORT_BUS.length; ++i) {
            if (GTMachines.ITEM_IMPORT_BUS[i] == null || GTMachines.ITEM_EXPORT_BUS[i] == null) continue;
            VanillaRecipeHelper.addShapedRecipe(provider, "item_bus_output_to_input_" + GTMachines.ITEM_IMPORT_BUS[i].getTier(), GTMachines.ITEM_IMPORT_BUS[i].asStack(), "d", "B", Character.valueOf('B'), GTMachines.ITEM_EXPORT_BUS[i].asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, "item_bus_input_to_output_" + GTMachines.ITEM_EXPORT_BUS[i].getTier(), GTMachines.ITEM_EXPORT_BUS[i].asStack(), "d", "B", Character.valueOf('B'), GTMachines.ITEM_IMPORT_BUS[i].asStack());
        }
        for (int tier : GTMachineUtils.MULTI_HATCH_TIERS) {
            tierName = GTValues.VN[tier].toLowerCase();
            MachineDefinition importHatch4x = GTMachines.FLUID_IMPORT_HATCH_4X[tier];
            MachineDefinition exportHatch4x = GTMachines.FLUID_EXPORT_HATCH_4X[tier];
            MachineDefinition importHatch9x = GTMachines.FLUID_IMPORT_HATCH_9X[tier];
            MachineDefinition exportHatch9x = GTMachines.FLUID_EXPORT_HATCH_9X[tier];
            VanillaRecipeHelper.addShapedRecipe(provider, "fluid_hatch_4x_output_to_input_" + tierName, importHatch4x.asStack(), "d", "B", Character.valueOf('B'), exportHatch4x.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, "fluid_hatch_4x_input_to_output_" + tierName, exportHatch4x.asStack(), "d", "B", Character.valueOf('B'), importHatch4x.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, "fluid_hatch_9x_output_to_input_" + tierName, importHatch9x.asStack(), "d", "B", Character.valueOf('B'), exportHatch9x.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, "fluid_hatch_9x_input_to_output_" + tierName, exportHatch9x.asStack(), "d", "B", Character.valueOf('B'), importHatch9x.asStack());
        }
        for (int tier : GTMachineUtils.DUAL_HATCH_TIERS) {
            tierName = GTValues.VN[tier].toLowerCase();
            MachineDefinition inputBuffer = GTMachines.DUAL_IMPORT_HATCH[tier];
            MachineDefinition outputBuffer = GTMachines.DUAL_EXPORT_HATCH[tier];
            VanillaRecipeHelper.addShapedRecipe(provider, "dual_hatch_output_to_input_" + tierName, inputBuffer.asStack(), "d", "B", Character.valueOf('B'), outputBuffer.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, "dual_hatch_input_to_output_" + tierName, outputBuffer.asStack(), "d", "B", Character.valueOf('B'), inputBuffer.asStack());
        }
        VanillaRecipeHelper.addShapedRecipe(provider, "steam_bus_output_to_input", GTMachines.STEAM_EXPORT_BUS.asStack(), "d", "B", Character.valueOf('B'), GTMachines.STEAM_IMPORT_BUS.asStack());
        VanillaRecipeHelper.addShapedRecipe(provider, "steam_bus_input_to_output", GTMachines.STEAM_IMPORT_BUS.asStack(), "d", "B", Character.valueOf('B'), GTMachines.STEAM_EXPORT_BUS.asStack());
        if (GTCEu.Mods.isAE2Loaded()) {
            VanillaRecipeHelper.addShapedRecipe(provider, "me_fluid_hatch_output_to_input", GTAEMachines.FLUID_IMPORT_HATCH_ME.asStack(), "d", "B", Character.valueOf('B'), GTAEMachines.FLUID_EXPORT_HATCH_ME.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, "me_fluid_hatch_input_to_output", GTAEMachines.FLUID_EXPORT_HATCH_ME.asStack(), "d", "B", Character.valueOf('B'), GTAEMachines.FLUID_IMPORT_HATCH_ME.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, "me_item_bus_output_to_input", GTAEMachines.ITEM_IMPORT_BUS_ME.asStack(), "d", "B", Character.valueOf('B'), GTAEMachines.ITEM_EXPORT_BUS_ME.asStack());
            VanillaRecipeHelper.addShapedRecipe(provider, "me_item_bus_input_to_output", GTAEMachines.ITEM_EXPORT_BUS_ME.asStack(), "d", "B", Character.valueOf('B'), GTAEMachines.ITEM_IMPORT_BUS_ME.asStack());
        }
    }
}

