/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.core.mixins.ftbchunks;

import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.integration.map.ftbchunks.FTBChunksOptions;
import com.gregtechceu.gtceu.integration.map.ftbchunks.FTBChunksRenderer;
import com.gregtechceu.gtceu.integration.map.ftbchunks.veins.fluid.FluidVeinIcon;
import com.gregtechceu.gtceu.integration.map.ftbchunks.veins.fluid.FluidVeinWidget;
import dev.ftb.mods.ftbchunks.api.client.icon.MapIcon;
import dev.ftb.mods.ftbchunks.client.gui.LargeMapScreen;
import dev.ftb.mods.ftbchunks.client.gui.MapIconWidget;
import dev.ftb.mods.ftbchunks.client.gui.RegionMapPanel;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Widget;
import net.minecraft.world.level.ChunkPos;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RegionMapPanel.class}, remap=false)
public abstract class RegionMapPanelMixin
extends Panel {
    @Shadow
    @Final
    LargeMapScreen largeMap;
    @Shadow
    int regionMinX;
    @Shadow
    int regionMinZ;

    public RegionMapPanelMixin(Panel panel) {
        super(panel);
    }

    @Inject(method={"addWidgets"}, at={@At(value="INVOKE", target="Ldev/ftb/mods/ftbchunks/client/gui/RegionMapPanel;alignWidgets()V")})
    private void gtceu$injectAddWidgets(CallbackInfo ci) {
        if (!ConfigHolder.INSTANCE.compat.minimap.toggle.ftbChunksIntegration) {
            return;
        }
        if (FTBChunksOptions.showLayer("bedrock_fluids")) {
            FTBChunksRenderer.fluidElements.row((Object)this.largeMap.currentDimension()).forEach((pos, icon) -> {
                FluidVeinWidget widget = new FluidVeinWidget((RegionMapPanel)this, (FluidVeinIcon)icon);
                this.add(widget);
            });
        }
    }

    @Inject(method={"alignWidgets"}, at={@At(value="TAIL")})
    private void gtceu$injectAlignWidgets(CallbackInfo ci) {
        if (!ConfigHolder.INSTANCE.compat.minimap.toggle.ftbChunksIntegration) {
            return;
        }
        int regionSize = this.largeMap.getRegionTileSize();
        int chunkSize = this.largeMap.getRegionTileSize() / 32;
        for (Widget widget : this.widgets) {
            int y;
            int x;
            ChunkPos chunkPos;
            MapIconWidget w;
            MapIcon mapIcon;
            if (widget instanceof MapIconWidget && (mapIcon = (w = (MapIconWidget)widget).getMapIcon()) instanceof FluidVeinIcon) {
                FluidVeinIcon icon = (FluidVeinIcon)mapIcon;
                chunkPos = icon.getChunkPos();
                x = (chunkPos.m_45610_() - this.regionMinX) * regionSize + chunkPos.m_45613_() * chunkSize;
                y = (chunkPos.m_45612_() - this.regionMinZ) * regionSize + chunkPos.m_45614_() * chunkSize;
                icon.setSize(chunkSize);
                w.setPosAndSize(x, y, chunkSize, chunkSize);
                continue;
            }
            if (!(widget instanceof FluidVeinWidget)) continue;
            FluidVeinWidget w2 = (FluidVeinWidget)widget;
            chunkPos = w2.getMapIcon().getChunkPos();
            x = (chunkPos.m_45610_() - this.regionMinX) * regionSize + chunkPos.m_45613_() * chunkSize;
            y = (chunkPos.m_45612_() - this.regionMinZ) * regionSize + chunkPos.m_45614_() * chunkSize;
            w2.setPosAndSize(x, y, chunkSize, chunkSize);
        }
    }
}

