/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.worldgen.feature;

import com.gregtechceu.gtceu.common.worldgen.feature.configurations.FluidSproutConfiguration;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.material.Fluids;
import org.apache.commons.lang3.mutable.MutableInt;

public class FluidSproutFeature
extends Feature<FluidSproutConfiguration> {
    public FluidSproutFeature() {
        super(FluidSproutConfiguration.CODEC);
    }

    public boolean m_142674_(FeaturePlaceContext<FluidSproutConfiguration> context) {
        RandomSource random = context.m_225041_();
        BlockPos blockpos = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        FluidSproutConfiguration config = (FluidSproutConfiguration)context.m_159778_();
        MutableInt placedAmount = new MutableInt(0);
        int size = config.size().m_214085_(random);
        int radius = Mth.m_14167_((float)((float)size / 2.0f));
        int x0 = blockpos.m_123341_() - radius;
        int y0 = blockpos.m_123342_() - radius;
        int z0 = blockpos.m_123343_() - radius;
        int width = size + 1;
        int length = size + 1;
        int height = size + 1;
        if (config.fluid().m_6212_(Fluids.f_76191_)) {
            return false;
        }
        int surfaceHeight = level.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, blockpos.m_123341_(), blockpos.m_123343_());
        if (blockpos.m_123342_() >= surfaceHeight) {
            return false;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        try (BulkSectionAccess bulkSectionAccess = new BulkSectionAccess((LevelAccessor)level);){
            for (int x = 0; x < width; ++x) {
                float dx = (float)x * 2.0f / (float)width - 1.0f;
                if (dx * dx > 1.0f) continue;
                for (int y = 0; y < height; ++y) {
                    float dy = (float)y * 2.0f / (float)height - 1.0f;
                    if (dx * dx + dy * dy > 1.0f || level.m_151562_(y0 + y)) continue;
                    for (int z = 0; z < length; ++z) {
                        float dz = (float)z * 2.0f / (float)length - 1.0f;
                        if (dx * dx + dy * dy + dz * dz > 1.0f) continue;
                        int currentX = x0 + x;
                        int currentY = y0 + y;
                        int currentZ = z0 + z;
                        this.setBlock(mutablePos, currentX, currentY, currentZ, bulkSectionAccess, level, config, placedAmount);
                    }
                }
            }
            if (random.m_188501_() <= config.sproutChance()) {
                int currentX = blockpos.m_123341_();
                int currentZ = blockpos.m_123343_();
                int springHeight = surfaceHeight + config.surfaceOffset().m_214085_(random);
                for (int currentY = blockpos.m_123342_(); currentY <= springHeight; ++currentY) {
                    this.setBlock(mutablePos, currentX, currentY, currentZ, bulkSectionAccess, level, config, placedAmount);
                    if (currentY > surfaceHeight) continue;
                    this.setBlock(mutablePos, currentX + 1, currentY, currentZ, bulkSectionAccess, level, config, placedAmount);
                    this.setBlock(mutablePos, currentX - 1, currentY, currentZ, bulkSectionAccess, level, config, placedAmount);
                    this.setBlock(mutablePos, currentX, currentY, currentZ + 1, bulkSectionAccess, level, config, placedAmount);
                    this.setBlock(mutablePos, currentX, currentY, currentZ - 1, bulkSectionAccess, level, config, placedAmount);
                }
            }
        }
        return placedAmount.getValue() > 0;
    }

    public void setBlock(BlockPos.MutableBlockPos mutablePos, int currentX, int currentY, int currentZ, BulkSectionAccess access, WorldGenLevel level, FluidSproutConfiguration config, MutableInt placedAmount) {
        mutablePos.m_122178_(currentX, currentY, currentZ);
        if (!level.m_180807_((BlockPos)mutablePos)) {
            return;
        }
        LevelChunkSection levelchunksection = access.m_156104_((BlockPos)mutablePos);
        if (levelchunksection == null) {
            return;
        }
        int sectionX = SectionPos.m_123207_((int)currentX);
        int sectionY = SectionPos.m_123207_((int)currentY);
        int sectionZ = SectionPos.m_123207_((int)currentZ);
        levelchunksection.m_62991_(sectionX, sectionY, sectionZ, config.fluid().m_76145_().m_76188_(), false);
        level.m_46865_((BlockPos)mutablePos).m_8113_((BlockPos)mutablePos);
        placedAmount.add(1);
    }

    public boolean canPlaceFluid(BlockState state, Function<BlockPos, BlockState> adjacentStateAccessor, RandomSource random, RuleTest target, BlockPos.MutableBlockPos mutablePos) {
        if (!target.m_213865_(state, random)) {
            return false;
        }
        return !FluidSproutFeature.m_159750_(adjacentStateAccessor, (BlockPos)mutablePos);
    }
}

