/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.recipe.condition;

import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.capability.ICleanroomReceiver;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.ICleanroomProvider;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.CleanroomType;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.condition.RecipeConditionType;
import com.gregtechceu.gtceu.common.data.GTRecipeConditions;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;

public class CleanroomCondition
extends RecipeCondition {
    public static final Codec<CleanroomCondition> CODEC = RecordCodecBuilder.create(instance -> RecipeCondition.isReverse(instance).and((App)CleanroomType.CODEC.fieldOf("cleanroom").forGetter(val -> val.cleanroom)).apply((Applicative)instance, CleanroomCondition::new));
    public static final CleanroomCondition INSTANCE = new CleanroomCondition();
    private CleanroomType cleanroom = CleanroomType.CLEANROOM;

    public CleanroomCondition(boolean isReverse, CleanroomType cleanroom) {
        super(isReverse);
        this.cleanroom = cleanroom;
    }

    @Override
    public RecipeConditionType<?> getType() {
        return GTRecipeConditions.CLEANROOM;
    }

    @Override
    public Component getTooltips() {
        return this.cleanroom == null ? null : Component.m_237110_((String)"gtceu.recipe.cleanroom", (Object[])new Object[]{Component.m_237115_((String)this.cleanroom.getTranslationKey())});
    }

    @Override
    public boolean test(@NotNull GTRecipe recipe, @NotNull RecipeLogic recipeLogic) {
        if (!ConfigHolder.INSTANCE.machines.enableCleanroom) {
            return true;
        }
        MetaMachine machine = recipeLogic.getMachine();
        if (machine instanceof ICleanroomReceiver) {
            ICleanroomReceiver receiver = (ICleanroomReceiver)((Object)machine);
            if (this.cleanroom != null) {
                if (ConfigHolder.INSTANCE.machines.cleanMultiblocks && machine instanceof IMultiController) {
                    return true;
                }
                ICleanroomProvider provider = receiver.getCleanroom();
                if (provider == null) {
                    return false;
                }
                return provider.isClean() && provider.getTypes().contains(this.cleanroom);
            }
        }
        return true;
    }

    @Override
    @NotNull
    public JsonObject serialize() {
        JsonObject value = super.serialize();
        value.addProperty("cleanroom", this.cleanroom.getName());
        return value;
    }

    @Override
    public RecipeCondition deserialize(@NotNull JsonObject config) {
        super.deserialize(config);
        this.cleanroom = CleanroomType.getByNameOrDefault(GsonHelper.m_13851_((JsonObject)config, (String)"cleanroom", (String)"cleanroom"));
        return this;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        super.toNetwork(buf);
        buf.m_130070_(this.cleanroom.getName());
    }

    @Override
    public RecipeCondition fromNetwork(FriendlyByteBuf buf) {
        super.fromNetwork(buf);
        this.cleanroom = CleanroomType.getByNameOrDefault(buf.m_130277_());
        return this;
    }

    @Override
    public RecipeCondition createTemplate() {
        return new CleanroomCondition();
    }

    @Generated
    public CleanroomCondition(CleanroomType cleanroom) {
        this.cleanroom = cleanroom;
    }

    @Generated
    public CleanroomCondition() {
    }

    @Generated
    public CleanroomType getCleanroom() {
        return this.cleanroom;
    }
}

