/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.optical;

import com.gregtechceu.gtceu.api.pipenet.LevelPipeNet;
import com.gregtechceu.gtceu.api.pipenet.Node;
import com.gregtechceu.gtceu.api.pipenet.PipeNet;
import com.gregtechceu.gtceu.common.pipelike.optical.OpticalNetWalker;
import com.gregtechceu.gtceu.common.pipelike.optical.OpticalPipeProperties;
import com.gregtechceu.gtceu.common.pipelike.optical.OpticalRoutePath;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public class OpticalPipeNet
extends PipeNet<OpticalPipeProperties> {
    private final Map<BlockPos, OpticalRoutePath> NET_DATA = new Object2ObjectOpenHashMap();

    public OpticalPipeNet(LevelPipeNet<OpticalPipeProperties, ? extends PipeNet<OpticalPipeProperties>> world) {
        super(world);
    }

    @Nullable
    public OpticalRoutePath getNetData(BlockPos pipePos, Direction facing) {
        if (this.NET_DATA.containsKey(pipePos)) {
            return this.NET_DATA.get(pipePos);
        }
        OpticalRoutePath data = OpticalNetWalker.createNetData(this, pipePos, facing);
        if (data == OpticalNetWalker.FAILED_MARKER) {
            return null;
        }
        this.NET_DATA.put(pipePos, data);
        return data;
    }

    @Override
    public void onNeighbourUpdate(BlockPos fromPos) {
        this.NET_DATA.clear();
    }

    @Override
    public void onPipeConnectionsUpdate() {
        this.NET_DATA.clear();
    }

    @Override
    protected void transferNodeData(Map<BlockPos, Node<OpticalPipeProperties>> transferredNodes, PipeNet<OpticalPipeProperties> parentNet) {
        super.transferNodeData(transferredNodes, parentNet);
        this.NET_DATA.clear();
        ((OpticalPipeNet)parentNet).NET_DATA.clear();
    }

    @Override
    protected void writeNodeData(OpticalPipeProperties nodeData, CompoundTag tagCompound) {
    }

    @Override
    protected OpticalPipeProperties readNodeData(CompoundTag tagCompound) {
        return OpticalPipeProperties.INSTANCE;
    }
}

