/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.network.packets;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.client.ClientProxy;
import com.gregtechceu.gtceu.integration.map.cache.client.GTClientCache;
import com.lowdragmc.lowdraglib.networking.IHandlerContext;
import com.lowdragmc.lowdraglib.networking.IPacket;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class SPacketSyncOreVeins
implements IPacket {
    private final Map<ResourceLocation, GTOreDefinition> veins;

    public SPacketSyncOreVeins() {
        this.veins = new HashMap<ResourceLocation, GTOreDefinition>();
    }

    public void encode(FriendlyByteBuf buf) {
        RegistryOps ops = RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)GTRegistries.builtinRegistry());
        int size = this.veins.size();
        buf.m_130130_(size);
        for (Map.Entry<ResourceLocation, GTOreDefinition> entry : this.veins.entrySet()) {
            buf.m_130085_(entry.getKey());
            CompoundTag tag = (CompoundTag)GTOreDefinition.FULL_CODEC.encodeStart((DynamicOps)ops, (Object)entry.getValue()).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0));
            buf.m_130079_(tag);
        }
    }

    public void decode(FriendlyByteBuf buf) {
        RegistryOps ops = RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)GTRegistries.builtinRegistry());
        Stream.generate(() -> {
            ResourceLocation id = buf.m_130281_();
            CompoundTag tag = buf.m_130261_();
            GTOreDefinition def = (GTOreDefinition)GTOreDefinition.FULL_CODEC.parse((DynamicOps)ops, (Object)tag).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0));
            return Map.entry(id, def);
        }).limit(buf.m_130242_()).forEach(entry -> this.veins.put((ResourceLocation)entry.getKey(), (GTOreDefinition)entry.getValue()));
    }

    public void execute(IHandlerContext handler) {
        ClientProxy.CLIENT_ORE_VEINS.clear();
        ClientProxy.CLIENT_ORE_VEINS.putAll(this.veins);
        GTClientCache.instance.oreVeinDefinitionsChanged((Map<ResourceLocation, GTOreDefinition>)ClientProxy.CLIENT_ORE_VEINS);
    }

    @Generated
    public SPacketSyncOreVeins(Map<ResourceLocation, GTOreDefinition> veins) {
        this.veins = veins;
    }
}

