/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.storage;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IDataInfoProvider;
import com.gregtechceu.gtceu.api.pipenet.longdistance.ILDEndpoint;
import com.gregtechceu.gtceu.api.pipenet.longdistance.LongDistanceNetwork;
import com.gregtechceu.gtceu.api.pipenet.longdistance.LongDistancePipeType;
import com.gregtechceu.gtceu.common.item.PortableScannerBehavior;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public abstract class LongDistanceEndpointMachine
extends MetaMachine
implements ILDEndpoint,
IDataInfoProvider {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(LongDistanceEndpointMachine.class, MetaMachine.MANAGED_FIELD_HOLDER);
    @NotNull
    private final LongDistancePipeType pipeType;
    @Persisted
    private IO ioType = IO.NONE;
    private ILDEndpoint link;
    private boolean placed = false;

    public LongDistanceEndpointMachine(IMachineBlockEntity holder, LongDistancePipeType pipeType) {
        super(holder);
        this.pipeType = Objects.requireNonNull(pipeType);
    }

    public void updateNetwork() {
        List<LongDistanceNetwork> networks;
        if (this.getLevel().f_46443_) {
            return;
        }
        LongDistanceNetwork network = LongDistanceNetwork.get((LevelAccessor)this.getLevel(), this.getPos());
        if (network != null) {
            network.onRemoveEndpoint(this);
        }
        if ((networks = this.findNetworks()).isEmpty()) {
            network = this.pipeType.createNetwork(this.getLevel());
            network.onPlaceEndpoint(this);
            this.setIoType(IO.NONE);
        } else if (networks.size() == 1) {
            networks.get(0).onPlaceEndpoint(this);
        } else {
            this.setIoType(IO.NONE);
        }
    }

    @Override
    public void setFrontFacing(Direction frontFacing) {
        this.placed = true;
        super.setFrontFacing(frontFacing);
        if (this.getLevel() != null && !this.getLevel().f_46443_) {
            this.updateNetwork();
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, this::updateNetwork));
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.getLevel().f_46443_) {
            return;
        }
        if (this.link != null) {
            this.link.invalidateLink();
            this.invalidateLink();
        }
        this.setIoType(IO.NONE);
        LongDistanceNetwork network = LongDistanceNetwork.get((LevelAccessor)this.getLevel(), this.getPos());
        if (network != null) {
            network.onRemoveEndpoint(this);
        }
    }

    @Override
    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        if (!this.placed || this.getLevel().f_46443_) {
            return;
        }
        List<LongDistanceNetwork> networks = this.findNetworks();
        this.updateNetwork();
        LongDistanceNetwork network = LongDistanceNetwork.get((LevelAccessor)this.getLevel(), this.getPos());
        if (network == null) {
            if (networks.isEmpty()) {
                network = this.pipeType.createNetwork(this.getLevel());
                network.onPlaceEndpoint(this);
            } else if (networks.size() == 1) {
                networks.get(0).onPlaceEndpoint(this);
            }
        } else if (networks.size() > 1) {
            this.onUnload();
        }
        if (networks.size() != 1) {
            this.setIoType(IO.NONE);
        }
    }

    @Override
    public void notifyBlockUpdate() {
        super.notifyBlockUpdate();
        this.updateNetwork();
    }

    private List<LongDistanceNetwork> findNetworks() {
        ArrayList<LongDistanceNetwork> networks = new ArrayList<LongDistanceNetwork>();
        LongDistanceNetwork network = LongDistanceNetwork.get((LevelAccessor)this.getLevel(), this.getPos().m_121945_(this.getFrontFacing()));
        if (network != null && this.pipeType == network.getPipeType()) {
            networks.add(network);
            this.setIoType(IO.OUT);
        }
        if ((network = LongDistanceNetwork.get((LevelAccessor)this.getLevel(), this.getPos().m_121945_(this.getOutputFacing()))) != null && this.pipeType == network.getPipeType()) {
            networks.add(network);
            this.setIoType(IO.IN);
        }
        return networks;
    }

    @Override
    public ILDEndpoint getLink() {
        if (this.link == null) {
            LongDistanceNetwork network = LongDistanceNetwork.get((LevelAccessor)this.getLevel(), this.getPos());
            if (network != null && network.isValid()) {
                this.link = network.getOtherEndpoint(this);
            }
        } else if (this.link.isInValid()) {
            this.link.invalidateLink();
            this.link = null;
            LongDistanceNetwork network = LongDistanceNetwork.get((LevelAccessor)this.getLevel(), this.getPos());
            if (network != null) {
                network.invalidateEndpoints();
                if (network.isValid()) {
                    this.link = network.getOtherEndpoint(this);
                }
            }
        }
        return this.link;
    }

    @Override
    public void invalidateLink() {
        this.link = null;
    }

    @Override
    public Direction getOutputFacing() {
        return this.getFrontFacing().m_122424_();
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    @Nonnull
    public List<Component> getDataInfo(PortableScannerBehavior.DisplayMode mode) {
        ArrayList<Component> textComponents = new ArrayList<Component>();
        if (mode == PortableScannerBehavior.DisplayMode.SHOW_ALL || mode == PortableScannerBehavior.DisplayMode.SHOW_MACHINE_INFO) {
            LongDistanceNetwork network = LongDistanceNetwork.get((LevelAccessor)this.getLevel(), this.getPos());
            if (network == null) {
                textComponents.add((Component)Component.m_237115_((String)"block.gtceu.long_distance_item_pipeline_no_network"));
            } else {
                textComponents.add((Component)Component.m_237115_((String)"block.gtceu.long_distance_item_pipeline_network_header"));
                textComponents.add((Component)Component.m_237110_((String)"block.gtceu.long_distance_item_pipeline_pipe_count", (Object[])new Object[]{FormattingUtil.formatNumbers(network.getTotalSize())}));
                ILDEndpoint in = network.getActiveInputIndex();
                ILDEndpoint out = network.getActiveOutputIndex();
                textComponents.add((Component)Component.m_237110_((String)"block.gtceu.long_distance_item_pipeline_input_pos", (Object[])new Object[]{Component.m_237113_((String)(in == null ? "none" : in.getPos().toString()))}));
                textComponents.add((Component)Component.m_237110_((String)"block.gtceu.long_distance_item_pipeline_output_pos", (Object[])new Object[]{Component.m_237113_((String)(out == null ? "none" : out.getPos().toString()))}));
            }
            if (this.isInput()) {
                textComponents.add((Component)Component.m_237115_((String)"block.gtceu.long_distance_item_pipeline_input_endpoint"));
            }
            if (this.isOutput()) {
                textComponents.add((Component)Component.m_237115_((String)"block.gtceu.long_distance_item_pipeline_output_endpoint"));
            }
        }
        return textComponents;
    }

    @Override
    @NotNull
    @Generated
    public LongDistancePipeType getPipeType() {
        return this.pipeType;
    }

    @Override
    @Generated
    public IO getIoType() {
        return this.ioType;
    }

    @Override
    @Generated
    public void setIoType(IO ioType) {
        this.ioType = ioType;
    }
}

