/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.IUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMufflerMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.part.MultiblockPartMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.part.TieredPartMachine;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.stream.IntStream;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MufflerPartMachine
extends TieredPartMachine
implements IMufflerMachine,
IUIMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MufflerPartMachine.class, MultiblockPartMachine.MANAGED_FIELD_HOLDER);
    private final int recoveryChance;
    @Persisted
    private final CustomItemStackHandler inventory;

    public MufflerPartMachine(IMachineBlockEntity holder, int tier) {
        super(holder, tier);
        this.recoveryChance = Math.max(1, tier * 10);
        this.inventory = new CustomItemStackHandler((int)Math.pow(tier + 1, 2.0));
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void recoverItemsTable(ItemStack ... recoveryItems) {
        int numRolls = Math.min(recoveryItems.length, this.inventory.getSlots());
        IntStream.range(0, numRolls).forEach(slot -> {
            if (this.calculateChance()) {
                ItemHandlerHelper.insertItemStacked((IItemHandler)this.inventory, (ItemStack)recoveryItems[slot].m_41777_(), (boolean)false);
            }
        });
    }

    private boolean calculateChance() {
        return this.recoveryChance >= 100 || this.recoveryChance >= GTValues.RNG.m_188503_(100);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        super.clientTick();
        for (IMultiController controller : this.getControllers()) {
            IRecipeLogicMachine recipeLogicMachine;
            if (!(controller instanceof IRecipeLogicMachine) || !(recipeLogicMachine = (IRecipeLogicMachine)((Object)controller)).getRecipeLogic().isWorking()) continue;
            this.emitPollutionParticles();
            break;
        }
    }

    @Override
    public ModularUI createUI(Player entityPlayer) {
        int rowSize = (int)Math.sqrt(this.inventory.getSlots());
        int xOffset = rowSize == 10 ? 9 : 0;
        ModularUI modular = new ModularUI(176 + xOffset * 2, 18 + 18 * rowSize + 94, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND}).widget((Widget)new LabelWidget(10, 5, this.getBlockState().m_60734_().m_7705_())).widget((Widget)UITemplate.bindPlayerInventory(entityPlayer.m_150109_(), (IGuiTexture)GuiTextures.SLOT, 7 + xOffset, 18 + 18 * rowSize + 12, true));
        for (int y = 0; y < rowSize; ++y) {
            for (int x = 0; x < rowSize; ++x) {
                int index = y * rowSize + x;
                modular.widget((Widget)new SlotWidget((IItemHandlerModifiable)this.inventory, index, 88 - rowSize * 9 + x * 18 + xOffset, 18 + y * 18, true, false).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT));
            }
        }
        return modular;
    }

    @Generated
    public int getRecoveryChance() {
        return this.recoveryChance;
    }

    @Generated
    public CustomItemStackHandler getInventory() {
        return this.inventory;
    }
}

