/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.generator;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyTooltip;
import com.gregtechceu.gtceu.api.gui.fancy.TooltipsPanel;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.ITieredMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockDisplayText;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.modifier.ModifierFunction;
import com.gregtechceu.gtceu.api.recipe.modifier.ParallelLogic;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTMath;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.Iterator;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LargeCombustionEngineMachine
extends WorkableElectricMultiblockMachine
implements ITieredMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(LargeCombustionEngineMachine.class, WorkableMultiblockMachine.MANAGED_FIELD_HOLDER);
    private static final FluidStack OXYGEN_STACK = GTMaterials.Oxygen.getFluid(1);
    private static final FluidStack LIQUID_OXYGEN_STACK = GTMaterials.Oxygen.getFluid(FluidStorageKeys.LIQUID, 4);
    private static final FluidStack LUBRICANT_STACK = GTMaterials.Lubricant.getFluid(1);
    private final int tier;
    @DescSynced
    private boolean isOxygenBoosted = false;
    private int runningTimer = 0;

    public LargeCombustionEngineMachine(IMachineBlockEntity holder, int tier) {
        super(holder, new Object[0]);
        this.tier = tier;
    }

    private boolean isIntakesObstructed() {
        Direction facing = this.getFrontFacing();
        boolean permuteXZ = facing.m_122434_() == Direction.Axis.Z;
        BlockPos centerPos = this.getPos().m_121945_(facing);
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                if (x == 0 && y == 0) continue;
                BlockPos blockPos = centerPos.m_7918_(permuteXZ ? x : 0, y, permuteXZ ? 0 : x);
                BlockState blockState = this.getLevel().m_8055_(blockPos);
                if (blockState.m_60795_()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isExtreme() {
        return this.getTier() > 4;
    }

    public boolean isBoostAllowed() {
        return this.getMaxVoltage() >= GTValues.V[this.getTier() + 1];
    }

    @Override
    public long getOverclockVoltage() {
        if (this.isOxygenBoosted) {
            return GTValues.V[this.tier] * 2L;
        }
        return GTValues.V[this.tier];
    }

    protected GTRecipe getLubricantRecipe() {
        return GTRecipeBuilder.ofRaw().inputFluids(LUBRICANT_STACK).buildRawRecipe();
    }

    protected GTRecipe getBoostRecipe() {
        return GTRecipeBuilder.ofRaw().inputFluids(this.isExtreme() ? LIQUID_OXYGEN_STACK : OXYGEN_STACK).buildRawRecipe();
    }

    protected double getProductionBoost() {
        if (!this.isOxygenBoosted) {
            return 1.0;
        }
        return this.isExtreme() ? 2.0 : 1.5;
    }

    public static ModifierFunction recipeModifier(@NotNull MetaMachine machine, @NotNull GTRecipe recipe) {
        if (!(machine instanceof LargeCombustionEngineMachine)) {
            return RecipeModifier.nullWrongType(LargeCombustionEngineMachine.class, machine);
        }
        LargeCombustionEngineMachine engineMachine = (LargeCombustionEngineMachine)machine;
        long EUt = RecipeHelper.getOutputEUt(recipe);
        if (EUt > 0L && !engineMachine.isIntakesObstructed() && engineMachine.getLubricantRecipe().matchRecipe(engineMachine).isSuccess()) {
            int maxParallel = (int)(engineMachine.getOverclockVoltage() / EUt);
            int actualParallel = ParallelLogic.getParallelAmount(engineMachine, recipe, maxParallel);
            double eutMultiplier = (double)actualParallel * engineMachine.getProductionBoost();
            return ModifierFunction.builder().inputModifier(ContentModifier.multiplier(actualParallel)).outputModifier(ContentModifier.multiplier(actualParallel)).eutMultiplier(eutMultiplier).parallels(actualParallel).build();
        }
        return ModifierFunction.NULL;
    }

    @Override
    public boolean onWorking() {
        boolean value = super.onWorking();
        if (this.runningTimer % 72 == 0 && !this.getLubricantRecipe().handleRecipeIO(IO.IN, this, this.recipeLogic.getChanceCaches())) {
            this.recipeLogic.interruptRecipe();
            return false;
        }
        if (this.isBoostAllowed()) {
            GTRecipe boosterRecipe = this.getBoostRecipe();
            this.isOxygenBoosted = boosterRecipe.matchRecipe(this).isSuccess() && boosterRecipe.handleRecipeIO(IO.IN, this, this.recipeLogic.getChanceCaches());
        }
        ++this.runningTimer;
        if (this.runningTimer > 72000) {
            this.runningTimer %= 72000;
        }
        return value;
    }

    @Override
    public boolean dampingWhenWaiting() {
        return false;
    }

    @Override
    public void addDisplayText(List<Component> textList) {
        MultiblockDisplayText.Builder builder = MultiblockDisplayText.builder(textList, this.isFormed()).setWorkingStatus(this.recipeLogic.isWorkingEnabled(), this.recipeLogic.isActive());
        if (this.isExtreme()) {
            builder.addEnergyProductionLine(GTValues.V[this.tier + 1], this.recipeLogic.getLastRecipe() != null ? RecipeHelper.getOutputEUt(this.recipeLogic.getLastRecipe()) : 0L);
        } else {
            builder.addEnergyProductionAmpsLine(GTValues.V[this.tier] * 3L, 3);
        }
        if (this.isActive() && this.isWorkingEnabled()) {
            builder.addCurrentEnergyProductionLine(this.recipeLogic.getLastRecipe() != null ? RecipeHelper.getOutputEUt(this.recipeLogic.getLastRecipe()) : 0L);
        }
        builder.addFuelNeededLine(this.getRecipeFluidInputInfo(), this.recipeLogic.getDuration());
        if (this.isFormed && this.isOxygenBoosted) {
            String key = this.isExtreme() ? "gtceu.multiblock.large_combustion_engine.liquid_oxygen_boosted" : "gtceu.multiblock.large_combustion_engine.oxygen_boosted";
            builder.addCustom(tl -> tl.add(Component.m_237115_((String)key).m_130940_(ChatFormatting.AQUA)));
        }
        builder.addWorkingStatusLine();
    }

    @Nullable
    public String getRecipeFluidInputInfo() {
        GTRecipe recipe = this.recipeLogic.getLastRecipe();
        if (recipe == null) {
            Iterator<GTRecipe> iterator = this.recipeLogic.searchRecipe();
            GTRecipe gTRecipe = recipe = iterator != null && iterator.hasNext() ? iterator.next() : null;
            if (recipe == null) {
                return null;
            }
        }
        FluidStack requiredFluidInput = RecipeHelper.getInputFluids(recipe).get(0);
        long ocAmount = this.getMaxVoltage() / RecipeHelper.getOutputEUt(recipe);
        int neededAmount = GTMath.saturatedCast(ocAmount * (long)requiredFluidInput.getAmount());
        return String.valueOf(ChatFormatting.RED) + FormattingUtil.formatNumbers(neededAmount) + "mB";
    }

    @Override
    public void attachTooltips(TooltipsPanel tooltipsPanel) {
        super.attachTooltips(tooltipsPanel);
        tooltipsPanel.attachTooltips(new IFancyTooltip.Basic(() -> GuiTextures.INDICATOR_NO_STEAM.get(false), () -> List.of(Component.m_237115_((String)"gtceu.multiblock.large_combustion_engine.obstructed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED))), this::isIntakesObstructed, () -> null));
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    @Generated
    public int getTier() {
        return this.tier;
    }
}

