/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric.research;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.IHPCAComponentHatch;
import com.gregtechceu.gtceu.api.capability.IHPCAComputationProvider;
import com.gregtechceu.gtceu.api.capability.IHPCACoolantProvider;
import com.gregtechceu.gtceu.api.capability.IOpticalComputationProvider;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.util.TimedProgressSupplier;
import com.gregtechceu.gtceu.api.gui.widget.ExtendedProgressWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMaintenanceMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockDisplayText;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.IRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.misc.EnergyContainerList;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.api.transfer.fluid.FluidHandlerList;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.IManaged;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.FieldManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class HPCAMachine
extends WorkableElectricMultiblockMachine
implements IOpticalComputationProvider,
IControllable {
    private static final double IDLE_TEMPERATURE = 200.0;
    private static final double DAMAGE_TEMPERATURE = 1000.0;
    private IMaintenanceMachine maintenance;
    private IEnergyContainer energyContainer = new EnergyContainerList(new ArrayList());
    private IFluidHandler coolantHandler;
    @Persisted
    @DescSynced
    private final HPCAGridHandler hpcaHandler;
    private boolean hasNotEnoughEnergy;
    @Persisted
    private double temperature = 200.0;
    private final TimedProgressSupplier progressSupplier = new TimedProgressSupplier(200, 47, false);
    @Nullable
    protected TickableSubscription tickSubs;

    public HPCAMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, args);
        this.hpcaHandler = new HPCAGridHandler(this);
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        ArrayList<IEnergyContainer> energyContainers = new ArrayList<IEnergyContainer>();
        ArrayList<IFluidHandler> coolantContainers = new ArrayList<IFluidHandler>();
        ArrayList<IHPCAComponentHatch> componentHatches = new ArrayList<IHPCAComponentHatch>();
        Map ioMap = (Map)this.getMultiblockState().getMatchContext().getOrCreate("ioMap", Long2ObjectMaps::emptyMap);
        for (IMultiPart part : this.getParts()) {
            IO io = ioMap.getOrDefault(part.self().getPos().m_121878_(), IO.BOTH);
            if (part instanceof IHPCAComponentHatch) {
                IHPCAComponentHatch componentHatch = (IHPCAComponentHatch)((Object)part);
                componentHatches.add(componentHatch);
            }
            if (part instanceof IMaintenanceMachine) {
                IMaintenanceMachine maintenanceMachine;
                this.maintenance = maintenanceMachine = (IMaintenanceMachine)part;
            }
            if (io == IO.NONE || io == IO.OUT) continue;
            for (IRecipeHandlerTrait handler : part.getRecipeHandlers()) {
                if (io != IO.BOTH && handler.getHandlerIO() != IO.BOTH && io != handler.getHandlerIO()) continue;
                if (handler.getCapability() == EURecipeCapability.CAP && handler instanceof IEnergyContainer) {
                    IEnergyContainer container = (IEnergyContainer)((Object)handler);
                    energyContainers.add(container);
                    continue;
                }
                if (handler.getCapability() != FluidRecipeCapability.CAP || !(handler instanceof IFluidHandler)) continue;
                IFluidHandler fluidHandler = (IFluidHandler)handler;
                coolantContainers.add(fluidHandler);
            }
        }
        this.energyContainer = new EnergyContainerList(energyContainers);
        this.coolantHandler = new FluidHandlerList(coolantContainers);
        this.hpcaHandler.onStructureForm(componentHatches);
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, this::updateTickSubscription));
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, this::updateTickSubscription));
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.tickSubs != null) {
            this.tickSubs.unsubscribe();
            this.tickSubs = null;
        }
    }

    protected void updateTickSubscription() {
        if (this.isFormed) {
            this.tickSubs = this.subscribeServerTick(this.tickSubs, this::tick);
        } else if (this.tickSubs != null) {
            this.tickSubs.unsubscribe();
            this.tickSubs = null;
        }
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.energyContainer = new EnergyContainerList(new ArrayList());
        this.hpcaHandler.onStructureInvalidate();
    }

    @Override
    public int requestCWUt(int cwut, boolean simulate, @NotNull Collection<IOpticalComputationProvider> seen) {
        seen.add(this);
        return this.isActive() && this.isWorkingEnabled() && !this.hasNotEnoughEnergy ? this.hpcaHandler.allocateCWUt(cwut, simulate) : 0;
    }

    @Override
    public int getMaxCWUt(@NotNull Collection<IOpticalComputationProvider> seen) {
        seen.add(this);
        return this.isActive() && this.isWorkingEnabled() ? this.hpcaHandler.getMaxCWUt() : 0;
    }

    @Override
    public boolean canBridge(@NotNull Collection<IOpticalComputationProvider> seen) {
        seen.add(this);
        return !this.isFormed() || this.hpcaHandler.hasHPCABridge();
    }

    public void tick() {
        if (this.isWorkingEnabled()) {
            this.consumeEnergy();
        }
        if (this.isActive()) {
            double midpoint = 400.0;
            double temperatureChange = this.hpcaHandler.calculateTemperatureChange(this.coolantHandler, this.temperature >= midpoint) / 2.0;
            this.temperature = this.temperature + temperatureChange <= 200.0 ? 200.0 : (this.temperature += temperatureChange);
            if (this.temperature >= 1000.0) {
                this.hpcaHandler.attemptDamageHPCA();
            }
            this.hpcaHandler.tick();
        } else {
            this.hpcaHandler.clearComputationCache();
            this.temperature = Math.max(200.0, this.temperature - 0.25);
        }
    }

    private void consumeEnergy() {
        boolean hasMaintenance;
        long energyToConsume = this.hpcaHandler.getCurrentEUt();
        boolean bl = hasMaintenance = ConfigHolder.INSTANCE.machines.enableMaintenance && this.maintenance != null;
        if (hasMaintenance) {
            energyToConsume += (long)this.maintenance.getNumMaintenanceProblems() * energyToConsume / 10L;
        }
        if (this.hasNotEnoughEnergy && this.energyContainer.getInputPerSec() > 19L * energyToConsume) {
            this.hasNotEnoughEnergy = false;
        }
        if (this.energyContainer.getEnergyStored() >= energyToConsume) {
            if (!this.hasNotEnoughEnergy) {
                long consumed = this.energyContainer.removeEnergy(energyToConsume);
                if (consumed == energyToConsume) {
                    this.getRecipeLogic().setStatus(RecipeLogic.Status.WORKING);
                } else {
                    this.hasNotEnoughEnergy = true;
                    this.getRecipeLogic().setStatus(RecipeLogic.Status.WAITING);
                }
            }
        } else {
            this.hasNotEnoughEnergy = true;
            this.getRecipeLogic().setStatus(RecipeLogic.Status.WAITING);
        }
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup builder = (WidgetGroup)super.createUIWidget();
        builder.addWidget((Widget)new ExtendedProgressWidget(() -> this.hpcaHandler.getAllocatedCWUt() > 0 ? this.progressSupplier.getAsDouble() : 0.0, 74, 57, 47, 47, GuiTextures.HPCA_COMPONENT_OUTLINE).setServerTooltipSupplier(this.hpcaHandler::addInfo).setFillDirection(ProgressTexture.FillDirection.LEFT_TO_RIGHT));
        int startX = 76;
        int startY = 59;
        if (this.getLevel().f_46443_) {
            if (this.isFormed) {
                this.hpcaHandler.tryGatherClientComponents(this.getLevel(), this.getPos(), this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped);
            } else {
                this.hpcaHandler.clearClientComponents();
            }
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int index = i * 3 + j;
                Supplier<IGuiTexture> textureSupplier = () -> this.hpcaHandler.getComponentTexture(index);
                builder.addWidget((Widget)new ImageWidget(startX + 15 * j, startY + 15 * i, 13, 13, textureSupplier));
            }
        }
        return builder;
    }

    @Override
    public void addDisplayText(List<Component> textList) {
        MultiblockDisplayText.builder(textList, this.isFormed()).setWorkingStatus(true, this.hpcaHandler.getAllocatedCWUt() > 0).setWorkingStatusKeys("gtceu.multiblock.idling", "gtceu.multiblock.idling", "gtceu.multiblock.data_bank.providing").addCustom(tl -> {
            if (this.isFormed()) {
                tl.add(Component.m_237110_((String)"gtceu.multiblock.hpca.energy", (Object[])new Object[]{FormattingUtil.formatNumbers(this.hpcaHandler.cachedEUt), FormattingUtil.formatNumbers(this.hpcaHandler.getMaxEUt()), GTValues.VNF[GTUtil.getTierByVoltage(this.hpcaHandler.getMaxEUt())]}).m_130940_(ChatFormatting.GRAY));
                MutableComponent cwutInfo = Component.m_237113_((String)(this.hpcaHandler.cachedCWUt + " / " + this.hpcaHandler.getMaxCWUt() + " CWU/t")).m_130940_(ChatFormatting.AQUA);
                tl.add(Component.m_237110_((String)"gtceu.multiblock.hpca.computation", (Object[])new Object[]{cwutInfo}).m_130940_(ChatFormatting.GRAY));
            }
        }).addWorkingStatusLine();
    }

    private ChatFormatting getDisplayTemperatureColor() {
        if (this.temperature < 500.0) {
            return ChatFormatting.GREEN;
        }
        if (this.temperature < 750.0) {
            return ChatFormatting.YELLOW;
        }
        return ChatFormatting.RED;
    }

    public static class HPCAGridHandler
    implements IManaged {
        public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(HPCAGridHandler.class);
        private final FieldManagedStorage syncStorage = new FieldManagedStorage((IManaged)this);
        @Nullable
        private final HPCAMachine controller;
        private final List<IHPCAComponentHatch> components = new ObjectArrayList();
        private final Set<IHPCACoolantProvider> coolantProviders = new ObjectOpenHashSet();
        private final Set<IHPCAComputationProvider> computationProviders = new ObjectOpenHashSet();
        private int numBridges;
        private int allocatedCWUt;
        @DescSynced
        private long cachedEUt;
        @DescSynced
        private int cachedCWUt;

        public HPCAGridHandler(@Nullable HPCAMachine controller) {
            this.controller = controller;
        }

        public void onStructureForm(Collection<IHPCAComponentHatch> components) {
            this.reset();
            for (IHPCAComponentHatch component : components) {
                this.components.add(component);
                if (component instanceof IHPCACoolantProvider) {
                    IHPCACoolantProvider coolantProvider = (IHPCACoolantProvider)component;
                    this.coolantProviders.add(coolantProvider);
                }
                if (component instanceof IHPCAComputationProvider) {
                    IHPCAComputationProvider computationProvider = (IHPCAComputationProvider)component;
                    this.computationProviders.add(computationProvider);
                }
                if (!component.isBridge()) continue;
                ++this.numBridges;
            }
        }

        private void onStructureInvalidate() {
            this.reset();
        }

        private void reset() {
            this.clearComputationCache();
            this.components.clear();
            this.coolantProviders.clear();
            this.computationProviders.clear();
            this.numBridges = 0;
        }

        private void clearComputationCache() {
            this.allocatedCWUt = 0;
        }

        public void tick() {
            if (this.cachedCWUt != this.allocatedCWUt) {
                this.cachedCWUt = this.allocatedCWUt;
            }
            this.cachedEUt = this.getCurrentEUt();
            if (this.allocatedCWUt != 0) {
                this.allocatedCWUt = 0;
            }
        }

        public double calculateTemperatureChange(IFluidHandler coolantTank, boolean forceCoolWithActive) {
            double temperatureToDecrease;
            int coolantToDrain;
            FluidStack coolantStack;
            int maxCWUt = Math.max(1, this.getMaxCWUt());
            int maxCoolingDemand = this.getMaxCoolingDemand();
            int temperatureIncrease = (int)Math.round(1.0 * (double)maxCoolingDemand * (double)this.allocatedCWUt / (double)maxCWUt);
            long maxPassiveCooling = 0L;
            long maxActiveCooling = 0L;
            int maxCoolantDrain = 0;
            for (IHPCACoolantProvider coolantProvider : this.coolantProviders) {
                if (coolantProvider.isActiveCooler()) {
                    maxActiveCooling += (long)coolantProvider.getCoolingAmount();
                    maxCoolantDrain += coolantProvider.getMaxCoolantPerTick();
                    continue;
                }
                maxPassiveCooling += (long)coolantProvider.getCoolingAmount();
            }
            double temperatureChange = (long)temperatureIncrease - maxPassiveCooling;
            if (maxActiveCooling == 0L && maxCoolantDrain == 0) {
                return temperatureChange;
            }
            if (forceCoolWithActive || (double)maxActiveCooling <= temperatureChange) {
                FluidStack coolantStack2 = GTTransferUtils.drainFluidAccountNotifiableList(coolantTank, this.getCoolantStack(maxCoolantDrain), IFluidHandler.FluidAction.EXECUTE);
                if (!coolantStack2.isEmpty()) {
                    long coolantDrained = coolantStack2.getAmount();
                    temperatureChange = coolantDrained == (long)maxCoolantDrain ? (temperatureChange -= (double)maxActiveCooling) : (temperatureChange -= (double)maxActiveCooling * (1.0 * (double)coolantDrained / (double)maxCoolantDrain));
                }
            } else if (temperatureChange > 0.0 && !(coolantStack = GTTransferUtils.drainFluidAccountNotifiableList(coolantTank, this.getCoolantStack(coolantToDrain = Math.max(1, (int)((double)maxCoolantDrain * ((temperatureToDecrease = Math.min(temperatureChange, (double)maxActiveCooling)) / (double)maxActiveCooling)))), IFluidHandler.FluidAction.EXECUTE)).isEmpty()) {
                int coolantDrained = coolantStack.getAmount();
                if (coolantDrained == coolantToDrain) {
                    return 0.0;
                }
                temperatureChange -= temperatureToDecrease * (1.0 * (double)coolantDrained / (double)coolantToDrain);
            }
            return temperatureChange;
        }

        public FluidStack getCoolantStack(int amount) {
            return new FluidStack(this.getCoolant(), amount);
        }

        private Fluid getCoolant() {
            return GTMaterials.PCBCoolant.getFluid();
        }

        public void attemptDamageHPCA() {
            if (GTValues.RNG.m_188503_(200) == 0) {
                ArrayList<IHPCAComponentHatch> candidates = new ArrayList<IHPCAComponentHatch>();
                for (IHPCAComponentHatch component : this.components) {
                    if (!component.canBeDamaged()) continue;
                    candidates.add(component);
                }
                if (!candidates.isEmpty()) {
                    ((IHPCAComponentHatch)candidates.get(GTValues.RNG.m_188503_(candidates.size()))).setDamaged(true);
                }
            }
        }

        public int allocateCWUt(int cwut, boolean simulate) {
            int maxCWUt = this.getMaxCWUt();
            int availableCWUt = maxCWUt - this.allocatedCWUt;
            int toAllocate = Math.min(cwut, availableCWUt);
            if (!simulate) {
                this.allocatedCWUt += toAllocate;
            }
            return toAllocate;
        }

        public int getMaxCWUt() {
            int maxCWUt = 0;
            for (IHPCAComputationProvider computationProvider : this.computationProviders) {
                maxCWUt += computationProvider.getCWUPerTick();
            }
            return maxCWUt;
        }

        public long getCurrentEUt() {
            long upkeepEUt;
            long maximumCWUt = Math.max(1, this.getMaxCWUt());
            long maximumEUt = this.getMaxEUt();
            if (maximumEUt == (upkeepEUt = this.getUpkeepEUt())) {
                return maximumEUt;
            }
            return upkeepEUt + (maximumEUt - upkeepEUt) * (long)this.allocatedCWUt / maximumCWUt;
        }

        public long getUpkeepEUt() {
            long upkeepEUt = 0L;
            for (IHPCAComponentHatch component : this.components) {
                upkeepEUt += (long)component.getUpkeepEUt();
            }
            return upkeepEUt;
        }

        public long getMaxEUt() {
            long maximumEUt = 0L;
            for (IHPCAComponentHatch component : this.components) {
                maximumEUt += (long)component.getMaxEUt();
            }
            return maximumEUt;
        }

        public boolean hasHPCABridge() {
            return this.numBridges > 0;
        }

        public boolean hasActiveCoolers() {
            for (IHPCACoolantProvider coolantProvider : this.coolantProviders) {
                if (!coolantProvider.isActiveCooler()) continue;
                return true;
            }
            return false;
        }

        public int getMaxCoolingAmount() {
            int maxCooling = 0;
            for (IHPCACoolantProvider coolantProvider : this.coolantProviders) {
                maxCooling += coolantProvider.getCoolingAmount();
            }
            return maxCooling;
        }

        public int getMaxCoolingDemand() {
            int maxCooling = 0;
            for (IHPCAComputationProvider computationProvider : this.computationProviders) {
                maxCooling += computationProvider.getCoolingPerTick();
            }
            return maxCooling;
        }

        public int getMaxCoolantDemand() {
            int maxCoolant = 0;
            for (IHPCACoolantProvider coolantProvider : this.coolantProviders) {
                maxCoolant += coolantProvider.getMaxCoolantPerTick();
            }
            return maxCoolant;
        }

        public void addInfo(List<Component> textList) {
            MutableComponent data = Component.m_237113_((String)Integer.toString(this.getMaxCWUt())).m_130940_(ChatFormatting.AQUA);
            textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.hpca.info_max_computation", (Object[])new Object[]{data}).m_130940_(ChatFormatting.GRAY));
            ChatFormatting coolingColor = this.getMaxCoolingAmount() < this.getMaxCoolingDemand() ? ChatFormatting.RED : ChatFormatting.GREEN;
            data = Component.m_237113_((String)Integer.toString(this.getMaxCoolingDemand())).m_130940_(coolingColor);
            textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.hpca.info_max_cooling_demand", (Object[])new Object[]{data}).m_130940_(ChatFormatting.GRAY));
            data = Component.m_237113_((String)Integer.toString(this.getMaxCoolingAmount())).m_130940_(coolingColor);
            textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.hpca.info_max_cooling_available", (Object[])new Object[]{data}).m_130940_(ChatFormatting.GRAY));
            if (this.getMaxCoolantDemand() > 0) {
                data = Component.m_237110_((String)"gtceu.universal.liters", (Object[])new Object[]{this.getMaxCoolantDemand()}).m_130940_(ChatFormatting.YELLOW).m_130946_(" ");
                MutableComponent coolantName = Component.m_237115_((String)"gtceu.multiblock.hpca.info_coolant_name").m_130940_(ChatFormatting.YELLOW);
                data.m_7220_((Component)coolantName);
            } else {
                data = Component.m_237113_((String)"0").m_130940_(ChatFormatting.GREEN);
            }
            textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.hpca.info_max_coolant_required", (Object[])new Object[]{data}).m_130940_(ChatFormatting.GRAY));
            if (this.numBridges > 0) {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.hpca.info_bridging_enabled").m_130940_(ChatFormatting.GREEN));
            } else {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.hpca.info_bridging_disabled").m_130940_(ChatFormatting.RED));
            }
        }

        public void addWarnings(List<Component> textList) {
            ArrayList<MutableComponent> warnings = new ArrayList<MutableComponent>();
            if (this.numBridges > 1) {
                warnings.add(Component.m_237115_((String)"gtceu.multiblock.hpca.warning_multiple_bridges").m_130940_(ChatFormatting.GRAY));
            }
            if (this.computationProviders.isEmpty()) {
                warnings.add(Component.m_237115_((String)"gtceu.multiblock.hpca.warning_no_computation").m_130940_(ChatFormatting.GRAY));
            }
            if (this.getMaxCoolingDemand() > this.getMaxCoolingAmount()) {
                warnings.add(Component.m_237115_((String)"gtceu.multiblock.hpca.warning_low_cooling").m_130940_(ChatFormatting.GRAY));
            }
            if (!warnings.isEmpty()) {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.hpca.warning_structure_header").m_130940_(ChatFormatting.YELLOW));
                textList.addAll(warnings);
            }
        }

        public void addErrors(List<Component> textList) {
            if (this.components.stream().anyMatch(IHPCAComponentHatch::isDamaged)) {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.hpca.error_damaged").m_130940_(ChatFormatting.RED));
            }
        }

        public ResourceTexture getComponentTexture(int index) {
            if (this.components.size() <= index) {
                return GuiTextures.BLANK_TRANSPARENT;
            }
            return this.components.get(index).getComponentIcon();
        }

        public void tryGatherClientComponents(Level world, BlockPos pos, Direction frontFacing, Direction upwardsFacing, boolean flip) {
            Direction relativeUp = RelativeDirection.UP.getRelativeFacing(frontFacing, upwardsFacing, flip);
            if (this.components.isEmpty()) {
                BlockPos testPos = pos.m_5484_(frontFacing.m_122424_(), 3).m_5484_(relativeUp, 3);
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        IMachineBlockEntity machineBE;
                        MetaMachine machine;
                        BlockPos tempPos = testPos.m_5484_(frontFacing, j).m_5484_(relativeUp.m_122424_(), i);
                        BlockEntity be = world.m_7702_(tempPos);
                        if (be instanceof IHPCAComponentHatch) {
                            IHPCAComponentHatch hatch = (IHPCAComponentHatch)be;
                            this.components.add(hatch);
                            continue;
                        }
                        if (!(be instanceof IMachineBlockEntity) || !((machine = (machineBE = (IMachineBlockEntity)be).getMetaMachine()) instanceof IHPCAComponentHatch)) continue;
                        IHPCAComponentHatch hatch = (IHPCAComponentHatch)((Object)machine);
                        this.components.add(hatch);
                    }
                }
            }
        }

        public void clearClientComponents() {
            this.components.clear();
        }

        public ManagedFieldHolder getFieldHolder() {
            return MANAGED_FIELD_HOLDER;
        }

        public void onChanged() {
            this.controller.onChanged();
        }

        @Generated
        public FieldManagedStorage getSyncStorage() {
            return this.syncStorage;
        }

        @Generated
        public int getAllocatedCWUt() {
            return this.allocatedCWUt;
        }
    }
}

