/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.worldgen.BiomeWeightModifier;
import com.gregtechceu.gtceu.api.data.worldgen.GTLayerPattern;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.IWorldGenLayer;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGenLayers;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGeneratorUtils;
import com.gregtechceu.gtceu.api.data.worldgen.generator.IndicatorGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.indicators.SurfaceIndicatorGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.DikeVeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.NoopVeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.VeinedVeinGenerator;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTMaterialBlocks;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class GTOres {
    private static int largestVeinSize = 0;
    private static int largestIndicatorOffset = 0;
    private static final Map<ResourceLocation, GTOreDefinition> toReRegister = new HashMap<ResourceLocation, GTOreDefinition>();
    public static RuleTest[] END_RULES = new RuleTest[]{WorldGeneratorUtils.END_ORE_REPLACEABLES};
    public static final GTOreDefinition BAUXITE_VEIN_END = GTOres.create("bauxite_vein_end", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)32, (int)40)).density(0.3f).weight(40).layer(WorldGenLayers.ENDSTONE).heightRangeUniform(10, 80).biomes((TagKey<Biome>)BiomeTags.f_215818_).layeredVeinGenerator(generator -> generator.withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(END_RULES).layer(l -> l.weight(2).state(() -> ((Block)Blocks.f_50259_).m_49966_()).size(1, 6)).layer(l -> l.weight(2).mat(GTMaterials.Bauxite).size(1, 4)).layer(l -> l.weight(1).mat(GTMaterials.Ilmenite).size(1, 2)).layer(l -> l.weight(1).mat(GTMaterials.Aluminium).size(1, 1)).build()))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Bauxite).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE)));
    public static final GTOreDefinition MAGNETITE_VEIN_END = GTOres.create("magnetite_vein_end", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)38, (int)44)).density(0.15f).weight(30).layer(WorldGenLayers.ENDSTONE).heightRangeUniform(20, 80).biomes((TagKey<Biome>)BiomeTags.f_215818_).layeredVeinGenerator(generator -> generator.withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(END_RULES).layer(l -> l.weight(3).mat(GTMaterials.Magnetite).size(1, 4)).layer(l -> l.weight(2).mat(GTMaterials.VanadiumMagnetite).size(1, 2)).layer(l -> l.weight(2).mat(GTMaterials.Chromite).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Gold).size(1, 1)).build()))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Magnetite).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE)));
    public static final GTOreDefinition NAQUADAH_VEIN = GTOres.create("naquadah_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)48, (int)80)).density(0.25f).weight(30).layer(WorldGenLayers.ENDSTONE).heightRangeUniform(10, 90).biomes((TagKey<Biome>)BiomeTags.f_215818_).cuboidVeinGenerator(generator -> generator.top(b -> b.mat(GTMaterials.Naquadah).size(2)).middle(b -> b.mat(GTMaterials.Naquadah).size(3)).bottom(b -> b.mat(GTMaterials.Naquadah).size(2)).spread(b -> b.mat(GTMaterials.Plutonium239))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Naquadah).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE)));
    public static final GTOreDefinition PITCHBLENDE_VEIN = GTOres.create("pitchblende_vein_end", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)32, (int)64)).density(0.25f).weight(30).layer(WorldGenLayers.ENDSTONE).heightRangeUniform(30, 60).biomes((TagKey<Biome>)BiomeTags.f_215818_).cuboidVeinGenerator(generator -> generator.top(b -> b.mat(GTMaterials.Pitchblende).size(2)).middle(b -> b.mat(GTMaterials.Pitchblende).size(3)).bottom(b -> b.mat(GTMaterials.Pitchblende).size(2)).spread(b -> b.mat(GTMaterials.Uraninite))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Pitchblende).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE)));
    public static final GTOreDefinition SCHEELITE_VEIN = GTOres.create("scheelite_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)50, (int)64)).density(0.7f).weight(20).layer(WorldGenLayers.ENDSTONE).heightRangeUniform(20, 60).biomes((TagKey<Biome>)BiomeTags.f_215818_).dikeVeinGenerator(generator -> generator.withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Scheelite, 3, 20, 60)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Tungstate, 2, 35, 55)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Lithium, 1, 20, 40))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Scheelite).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE)));
    public static final GTOreDefinition SHELDONITE_VEIN = GTOres.create("sheldonite_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)25, (int)29)).density(0.2f).weight(10).layer(WorldGenLayers.ENDSTONE).heightRangeUniform(5, 50).biomes((TagKey<Biome>)BiomeTags.f_215818_).layeredVeinGenerator(generator -> generator.withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(END_RULES).layer(l -> l.weight(3).mat(GTMaterials.Bornite).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Cooperite).size(1, 1)).layer(l -> l.weight(2).mat(GTMaterials.Platinum).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Palladium).size(1, 1)).build()))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Platinum).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE)));
    public static RuleTest[] NETHER_RULES = new RuleTest[]{new TagMatchTest(BlockTags.f_215835_)};
    public static final GTOreDefinition BANDED_IRON_VEIN = GTOres.create("banded_iron_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)40, (int)52)).density(1.0f).weight(30).layer(WorldGenLayers.NETHERRACK).heightRangeUniform(20, 40).biomes((TagKey<Biome>)BiomeTags.f_207612_).veinedVeinGenerator(generator -> generator.oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Goethite, 3)).oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.YellowLimonite, 2)).oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Hematite, 2)).rareBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Gold, 1)).rareBlockChance(0.075f).veininessThreshold(0.01f).maxRichnessThreshold(0.175f).minRichness(0.7f).maxRichness(1.0f).edgeRoundoffBegin(3).maxEdgeRoundoff(0.1f)).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Goethite).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE)));
    public static final GTOreDefinition BERYLLIUM_VEIN = GTOres.create("beryllium_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)50, (int)64)).density(0.75f).weight(30).layer(WorldGenLayers.NETHERRACK).heightRangeUniform(5, 30).biomes((TagKey<Biome>)BiomeTags.f_207612_).dikeVeinGenerator(generator -> generator.withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Beryllium, 3, 5, 30)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Emerald, 2, 5, 19)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Emerald, 2, 16, 30))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Beryllium).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE)));
    public static final GTOreDefinition CERTUS_QUARTZ_VEIN = GTOres.create("certus_quartz", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)25, (int)29)).density(0.25f).weight(40).layer(WorldGenLayers.NETHERRACK).heightRangeUniform(80, 120).biomes((TagKey<Biome>)BiomeTags.f_207612_).layeredVeinGenerator(generator -> generator.withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(NETHER_RULES).layer(l -> l.weight(3).mat(GTMaterials.Quartzite).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.CertusQuartz).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Barite).size(1, 1)).build()))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.CertusQuartz).placement(SurfaceIndicatorGenerator.IndicatorPlacement.BELOW)));
    public static final GTOreDefinition MANGANESE_VEIN = GTOres.create("manganese_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)50, (int)64)).density(0.75f).weight(20).layer(WorldGenLayers.NETHERRACK).heightRangeUniform(20, 30).biomes((TagKey<Biome>)BiomeTags.f_207612_).dikeVeinGenerator(generator -> generator.withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Grossular, 3, 20, 30)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Pyrolusite, 2, 20, 26)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Tantalite, 1, 24, 30))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Grossular).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE)));
    public static final GTOreDefinition MOLYBDENUM_VEIN = GTOres.create("molybdenum_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)25, (int)29)).density(0.25f).weight(5).layer(WorldGenLayers.NETHERRACK).heightRangeUniform(20, 50).biomes((TagKey<Biome>)BiomeTags.f_207612_).layeredVeinGenerator(generator -> generator.withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(NETHER_RULES).layer(l -> l.weight(3).mat(GTMaterials.Wulfenite).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Molybdenite).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Molybdenum).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Powellite).size(1, 1)).build()))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Molybdenum).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE)));
    public static final GTOreDefinition MONAZITE_VEIN = GTOres.create("monazite_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)25, (int)29)).density(0.25f).weight(30).layer(WorldGenLayers.NETHERRACK).heightRangeUniform(20, 40).biomes((TagKey<Biome>)BiomeTags.f_207612_).layeredVeinGenerator(generator -> generator.withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(NETHER_RULES).layer(l -> l.weight(3).mat(GTMaterials.Bastnasite).size(2, 4)).layer(l -> l.weight(1).mat(GTMaterials.Monazite).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Neodymium).size(1, 1)).build()))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Bastnasite).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE)));
    public static final GTOreDefinition NETHER_QUARTZ_VEIN = GTOres.create("nether_quartz_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)32, (int)40)).density(0.2f).weight(80).layer(WorldGenLayers.NETHERRACK).heightRangeUniform(40, 80).biomes((TagKey<Biome>)BiomeTags.f_207612_).layeredVeinGenerator(generator -> generator.withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(NETHER_RULES).layer(l -> l.weight(3).mat(GTMaterials.NetherQuartz).size(2, 4)).layer(l -> l.weight(1).mat(GTMaterials.Quartzite).size(1, 1)).build()))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.NetherQuartz).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE)));
    public static final GTOreDefinition REDSTONE_VEIN = GTOres.create("redstone_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)32, (int)40)).density(0.2f).weight(60).layer(WorldGenLayers.NETHERRACK).heightRangeUniform(5, 40).biomes((TagKey<Biome>)BiomeTags.f_207612_).layeredVeinGenerator(generator -> generator.withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(NETHER_RULES).layer(l -> l.weight(3).mat(GTMaterials.Redstone).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Ruby).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Cinnabar).size(1, 1)).build()))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Redstone).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE)));
    public static final GTOreDefinition SALTPETER_VEIN = GTOres.create("saltpeter_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)32, (int)40)).density(0.25f).weight(40).layer(WorldGenLayers.NETHERRACK).heightRangeUniform(5, 45).biomes((TagKey<Biome>)BiomeTags.f_207612_).layeredVeinGenerator(generator -> generator.withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(NETHER_RULES).layer(l -> l.weight(3).mat(GTMaterials.Saltpeter).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Diatomite).size(1, 1)).layer(l -> l.weight(2).mat(GTMaterials.Electrotine).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Alunite).size(1, 1)).build()))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Saltpeter).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE)));
    public static final GTOreDefinition SULFUR_VEIN = GTOres.create("sulfur_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)32, (int)40)).density(0.2f).weight(100).layer(WorldGenLayers.NETHERRACK).heightRangeUniform(10, 30).biomes((TagKey<Biome>)BiomeTags.f_207612_).layeredVeinGenerator(generator -> generator.withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(NETHER_RULES).layer(l -> l.weight(3).mat(GTMaterials.Sulfur).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Pyrite).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Sphalerite).size(1, 1)).build()))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Sulfur).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE)));
    public static final GTOreDefinition TETRAHEDRITE_VEIN = GTOres.create("tetrahedrite_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)40, (int)52)).density(1.0f).weight(70).layer(WorldGenLayers.NETHERRACK).heightRangeUniform(80, 120).biomes((TagKey<Biome>)BiomeTags.f_207612_).veinedVeinGenerator(generator -> generator.oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Tetrahedrite, 4)).oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Copper, 2)).rareBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Stibnite, 1)).rareBlockChance(0.15f).veininessThreshold(0.01f).maxRichnessThreshold(0.175f).minRichness(0.7f).maxRichness(1.0f).edgeRoundoffBegin(3).maxEdgeRoundoff(0.1f)).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Tetrahedrite).placement(SurfaceIndicatorGenerator.IndicatorPlacement.BELOW)));
    public static final GTOreDefinition TOPAZ_VEIN = GTOres.create("topaz_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)25, (int)29)).density(0.25f).weight(70).layer(WorldGenLayers.NETHERRACK).heightRangeUniform(80, 120).biomes((TagKey<Biome>)BiomeTags.f_207612_).layeredVeinGenerator(generator -> generator.withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(NETHER_RULES).layer(l -> l.weight(3).mat(GTMaterials.BlueTopaz).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Topaz).size(1, 1)).layer(l -> l.weight(2).mat(GTMaterials.Chalcocite).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Bornite).size(1, 1)).build()))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Topaz).placement(SurfaceIndicatorGenerator.IndicatorPlacement.BELOW)));
    public static RuleTest[] OVERWORLD_RULES = new RuleTest[]{new TagMatchTest(BlockTags.f_144266_)};
    public static final GTOreDefinition APATITE_VEIN = GTOres.create("apatite_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)32, (int)40)).density(0.25f).weight(40).layer(WorldGenLayers.STONE).heightRangeUniform(10, 80).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator(generator -> generator.withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(3).mat(GTMaterials.Apatite).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.TricalciumPhosphate).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Pyrochlore).size(1, 1)).build()))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Apatite).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE)));
    public static final GTOreDefinition CASSITERITE_VEIN = GTOres.create("cassiterite_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)40, (int)52)).density(1.0f).weight(80).layer(WorldGenLayers.STONE).heightRangeUniform(10, 80).biomes((TagKey<Biome>)BiomeTags.f_215817_).veinedVeinGenerator(generator -> generator.oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Tin, 4)).rareBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Cassiterite, 2)).rareBlockChance(0.33f).veininessThreshold(0.01f).maxRichnessThreshold(0.175f).minRichness(0.7f).maxRichness(1.0f).edgeRoundoffBegin(3).maxEdgeRoundoff(0.1f)).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Cassiterite)));
    public static final GTOreDefinition COAL_VEIN = GTOres.create("coal_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)38, (int)44)).density(0.25f).weight(80).layer(WorldGenLayers.STONE).heightRangeUniform(10, 140).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator(generator -> generator.withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(3).mat(GTMaterials.Coal).size(2, 4)).layer(l -> l.weight(3).mat(GTMaterials.Coal).size(2, 4)).build()))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Coal)));
    public static final GTOreDefinition COPPER_TIN_VEIN = GTOres.create("copper_tin_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)40, (int)52)).density(1.0f).weight(50).layer(WorldGenLayers.STONE).heightRangeUniform(-10, 160).biomes((TagKey<Biome>)BiomeTags.f_215817_).veinedVeinGenerator(generator -> generator.oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Chalcopyrite, 5)).oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Zeolite, 2)).oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Cassiterite, 2)).rareBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Realgar, 1)).rareBlockChance(0.1f).veininessThreshold(0.01f).maxRichnessThreshold(0.175f).minRichness(0.7f).maxRichness(1.0f).edgeRoundoffBegin(3).maxEdgeRoundoff(0.1f)).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Chalcopyrite)));
    public static final GTOreDefinition GALENA_VEIN = GTOres.create("galena_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)32, (int)40)).density(0.25f).weight(40).layer(WorldGenLayers.STONE).heightRangeUniform(-15, 45).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator(generator -> generator.withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(3).mat(GTMaterials.Galena).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Silver).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Lead).size(1, 1)).build()))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Galena)));
    public static final GTOreDefinition GARNET_TIN_VEIN = GTOres.create("garnet_tin_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)32, (int)40)).density(0.4f).weight(80).layer(WorldGenLayers.STONE).heightRangeUniform(30, 60).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator(generator -> generator.withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(3).mat(GTMaterials.CassiteriteSand).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.GarnetSand).size(1, 1)).layer(l -> l.weight(2).mat(GTMaterials.Asbestos).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Diatomite).size(1, 1)).build()))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.GarnetSand)));
    public static final GTOreDefinition GARNET_VEIN = GTOres.create("garnet_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)50, (int)64)).density(0.75f).weight(40).layer(WorldGenLayers.STONE).heightRangeUniform(-10, 50).biomes((TagKey<Biome>)BiomeTags.f_215817_).dikeVeinGenerator(generator -> generator.withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.GarnetRed, 3, -10, 50)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.GarnetYellow, 2, -10, 50)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Amethyst, 2, -10, 22)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Opal, 1, 18, 50))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.GarnetRed).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE)));
    public static final GTOreDefinition IRON_VEIN = GTOres.create("iron_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)40, (int)52)).density(1.0f).weight(120).layer(WorldGenLayers.STONE).heightRangeUniform(-10, 60).biomes((TagKey<Biome>)BiomeTags.f_215817_).veinedVeinGenerator(generator -> generator.oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Goethite, 5)).oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.YellowLimonite, 2)).oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Hematite, 2)).oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Malachite, 1)).veininessThreshold(0.01f).maxRichnessThreshold(0.175f).minRichness(0.7f).maxRichness(1.0f).edgeRoundoffBegin(3).maxEdgeRoundoff(0.1f)).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Goethite)));
    public static final GTOreDefinition LUBRICANT_VEIN = GTOres.create("lubricant_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)25, (int)29)).density(0.25f).weight(40).layer(WorldGenLayers.STONE).heightRangeUniform(0, 50).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator(generator -> generator.withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(3).mat(GTMaterials.Soapstone).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Talc).size(1, 1)).layer(l -> l.weight(2).mat(GTMaterials.GlauconiteSand).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Pentlandite).size(1, 1)).build()))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Talc)));
    public static final GTOreDefinition MAGNETITE_VEIN_OW = GTOres.create("magnetite_vein_ow", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)38, (int)44)).density(0.15f).weight(80).layer(WorldGenLayers.STONE).heightRangeUniform(10, 60).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator(generator -> generator.withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(3).mat(GTMaterials.Magnetite).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.VanadiumMagnetite).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Gold).size(1, 1)).build()))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Magnetite)));
    public static final GTOreDefinition MINERAL_SAND_VEIN = GTOres.create("mineral_sand_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)32, (int)40)).density(0.2f).weight(80).layer(WorldGenLayers.STONE).heightRangeUniform(15, 60).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator(generator -> generator.withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(3).mat(GTMaterials.BasalticMineralSand).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.GraniticMineralSand).size(1, 1)).layer(l -> l.weight(2).mat(GTMaterials.FullersEarth).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Gypsum).size(1, 1)).build()))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.BasalticMineralSand)));
    public static final GTOreDefinition NICKEL_VEIN = GTOres.create("nickel_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)32, (int)40)).density(0.25f).weight(40).layer(WorldGenLayers.STONE).heightRangeUniform(-10, 60).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator(generator -> generator.withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(3).mat(GTMaterials.Garnierite).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Nickel).size(1, 1)).layer(l -> l.weight(2).mat(GTMaterials.Cobaltite).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Pentlandite).size(1, 1)).build()))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Nickel)));
    public static final GTOreDefinition SALTS_VEIN = GTOres.create("salts_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)32, (int)40)).density(0.2f).weight(50).layer(WorldGenLayers.STONE).heightRangeUniform(30, 70).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator(generator -> generator.withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(3).mat(GTMaterials.RockSalt).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Salt).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Lepidolite).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Spodumene).size(1, 1)).build()))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Salt)));
    public static final GTOreDefinition OILSANDS_VEIN = GTOres.create("oilsands_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)25, (int)29)).density(0.3f).weight(40).layer(WorldGenLayers.STONE).heightRangeUniform(30, 80).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator(generator -> generator.withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(3).mat(GTMaterials.Oilsands).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Oilsands).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Oilsands).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Oilsands).size(1, 1)).build()))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Oilsands)));
    public static RuleTest[] DEEPSLATE_RULES = new RuleTest[]{new TagMatchTest(BlockTags.f_144267_)};
    public static final GTOreDefinition COPPER_VEIN = GTOres.create("copper_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)40, (int)52)).density(1.0f).weight(80).layer(WorldGenLayers.DEEPSLATE).heightRangeUniform(-40, 10).biomes((TagKey<Biome>)BiomeTags.f_215817_).veinedVeinGenerator(generator -> generator.oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Chalcopyrite, 5)).oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Iron, 2)).oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Pyrite, 2)).oreBlock(new VeinedVeinGenerator.VeinBlockDefinition(GTMaterials.Copper, 2)).veininessThreshold(0.01f).maxRichnessThreshold(0.175f).minRichness(0.7f).maxRichness(1.0f).edgeRoundoffBegin(3).maxEdgeRoundoff(0.1f)).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Copper)));
    public static final GTOreDefinition DIAMOND_VEIN = GTOres.create("diamond_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)32, (int)40)).density(0.25f).weight(40).layer(WorldGenLayers.DEEPSLATE).heightRangeUniform(-55, -30).biomes((TagKey<Biome>)BiomeTags.f_215817_).classicVeinGenerator(generator -> generator.primary(b -> b.mat(GTMaterials.Graphite).size(4)).secondary(b -> b.mat(GTMaterials.Graphite).size(3)).between(b -> b.mat(GTMaterials.Diamond).size(3)).sporadic(b -> b.mat(GTMaterials.Coal))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Diamond).density(0.1f).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE).radius(2)));
    public static final GTOreDefinition LAPIS_VEIN = GTOres.create("lapis_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)40, (int)52)).density(0.75f).weight(40).layer(WorldGenLayers.DEEPSLATE).heightRangeUniform(-60, 10).biomes((TagKey<Biome>)BiomeTags.f_215817_).dikeVeinGenerator(generator -> generator.withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Lazurite, 3, -60, 10)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Sodalite, 2, -50, 0)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Lapis, 2, -50, 0)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Calcite, 1, -40, 10))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Lapis).density(0.15f).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE).radius(3)));
    public static final GTOreDefinition MANGANESE_VEIN_OW = GTOres.create("manganese_vein_ow", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)50, (int)64)).density(0.75f).weight(20).layer(WorldGenLayers.DEEPSLATE).heightRangeUniform(-30, 0).biomes((TagKey<Biome>)BiomeTags.f_215817_).dikeVeinGenerator(generator -> generator.withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Grossular, 3, -50, -5)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Spessartine, 2, -40, -15)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Pyrolusite, 2, -40, -15)).withBlock(new DikeVeinGenerator.DikeBlockDefinition(GTMaterials.Tantalite, 1, -30, -5))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Grossular).density(0.15f).radius(3)));
    public static final GTOreDefinition MICA_VEIN = GTOres.create("mica_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)32, (int)40)).density(0.25f).weight(20).layer(WorldGenLayers.DEEPSLATE).heightRangeUniform(-40, -10).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator(generator -> generator.withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(3).mat(GTMaterials.Kyanite).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Mica).size(1, 1)).layer(l -> l.weight(2).mat(GTMaterials.Bauxite).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Pollucite).size(1, 1)).build()))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Mica).radius(3)));
    public static final GTOreDefinition OLIVINE_VEIN = GTOres.create("olivine_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)32, (int)40)).density(0.25f).weight(20).layer(WorldGenLayers.DEEPSLATE).heightRangeUniform(-20, 10).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator(generator -> generator.withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(3).mat(GTMaterials.Bentonite).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Magnetite).size(1, 1)).layer(l -> l.weight(2).mat(GTMaterials.Olivine).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.GlauconiteSand).size(1, 1)).build()))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Olivine).density(0.15f).radius(3)));
    public static final GTOreDefinition REDSTONE_VEIN_OW = GTOres.create("redstone_vein_ow", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)32, (int)40)).density(0.2f).weight(60).layer(WorldGenLayers.DEEPSLATE).heightRangeUniform(-65, -10).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator(generator -> generator.withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(3).mat(GTMaterials.Redstone).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Ruby).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Cinnabar).size(1, 1)).build()))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Redstone)));
    public static final GTOreDefinition SAPPHIRE_VEIN = GTOres.create("sapphire_vein", (GTOreDefinition vein) -> vein.clusterSize((IntProvider)UniformInt.m_146622_((int)25, (int)29)).density(0.25f).weight(60).layer(WorldGenLayers.DEEPSLATE).heightRangeUniform(-40, 0).biomes((TagKey<Biome>)BiomeTags.f_215817_).layeredVeinGenerator(generator -> generator.withLayerPattern((NonNullSupplier<GTLayerPattern>)((NonNullSupplier)() -> GTLayerPattern.builder(OVERWORLD_RULES).layer(l -> l.weight(3).mat(GTMaterials.Almandine).size(2, 4)).layer(l -> l.weight(2).mat(GTMaterials.Pyrope).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.Sapphire).size(1, 1)).layer(l -> l.weight(1).mat(GTMaterials.GreenSapphire).size(1, 1)).build()))).surfaceIndicatorGenerator(indicator -> indicator.surfaceRock(GTMaterials.Sapphire).density(0.15f).placement(SurfaceIndicatorGenerator.IndicatorPlacement.ABOVE).radius(3)));

    private static GTOreDefinition create(String name, Consumer<GTOreDefinition> config) {
        return GTOres.create(GTCEu.id(name), config);
    }

    public static GTOreDefinition create(ResourceLocation name, Consumer<GTOreDefinition> config) {
        GTOreDefinition def = GTOres.blankOreDefinition();
        config.accept(def);
        def.register(name);
        toReRegister.put(name, def);
        return def;
    }

    private static Supplier<? extends Block> ore(TagPrefix oreTag, Material material) {
        BlockEntry block = (BlockEntry)GTMaterialBlocks.MATERIAL_BLOCKS.get((Object)oreTag, (Object)material);
        if (block == null) {
            ResourceLocation oreKey = oreTag == TagPrefix.ore ? new ResourceLocation("%s_ore".formatted(material.getName())) : (oreTag == TagPrefix.oreNetherrack ? new ResourceLocation("nether_%s_ore".formatted(material.getName())) : new ResourceLocation("%s_%s_ore".formatted(oreTag.name, material.getName())));
            return BuiltInRegistries.f_256975_.m_7804_(oreKey) ? () -> (Block)BuiltInRegistries.f_256975_.m_7745_(oreKey) : () -> Blocks.f_50016_;
        }
        return block;
    }

    public static void init() {
        toReRegister.forEach(GTRegistries.ORE_VEINS::registerOrOverride);
    }

    public static void updateLargestVeinSize() {
        largestVeinSize = GTRegistries.ORE_VEINS.values().stream().map(GTOreDefinition::clusterSize).mapToInt(intProvider -> (intProvider.m_142739_() + intProvider.m_142737_()) / 2).max().orElse(0);
        largestIndicatorOffset = GTRegistries.ORE_VEINS.values().stream().flatMapToInt(definition -> definition.indicatorGenerators().stream().mapToInt(indicatorGenerator -> indicatorGenerator.getSearchRadiusModifier((int)Math.ceil((double)definition.clusterSize().m_142739_() / 2.0)))).max().orElse(0);
    }

    public static GTOreDefinition blankOreDefinition() {
        return new GTOreDefinition((IntProvider)ConstantInt.f_146476_, 0.0f, 0, IWorldGenLayer.NOWHERE, Set.of(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)0)), 0.0f, () -> HolderSet.m_205809_((Holder[])new Holder[0]), BiomeWeightModifier.EMPTY, NoopVeinGenerator.INSTANCE, new ArrayList<IndicatorGenerator>());
    }

    @Generated
    public static int getLargestVeinSize() {
        return largestVeinSize;
    }

    @Generated
    public static int getLargestIndicatorOffset() {
        return largestIndicatorOffset;
    }
}

