/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.commands;

import com.google.gson.JsonElement;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.BedrockFluidDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockore.BedrockOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVein;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVeinMetadata;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OrePlacer;
import com.gregtechceu.gtceu.api.gui.factory.GTUIEditorFactory;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.registry.GTRegistry;
import com.gregtechceu.gtceu.common.commands.arguments.GTRegistryArgument;
import com.gregtechceu.gtceu.data.pack.GTDynamicDataPack;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import org.slf4j.Logger;

public class GTCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"gtceu").requires(source -> source.m_6761_(3))).then(Commands.m_82127_((String)"ui_editor").executes(context -> {
            GTUIEditorFactory.INSTANCE.openUI((Object)GTUIEditorFactory.INSTANCE, ((CommandSourceStack)context.getSource()).m_81375_());
            return 1;
        }))).then(Commands.m_82127_((String)"check_recipes_valid").executes(context -> {
            for (Recipe recipe : ((CommandSourceStack)context.getSource()).m_81377_().m_129894_().m_44051_()) {
                GTRecipe gtRecipe;
                if (!(recipe instanceof GTRecipe) || (gtRecipe = (GTRecipe)recipe).checkRecipeValid()) continue;
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"recipe %s is invalid".formatted(gtRecipe.id)), false);
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dump_data").then(Commands.m_82127_((String)"bedrock_fluid_veins").executes(context -> GTCommands.dumpDataRegistry((CommandContext<CommandSourceStack>)context, GTRegistries.BEDROCK_FLUID_DEFINITIONS, BedrockFluidDefinition.FULL_CODEC, "gtceu/fluid_veins")))).then(Commands.m_82127_((String)"bedrock_ore_veins").executes(context -> GTCommands.dumpDataRegistry((CommandContext<CommandSourceStack>)context, GTRegistries.BEDROCK_ORE_DEFINITIONS, BedrockOreDefinition.FULL_CODEC, "gtceu/bedrock_ore_veins")))).then(Commands.m_82127_((String)"ore_veins").executes(context -> GTCommands.dumpDataRegistry((CommandContext<CommandSourceStack>)context, GTRegistries.ORE_VEINS, GTOreDefinition.FULL_CODEC, "gtceu/ore_veins"))))).then(Commands.m_82127_((String)"place_vein").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"vein", GTRegistryArgument.registry(GTRegistries.ORE_VEINS, ResourceLocation.class)).executes(context -> GTCommands.placeVein((CommandContext<CommandSourceStack>)context, BlockPos.m_274446_((Position)((CommandSourceStack)context.getSource()).m_81371_())))).then(Commands.m_82129_((String)"position", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> GTCommands.placeVein((CommandContext<CommandSourceStack>)context, BlockPosArgument.m_264582_((CommandContext)context, (String)"position")))))));
    }

    private static <T> int dumpDataRegistry(CommandContext<CommandSourceStack> context, GTRegistry<ResourceLocation, T> registry, Codec<T> codec, String folder) {
        Path parent = GTCEu.getGameDir().resolve("gtceu/dumped/data");
        RegistryOps ops = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)((CommandSourceStack)context.getSource()).m_5894_());
        int dumpedCount = 0;
        for (ResourceLocation id : registry.keys()) {
            T entry = registry.get(id);
            JsonElement json = (JsonElement)codec.encodeStart((DynamicOps)ops, entry).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0));
            GTDynamicDataPack.writeJson(id, folder, parent, json);
            ++dumpedCount;
        }
        int result = dumpedCount;
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.gtceu.dump_data.success", (Object[])new Object[]{result, registry.getRegistryName().toString(), parent.toString()}), true);
        return result;
    }

    private static int placeVein(CommandContext<CommandSourceStack> context, BlockPos sourcePos) {
        GTOreDefinition vein = (GTOreDefinition)context.getArgument("vein", GTOreDefinition.class);
        ResourceLocation id = (ResourceLocation)GTRegistries.ORE_VEINS.getKey(vein);
        ChunkPos chunkPos = new ChunkPos(sourcePos);
        ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
        GeneratedVeinMetadata metadata = new GeneratedVeinMetadata(id, chunkPos, sourcePos, vein);
        RandomSource random = level.f_46441_;
        OrePlacer placer = new OrePlacer();
        OreGenerator generator = placer.getOreGenCache().getOreGenerator();
        try (BulkSectionAccess access = new BulkSectionAccess((LevelAccessor)level);){
            Optional<GeneratedVein> generated = generator.generateOres(new OreGenerator.VeinConfiguration(metadata, random), (WorldGenLevel)level, chunkPos);
            if (generated.isEmpty()) {
                throw new CommandRuntimeException((Component)Component.m_237110_((String)"command.gtceu.place_vein.failure", (Object[])new Object[]{id.toString(), sourcePos.toString()}));
            }
            for (ChunkPos pos : generated.get().getGeneratedChunks()) {
                placer.placeVein(pos, random, access, generated.get(), (RuleTest)AlwaysTrueTest.f_73954_);
                level.m_6325_(pos.f_45578_, pos.f_45579_).m_8092_(true);
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.gtceu.place_vein.success", (Object[])new Object[]{id.toString(), sourcePos.toString()}), true);
        }
        return 1;
    }
}

