/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.blockentity;

import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ItemPipeProperties;
import com.gregtechceu.gtceu.common.block.ItemPipeBlock;
import com.gregtechceu.gtceu.common.pipelike.item.ItemNetHandler;
import com.gregtechceu.gtceu.common.pipelike.item.ItemPipeNet;
import com.gregtechceu.gtceu.common.pipelike.item.ItemPipeType;
import com.gregtechceu.gtceu.utils.FacingPos;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.gregtechceu.gtceu.utils.GTUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.ref.WeakReference;
import java.util.EnumMap;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemPipeBlockEntity
extends PipeBlockEntity<ItemPipeType, ItemPipeProperties> {
    protected WeakReference<ItemPipeNet> currentItemPipeNet = new WeakReference<Object>(null);
    private final EnumMap<Direction, ItemNetHandler> handlers = new EnumMap(Direction.class);
    private final Object2IntMap<FacingPos> transferred = new Object2IntOpenHashMap();
    private ItemNetHandler defaultHandler;
    private final IItemHandlerModifiable clientCapability = new ItemStackHandler(0);
    private int transferredItems = 0;
    private long timer = 0L;

    public ItemPipeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public static ItemPipeBlockEntity create(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        return new ItemPipeBlockEntity(type, pos, blockState);
    }

    public long getLevelTime() {
        return this.m_58898_() ? this.m_58904_().m_46467_() : 0L;
    }

    public static void onBlockEntityRegister(BlockEntityType<ItemPipeBlockEntity> itemPipeBlockEntityBlockEntityType) {
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            Level world = this.m_58904_();
            if (world.m_5776_()) {
                return LazyOptional.empty();
            }
            if (side != null && this.isConnected(side)) {
                this.ensureHandlersInitialized();
                this.checkNetwork();
                if (this.currentItemPipeNet.get() == null) {
                    return LazyOptional.empty();
                }
                return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, LazyOptional.of(() -> this.getHandler(side, true)));
            }
        } else {
            if (cap == GTCapability.CAPABILITY_COVERABLE) {
                return GTCapability.CAPABILITY_COVERABLE.orEmpty(cap, LazyOptional.of(this::getCoverContainer));
            }
            if (cap == GTCapability.CAPABILITY_TOOLABLE) {
                return GTCapability.CAPABILITY_TOOLABLE.orEmpty(cap, LazyOptional.of(() -> this));
            }
        }
        return super.getCapability(cap, side);
    }

    private void ensureHandlersInitialized() {
        if (this.getHandlers().isEmpty()) {
            this.initHandlers();
        }
    }

    public void initHandlers() {
        ItemPipeNet net = this.getItemPipeNet();
        if (net == null) {
            return;
        }
        for (Direction facing : GTUtil.DIRECTIONS) {
            this.handlers.put(facing, new ItemNetHandler(net, this, facing));
        }
        this.defaultHandler = new ItemNetHandler(net, this, null);
    }

    public void checkNetwork() {
        if (this.defaultHandler != null) {
            ItemPipeNet current = this.getItemPipeNet();
            if (this.defaultHandler.getNet() != current) {
                this.defaultHandler.updateNetwork(current);
                for (ItemNetHandler handler : this.handlers.values()) {
                    handler.updateNetwork(current);
                }
            }
        }
    }

    @Override
    public boolean canAttachTo(Direction side) {
        if (this.f_58857_ == null) {
            return false;
        }
        if (this.f_58857_.m_7702_(this.m_58899_().m_121945_(side)) instanceof ItemPipeBlockEntity) {
            return false;
        }
        return GTTransferUtils.hasAdjacentItemHandler(this.f_58857_, this.m_58899_(), side);
    }

    @Nullable
    public ItemPipeNet getItemPipeNet() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            level = this.m_58900_().m_60734_();
            if (level instanceof ItemPipeBlock) {
                ItemPipeBlock itemPipeBlock = (ItemPipeBlock)level;
                ItemPipeNet currentItemPipeNet = (ItemPipeNet)this.currentItemPipeNet.get();
                if (currentItemPipeNet != null && currentItemPipeNet.isValid() && currentItemPipeNet.containsNode(this.m_58899_())) {
                    return currentItemPipeNet;
                }
                currentItemPipeNet = (ItemPipeNet)itemPipeBlock.getWorldPipeNet(serverLevel).getNetFromPos(this.m_58899_());
                if (currentItemPipeNet != null) {
                    this.currentItemPipeNet = new WeakReference<ItemPipeNet>(currentItemPipeNet);
                }
            }
        }
        return (ItemPipeNet)this.currentItemPipeNet.get();
    }

    public void resetTransferred() {
        this.transferred.clear();
    }

    private void updateTransferredState() {
        long currentTime = this.getLevelTime();
        long dif = currentTime - this.timer;
        if (dif >= 20L || dif < 0L) {
            this.transferredItems = 0;
            this.timer = currentTime;
        }
    }

    public void addTransferredItems(int amount) {
        this.updateTransferredState();
        this.transferredItems += amount;
    }

    public int getTransferredItems() {
        this.updateTransferredState();
        return this.transferredItems;
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.handlers.clear();
    }

    public IItemHandlerModifiable getHandler(@Nullable Direction side, boolean useCoverCapability) {
        this.ensureHandlersInitialized();
        this.checkNetwork();
        if (this.currentItemPipeNet.get() == null) {
            return null;
        }
        ItemNetHandler handler = this.getHandlers().getOrDefault(side, this.getDefaultHandler());
        if (!useCoverCapability || side == null) {
            return handler;
        }
        CoverBehavior cover = this.getCoverContainer().getCoverAtSide(side);
        return cover != null ? cover.getItemHandlerCap(handler) : handler;
    }

    @Generated
    public EnumMap<Direction, ItemNetHandler> getHandlers() {
        return this.handlers;
    }

    @Generated
    public Object2IntMap<FacingPos> getTransferred() {
        return this.transferred;
    }

    @Generated
    public ItemNetHandler getDefaultHandler() {
        return this.defaultHandler;
    }
}

