/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.renderer.machine.OverlayEnergyIORenderer;
import com.gregtechceu.gtceu.client.renderer.machine.TieredHullMachineRenderer;
import com.gregtechceu.gtceu.client.util.StaticFaceBakery;
import com.gregtechceu.gtceu.common.machine.electric.ConverterMachine;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ConverterRenderer
extends TieredHullMachineRenderer {
    private static final ResourceLocation CONVERTER_FE_IN = GTCEu.id("block/overlay/converter/converter_native_in");
    private static final ResourceLocation CONVERTER_FE_OUT = GTCEu.id("block/overlay/converter/converter_native_out");
    private final OverlayEnergyIORenderer ENERGY_IN;
    private final OverlayEnergyIORenderer ENERGY_OUT;

    public ConverterRenderer(int tier, int baseAmp) {
        super(tier, GTCEu.id("block/machine/hull_machine"));
        switch (baseAmp) {
            case 4: {
                this.ENERGY_IN = OverlayEnergyIORenderer.ENERGY_IN_4A;
                this.ENERGY_OUT = OverlayEnergyIORenderer.ENERGY_OUT_4A;
                break;
            }
            case 8: {
                this.ENERGY_IN = OverlayEnergyIORenderer.ENERGY_IN_8A;
                this.ENERGY_OUT = OverlayEnergyIORenderer.ENERGY_OUT_8A;
                break;
            }
            case 16: {
                this.ENERGY_IN = OverlayEnergyIORenderer.ENERGY_IN_16A;
                this.ENERGY_OUT = OverlayEnergyIORenderer.ENERGY_OUT_16A;
                break;
            }
            default: {
                this.ENERGY_IN = OverlayEnergyIORenderer.ENERGY_IN_1A;
                this.ENERGY_OUT = OverlayEnergyIORenderer.ENERGY_OUT_1A;
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderMachine(List<BakedQuad> quads, MachineDefinition definition, @Nullable MetaMachine machine, Direction frontFacing, @Nullable Direction side, RandomSource rand, Direction modelFacing, ModelState modelState) {
        super.renderMachine(quads, definition, machine, frontFacing, side, rand, modelFacing, modelState);
        boolean isFeToEu = false;
        if (machine instanceof ConverterMachine) {
            ConverterMachine converter = (ConverterMachine)machine;
            isFeToEu = converter.isFeToEu();
        }
        if (side == frontFacing && modelFacing != null) {
            if (isFeToEu) {
                this.ENERGY_OUT.renderOverlay(quads, modelFacing, modelState, 2);
            } else {
                quads.add(StaticFaceBakery.bakeFace(modelFacing, ModelFactory.getBlockSprite((ResourceLocation)CONVERTER_FE_OUT), modelState, -1));
            }
        } else if (side != null && modelFacing != null) {
            if (isFeToEu) {
                quads.add(StaticFaceBakery.bakeFace(modelFacing, ModelFactory.getBlockSprite((ResourceLocation)CONVERTER_FE_IN), modelState, -1));
            } else {
                this.ENERGY_IN.renderOverlay(quads, modelFacing, modelState, 2);
            }
        }
    }

    @Override
    public void onPrepareTextureAtlas(ResourceLocation atlasName, Consumer<ResourceLocation> register) {
        super.onPrepareTextureAtlas(atlasName, register);
        if (atlasName.equals((Object)TextureAtlas.f_118259_)) {
            register.accept(CONVERTER_FE_IN);
            register.accept(CONVERTER_FE_OUT);
        }
    }
}

