/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.particle;

import com.gregtechceu.gtceu.common.particle.HazardParticleOptions;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class HazardParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    protected HazardParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, HazardParticleOptions options, SpriteSet sprites) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.f_172258_ = 0.96f;
        this.f_107226_ = 0.0125f;
        this.f_172259_ = true;
        this.sprites = sprites;
        this.f_107215_ *= (double)0.1f;
        this.f_107216_ *= (double)0.1f;
        this.f_107217_ *= (double)0.1f;
        float colorMultiplier = this.f_107223_.m_188501_() * 0.4f + 0.6f;
        this.f_107227_ = this.randomizeColor((float)FastColor.ARGB32.m_13665_((int)options.color()) / 255.0f, colorMultiplier);
        this.f_107228_ = this.randomizeColor((float)FastColor.ARGB32.m_13667_((int)options.color()) / 255.0f, colorMultiplier);
        this.f_107229_ = this.randomizeColor((float)FastColor.ARGB32.m_13669_((int)options.color()) / 255.0f, colorMultiplier);
        this.f_107663_ *= 0.75f * options.scale();
        this.f_107225_ = (int)((double)this.f_107225_ / ((double)level.f_46441_.m_188501_() * 0.8 + 0.2) * 2.0);
        this.m_108339_(sprites);
        this.f_107219_ = false;
    }

    protected float randomizeColor(float coordMultiplier, float multiplier) {
        return (this.f_107223_.m_188501_() * 0.2f + 0.8f) * coordMultiplier * multiplier;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public float m_5902_(float scaleFactor) {
        return this.f_107663_ * Mth.m_14036_((float)(((float)this.f_107224_ + scaleFactor) / (float)this.f_107225_ * 32.0f), (float)0.0f, (float)1.0f);
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_108339_(this.sprites);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<HazardParticleOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(HazardParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            RandomSource randomSource = level.f_46441_;
            return new HazardParticle(level, x, y, z, xSpeed += (double)randomSource.m_188501_() * -1.9 * (double)randomSource.m_188501_() * 0.1, ySpeed += (double)randomSource.m_188501_() * -0.5 * (double)randomSource.m_188501_() * 0.1 * 5.0, zSpeed += (double)randomSource.m_188501_() * -1.9 * (double)randomSource.m_188501_() * 0.1, options, this.sprites);
        }
    }
}

