/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.model;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.client.util.StaticFaceBakery;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.lowdragmc.lowdraglib.client.renderer.IItemRendererProvider;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.SimpleModelState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class WorkableOverlayModel {
    protected final ResourceLocation location;
    @OnlyIn(value=Dist.CLIENT)
    public Map<OverlayFace, ActivePredicate> sprites;

    public WorkableOverlayModel(ResourceLocation location) {
        this.location = location;
        if (GTCEu.isClientSide()) {
            this.sprites = new EnumMap<OverlayFace, ActivePredicate>(OverlayFace.class);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<BakedQuad> bakeQuads(@Nullable Direction side, Direction frontFacing, Direction upwardsFacing, boolean isActive, boolean isWorkingEnabled) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        float degree = 1.5707964f * (float)(upwardsFacing == Direction.EAST ? 1 : (upwardsFacing == Direction.SOUTH ? 2 : (upwardsFacing == Direction.WEST ? -1 : 0)));
        Matrix4f matrix = new Matrix4f();
        if (frontFacing.m_122434_() != Direction.Axis.Y) {
            double rotationRad = Math.toRadians(frontFacing.m_122435_());
            Quaternionf worldUp = new Quaternionf().rotationAxis((float)Math.PI - (float)rotationRad, 0.0f, 1.0f, 0.0f);
            matrix.rotate((Quaternionfc)worldUp);
        } else {
            matrix.rotate(1.5707964f, (float)frontFacing.m_122430_(), 0.0f, 0.0f);
            if (upwardsFacing.m_122434_() == Direction.Axis.Z) {
                matrix.rotate((float)Math.PI, 0.0f, 0.0f, (float)upwardsFacing.m_122431_());
            }
            if (frontFacing.m_122421_() == Direction.AxisDirection.NEGATIVE) {
                matrix.rotate((float)Math.PI, 0.0f, 0.0f, 1.0f);
            }
        }
        Quaternionf rot = new Quaternionf().rotationAxis(degree, 0.0f, 0.0f, frontFacing.m_122421_() == Direction.AxisDirection.NEGATIVE ? 1.0f : -1.0f);
        if (frontFacing.m_122421_() == Direction.AxisDirection.POSITIVE && frontFacing.m_122434_() != Direction.Axis.Y && upwardsFacing.m_122434_() != Direction.Axis.Z) {
            matrix.rotate((float)Math.PI, 0.0f, 0.0f, 1.0f);
        }
        matrix.rotate((Quaternionfc)rot);
        SimpleModelState rotation = new SimpleModelState(new Transformation(matrix));
        for (Direction renderSide : GTUtil.DIRECTIONS) {
            BakedQuad quad;
            ActivePredicate predicate = this.sprites.get((Object)OverlayFace.bySide(renderSide));
            if (predicate == null) continue;
            TextureAtlasSprite texture = predicate.getSprite(isActive, isWorkingEnabled);
            if (texture != null && (quad = StaticFaceBakery.bakeFace(StaticFaceBakery.SLIGHTLY_OVER_BLOCK, renderSide, texture, (ModelState)rotation, -1, 0, true, true)).m_111306_() == side) {
                quads.add(quad);
            }
            if ((texture = predicate.getEmissiveSprite(isActive, isWorkingEnabled)) == null) continue;
            if (ConfigHolder.INSTANCE.client.machinesEmissiveTextures) {
                quad = StaticFaceBakery.bakeFace(StaticFaceBakery.SLIGHTLY_OVER_BLOCK, renderSide, texture, (ModelState)rotation, -101, 15, true, false);
                if (quad.m_111306_() != side) continue;
                quads.add(quad);
                continue;
            }
            quad = StaticFaceBakery.bakeFace(StaticFaceBakery.SLIGHTLY_OVER_BLOCK, renderSide, texture, (ModelState)rotation, -1, 0, true, true);
            if (quad.m_111306_() != side) continue;
            quads.add(quad);
        }
        return quads;
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public TextureAtlasSprite getParticleTexture() {
        for (ActivePredicate predicate : this.sprites.values()) {
            TextureAtlasSprite sprite = predicate.getSprite(false, false);
            if (sprite == null) continue;
            return sprite;
        }
        return ModelFactory.getBlockSprite((ResourceLocation)MissingTextureAtlasSprite.m_118071_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderItem(ItemStack stack, ItemDisplayContext transformType, boolean leftHand, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel model) {
        IItemRendererProvider.disabled.set(true);
        Minecraft.m_91087_().m_91291_().m_115143_(stack, transformType, leftHand, matrixStack, buffer, combinedLight, combinedOverlay, (state, direction, random) -> this.bakeQuads(direction, Direction.NORTH, Direction.NORTH, false, false));
        IItemRendererProvider.disabled.set(false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerTextureAtlas(Consumer<ResourceLocation> register) {
        ResourceManager resManager = Minecraft.m_91087_().m_91098_();
        this.sprites.clear();
        for (OverlayFace overlayFace : OverlayFace.VALUES) {
            String overlayPath = "/overlay_" + overlayFace.name().toLowerCase(Locale.ROOT);
            ResourceLocation normalSprite = new ResourceLocation(this.location.m_135827_(), this.location.m_135815_() + overlayPath);
            ResourceLocation normalSprite1 = this.getTextureLocation(normalSprite);
            if (!resManager.m_213713_(normalSprite1).isPresent()) continue;
            register.accept(normalSprite);
            String active = String.format("%s_active", overlayPath);
            ResourceLocation activeSprite = new ResourceLocation(this.location.m_135827_(), this.location.m_135815_() + active);
            ResourceLocation activeSprite1 = this.getTextureLocation(activeSprite);
            if (resManager.m_213713_(activeSprite1).isPresent()) {
                register.accept(activeSprite);
            } else {
                activeSprite = normalSprite;
            }
            String paused = String.format("%s_paused", overlayPath);
            ResourceLocation pausedSprite = new ResourceLocation(this.location.m_135827_(), this.location.m_135815_() + paused);
            ResourceLocation pausedSprite1 = this.getTextureLocation(pausedSprite);
            if (resManager.m_213713_(pausedSprite1).isPresent()) {
                register.accept(pausedSprite);
            } else {
                pausedSprite = normalSprite;
            }
            ResourceLocation normalSpriteEmissive = new ResourceLocation(this.location.m_135827_(), this.location.m_135815_() + overlayPath + "_emissive");
            ResourceLocation normalSpriteEmissive1 = this.getTextureLocation(normalSpriteEmissive);
            if (resManager.m_213713_(normalSpriteEmissive1).isPresent()) {
                register.accept(normalSpriteEmissive);
            } else {
                normalSpriteEmissive = null;
            }
            ResourceLocation activeSpriteEmissive = new ResourceLocation(this.location.m_135827_(), this.location.m_135815_() + active + "_emissive");
            ResourceLocation activeSpriteEmissive1 = this.getTextureLocation(activeSpriteEmissive);
            if (resManager.m_213713_(activeSpriteEmissive1).isPresent()) {
                register.accept(activeSpriteEmissive);
            } else {
                activeSpriteEmissive = null;
            }
            ResourceLocation pausedSpriteEmissive = new ResourceLocation(this.location.m_135827_(), this.location.m_135815_() + paused + "_emissive");
            ResourceLocation pausedSpriteEmissive1 = this.getTextureLocation(pausedSpriteEmissive);
            if (resManager.m_213713_(pausedSpriteEmissive1).isPresent()) {
                register.accept(pausedSpriteEmissive);
            } else {
                pausedSpriteEmissive = null;
            }
            this.sprites.put(overlayFace, new ActivePredicate(normalSprite, activeSprite, pausedSprite, normalSpriteEmissive, activeSpriteEmissive, pausedSpriteEmissive));
        }
    }

    private ResourceLocation getTextureLocation(ResourceLocation location) {
        return new ResourceLocation(location.m_135827_(), "textures/%s.png".formatted(location.m_135815_()));
    }

    public static enum OverlayFace {
        FRONT,
        BACK,
        TOP,
        BOTTOM,
        SIDE;

        public static final OverlayFace[] VALUES;

        public static OverlayFace bySide(Direction side) {
            return switch (side) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.DOWN -> BOTTOM;
                case Direction.UP -> TOP;
                case Direction.NORTH -> FRONT;
                case Direction.SOUTH -> BACK;
                case Direction.WEST, Direction.EAST -> SIDE;
            };
        }

        static {
            VALUES = OverlayFace.values();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ActivePredicate {
        private final ResourceLocation normalSprite;
        private final ResourceLocation activeSprite;
        private final ResourceLocation pausedSprite;
        private final ResourceLocation normalSpriteEmissive;
        private final ResourceLocation activeSpriteEmissive;
        private final ResourceLocation pausedSpriteEmissive;

        public ActivePredicate(@Nullable ResourceLocation normalSprite, @Nullable ResourceLocation activeSprite, @Nullable ResourceLocation pausedSprite, @Nullable ResourceLocation normalSpriteEmissive, @Nullable ResourceLocation activeSpriteEmissive, @Nullable ResourceLocation pausedSpriteEmissive) {
            this.normalSprite = normalSprite;
            this.activeSprite = activeSprite;
            this.pausedSprite = pausedSprite;
            this.normalSpriteEmissive = normalSpriteEmissive;
            this.activeSpriteEmissive = activeSpriteEmissive;
            this.pausedSpriteEmissive = pausedSpriteEmissive;
        }

        @Nullable
        public TextureAtlasSprite getSprite(boolean active, boolean workingEnabled) {
            return this.getTextureAtlasSprite(active, workingEnabled, this.activeSprite, this.pausedSprite, this.normalSprite);
        }

        @Nullable
        public TextureAtlasSprite getEmissiveSprite(boolean active, boolean workingEnabled) {
            return this.getTextureAtlasSprite(active, workingEnabled, this.activeSpriteEmissive, this.pausedSpriteEmissive, this.normalSpriteEmissive);
        }

        @Nullable
        private TextureAtlasSprite getTextureAtlasSprite(boolean active, boolean workingEnabled, @Nullable ResourceLocation activeSprite, @Nullable ResourceLocation pausedSprite, @Nullable ResourceLocation normalSprite) {
            if (active) {
                if (workingEnabled) {
                    return activeSprite == null ? null : ModelFactory.getBlockSprite((ResourceLocation)activeSprite);
                }
                return pausedSprite == null ? null : ModelFactory.getBlockSprite((ResourceLocation)pausedSprite);
            }
            return normalSprite == null ? null : ModelFactory.getBlockSprite((ResourceLocation)normalSprite);
        }
    }
}

