/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.registry.registrate;

import com.gregtechceu.gtceu.api.block.IMachineBlock;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.MultiblockShapeInfo;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import com.gregtechceu.gtceu.api.registry.registrate.MachineBuilder;
import com.gregtechceu.gtceu.utils.SupplierMemoizer;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import dev.latvian.mods.kubejs.client.LangEventJS;
import dev.latvian.mods.rhino.util.HideFromJS;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MultiblockMachineBuilder
extends MachineBuilder<MultiblockMachineDefinition> {
    private boolean generator;
    private Function<MultiblockMachineDefinition, BlockPattern> pattern;
    private final List<Function<MultiblockMachineDefinition, List<MultiblockShapeInfo>>> shapeInfos = new ArrayList<Function<MultiblockMachineDefinition, List<MultiblockShapeInfo>>>();
    private boolean allowExtendedFacing = true;
    private boolean allowFlip = true;
    private final List<Supplier<ItemStack[]>> recoveryItems = new ArrayList<Supplier<ItemStack[]>>();
    private Comparator<IMultiPart> partSorter = (a, b) -> 0;
    private TriFunction<IMultiController, IMultiPart, Direction, BlockState> partAppearance;
    private BiConsumer<IMultiController, List<Component>> additionalDisplay = (m, l) -> {};

    protected MultiblockMachineBuilder(Registrate registrate, String name, Function<IMachineBlockEntity, ? extends MultiblockControllerMachine> metaMachine, BiFunction<BlockBehaviour.Properties, MultiblockMachineDefinition, IMachineBlock> blockFactory, BiFunction<IMachineBlock, Item.Properties, MetaMachineItem> itemFactory, TriFunction<BlockEntityType<?>, BlockPos, BlockState, IMachineBlockEntity> blockEntityFactory) {
        super(registrate, name, MultiblockMachineDefinition::createDefinition, metaMachine::apply, blockFactory, itemFactory, blockEntityFactory);
    }

    public static MultiblockMachineBuilder createMulti(Registrate registrate, String name, Function<IMachineBlockEntity, ? extends MultiblockControllerMachine> metaMachine, BiFunction<BlockBehaviour.Properties, MultiblockMachineDefinition, IMachineBlock> blockFactory, BiFunction<IMachineBlock, Item.Properties, MetaMachineItem> itemFactory, TriFunction<BlockEntityType<?>, BlockPos, BlockState, IMachineBlockEntity> blockEntityFactory) {
        return new MultiblockMachineBuilder(registrate, name, metaMachine, blockFactory, itemFactory, blockEntityFactory);
    }

    public MultiblockMachineBuilder shapeInfo(Function<MultiblockMachineDefinition, MultiblockShapeInfo> shape) {
        this.shapeInfos.add(d -> List.of((MultiblockShapeInfo)shape.apply((MultiblockMachineDefinition)d)));
        return this;
    }

    public MultiblockMachineBuilder shapeInfos(Function<MultiblockMachineDefinition, List<MultiblockShapeInfo>> shapes) {
        this.shapeInfos.add(shapes);
        return this;
    }

    public MultiblockMachineBuilder recoveryItems(Supplier<ItemLike[]> items) {
        this.recoveryItems.add(() -> (ItemStack[])Arrays.stream((ItemLike[])items.get()).map(ItemLike::m_5456_).map(Item::m_7968_).toArray(ItemStack[]::new));
        return this;
    }

    public MultiblockMachineBuilder recoveryStacks(Supplier<ItemStack[]> stacks) {
        this.recoveryItems.add(stacks);
        return this;
    }

    public MultiblockMachineBuilder definition(Function<ResourceLocation, MultiblockMachineDefinition> definition) {
        return (MultiblockMachineBuilder)super.definition(definition);
    }

    public MultiblockMachineBuilder machine(Function<IMachineBlockEntity, MetaMachine> machine) {
        return (MultiblockMachineBuilder)super.machine(machine);
    }

    public MultiblockMachineBuilder renderer(@Nullable Supplier<IRenderer> renderer) {
        return (MultiblockMachineBuilder)super.renderer(renderer);
    }

    public MultiblockMachineBuilder shape(VoxelShape shape) {
        return (MultiblockMachineBuilder)super.shape(shape);
    }

    public MultiblockMachineBuilder multiblockPreviewRenderer(boolean multiBlockWorldPreview, boolean multiBlockXEIPreview) {
        return (MultiblockMachineBuilder)super.multiblockPreviewRenderer(multiBlockWorldPreview, multiBlockXEIPreview);
    }

    public MultiblockMachineBuilder rotationState(RotationState rotationState) {
        return (MultiblockMachineBuilder)super.rotationState(rotationState);
    }

    public MultiblockMachineBuilder hasTESR(boolean hasTESR) {
        return (MultiblockMachineBuilder)super.hasTESR(hasTESR);
    }

    public MultiblockMachineBuilder blockProp(NonNullUnaryOperator<BlockBehaviour.Properties> blockProp) {
        return (MultiblockMachineBuilder)super.blockProp(blockProp);
    }

    public MultiblockMachineBuilder itemProp(NonNullUnaryOperator<Item.Properties> itemProp) {
        return (MultiblockMachineBuilder)super.itemProp(itemProp);
    }

    public MultiblockMachineBuilder blockBuilder(Consumer<BlockBuilder<? extends Block, ?>> blockBuilder) {
        return (MultiblockMachineBuilder)super.blockBuilder(blockBuilder);
    }

    public MultiblockMachineBuilder itemBuilder(Consumer<ItemBuilder<? extends MetaMachineItem, ?>> itemBuilder) {
        return (MultiblockMachineBuilder)super.itemBuilder(itemBuilder);
    }

    public MultiblockMachineBuilder recipeTypes(GTRecipeType ... recipeTypes) {
        return (MultiblockMachineBuilder)super.recipeTypes(recipeTypes);
    }

    public MultiblockMachineBuilder recipeType(GTRecipeType recipeTypes) {
        return (MultiblockMachineBuilder)super.recipeType(recipeTypes);
    }

    public MultiblockMachineBuilder tier(int tier) {
        return (MultiblockMachineBuilder)super.tier(tier);
    }

    public MultiblockMachineBuilder recipeOutputLimits(Object2IntMap<RecipeCapability<?>> map) {
        return (MultiblockMachineBuilder)super.recipeOutputLimits(map);
    }

    public MultiblockMachineBuilder addOutputLimit(RecipeCapability<?> capability, int limit) {
        return (MultiblockMachineBuilder)super.addOutputLimit(capability, limit);
    }

    public MultiblockMachineBuilder itemColor(BiFunction<ItemStack, Integer, Integer> itemColor) {
        return (MultiblockMachineBuilder)super.itemColor(itemColor);
    }

    public MultiblockMachineBuilder modelRenderer(Supplier<ResourceLocation> model) {
        return (MultiblockMachineBuilder)super.modelRenderer(model);
    }

    public MultiblockMachineBuilder defaultModelRenderer() {
        return (MultiblockMachineBuilder)super.defaultModelRenderer();
    }

    public MultiblockMachineBuilder tieredHullRenderer(ResourceLocation model) {
        return (MultiblockMachineBuilder)super.tieredHullRenderer(model);
    }

    public MultiblockMachineBuilder overlayTieredHullRenderer(String name) {
        return (MultiblockMachineBuilder)super.overlayTieredHullRenderer(name);
    }

    public MultiblockMachineBuilder workableTieredHullRenderer(ResourceLocation workableModel) {
        return (MultiblockMachineBuilder)super.workableTieredHullRenderer(workableModel);
    }

    public MultiblockMachineBuilder workableCasingRenderer(ResourceLocation baseCasing, ResourceLocation overlayModel) {
        return (MultiblockMachineBuilder)super.workableCasingRenderer(baseCasing, overlayModel);
    }

    public MultiblockMachineBuilder workableCasingRenderer(ResourceLocation baseCasing, ResourceLocation overlayModel, boolean tint) {
        return (MultiblockMachineBuilder)super.workableCasingRenderer(baseCasing, overlayModel, tint);
    }

    public MultiblockMachineBuilder sidedWorkableCasingRenderer(String basePath, ResourceLocation overlayModel, boolean tint) {
        return (MultiblockMachineBuilder)super.sidedWorkableCasingRenderer(basePath, overlayModel, tint);
    }

    public MultiblockMachineBuilder sidedWorkableCasingRenderer(String basePath, ResourceLocation overlayModel) {
        return (MultiblockMachineBuilder)super.sidedWorkableCasingRenderer(basePath, overlayModel);
    }

    public MultiblockMachineBuilder tooltipBuilder(BiConsumer<ItemStack, List<Component>> tooltipBuilder) {
        return (MultiblockMachineBuilder)super.tooltipBuilder(tooltipBuilder);
    }

    public MultiblockMachineBuilder appearance(Supplier<BlockState> state) {
        return (MultiblockMachineBuilder)super.appearance(state);
    }

    public MultiblockMachineBuilder appearanceBlock(Supplier<? extends Block> block) {
        return (MultiblockMachineBuilder)super.appearanceBlock(block);
    }

    public MultiblockMachineBuilder langValue(String langValue) {
        return (MultiblockMachineBuilder)super.langValue(langValue);
    }

    public MultiblockMachineBuilder overlaySteamHullRenderer(String name) {
        return (MultiblockMachineBuilder)super.overlaySteamHullRenderer(name);
    }

    public MultiblockMachineBuilder workableSteamHullRenderer(boolean isHighPressure, ResourceLocation workableModel) {
        return (MultiblockMachineBuilder)super.workableSteamHullRenderer(isHighPressure, workableModel);
    }

    public MultiblockMachineBuilder tooltips(Component ... components) {
        return (MultiblockMachineBuilder)super.tooltips(components);
    }

    public MultiblockMachineBuilder conditionalTooltip(Component component, Supplier<Boolean> condition) {
        return this.conditionalTooltip(component, condition.get());
    }

    public MultiblockMachineBuilder conditionalTooltip(Component component, boolean condition) {
        if (condition) {
            this.tooltips(component);
        }
        return this;
    }

    public MultiblockMachineBuilder abilities(PartAbility ... abilities) {
        return (MultiblockMachineBuilder)super.abilities(abilities);
    }

    public MultiblockMachineBuilder paintingColor(int paintingColor) {
        return (MultiblockMachineBuilder)super.paintingColor(paintingColor);
    }

    public MultiblockMachineBuilder recipeModifier(RecipeModifier recipeModifier) {
        return (MultiblockMachineBuilder)super.recipeModifier(recipeModifier);
    }

    public MultiblockMachineBuilder recipeModifier(RecipeModifier recipeModifier, boolean alwaysTryModifyRecipe) {
        return (MultiblockMachineBuilder)super.recipeModifier(recipeModifier, alwaysTryModifyRecipe);
    }

    public MultiblockMachineBuilder recipeModifiers(RecipeModifier ... recipeModifiers) {
        return (MultiblockMachineBuilder)super.recipeModifiers(recipeModifiers);
    }

    public MultiblockMachineBuilder recipeModifiers(boolean alwaysTryModifyRecipe, RecipeModifier ... recipeModifiers) {
        return (MultiblockMachineBuilder)super.recipeModifiers(alwaysTryModifyRecipe, recipeModifiers);
    }

    public MultiblockMachineBuilder noRecipeModifier() {
        return (MultiblockMachineBuilder)super.noRecipeModifier();
    }

    public MultiblockMachineBuilder alwaysTryModifyRecipe(boolean alwaysTryModifyRecipe) {
        return (MultiblockMachineBuilder)super.alwaysTryModifyRecipe(alwaysTryModifyRecipe);
    }

    public MultiblockMachineBuilder beforeWorking(BiPredicate<IRecipeLogicMachine, GTRecipe> beforeWorking) {
        return (MultiblockMachineBuilder)super.beforeWorking(beforeWorking);
    }

    public MultiblockMachineBuilder onWorking(Predicate<IRecipeLogicMachine> onWorking) {
        return (MultiblockMachineBuilder)super.onWorking(onWorking);
    }

    public MultiblockMachineBuilder onWaiting(Consumer<IRecipeLogicMachine> onWaiting) {
        return (MultiblockMachineBuilder)super.onWaiting(onWaiting);
    }

    public MultiblockMachineBuilder afterWorking(Consumer<IRecipeLogicMachine> afterWorking) {
        return (MultiblockMachineBuilder)super.afterWorking(afterWorking);
    }

    public MultiblockMachineBuilder regressWhenWaiting(boolean dampingWhenWaiting) {
        return (MultiblockMachineBuilder)super.regressWhenWaiting(dampingWhenWaiting);
    }

    public MultiblockMachineBuilder editableUI(@Nullable EditableMachineUI editableUI) {
        return (MultiblockMachineBuilder)super.editableUI(editableUI);
    }

    public MultiblockMachineBuilder onBlockEntityRegister(NonNullConsumer<BlockEntityType<BlockEntity>> onBlockEntityRegister) {
        return (MultiblockMachineBuilder)super.onBlockEntityRegister(onBlockEntityRegister);
    }

    @Override
    public void generateLang(LangEventJS lang) {
        super.generateLang(lang);
        if (this.langValue() != null) {
            lang.add("gtceu", ((MultiblockMachineDefinition)this.value).getDescriptionId(), ((MultiblockMachineDefinition)this.value).getLangValue());
        }
    }

    @Override
    @HideFromJS
    public MultiblockMachineDefinition register() {
        MultiblockMachineDefinition definition = (MultiblockMachineDefinition)super.register();
        definition.setGenerator(this.generator);
        if (this.pattern == null) {
            throw new IllegalStateException("missing pattern while creating multiblock " + this.name);
        }
        definition.setPatternFactory(SupplierMemoizer.memoize(() -> this.pattern.apply(definition)));
        definition.setShapes(() -> this.shapeInfos.stream().map(factory -> (List)factory.apply(definition)).flatMap(Collection::stream).toList());
        definition.setAllowExtendedFacing(this.allowExtendedFacing);
        definition.setAllowFlip(this.allowFlip);
        if (!this.recoveryItems.isEmpty()) {
            definition.setRecoveryItems(() -> (ItemStack[])this.recoveryItems.stream().map(Supplier::get).flatMap(Arrays::stream).toArray(ItemStack[]::new));
        }
        definition.setPartSorter(this.partSorter);
        if (this.partAppearance == null) {
            this.partAppearance = (controller, part, side) -> definition.getAppearance().get();
        }
        definition.setPartAppearance(this.partAppearance);
        definition.setAdditionalDisplay(this.additionalDisplay);
        this.value = definition;
        return this.value;
    }

    @Generated
    public MultiblockMachineBuilder generator(boolean generator) {
        this.generator = generator;
        return this;
    }

    @Generated
    public MultiblockMachineBuilder pattern(Function<MultiblockMachineDefinition, BlockPattern> pattern) {
        this.pattern = pattern;
        return this;
    }

    @Generated
    public MultiblockMachineBuilder allowExtendedFacing(boolean allowExtendedFacing) {
        this.allowExtendedFacing = allowExtendedFacing;
        return this;
    }

    @Generated
    public MultiblockMachineBuilder allowFlip(boolean allowFlip) {
        this.allowFlip = allowFlip;
        return this;
    }

    @Generated
    public MultiblockMachineBuilder partSorter(Comparator<IMultiPart> partSorter) {
        this.partSorter = partSorter;
        return this;
    }

    @Generated
    public MultiblockMachineBuilder partAppearance(TriFunction<IMultiController, IMultiPart, Direction, BlockState> partAppearance) {
        this.partAppearance = partAppearance;
        return this;
    }

    @Generated
    public BiConsumer<IMultiController, List<Component>> additionalDisplay() {
        return this.additionalDisplay;
    }

    @Generated
    public MultiblockMachineBuilder additionalDisplay(BiConsumer<IMultiController, List<Component>> additionalDisplay) {
        this.additionalDisplay = additionalDisplay;
        return this;
    }
}

