/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.modifier;

import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ParallelLogic {
    public static int getParallelAmount(MetaMachine machine, GTRecipe recipe, int parallelLimit) {
        if (parallelLimit <= 1) {
            return parallelLimit;
        }
        if (!(machine instanceof IRecipeLogicMachine)) {
            return 1;
        }
        IRecipeLogicMachine rlm = (IRecipeLogicMachine)((Object)machine);
        int maxInputMultiplier = ParallelLogic.limitByInput(rlm, recipe, parallelLimit);
        if (maxInputMultiplier == 0) {
            return 0;
        }
        return ParallelLogic.limitByOutputMerging(rlm, recipe, maxInputMultiplier, rlm::canVoidRecipeOutputs);
    }

    public static int limitByInput(IRecipeCapabilityHolder holder, GTRecipe recipe, int parallelLimit) {
        int minimum = Integer.MAX_VALUE;
        for (RecipeCapability<?> cap : recipe.inputs.keySet()) {
            if (!cap.doMatchInRecipe()) continue;
            minimum = Math.min(minimum, cap.getMaxParallelRatio(holder, recipe, parallelLimit));
        }
        for (RecipeCapability<?> cap : recipe.tickInputs.keySet()) {
            if (!cap.doMatchInRecipe()) continue;
            minimum = Math.min(minimum, cap.getMaxParallelRatio(holder, recipe, parallelLimit));
        }
        if (minimum == Integer.MAX_VALUE) {
            return 0;
        }
        return minimum;
    }

    public static int limitByOutputMerging(IRecipeCapabilityHolder holder, GTRecipe recipe, int parallelLimit, Predicate<RecipeCapability<?>> canVoid) {
        int limit;
        int minimum = parallelLimit;
        for (RecipeCapability<?> cap : recipe.outputs.keySet()) {
            if (canVoid.test(cap) || !cap.doMatchInRecipe() || recipe.getOutputContents(cap).isEmpty()) continue;
            limit = cap.limitParallel(recipe, holder, parallelLimit);
            if (limit == 0) {
                return 0;
            }
            minimum = Math.min(minimum, limit);
        }
        for (RecipeCapability<?> cap : recipe.tickOutputs.keySet()) {
            if (canVoid.test(cap) || !cap.doMatchInRecipe() || recipe.getTickOutputContents(cap).isEmpty()) continue;
            limit = cap.limitParallel(recipe, holder, parallelLimit);
            if (limit == 0) {
                return 0;
            }
            minimum = Math.min(minimum, limit);
        }
        return minimum;
    }

    public static int[] adjustMultiplier(boolean mergedAll, int minMultiplier, int multiplier, int maxMultiplier) {
        if (mergedAll) {
            minMultiplier = multiplier;
            int remainder = (maxMultiplier - multiplier) % 2;
            multiplier = multiplier + remainder + (maxMultiplier - multiplier) / 2;
        } else {
            maxMultiplier = multiplier;
            multiplier = (multiplier + minMultiplier) / 2;
        }
        if (maxMultiplier - minMultiplier <= 1) {
            multiplier = maxMultiplier = minMultiplier;
        }
        return new int[]{minMultiplier, multiplier, maxMultiplier};
    }

    public static int getParallelAmountFast(MetaMachine machine, @NotNull GTRecipe recipe, int parallelLimit) {
        IRecipeCapabilityHolder holder;
        if (parallelLimit <= 1) {
            return parallelLimit;
        }
        if (machine instanceof IRecipeCapabilityHolder) {
            holder = (IRecipeCapabilityHolder)((Object)machine);
        } else {
            return 1;
        }
        while (parallelLimit > 0) {
            GTRecipe copied = recipe.copy(ContentModifier.multiplier(parallelLimit), false);
            if (copied.matchRecipe(holder).isSuccess() && copied.matchTickRecipe(holder).isSuccess()) {
                return parallelLimit;
            }
            parallelLimit /= 2;
        }
        return 1;
    }
}

