/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class IntProviderIngredient
extends Ingredient {
    public static final ResourceLocation TYPE = GTCEu.id("int_provider");
    protected final IntProvider countProvider;
    protected Integer sampledCount = null;
    protected final Ingredient inner;
    protected ItemStack[] itemStacks = null;
    public static final IIngredientSerializer<IntProviderIngredient> SERIALIZER = new IIngredientSerializer<IntProviderIngredient>(){

        @NotNull
        public IntProviderIngredient parse(FriendlyByteBuf buffer) {
            IntProvider amount = (IntProvider)IntProvider.f_146531_.parse((DynamicOps)NbtOps.f_128958_, (Object)buffer.m_130260_().m_128423_("provider")).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0));
            return new IntProviderIngredient(Ingredient.m_43940_((FriendlyByteBuf)buffer), amount);
        }

        @NotNull
        public IntProviderIngredient parse(JsonObject json) {
            IntProvider amount = (IntProvider)IntProvider.f_146531_.parse((DynamicOps)JsonOps.INSTANCE, (Object)json.get("count_provider")).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0));
            Ingredient inner = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
            return new IntProviderIngredient(inner, amount);
        }

        public void write(FriendlyByteBuf buffer, IntProviderIngredient ingredient) {
            CompoundTag wrapper = new CompoundTag();
            wrapper.m_128365_("provider", (Tag)IntProvider.f_146531_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)ingredient.countProvider).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0)));
            buffer.m_130079_(wrapper);
            ingredient.inner.m_43923_(buffer);
        }
    };

    public IntProviderIngredient(Ingredient inner, IntProvider countProvider) {
        super(Stream.empty());
        this.inner = inner;
        this.countProvider = countProvider;
    }

    public IntProviderIngredient(@NotNull TagKey<Item> tag, IntProvider amount) {
        this(Ingredient.m_204132_(tag), amount);
    }

    public static IntProviderIngredient create(Ingredient inner, IntProvider countProvider) {
        return new IntProviderIngredient(inner, countProvider);
    }

    public boolean test(@Nullable ItemStack stack) {
        return this.inner.test(stack);
    }

    public ItemStack @NotNull [] m_43908_() {
        if (this.itemStacks == null) {
            this.itemStacks = (ItemStack[])Arrays.stream(this.inner.m_43908_()).map(i -> i.m_255036_(this.getSampledCount(GTValues.RNG))).toArray(ItemStack[]::new);
        }
        return this.itemStacks;
    }

    public int getSampledCount(@NotNull RandomSource random) {
        if (this.sampledCount == null) {
            this.sampledCount = this.countProvider.m_214085_(random);
        }
        return this.sampledCount;
    }

    @NotNull
    public IntList m_43931_() {
        return this.inner.m_43931_();
    }

    public boolean m_43947_() {
        return this.inner.m_43947_();
    }

    @NotNull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    public static IntProviderIngredient fromJson(JsonObject json) {
        return (IntProviderIngredient)SERIALIZER.parse(json);
    }

    @NotNull
    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", TYPE.toString());
        json.add("count_provider", (JsonElement)IntProvider.f_146531_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.countProvider).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0)));
        json.add("ingredient", this.inner.m_43942_());
        return json;
    }

    @Generated
    public IntProvider getCountProvider() {
        return this.countProvider;
    }

    @Generated
    public void setSampledCount(Integer sampledCount) {
        this.sampledCount = sampledCount;
    }

    @Generated
    public Ingredient getInner() {
        return this.inner;
    }

    @Generated
    public void setItemStacks(ItemStack[] itemStacks) {
        this.itemStacks = itemStacks;
    }
}

