/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.feature.multiblock;

import com.gregtechceu.gtceu.api.capability.IParallelHatch;
import com.gregtechceu.gtceu.api.machine.feature.IInteractedMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineFeature;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.MultiblockState;
import com.gregtechceu.gtceu.client.renderer.MultiblockInWorldPreviewRenderer;
import com.gregtechceu.gtceu.config.ConfigHolder;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IMultiController
extends IMachineFeature,
IInteractedMachine {
    @Override
    default public MultiblockControllerMachine self() {
        return (MultiblockControllerMachine)this;
    }

    default public boolean checkPattern() {
        BlockPattern pattern = this.getPattern();
        return pattern != null && pattern.checkPatternAt(this.getMultiblockState(), false);
    }

    default public boolean checkPatternWithLock() {
        Lock lock = this.getPatternLock();
        lock.lock();
        try {
            boolean bl = this.checkPattern();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    default public boolean checkPatternWithTryLock() {
        Lock lock = this.getPatternLock();
        if (lock.tryLock()) {
            try {
                boolean bl = this.checkPattern();
                return bl;
            }
            finally {
                lock.unlock();
            }
        }
        return false;
    }

    default public BlockPattern getPattern() {
        return this.self().getDefinition().getPatternFactory().get();
    }

    public boolean isFormed();

    @NotNull
    public MultiblockState getMultiblockState();

    public void asyncCheckPattern(long var1);

    public void onStructureFormed();

    public void onStructureInvalid();

    public boolean hasFrontFacing();

    public List<IMultiPart> getParts();

    public Optional<IParallelHatch> getParallelHatch();

    public void onPartUnload();

    public Lock getPatternLock();

    default public boolean shouldAddPartToController(IMultiPart part) {
        return true;
    }

    @Nullable
    default public BlockState getPartAppearance(IMultiPart part, Direction side, BlockState sourceState, BlockPos sourcePos) {
        if (this.isFormed()) {
            return (BlockState)this.self().getDefinition().getPartAppearance().apply((Object)this, (Object)part, (Object)side);
        }
        return null;
    }

    @Override
    default public InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.self().isFormed() && player.m_6144_() && player.m_21120_(hand).m_41619_()) {
            if (world.m_5776_()) {
                MultiblockInWorldPreviewRenderer.showPreview(pos, this.self(), ConfigHolder.INSTANCE.client.inWorldPreviewDuration * 20);
            }
            return InteractionResult.SUCCESS;
        }
        return IInteractedMachine.super.onUse(state, world, pos, player, hand, hit);
    }
}

