/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.widget;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.gui.widget.PhantomFluidWidget;
import com.gregtechceu.gtceu.client.TooltipsHandler;
import com.gregtechceu.gtceu.integration.xei.entry.fluid.FluidEntryList;
import com.gregtechceu.gtceu.integration.xei.entry.fluid.FluidStackList;
import com.gregtechceu.gtceu.integration.xei.entry.fluid.FluidTagList;
import com.gregtechceu.gtceu.integration.xei.handlers.fluid.CycleFluidEntryHandler;
import com.gregtechceu.gtceu.integration.xei.handlers.fluid.CycleFluidStackHandler;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.ingredient.IRecipeIngredientSlot;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.util.TextFormattingUtil;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.jei.ClickableIngredient;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.jei.JEIPlugin;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.forge.FluidHelperImpl;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.api.forge.ForgeEmiStack;
import dev.emi.emi.api.stack.EmiIngredient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryStacks;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@LDLRegister(name="fluid_slot", group="widget.container", priority=50)
public class TankWidget
extends Widget
implements IRecipeIngredientSlot,
IConfigurableWidget {
    public static final ResourceBorderTexture FLUID_SLOT_TEXTURE = new ResourceBorderTexture("ldlib:textures/gui/fluid_slot.png", 18, 18, 1, 1);
    @Nullable
    protected IFluidHandler fluidTank;
    protected int tank;
    @Configurable(name="ldlib.gui.editor.name.showAmount")
    protected boolean showAmount;
    @Configurable(name="ldlib.gui.editor.name.allowClickFilled")
    protected boolean allowClickFilled;
    @Configurable(name="ldlib.gui.editor.name.allowClickDrained")
    protected boolean allowClickDrained;
    @Configurable(name="ldlib.gui.editor.name.drawHoverOverlay")
    public boolean drawHoverOverlay = true;
    @Configurable(name="ldlib.gui.editor.name.drawHoverTips")
    protected boolean drawHoverTips;
    @Configurable(name="ldlib.gui.editor.name.fillDirection")
    protected ProgressTexture.FillDirection fillDirection = ProgressTexture.FillDirection.ALWAYS_FULL;
    protected BiConsumer<TankWidget, List<Component>> onAddedTooltips;
    protected IngredientIO ingredientIO = IngredientIO.RENDER_ONLY;
    protected float XEIChance = 1.0f;
    protected net.minecraftforge.fluids.FluidStack lastFluidInTank;
    protected int lastTankCapacity;
    protected Runnable changeListener;
    @Nullable
    net.minecraftforge.fluids.FluidStack currentJEIRenderedIngredient = null;

    public TankWidget() {
        this(null, 0, 0, 18, 18, true, true);
    }

    public void initTemplate() {
        this.setBackground((IGuiTexture)FLUID_SLOT_TEXTURE);
        this.setFillDirection(ProgressTexture.FillDirection.DOWN_TO_UP);
    }

    public TankWidget(IFluidHandler fluidTank, int x, int y, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
        this(fluidTank, x, y, 18, 18, allowClickContainerFilling, allowClickContainerEmptying);
    }

    public TankWidget(@Nullable IFluidHandler fluidTank, int x, int y, int width, int height, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
        super(new Position(x, y), new Size(width, height));
        this.fluidTank = fluidTank;
        this.tank = 0;
        this.showAmount = true;
        this.allowClickFilled = allowClickContainerFilling;
        this.allowClickDrained = allowClickContainerEmptying;
        this.drawHoverTips = true;
    }

    public TankWidget(IFluidHandler fluidHandler, int tank, int x, int y, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
        this(fluidHandler, tank, x, y, 18, 18, allowClickContainerFilling, allowClickContainerEmptying);
    }

    public TankWidget(@Nullable IFluidHandler fluidHandler, int tank, int x, int y, int width, int height, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
        super(new Position(x, y), new Size(width, height));
        this.fluidTank = fluidHandler;
        this.tank = tank;
        this.showAmount = true;
        this.allowClickFilled = allowClickContainerFilling;
        this.allowClickDrained = allowClickContainerEmptying;
        this.drawHoverTips = true;
    }

    public TankWidget setFluidTank(IFluidHandler fluidTank) {
        this.fluidTank = fluidTank;
        this.tank = 0;
        if (this.isClientSideWidget) {
            this.setClientSideWidget();
        }
        return this;
    }

    public TankWidget setFluidTank(IFluidHandler fluidTank, int tank) {
        this.fluidTank = fluidTank;
        this.tank = tank;
        if (this.isClientSideWidget) {
            this.setClientSideWidget();
        }
        return this;
    }

    public TankWidget setClientSideWidget() {
        super.setClientSideWidget();
        this.lastFluidInTank = this.fluidTank != null ? this.fluidTank.getFluidInTank(this.tank).copy() : null;
        this.lastTankCapacity = this.fluidTank != null ? this.fluidTank.getTankCapacity(this.tank) : 0;
        return this;
    }

    public TankWidget setBackground(IGuiTexture background) {
        super.setBackground(new IGuiTexture[]{background});
        return this;
    }

    @Nullable
    public Object getXEIIngredientOverMouse(double mouseX, double mouseY) {
        if (this.self().isMouseOverElement(mouseX, mouseY)) {
            if (this.lastFluidInTank == null || this.lastFluidInTank.isEmpty()) {
                return null;
            }
            IFluidHandler iFluidHandler = this.fluidTank;
            if (iFluidHandler instanceof CycleFluidStackHandler) {
                CycleFluidStackHandler stackHandler = (CycleFluidStackHandler)iFluidHandler;
                return this.getXEIIngredientsClickable(stackHandler, this.tank).get(0);
            }
            iFluidHandler = this.fluidTank;
            if (iFluidHandler instanceof CycleFluidEntryHandler) {
                CycleFluidEntryHandler entryHandler = (CycleFluidEntryHandler)iFluidHandler;
                return this.getXEIIngredientsClickable(entryHandler, this.tank).get(0);
            }
            if (GTCEu.Mods.isJEILoaded()) {
                return JEICallWrapper.getJEIFluidClickable(this.lastFluidInTank, this.getPosition(), this.getSize());
            }
            if (GTCEu.Mods.isREILoaded()) {
                return EntryStacks.of((dev.architectury.fluid.FluidStack)REICallWrapper.toREIStack(this.lastFluidInTank));
            }
            if (GTCEu.Mods.isEMILoaded()) {
                return ForgeEmiStack.of((net.minecraftforge.fluids.FluidStack)this.lastFluidInTank).setChance(this.XEIChance);
            }
        }
        return null;
    }

    public List<Object> getXEIIngredients() {
        if (this.lastFluidInTank == null || this.lastFluidInTank.isEmpty()) {
            return Collections.emptyList();
        }
        IFluidHandler iFluidHandler = this.fluidTank;
        if (iFluidHandler instanceof CycleFluidStackHandler) {
            CycleFluidStackHandler stackHandler = (CycleFluidStackHandler)iFluidHandler;
            return this.getXEIIngredientsClickable(stackHandler, this.tank);
        }
        iFluidHandler = this.fluidTank;
        if (iFluidHandler instanceof CycleFluidEntryHandler) {
            CycleFluidEntryHandler entryHandler = (CycleFluidEntryHandler)iFluidHandler;
            return this.getXEIIngredientsClickable(entryHandler, this.tank);
        }
        if (GTCEu.Mods.isJEILoaded()) {
            return List.of(JEICallWrapper.getJEIFluidClickable(this.lastFluidInTank, this.getPosition(), this.getSize()));
        }
        if (GTCEu.Mods.isREILoaded()) {
            return List.of(EntryStacks.of((dev.architectury.fluid.FluidStack)REICallWrapper.toREIStack(this.lastFluidInTank)));
        }
        if (GTCEu.Mods.isEMILoaded()) {
            return List.of(ForgeEmiStack.of((net.minecraftforge.fluids.FluidStack)this.lastFluidInTank).setChance(this.XEIChance));
        }
        return List.of(this.lastFluidInTank);
    }

    private List<Object> getXEIIngredients(CycleFluidStackHandler handler, int index) {
        FluidStackList stackList = handler.getStackList(index);
        if (GTCEu.Mods.isJEILoaded()) {
            return JEICallWrapper.getJEIIngredients(stackList);
        }
        if (GTCEu.Mods.isREILoaded()) {
            return REICallWrapper.getREIIngredients(stackList);
        }
        if (GTCEu.Mods.isEMILoaded()) {
            return EMICallWrapper.getEMIIngredients(stackList, this.getXEIChance());
        }
        return Collections.emptyList();
    }

    private List<Object> getXEIIngredientsClickable(CycleFluidStackHandler handler, int index) {
        FluidStackList stackList = handler.getStackList(index);
        if (GTCEu.Mods.isJEILoaded()) {
            return JEICallWrapper.getJEIIngredientsClickable(stackList, this.getPosition(), this.getSize());
        }
        if (GTCEu.Mods.isREILoaded()) {
            return REICallWrapper.getREIIngredients(stackList);
        }
        if (GTCEu.Mods.isEMILoaded()) {
            return EMICallWrapper.getEMIIngredients(stackList, this.getXEIChance());
        }
        return Collections.emptyList();
    }

    private List<Object> getXEIIngredients(CycleFluidEntryHandler handler, int index) {
        FluidEntryList entryList = handler.getEntry(index);
        if (GTCEu.Mods.isJEILoaded()) {
            return JEICallWrapper.getJEIIngredients(entryList);
        }
        if (GTCEu.Mods.isREILoaded()) {
            return REICallWrapper.getREIIngredients(entryList);
        }
        if (GTCEu.Mods.isEMILoaded()) {
            return EMICallWrapper.getEMIIngredients(entryList, this.getXEIChance());
        }
        return Collections.emptyList();
    }

    private List<Object> getXEIIngredientsClickable(CycleFluidEntryHandler handler, int index) {
        FluidEntryList entryList = handler.getEntry(index);
        if (GTCEu.Mods.isJEILoaded()) {
            return JEICallWrapper.getJEIIngredientsClickable(entryList, this.getPosition(), this.getSize());
        }
        if (GTCEu.Mods.isREILoaded()) {
            return REICallWrapper.getREIIngredients(entryList);
        }
        if (GTCEu.Mods.isEMILoaded()) {
            return EMICallWrapper.getEMIIngredients(entryList, this.getXEIChance());
        }
        return Collections.emptyList();
    }

    public List<Component> getTooltipTexts() {
        List<Component> tooltips = this.getAdditionalTooltips(new ArrayList<Component>());
        tooltips.addAll(this.tooltipTexts);
        return tooltips;
    }

    public List<Component> getAdditionalTooltips(List<Component> list) {
        if (this.onAddedTooltips != null) {
            this.onAddedTooltips.accept(this, list);
        }
        return list;
    }

    public List<Component> getFullTooltipTexts() {
        net.minecraftforge.fluids.FluidStack stack;
        ArrayList<Component> tooltips = new ArrayList<Component>();
        boolean isPhantom = this instanceof PhantomFluidWidget;
        net.minecraftforge.fluids.FluidStack fluidStack = stack = this.currentJEIRenderedIngredient != null ? this.currentJEIRenderedIngredient : this.lastFluidInTank;
        if (stack != null && !stack.isEmpty()) {
            tooltips.add(stack.getDisplayName());
            if (!isPhantom && this.showAmount) {
                tooltips.add((Component)Component.m_237110_((String)"gtceu.fluid.amount", (Object[])new Object[]{stack.getAmount(), this.lastTankCapacity}));
            }
            TooltipsHandler.appendFluidTooltips(stack, tooltips::add, null);
        } else {
            tooltips.add((Component)Component.m_237115_((String)"gtceu.fluid.empty"));
            if (!isPhantom && this.showAmount) {
                tooltips.add((Component)Component.m_237110_((String)"gtceu.fluid.amount", (Object[])new Object[]{0, this.lastTankCapacity}).m_130946_(" mB"));
            }
        }
        tooltips.addAll(this.getTooltipTexts());
        return tooltips;
    }

    public void setCurrentJEIRenderedIngredient(Object ingredient) {
        net.minecraftforge.fluids.FluidStack f;
        this.currentJEIRenderedIngredient = GTCEu.Mods.isJEILoaded() ? (ingredient instanceof net.minecraftforge.fluids.FluidStack ? (f = (net.minecraftforge.fluids.FluidStack)ingredient) : null) : null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        net.minecraftforge.fluids.FluidStack renderedFluid;
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        if (this.isClientSideWidget && this.fluidTank != null) {
            net.minecraftforge.fluids.FluidStack fluidStack = this.fluidTank.getFluidInTank(this.tank);
            int capacity = this.fluidTank.getTankCapacity(this.tank);
            if (capacity != this.lastTankCapacity) {
                this.lastTankCapacity = capacity;
            }
            if (!fluidStack.isFluidEqual(this.lastFluidInTank)) {
                this.lastFluidInTank = fluidStack.copy();
            } else if (fluidStack.getAmount() != this.lastFluidInTank.getAmount()) {
                this.lastFluidInTank.setAmount(fluidStack.getAmount());
            }
        }
        Position pos = this.getPosition();
        Size size = this.getSize();
        net.minecraftforge.fluids.FluidStack fluidStack = renderedFluid = this.currentJEIRenderedIngredient != null ? this.currentJEIRenderedIngredient : this.lastFluidInTank;
        if (renderedFluid != null) {
            RenderSystem.disableBlend();
            if (!renderedFluid.isEmpty()) {
                double progress = (double)renderedFluid.getAmount() * 1.0 / (double)Math.max(Math.max(renderedFluid.getAmount(), this.lastTankCapacity), 1);
                float drawnU = (float)this.fillDirection.getDrawnU(progress);
                float drawnV = (float)this.fillDirection.getDrawnV(progress);
                float drawnWidth = (float)this.fillDirection.getDrawnWidth(progress);
                float drawnHeight = (float)this.fillDirection.getDrawnHeight(progress);
                int width = size.width - 2;
                int height = size.height - 2;
                int x = pos.x + 1;
                int y = pos.y + 1;
                DrawerHelper.drawFluidForGui((GuiGraphics)graphics, (FluidStack)FluidHelperImpl.toFluidStack((net.minecraftforge.fluids.FluidStack)renderedFluid), (long)renderedFluid.getAmount(), (int)((int)((float)x + drawnU * (float)width)), (int)((int)((float)y + drawnV * (float)height)), (int)((int)((float)width * drawnWidth)), (int)((int)((float)height * drawnHeight)));
            }
            if (this.showAmount && !renderedFluid.isEmpty()) {
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
                String s = TextFormattingUtil.formatLongToCompactStringBuckets((long)renderedFluid.getAmount(), (int)3) + "B";
                Font fontRenderer = Minecraft.m_91087_().f_91062_;
                graphics.m_280056_(fontRenderer, s, (int)(((float)pos.x + (float)size.width / 3.0f) * 2.0f - (float)fontRenderer.m_92895_(s) + 21.0f), (int)(((float)pos.y + (float)size.height / 3.0f + 6.0f) * 2.0f), 0xFFFFFF, true);
                graphics.m_280168_().m_85849_();
            }
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        this.drawOverlay(graphics, mouseX, mouseY, partialTicks);
        if (this.drawHoverOverlay && this.isMouseOverElement(mouseX, mouseY) && this.getHoverElement(mouseX, mouseY) == this) {
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            DrawerHelper.drawSolidRect((GuiGraphics)graphics, (int)(this.getPosition().x + 1), (int)(this.getPosition().y + 1), (int)(this.getSize().width - 2), (int)(this.getSize().height - 2), (int)-2130706433);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInForeground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.drawHoverTips && this.isMouseOverElement(mouseX, mouseY) && this.getHoverElement(mouseX, mouseY) == this) {
            if (this.gui != null) {
                this.gui.getModularUIGui().setHoverTooltip(this.getFullTooltipTexts(), ItemStack.f_41583_, null, null);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public void detectAndSendChanges() {
        if (this.fluidTank != null) {
            net.minecraftforge.fluids.FluidStack fluidStack = this.fluidTank.getFluidInTank(this.tank);
            int capacity = this.fluidTank.getTankCapacity(this.tank);
            if (capacity != this.lastTankCapacity) {
                this.lastTankCapacity = capacity;
                this.writeUpdateInfo(0, buffer -> buffer.m_130130_(this.lastTankCapacity));
            }
            if (!fluidStack.isFluidEqual(this.lastFluidInTank)) {
                this.lastFluidInTank = fluidStack.copy();
                CompoundTag tag = fluidStack.writeToNBT(new CompoundTag());
                this.writeUpdateInfo(2, buffer -> buffer.m_130079_(tag));
            } else if (fluidStack.getAmount() != this.lastFluidInTank.getAmount()) {
                this.lastFluidInTank.setAmount(fluidStack.getAmount());
                this.writeUpdateInfo(3, buffer -> buffer.m_130130_(this.lastFluidInTank.getAmount()));
            } else {
                super.detectAndSendChanges();
                return;
            }
            if (this.changeListener != null) {
                this.changeListener.run();
            }
        }
    }

    public void writeInitialData(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.fluidTank != null);
        if (this.fluidTank != null) {
            this.lastTankCapacity = this.fluidTank.getTankCapacity(this.tank);
            buffer.m_130130_(this.lastTankCapacity);
            net.minecraftforge.fluids.FluidStack fluidStack = this.fluidTank.getFluidInTank(this.tank);
            this.lastFluidInTank = fluidStack.copy();
            CompoundTag tag = fluidStack.writeToNBT(new CompoundTag());
            buffer.m_130079_(tag);
        }
    }

    public void readInitialData(FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            this.lastTankCapacity = buffer.m_130242_();
            this.readUpdateInfo(2, buffer);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
        if (id == 0) {
            this.lastTankCapacity = buffer.m_130242_();
        } else if (id == 1) {
            this.lastFluidInTank = null;
        } else if (id == 2) {
            this.lastFluidInTank = net.minecraftforge.fluids.FluidStack.loadFluidStackFromNBT((CompoundTag)buffer.m_130260_());
        } else if (id == 3 && this.lastFluidInTank != null) {
            this.lastFluidInTank.setAmount(buffer.m_130242_());
        } else if (id == 4) {
            ItemStack currentStack = this.gui.getModularUIContainer().m_142621_();
            int newStackSize = buffer.m_130242_();
            currentStack.m_41764_(newStackSize);
            this.gui.getModularUIContainer().m_142503_(currentStack);
        } else {
            super.readUpdateInfo(id, buffer);
            return;
        }
        if (this.changeListener != null) {
            this.changeListener.run();
        }
    }

    public void handleClientAction(int id, FriendlyByteBuf buffer) {
        boolean isShiftKeyDown;
        int clickResult;
        super.handleClientAction(id, buffer);
        if (id == 1 && (clickResult = this.tryClickContainer(isShiftKeyDown = buffer.readBoolean())) >= 0) {
            this.writeUpdateInfo(4, buf -> buf.m_130130_(clickResult));
        }
    }

    private int tryClickContainer(boolean isShiftKeyDown) {
        int i;
        if (this.fluidTank == null) {
            return -1;
        }
        Player player = this.gui.entityPlayer;
        ItemStack currentStack = this.gui.getModularUIContainer().m_142621_();
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)currentStack).resolve().orElse(null);
        if (handler == null) {
            return -1;
        }
        int maxAttempts = isShiftKeyDown ? currentStack.m_41613_() : 1;
        net.minecraftforge.fluids.FluidStack initialFluid = this.fluidTank.getFluidInTank(this.tank).copy();
        if (this.allowClickFilled && initialFluid.getAmount() > 0) {
            FluidActionResult result;
            boolean performedFill = false;
            ItemStack filledResult = ItemStack.f_41583_;
            for (i = 0; i < maxAttempts && (result = FluidUtil.tryFillContainer((ItemStack)currentStack, (IFluidHandler)this.fluidTank, (int)Integer.MAX_VALUE, null, (boolean)false)).isSuccess(); ++i) {
                ItemStack remainingStack = FluidUtil.tryFillContainer((ItemStack)currentStack, (IFluidHandler)this.fluidTank, (int)Integer.MAX_VALUE, null, (boolean)true).getResult();
                performedFill = true;
                currentStack.m_41774_(1);
                if (filledResult.m_41619_()) {
                    filledResult = remainingStack.m_41777_();
                    continue;
                }
                if (ItemStack.m_150942_((ItemStack)filledResult, (ItemStack)remainingStack)) {
                    if (filledResult.m_41613_() < filledResult.m_41741_()) {
                        filledResult.m_41769_(1);
                        continue;
                    }
                    player.m_150109_().m_150079_(remainingStack);
                    continue;
                }
                player.m_150109_().m_150079_(filledResult);
                filledResult = remainingStack.m_41777_();
            }
            if (performedFill) {
                SoundEvent soundevent = initialFluid.getFluid().getFluidType().getSound(initialFluid, SoundActions.BUCKET_FILL);
                if (soundevent == null) {
                    soundevent = SoundEvents.f_11781_;
                }
                player.m_9236_().m_6263_(null, player.m_20182_().f_82479_, player.m_20182_().f_82480_ + 0.5, player.m_20182_().f_82481_, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (currentStack.m_41619_()) {
                    this.gui.getModularUIContainer().m_142503_(filledResult);
                } else {
                    this.gui.getModularUIContainer().m_142503_(currentStack);
                    player.m_150109_().m_150079_(filledResult);
                }
                return this.gui.getModularUIContainer().m_142621_().m_41613_();
            }
        }
        if (this.allowClickDrained) {
            int remainingCapacity;
            FluidActionResult result;
            boolean performedEmptying = false;
            ItemStack drainedResult = ItemStack.f_41583_;
            for (i = 0; i < maxAttempts && (result = FluidUtil.tryEmptyContainer((ItemStack)currentStack, (IFluidHandler)this.fluidTank, (int)(remainingCapacity = this.fluidTank.getTankCapacity(this.tank) - this.fluidTank.getFluidInTank(this.tank).getAmount()), null, (boolean)false)).isSuccess(); ++i) {
                ItemStack remainingStack = FluidUtil.tryEmptyContainer((ItemStack)currentStack, (IFluidHandler)this.fluidTank, (int)remainingCapacity, null, (boolean)true).getResult();
                performedEmptying = true;
                currentStack.m_41774_(1);
                if (drainedResult.m_41619_()) {
                    drainedResult = remainingStack.m_41777_();
                    continue;
                }
                if (ItemStack.m_150942_((ItemStack)drainedResult, (ItemStack)remainingStack)) {
                    if (drainedResult.m_41613_() < drainedResult.m_41741_()) {
                        drainedResult.m_41769_(1);
                        continue;
                    }
                    player.m_150109_().m_150079_(remainingStack);
                    continue;
                }
                player.m_150109_().m_150079_(drainedResult);
                drainedResult = remainingStack.m_41777_();
            }
            net.minecraftforge.fluids.FluidStack filledFluid = this.fluidTank.getFluidInTank(this.tank);
            if (performedEmptying) {
                SoundEvent soundevent = filledFluid.getFluid().getFluidType().getSound(filledFluid, SoundActions.BUCKET_EMPTY);
                if (soundevent == null) {
                    soundevent = SoundEvents.f_11778_;
                }
                player.m_9236_().m_6263_(null, player.m_20182_().f_82479_, player.m_20182_().f_82480_ + 0.5, player.m_20182_().f_82481_, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (currentStack.m_41619_()) {
                    this.gui.getModularUIContainer().m_142503_(drainedResult);
                } else {
                    this.gui.getModularUIContainer().m_142503_(currentStack);
                    player.m_150109_().m_150079_(drainedResult);
                }
                return this.gui.getModularUIContainer().m_142621_().m_41613_();
            }
        }
        return -1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if ((this.allowClickDrained || this.allowClickFilled) && this.isMouseOverElement(mouseX, mouseY) && button == 0 && FluidUtil.getFluidHandler((ItemStack)this.gui.getModularUIContainer().m_142621_()).isPresent()) {
            boolean isShiftKeyDown = TankWidget.isShiftDown();
            this.writeClientAction(1, writer -> writer.writeBoolean(isShiftKeyDown));
            TankWidget.playButtonClickSound();
            return true;
        }
        return false;
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        FluidTank handler = new FluidTank(5000);
        handler.fill(new net.minecraftforge.fluids.FluidStack((Fluid)Fluids.f_76193_, 3000), IFluidHandler.FluidAction.EXECUTE);
        father.addConfigurators(new Configurator[]{new WrapperConfigurator("ldlib.gui.editor.group.preview", (Widget)new TankWidget(){

            public void updateScreen() {
                super.updateScreen();
                this.setHoverTooltips(TankWidget.this.tooltipTexts);
                this.backgroundTexture = TankWidget.this.backgroundTexture;
                this.hoverTexture = TankWidget.this.hoverTexture;
                this.showAmount = TankWidget.this.showAmount;
                this.drawHoverTips = TankWidget.this.drawHoverTips;
                this.fillDirection = TankWidget.this.fillDirection;
                this.overlay = TankWidget.this.overlay;
            }
        }.setAllowClickDrained(false).setAllowClickFilled(false).setFluidTank((IFluidHandler)handler))});
        super.buildConfigurator(father);
    }

    @Nullable
    @Generated
    public IFluidHandler getFluidTank() {
        return this.fluidTank;
    }

    @Generated
    public int getTank() {
        return this.tank;
    }

    @Generated
    public TankWidget setShowAmount(boolean showAmount) {
        this.showAmount = showAmount;
        return this;
    }

    @Generated
    public TankWidget setAllowClickFilled(boolean allowClickFilled) {
        this.allowClickFilled = allowClickFilled;
        return this;
    }

    @Generated
    public TankWidget setAllowClickDrained(boolean allowClickDrained) {
        this.allowClickDrained = allowClickDrained;
        return this;
    }

    @Generated
    public TankWidget setDrawHoverOverlay(boolean drawHoverOverlay) {
        this.drawHoverOverlay = drawHoverOverlay;
        return this;
    }

    @Generated
    public TankWidget setDrawHoverTips(boolean drawHoverTips) {
        this.drawHoverTips = drawHoverTips;
        return this;
    }

    @Generated
    public TankWidget setFillDirection(ProgressTexture.FillDirection fillDirection) {
        this.fillDirection = fillDirection;
        return this;
    }

    @Generated
    public TankWidget setOnAddedTooltips(BiConsumer<TankWidget, List<Component>> onAddedTooltips) {
        this.onAddedTooltips = onAddedTooltips;
        return this;
    }

    @Generated
    public TankWidget setIngredientIO(IngredientIO ingredientIO) {
        this.ingredientIO = ingredientIO;
        return this;
    }

    @Generated
    public IngredientIO getIngredientIO() {
        return this.ingredientIO;
    }

    @Generated
    public TankWidget setXEIChance(float XEIChance) {
        this.XEIChance = XEIChance;
        return this;
    }

    @Generated
    public float getXEIChance() {
        return this.XEIChance;
    }

    @Generated
    public TankWidget setChangeListener(Runnable changeListener) {
        this.changeListener = changeListener;
        return this;
    }

    public static final class JEICallWrapper {
        public static List<Object> getJEIIngredients(FluidEntryList list) {
            return list.getStacks().stream().filter(stack -> !stack.isEmpty()).map(JEICallWrapper::getJEIFluid).toList();
        }

        public static List<Object> getJEIIngredientsClickable(FluidEntryList list, Position pos, Size size) {
            return list.getStacks().stream().filter(stack -> !stack.isEmpty()).map(stack -> JEICallWrapper.getJEIFluidClickable(stack, pos, size)).toList();
        }

        public static Object getJEIFluid(net.minecraftforge.fluids.FluidStack fluidStack) {
            return JEICallWrapper._getJEIFluid(JEIPlugin.jeiHelpers.getPlatformFluidHelper(), fluidStack);
        }

        private static <T> Object _getJEIFluid(IPlatformFluidHelper<T> helper, net.minecraftforge.fluids.FluidStack fluidStack) {
            return helper.create(fluidStack.getFluid(), (long)fluidStack.getAmount(), fluidStack.getTag());
        }

        public static Object getJEIFluidClickable(net.minecraftforge.fluids.FluidStack fluidStack, Position pos, Size size) {
            return JEICallWrapper._getJEIFluidClickable(JEIPlugin.jeiHelpers.getPlatformFluidHelper(), fluidStack, pos, size);
        }

        private static <T> Object _getJEIFluidClickable(IPlatformFluidHelper<T> helper, net.minecraftforge.fluids.FluidStack fluidStack, Position pos, Size size) {
            Object ingredient = helper.create(fluidStack.getFluid(), (long)fluidStack.getAmount(), fluidStack.getTag());
            return JEIPlugin.jeiHelpers.getIngredientManager().createTypedIngredient(ingredient).map(typedIngredient -> new ClickableIngredient(typedIngredient, pos.x, pos.y, size.width, size.height)).orElse(null);
        }
    }

    public static final class REICallWrapper {
        public static dev.architectury.fluid.FluidStack toREIStack(net.minecraftforge.fluids.FluidStack stack) {
            return dev.architectury.fluid.FluidStack.create((Fluid)stack.getFluid(), (long)stack.getAmount(), (CompoundTag)stack.getTag());
        }

        private static EntryIngredient toREIIngredient(Stream<net.minecraftforge.fluids.FluidStack> stream) {
            return EntryIngredient.of(stream.map(REICallWrapper::toREIStack).map(EntryStacks::of).toList());
        }

        public static List<Object> getREIIngredients(FluidStackList list) {
            return List.of(REICallWrapper.toREIIngredient(list.stream()));
        }

        public static List<Object> getREIIngredients(FluidTagList list) {
            return list.getEntries().stream().map(FluidTagList.FluidTagEntry::stacks).map(REICallWrapper::toREIIngredient).collect(Collectors.toList());
        }

        public static List<Object> getREIIngredients(FluidEntryList list) {
            if (list instanceof FluidTagList) {
                FluidTagList tagList = (FluidTagList)list;
                return REICallWrapper.getREIIngredients(tagList);
            }
            if (list instanceof FluidStackList) {
                FluidStackList stackList = (FluidStackList)list;
                return REICallWrapper.getREIIngredients(stackList);
            }
            return Collections.emptyList();
        }
    }

    public static final class EMICallWrapper {
        private static EmiIngredient toEMIIngredient(Stream<net.minecraftforge.fluids.FluidStack> stream) {
            return EmiIngredient.of(stream.map(ForgeEmiStack::of).toList());
        }

        public static List<Object> getEMIIngredients(FluidStackList list, float xeiChance) {
            return List.of(EMICallWrapper.toEMIIngredient(list.stream()).setChance(xeiChance));
        }

        public static List<Object> getEMIIngredients(FluidTagList list, float xeiChance) {
            return list.getEntries().stream().map(FluidTagList.FluidTagEntry::stacks).map(stream -> EMICallWrapper.toEMIIngredient(stream).setChance(xeiChance)).collect(Collectors.toList());
        }

        public static List<Object> getEMIIngredients(FluidEntryList list, float xeiChance) {
            if (list instanceof FluidTagList) {
                FluidTagList tagList = (FluidTagList)list;
                return EMICallWrapper.getEMIIngredients(tagList, xeiChance);
            }
            if (list instanceof FluidStackList) {
                FluidStackList stackList = (FluidStackList)list;
                return EMICallWrapper.getEMIIngredients(stackList, xeiChance);
            }
            return Collections.emptyList();
        }
    }
}

