/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen.generator.veins;

import com.google.common.collect.Lists;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.generator.VeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.ores.OreBlockPlacer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BuddingAmethystBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.BulkSectionAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.GeodeCrackSettings;
import net.minecraft.world.level.levelgen.GeodeLayerSettings;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.GeodeFeature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

public class GeodeVeinGenerator
extends VeinGenerator {
    private static final Direction[] DIRECTIONS = Direction.values();
    public static final Codec<Double> CHANCE_RANGE = Codec.doubleRange((double)0.0, (double)1.0);
    public static final Codec<GeodeVeinGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GeodeBlockSettings.CODEC.fieldOf("blocks").forGetter(config -> config.geodeBlockSettings), (App)GeodeLayerSettings.f_158341_.fieldOf("layers").forGetter(config -> config.geodeLayerSettings), (App)GeodeCrackSettings.f_158324_.fieldOf("crack").forGetter(config -> config.geodeCrackSettings), (App)CHANCE_RANGE.fieldOf("use_potential_placements_chance").orElse((Object)0.35).forGetter(config -> config.usePotentialPlacementsChance), (App)CHANCE_RANGE.fieldOf("use_alternate_layer0_chance").orElse((Object)0.0).forGetter(config -> config.useAlternateLayer0Chance), (App)Codec.BOOL.fieldOf("placements_require_layer0_alternate").orElse((Object)true).forGetter(config -> config.placementsRequireLayer0Alternate), (App)IntProvider.m_146545_((int)1, (int)20).fieldOf("outer_wall_distance").orElse((Object)UniformInt.m_146622_((int)4, (int)5)).forGetter(config -> config.outerWallDistance), (App)IntProvider.m_146545_((int)1, (int)20).fieldOf("distribution_points").orElse((Object)UniformInt.m_146622_((int)3, (int)4)).forGetter(config -> config.distributionPoints), (App)IntProvider.m_146545_((int)0, (int)10).fieldOf("point_offset").orElse((Object)UniformInt.m_146622_((int)1, (int)2)).forGetter(config -> config.pointOffset), (App)Codec.INT.fieldOf("min_gen_offset").orElse((Object)-16).forGetter(config -> config.minGenOffset), (App)Codec.INT.fieldOf("max_gen_offset").orElse((Object)16).forGetter(config -> config.maxGenOffset), (App)CHANCE_RANGE.fieldOf("noise_multiplier").orElse((Object)0.05).forGetter(config -> config.noiseMultiplier), (App)Codec.INT.fieldOf("invalid_blocks_threshold").forGetter(config -> config.invalidBlocksThreshold)).apply((Applicative)instance, GeodeVeinGenerator::new));
    public GeodeBlockSettings geodeBlockSettings;
    public GeodeLayerSettings geodeLayerSettings;
    public GeodeCrackSettings geodeCrackSettings;
    public double usePotentialPlacementsChance = 0.5;
    public double useAlternateLayer0Chance = 0.0;
    public boolean placementsRequireLayer0Alternate = false;
    public IntProvider outerWallDistance = ConstantInt.m_146483_((int)0);
    public IntProvider distributionPoints = ConstantInt.m_146483_((int)0);
    public IntProvider pointOffset = ConstantInt.m_146483_((int)0);
    public int minGenOffset = 0;
    public int maxGenOffset = 0;
    public double noiseMultiplier = 1.0;
    public int invalidBlocksThreshold = 0;

    public GeodeVeinGenerator(GTOreDefinition entry) {
        super(entry);
    }

    @Override
    public List<Map.Entry<Either<BlockState, Material>, Integer>> getAllEntries() {
        LegacyRandomSource source = new LegacyRandomSource(0L);
        return List.of(Map.entry(this.geodeBlockSettings.fillingProvider.mapBoth(arg_0 -> GeodeVeinGenerator.lambda$getAllEntries$14((RandomSource)source, arg_0), Function.identity()), 1), Map.entry(this.geodeBlockSettings.innerLayerProvider.mapBoth(arg_0 -> GeodeVeinGenerator.lambda$getAllEntries$15((RandomSource)source, arg_0), Function.identity()), 1), Map.entry(this.geodeBlockSettings.alternateInnerLayerProvider.mapBoth(arg_0 -> GeodeVeinGenerator.lambda$getAllEntries$16((RandomSource)source, arg_0), Function.identity()), 1), Map.entry(this.geodeBlockSettings.middleLayerProvider.mapBoth(arg_0 -> GeodeVeinGenerator.lambda$getAllEntries$17((RandomSource)source, arg_0), Function.identity()), 1), Map.entry(this.geodeBlockSettings.outerLayerProvider.mapBoth(arg_0 -> GeodeVeinGenerator.lambda$getAllEntries$18((RandomSource)source, arg_0), Function.identity()), 1));
    }

    @Override
    public Map<BlockPos, OreBlockPlacer> generate(WorldGenLevel level, RandomSource random, GTOreDefinition entry, BlockPos origin) {
        BlockState blockState;
        int offset;
        int offset2;
        BulkSectionAccess access = new BulkSectionAccess((LevelAccessor)level);
        int minOffset = this.minGenOffset;
        int maxOffset = this.maxGenOffset;
        LinkedList points = Lists.newLinkedList();
        int distributionSample = this.distributionPoints.m_214085_(random);
        WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(level.m_7328_()));
        NormalNoise normalNoise = NormalNoise.m_230504_((RandomSource)worldgenRandom, (int)-4, (double[])new double[]{1.0});
        LinkedList list2 = Lists.newLinkedList();
        double wallDistance = (double)distributionSample / (double)this.outerWallDistance.m_142737_();
        double fillingSize = 1.0 / Math.sqrt(this.geodeLayerSettings.f_158342_);
        double innerSize = 1.0 / Math.sqrt(this.geodeLayerSettings.f_158343_ + wallDistance);
        double middleSize = 1.0 / Math.sqrt(this.geodeLayerSettings.f_158344_ + wallDistance);
        double outerSize = 1.0 / Math.sqrt(this.geodeLayerSettings.f_158345_ + wallDistance);
        double crackSize = 1.0 / Math.sqrt(this.geodeCrackSettings.f_158326_ + random.m_188500_() / 2.0 + (distributionSample > 3 ? wallDistance : 0.0));
        boolean doCrack = (double)random.m_188501_() < this.geodeCrackSettings.f_158325_;
        int invalidBlocksCount = 0;
        for (offset2 = 0; offset2 < distributionSample; ++offset2) {
            offset = this.outerWallDistance.m_214085_(random);
            BlockPos origin2 = origin.m_7918_(offset, this.outerWallDistance.m_214085_(random), this.outerWallDistance.m_214085_(random));
            blockState = access.m_156110_(origin2);
            if ((blockState.m_60795_() || blockState.m_204336_(BlockTags.f_144289_)) && ++invalidBlocksCount > this.invalidBlocksThreshold) {
                return Map.of();
            }
            points.add(Pair.of((Object)origin2, (Object)this.pointOffset.m_214085_(random)));
        }
        if (doCrack) {
            offset2 = random.m_188503_(4);
            offset = distributionSample * 2 + 1;
            if (offset2 == 0) {
                list2.add(origin.m_7918_(offset, 7, 0));
                list2.add(origin.m_7918_(offset, 5, 0));
                list2.add(origin.m_7918_(offset, 1, 0));
            } else if (offset2 == 1) {
                list2.add(origin.m_7918_(0, 7, offset));
                list2.add(origin.m_7918_(0, 5, offset));
                list2.add(origin.m_7918_(0, 1, offset));
            } else if (offset2 == 2) {
                list2.add(origin.m_7918_(offset, 7, offset));
                list2.add(origin.m_7918_(offset, 5, offset));
                list2.add(origin.m_7918_(offset, 1, offset));
            } else {
                list2.add(origin.m_7918_(0, 7, 0));
                list2.add(origin.m_7918_(0, 5, 0));
                list2.add(origin.m_7918_(0, 1, 0));
            }
        }
        ArrayList positions = Lists.newArrayList();
        Predicate placementPredicate = GeodeFeature.m_204735_(this.geodeBlockSettings.cannotReplace);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)origin.m_7918_(minOffset, minOffset, minOffset), (BlockPos)origin.m_7918_(maxOffset, maxOffset, maxOffset))) {
            LevelChunkSection section;
            double noiseValue = normalNoise.m_75380_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) * this.noiseMultiplier;
            double s = 0.0;
            double t = 0.0;
            for (Pair pair : points) {
                s += Mth.m_14193_((double)(pos.m_123331_((Vec3i)pair.getFirst()) + (double)((Integer)pair.getSecond()).intValue())) + noiseValue;
            }
            for (Direction[] origin4 : list2) {
                t += Mth.m_14193_((double)(pos.m_123331_((Vec3i)origin4) + (double)this.geodeCrackSettings.f_158327_)) + noiseValue;
            }
            if (s < outerSize || !level.m_180807_(pos) || (section = access.m_156104_(pos)) == null) continue;
            if (doCrack && t >= crackSize && s < fillingSize) {
                this.safeSetBlock(access, section, pos, Blocks.f_50016_.m_49966_(), placementPredicate);
                for (Direction direction : DIRECTIONS) {
                    BlockPos origin5 = pos.m_121945_(direction);
                    FluidState fluidState = level.m_6425_(origin5);
                    if (fluidState.m_76178_()) continue;
                    level.m_186469_(origin5, fluidState.m_76152_(), 0);
                }
                continue;
            }
            if (s >= fillingSize) {
                this.safeSetBlock(access, section, pos, this.getStateFromEither(this.geodeBlockSettings.fillingProvider, this.geodeBlockSettings, random, pos), placementPredicate);
                continue;
            }
            if (s >= innerSize) {
                boolean useAltLayer;
                boolean bl = useAltLayer = (double)random.m_188501_() < this.useAlternateLayer0Chance;
                if (useAltLayer) {
                    this.safeSetBlock(access, section, pos, this.getStateFromEither(this.geodeBlockSettings.alternateInnerLayerProvider, this.geodeBlockSettings, random, pos), placementPredicate);
                } else {
                    this.safeSetBlock(access, section, pos, this.getStateFromEither(this.geodeBlockSettings.innerLayerProvider, this.geodeBlockSettings, random, pos), placementPredicate);
                }
                if (this.placementsRequireLayer0Alternate && !useAltLayer || !((double)random.m_188501_() < this.usePotentialPlacementsChance)) continue;
                positions.add(pos.m_7949_());
                continue;
            }
            if (s >= middleSize) {
                this.safeSetBlock(access, section, pos, this.getStateFromEither(this.geodeBlockSettings.middleLayerProvider, this.geodeBlockSettings, random, pos), placementPredicate);
                continue;
            }
            if (!(s >= outerSize)) continue;
            this.safeSetBlock(access, section, pos, this.getStateFromEither(this.geodeBlockSettings.outerLayerProvider, this.geodeBlockSettings, random, pos), placementPredicate);
        }
        List<BlockState> innerPlacements = this.geodeBlockSettings.innerPlacements;
        block5: for (BlockPos origin2 : positions) {
            blockState = (BlockState)Util.m_214621_(innerPlacements, (RandomSource)random);
            for (Direction direction2 : DIRECTIONS) {
                LevelChunkSection section;
                if (blockState.m_61138_((Property)BlockStateProperties.f_61372_)) {
                    blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)direction2);
                }
                BlockPos origin6 = origin2.m_121945_(direction2);
                BlockState blockState2 = access.m_156110_(origin6);
                if (blockState.m_61138_((Property)BlockStateProperties.f_61362_)) {
                    blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(blockState2.m_60819_().m_76170_()));
                }
                if (!BuddingAmethystBlock.m_152734_((BlockState)blockState2) || !level.m_180807_(origin6) || (section = access.m_156104_(origin6)) == null) continue;
                this.safeSetBlock(access, section, origin6, blockState, placementPredicate);
                continue block5;
            }
        }
        access.close();
        return Map.of();
    }

    protected void safeSetBlock(BulkSectionAccess level, LevelChunkSection section, BlockPos pos, BlockState state, Predicate<BlockState> oldState) {
        if (oldState.test(level.m_156110_(pos))) {
            int x = SectionPos.m_123207_((int)pos.m_123341_());
            int y = SectionPos.m_123207_((int)pos.m_123342_());
            int z = SectionPos.m_123207_((int)pos.m_123343_());
            section.m_62991_(x, y, z, state, false);
        }
    }

    protected BlockState getStateFromEither(Either<BlockStateProvider, Material> either, GeodeBlockSettings settings, RandomSource random, BlockPos pos) {
        return (BlockState)either.map(provider -> provider.m_213972_(random, pos), material -> ChemicalHelper.getBlock(settings.providerMaterialPrefix, material).m_49966_());
    }

    @Override
    public VeinGenerator build() {
        return this;
    }

    @Override
    public VeinGenerator copy() {
        return new GeodeVeinGenerator(this.geodeBlockSettings, this.geodeLayerSettings, this.geodeCrackSettings, this.usePotentialPlacementsChance, this.useAlternateLayer0Chance, this.placementsRequireLayer0Alternate, this.outerWallDistance, this.distributionPoints, this.pointOffset, this.minGenOffset, this.maxGenOffset, this.noiseMultiplier, this.invalidBlocksThreshold);
    }

    @Override
    public Codec<? extends VeinGenerator> codec() {
        return CODEC;
    }

    @Generated
    public GeodeVeinGenerator(GeodeBlockSettings geodeBlockSettings, GeodeLayerSettings geodeLayerSettings, GeodeCrackSettings geodeCrackSettings, double usePotentialPlacementsChance, double useAlternateLayer0Chance, boolean placementsRequireLayer0Alternate, IntProvider outerWallDistance, IntProvider distributionPoints, IntProvider pointOffset, int minGenOffset, int maxGenOffset, double noiseMultiplier, int invalidBlocksThreshold) {
        this.geodeBlockSettings = geodeBlockSettings;
        this.geodeLayerSettings = geodeLayerSettings;
        this.geodeCrackSettings = geodeCrackSettings;
        this.usePotentialPlacementsChance = usePotentialPlacementsChance;
        this.useAlternateLayer0Chance = useAlternateLayer0Chance;
        this.placementsRequireLayer0Alternate = placementsRequireLayer0Alternate;
        this.outerWallDistance = outerWallDistance;
        this.distributionPoints = distributionPoints;
        this.pointOffset = pointOffset;
        this.minGenOffset = minGenOffset;
        this.maxGenOffset = maxGenOffset;
        this.noiseMultiplier = noiseMultiplier;
        this.invalidBlocksThreshold = invalidBlocksThreshold;
    }

    @Generated
    public GeodeVeinGenerator geodeBlockSettings(GeodeBlockSettings geodeBlockSettings) {
        this.geodeBlockSettings = geodeBlockSettings;
        return this;
    }

    @Generated
    public GeodeVeinGenerator geodeLayerSettings(GeodeLayerSettings geodeLayerSettings) {
        this.geodeLayerSettings = geodeLayerSettings;
        return this;
    }

    @Generated
    public GeodeVeinGenerator geodeCrackSettings(GeodeCrackSettings geodeCrackSettings) {
        this.geodeCrackSettings = geodeCrackSettings;
        return this;
    }

    @Generated
    public GeodeVeinGenerator usePotentialPlacementsChance(double usePotentialPlacementsChance) {
        this.usePotentialPlacementsChance = usePotentialPlacementsChance;
        return this;
    }

    @Generated
    public GeodeVeinGenerator useAlternateLayer0Chance(double useAlternateLayer0Chance) {
        this.useAlternateLayer0Chance = useAlternateLayer0Chance;
        return this;
    }

    @Generated
    public GeodeVeinGenerator placementsRequireLayer0Alternate(boolean placementsRequireLayer0Alternate) {
        this.placementsRequireLayer0Alternate = placementsRequireLayer0Alternate;
        return this;
    }

    @Generated
    public GeodeVeinGenerator outerWallDistance(IntProvider outerWallDistance) {
        this.outerWallDistance = outerWallDistance;
        return this;
    }

    @Generated
    public GeodeVeinGenerator distributionPoints(IntProvider distributionPoints) {
        this.distributionPoints = distributionPoints;
        return this;
    }

    @Generated
    public GeodeVeinGenerator pointOffset(IntProvider pointOffset) {
        this.pointOffset = pointOffset;
        return this;
    }

    @Generated
    public GeodeVeinGenerator minGenOffset(int minGenOffset) {
        this.minGenOffset = minGenOffset;
        return this;
    }

    @Generated
    public GeodeVeinGenerator maxGenOffset(int maxGenOffset) {
        this.maxGenOffset = maxGenOffset;
        return this;
    }

    @Generated
    public GeodeVeinGenerator noiseMultiplier(double noiseMultiplier) {
        this.noiseMultiplier = noiseMultiplier;
        return this;
    }

    @Generated
    public GeodeVeinGenerator invalidBlocksThreshold(int invalidBlocksThreshold) {
        this.invalidBlocksThreshold = invalidBlocksThreshold;
        return this;
    }

    private static /* synthetic */ BlockState lambda$getAllEntries$18(RandomSource source, BlockStateProvider provider) {
        return provider.m_213972_(source, BlockPos.f_121853_);
    }

    private static /* synthetic */ BlockState lambda$getAllEntries$17(RandomSource source, BlockStateProvider provider) {
        return provider.m_213972_(source, BlockPos.f_121853_);
    }

    private static /* synthetic */ BlockState lambda$getAllEntries$16(RandomSource source, BlockStateProvider provider) {
        return provider.m_213972_(source, BlockPos.f_121853_);
    }

    private static /* synthetic */ BlockState lambda$getAllEntries$15(RandomSource source, BlockStateProvider provider) {
        return provider.m_213972_(source, BlockPos.f_121853_);
    }

    private static /* synthetic */ BlockState lambda$getAllEntries$14(RandomSource source, BlockStateProvider provider) {
        return provider.m_213972_(source, BlockPos.f_121853_);
    }

    public record GeodeBlockSettings(Either<BlockStateProvider, Material> fillingProvider, Either<BlockStateProvider, Material> innerLayerProvider, Either<BlockStateProvider, Material> alternateInnerLayerProvider, Either<BlockStateProvider, Material> middleLayerProvider, Either<BlockStateProvider, Material> outerLayerProvider, List<BlockState> innerPlacements, TagKey<Block> cannotReplace, TagKey<Block> invalidBlocks, @Nullable TagPrefix providerMaterialPrefix) {
        public static final Codec<GeodeBlockSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either((Codec)BlockStateProvider.f_68747_, GTCEuAPI.materialManager.codec()).fieldOf("filling_provider").forGetter(config -> config.fillingProvider), (App)Codec.either((Codec)BlockStateProvider.f_68747_, GTCEuAPI.materialManager.codec()).fieldOf("inner_layer_provider").forGetter(config -> config.innerLayerProvider), (App)Codec.either((Codec)BlockStateProvider.f_68747_, GTCEuAPI.materialManager.codec()).fieldOf("alternate_inner_layer_provider").forGetter(config -> config.alternateInnerLayerProvider), (App)Codec.either((Codec)BlockStateProvider.f_68747_, GTCEuAPI.materialManager.codec()).fieldOf("middle_layer_provider").forGetter(config -> config.middleLayerProvider), (App)Codec.either((Codec)BlockStateProvider.f_68747_, GTCEuAPI.materialManager.codec()).fieldOf("outer_layer_provider").forGetter(config -> config.outerLayerProvider), (App)ExtraCodecs.m_144637_((Codec)BlockState.f_61039_.listOf()).fieldOf("inner_placements").forGetter(config -> config.innerPlacements), (App)TagKey.m_203886_((ResourceKey)Registries.f_256747_).fieldOf("cannot_replace").forGetter(config -> config.cannotReplace), (App)TagKey.m_203886_((ResourceKey)Registries.f_256747_).fieldOf("invalid_blocks").forGetter(config -> config.invalidBlocks), (App)TagPrefix.CODEC.optionalFieldOf("provider_material_prefix", (Object)TagPrefix.block).forGetter(config -> config.providerMaterialPrefix)).apply((Applicative)instance, GeodeBlockSettings::new));
    }
}

