/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.advancement.criterion;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.cyclops.integrateddynamics.api.advancement.criterion.ValuePredicate;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public class JsonDeserializers {
    private JsonDeserializers() {
    }

    @Nullable
    public static IPartType deserializePartType(JsonObject jsonObject) {
        JsonElement partTypeElement = jsonObject.get("parttype");
        IPartType partType = null;
        if (partTypeElement != null && !partTypeElement.isJsonNull() && (partType = PartTypes.REGISTRY.getPartType(new ResourceLocation(jsonObject.get("parttype").getAsString()))) == null) {
            throw new JsonSyntaxException("No part type found with name: " + jsonObject.get("parttype").getAsString());
        }
        return partType;
    }

    @Nullable
    public static IAspect deserializeAspect(JsonObject jsonObject) {
        JsonElement aspectElement = jsonObject.get("aspect");
        IAspect aspect = null;
        if (aspectElement != null && !aspectElement.isJsonNull() && (aspect = Aspects.REGISTRY.getAspect(new ResourceLocation(jsonObject.get("aspect").getAsString()))) == null) {
            throw new JsonSyntaxException("No aspect found with name: " + jsonObject.get("aspect").getAsString());
        }
        return aspect;
    }

    @Nullable
    public static IValueType deserializeValueType(JsonObject jsonobject) {
        JsonElement valueTypeElement = jsonobject.get("valuetype");
        IValueType valueType = null;
        if (valueTypeElement != null && !valueTypeElement.isJsonNull() && (valueType = ValueTypes.REGISTRY.getValueType(new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonobject, (String)"valuetype")))) == null) {
            throw new JsonSyntaxException("Unknown value type '" + GsonHelper.m_13906_((JsonObject)jsonobject, (String)"valuetype") + "', valid types are: " + String.valueOf(ValueTypes.REGISTRY.getValueTypes().stream().map(IValueType::getUniqueName).collect(Collectors.toList())));
        }
        return valueType;
    }

    @Nullable
    public static ValuePredicate deserializeValue(ValueDeseralizationContext valueDeseralizationContext, JsonObject jsonObject, @Nullable IValueType valueType) {
        return ValuePredicate.deserialize(valueDeseralizationContext, jsonObject, valueType);
    }
}

