/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.me.storage;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.core.AELog;
import appeng.core.definitions.AEItems;
import appeng.util.ConfigInventory;
import appeng.util.prioritylist.FuzzyPriorityList;
import appeng.util.prioritylist.IPartitionList;
import com.the9grounds.aeadditions.api.IAEAdditionsStorageCell;
import com.the9grounds.aeadditions.item.storage.StorageCell;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 d2\u00020\u0001:\u0001dB!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u00108\u001a\u00020\u0016H\u0016J,\u00109\u001a\u00020\f2\b\u0010:\u001a\u0004\u0018\u00010\u000b2\u0006\u0010;\u001a\u00020\f2\u0006\u0010<\u001a\u00020=2\b\u0010>\u001a\u0004\u0018\u00010?H\u0016J\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u00020\u001dH\u0016J\n\u0010E\u001a\u0004\u0018\u00010FH\u0016J\b\u0010G\u001a\u00020HH\u0016J\b\u0010I\u001a\u00020\fH\u0016J\n\u0010J\u001a\u0004\u0018\u00010KH\u0016J\b\u0010L\u001a\u00020MH\u0016J\u0006\u0010N\u001a\u00020\fJ\u0006\u0010O\u001a\u00020\fJ\n\u0010P\u001a\u0004\u0018\u00010QH\u0016J\b\u0010R\u001a\u00020\fH\u0016J\b\u0010S\u001a\u00020\fH\u0016J\n\u0010T\u001a\u0004\u0018\u000107H\u0016J\u0006\u0010U\u001a\u00020\fJ\b\u0010V\u001a\u00020\fH\u0016J\u0006\u0010W\u001a\u00020\u001dJ\n\u0010X\u001a\u0004\u0018\u00010YH\u0016J\u0006\u0010Z\u001a\u00020\fJ(\u0010[\u001a\u00020\f2\u0006\u0010:\u001a\u00020\u000b2\u0006\u0010;\u001a\u00020\f2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0002J.\u0010\\\u001a\u00020\f2\b\u0010:\u001a\u0004\u0018\u00010\u000b2\u0006\u0010;\u001a\u00020\f2\b\u0010<\u001a\u0004\u0018\u00010=2\b\u0010>\u001a\u0004\u0018\u00010?H\u0016J\u0006\u0010]\u001a\u00020\u0016J\u0010\u0010^\u001a\u00020\u00162\u0006\u0010_\u001a\u00020`H\u0002J\b\u0010a\u001a\u00020AH\u0002J\b\u0010b\u001a\u00020AH\u0016J\b\u0010c\u001a\u00020AH\u0014R*\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n8DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010*\u001a\u0004\u0018\u00010)2\b\u0010(\u001a\u0004\u0018\u00010)@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\"\u0010.\u001a\u0004\u0018\u00010-2\b\u0010(\u001a\u0004\u0018\u00010-@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u000e\u00101\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u00102\u001a\u0002038BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0010\u00106\u001a\u0004\u0018\u000107X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006e"}, d2={"Lcom/the9grounds/aeadditions/me/storage/AEAdditionsCellInventory;", "Lappeng/api/storage/cells/StorageCell;", "cellType", "Lcom/the9grounds/aeadditions/item/storage/StorageCell;", "itemStackLocal", "Lnet/minecraft/world/item/ItemStack;", "container", "Lappeng/api/storage/cells/ISaveProvider;", "(Lcom/the9grounds/aeadditions/item/storage/StorageCell;Lnet/minecraft/world/item/ItemStack;Lappeng/api/storage/cells/ISaveProvider;)V", "cellItems", "", "Lappeng/api/stacks/AEKey;", "", "getCellItems", "()Ljava/util/Map;", "setCellItems", "(Ljava/util/Map;)V", "getCellType", "()Lcom/the9grounds/aeadditions/item/storage/StorageCell;", "getContainer", "()Lappeng/api/storage/cells/ISaveProvider;", "hasVoidUpgrade", "", "isPersisted", "isPreformatted", "()Z", "getItemStackLocal", "()Lnet/minecraft/world/item/ItemStack;", "itemsPerByte", "", "getItemsPerByte", "()I", "setItemsPerByte", "(I)V", "keyType", "Lappeng/api/stacks/AEKeyType;", "getKeyType", "()Lappeng/api/stacks/AEKeyType;", "maxItemTypes", "maxItemsPerType", "<set-?>", "Lappeng/util/prioritylist/IPartitionList;", "partitionList", "getPartitionList", "()Lappeng/util/prioritylist/IPartitionList;", "Lappeng/api/config/IncludeExclude;", "partitionListMode", "getPartitionListMode", "()Lappeng/api/config/IncludeExclude;", "storedItemCount", "storedItems", "", "getStoredItems", "()S", "tagCompound", "Lnet/minecraft/nbt/CompoundTag;", "canHoldNewItem", "extract", "what", "amount", "mode", "Lappeng/api/config/Actionable;", "source", "Lappeng/api/networking/security/IActionSource;", "getAvailableStacks", "", "out", "Lappeng/api/stacks/KeyCounter;", "getBytesPerType", "getConfigInventory", "Lappeng/util/ConfigInventory;", "getDescription", "Lnet/minecraft/network/chat/Component;", "getFreeBytes", "getFuzzyMode", "Lappeng/api/config/FuzzyMode;", "getIdleDrain", "", "getRemainingItemCount", "getRemainingItemTypes", "getStatus", "Lappeng/api/storage/cells/CellState;", "getStoredItemCount", "getStoredItemTypes", "getTag", "getTotalBytes", "getTotalItemTypes", "getUnusedItemCount", "getUpgradesInventory", "Lappeng/api/upgrades/IUpgradeInventory;", "getUsedBytes", "innerInsert", "insert", "isFuzzy", "isStorageCell", "key", "Lappeng/api/stacks/AEItemKey;", "loadCellItems", "persist", "saveChanges", "Companion", "AEAdditions-1.20.1"})
public final class AEAdditionsCellInventory
implements appeng.api.storage.cells.StorageCell {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final StorageCell cellType;
    @NotNull
    private final ItemStack itemStackLocal;
    @Nullable
    private final ISaveProvider container;
    @Nullable
    private CompoundTag tagCompound;
    private int maxItemTypes;
    private short storedItems;
    private long storedItemCount;
    @Nullable
    private IPartitionList partitionList;
    @Nullable
    private IncludeExclude partitionListMode;
    private long maxItemsPerType;
    private boolean hasVoidUpgrade;
    @NotNull
    private final AEKeyType keyType;
    @Nullable
    private Map<AEKey, Long> cellItems;
    private int itemsPerByte;
    private boolean isPersisted;
    private static final int MAX_ITEM_TYPES = 300;
    @NotNull
    private static final String ITEM_TYPE_TAG = "it";
    @NotNull
    private static final String ITEM_COUNT_TAG = "ic";
    @NotNull
    private static final String ITEM_SLOT = "#";
    @NotNull
    private static final String ITEM_SLOT_COUNT = "@";
    @NotNull
    private static final String STACK_KEYS = "keys";
    @NotNull
    private static final String STACK_AMOUNTS = "amts";
    @NotNull
    private static final String[] ITEM_SLOT_KEYS = new String[MAX_ITEM_TYPES];
    @NotNull
    private static final String[] ITEM_SLOT_COUNT_KEYS = new String[MAX_ITEM_TYPES];

    public AEAdditionsCellInventory(@Nullable StorageCell cellType, @NotNull ItemStack itemStackLocal, @Nullable ISaveProvider container) {
        Intrinsics.checkNotNullParameter((Object)itemStackLocal, (String)"itemStackLocal");
        this.cellType = cellType;
        this.itemStackLocal = itemStackLocal;
        this.container = container;
        this.maxItemTypes = MAX_ITEM_TYPES;
        StorageCell storageCell = this.cellType;
        Intrinsics.checkNotNull((Object)storageCell);
        this.keyType = storageCell.getKeyType();
        this.isPersisted = true;
        AEKeyType aEKeyType = this.keyType;
        Intrinsics.checkNotNull((Object)aEKeyType);
        this.itemsPerByte = aEKeyType.getAmountPerByte();
        StorageCell storageCell2 = this.cellType;
        Intrinsics.checkNotNull((Object)storageCell2);
        this.maxItemTypes = storageCell2.getTotalTypes(this.itemStackLocal);
        if (this.maxItemTypes > MAX_ITEM_TYPES) {
            this.maxItemTypes = MAX_ITEM_TYPES;
        }
        if (this.maxItemTypes < 1) {
            this.maxItemTypes = 1;
        }
        CompoundTag compoundTag = this.tagCompound = this.itemStackLocal.m_41784_();
        Intrinsics.checkNotNull((Object)compoundTag);
        this.storedItems = compoundTag.m_128448_(ITEM_TYPE_TAG);
        CompoundTag compoundTag2 = this.tagCompound;
        Intrinsics.checkNotNull((Object)compoundTag2);
        this.storedItemCount = compoundTag2.m_128454_(ITEM_COUNT_TAG);
        this.cellItems = null;
        IPartitionList.Builder builder = IPartitionList.builder();
        IUpgradeInventory upgrades = this.getUpgradesInventory();
        ConfigInventory config = this.getConfigInventory();
        IUpgradeInventory iUpgradeInventory = upgrades;
        Intrinsics.checkNotNull((Object)iUpgradeInventory);
        boolean hasInverter = iUpgradeInventory.isInstalled((ItemLike)AEItems.INVERTER_CARD);
        boolean isFuzzy = upgrades.isInstalled((ItemLike)AEItems.FUZZY_CARD);
        if (isFuzzy) {
            builder.fuzzyMode(this.getFuzzyMode());
        }
        ConfigInventory configInventory = config;
        Intrinsics.checkNotNull((Object)configInventory);
        builder.addAll((Iterable)configInventory.keySet());
        this.partitionListMode = hasInverter ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST;
        this.partitionList = builder.build();
        if (upgrades.isInstalled((ItemLike)AEItems.EQUAL_DISTRIBUTION_CARD)) {
            long maxTypes = Integer.MAX_VALUE;
            if (!isFuzzy && this.partitionListMode == IncludeExclude.WHITELIST && !config.keySet().isEmpty()) {
                maxTypes = config.keySet().size();
            }
            maxTypes = Math.min(maxTypes, (long)this.maxItemTypes);
            long totalStorage = (this.getTotalBytes() - (long)this.getBytesPerType() * maxTypes) * (long)this.keyType.getAmountPerByte();
            this.maxItemsPerType = Math.max(0L, (totalStorage + maxTypes - 1L) / maxTypes);
        } else {
            this.maxItemsPerType = Long.MAX_VALUE;
        }
        this.hasVoidUpgrade = upgrades.isInstalled((ItemLike)AEItems.VOID_CARD);
    }

    @Nullable
    public final StorageCell getCellType() {
        return this.cellType;
    }

    @NotNull
    public final ItemStack getItemStackLocal() {
        return this.itemStackLocal;
    }

    @Nullable
    public final ISaveProvider getContainer() {
        return this.container;
    }

    private final short getStoredItems() {
        Map<AEKey, Long> map = this.getCellItems();
        return (short)(map != null ? map.size() : 0);
    }

    @Nullable
    public final IPartitionList getPartitionList() {
        return this.partitionList;
    }

    @Nullable
    public final IncludeExclude getPartitionListMode() {
        return this.partitionListMode;
    }

    @NotNull
    public final AEKeyType getKeyType() {
        return this.keyType;
    }

    @Nullable
    protected final Map<AEKey, Long> getCellItems() {
        if (this.cellItems == null) {
            this.cellItems = (Map)new Object2LongOpenHashMap();
            this.loadCellItems();
        }
        return this.cellItems;
    }

    protected final void setCellItems(@Nullable Map<AEKey, Long> map) {
        this.cellItems = map;
    }

    protected final int getItemsPerByte() {
        return this.itemsPerByte;
    }

    protected final void setItemsPerByte(int n) {
        this.itemsPerByte = n;
    }

    public void persist() {
        if (this.isPersisted) {
            return;
        }
        long itemCount = 0L;
        Map<AEKey, Long> map = this.getCellItems();
        Intrinsics.checkNotNull(map);
        LongArrayList amounts = new LongArrayList(map.size());
        ListTag keys = new ListTag();
        Map<AEKey, Long> map2 = this.getCellItems();
        Intrinsics.checkNotNull(map2);
        for (Map.Entry<AEKey, Long> entry : map2.entrySet()) {
            long amount = ((Number)entry.getValue()).longValue();
            if (amount <= 0L) continue;
            itemCount += amount;
            keys.add((Object)entry.getKey().toTagGeneric());
            amounts.add(amount);
        }
        if (keys.isEmpty()) {
            CompoundTag compoundTag = this.getTag();
            Intrinsics.checkNotNull((Object)compoundTag);
            compoundTag.m_128473_(STACK_KEYS);
            CompoundTag compoundTag2 = this.getTag();
            Intrinsics.checkNotNull((Object)compoundTag2);
            compoundTag2.m_128473_(STACK_AMOUNTS);
        } else {
            CompoundTag compoundTag = this.getTag();
            Intrinsics.checkNotNull((Object)compoundTag);
            compoundTag.m_128365_(STACK_KEYS, (Tag)keys);
            CompoundTag compoundTag3 = this.getTag();
            Intrinsics.checkNotNull((Object)compoundTag3);
            compoundTag3.m_128388_(STACK_AMOUNTS, amounts.toArray(new long[0]));
        }
        Map<AEKey, Long> map3 = this.getCellItems();
        Intrinsics.checkNotNull(map3);
        this.storedItems = (short)map3.size();
        this.storedItemCount = itemCount;
        if (itemCount == 0L) {
            CompoundTag compoundTag = this.getTag();
            Intrinsics.checkNotNull((Object)compoundTag);
            compoundTag.m_128473_(ITEM_COUNT_TAG);
        } else {
            CompoundTag compoundTag = this.getTag();
            Intrinsics.checkNotNull((Object)compoundTag);
            compoundTag.m_128356_(ITEM_COUNT_TAG, itemCount);
        }
        this.isPersisted = true;
    }

    @Nullable
    public CompoundTag getTag() {
        return this.itemStackLocal.m_41784_();
    }

    protected void saveChanges() {
        Map<AEKey, Long> map = this.getCellItems();
        Intrinsics.checkNotNull(map);
        this.storedItems = (short)map.size();
        this.storedItemCount = 0L;
        Map<AEKey, Long> map2 = this.getCellItems();
        Intrinsics.checkNotNull(map2);
        Iterator<Long> iterator = map2.values().iterator();
        while (iterator.hasNext()) {
            long storedAmount = ((Number)iterator.next()).longValue();
            this.storedItemCount += storedAmount;
        }
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    private final void loadCellItems() {
        boolean corruptedTag = false;
        CompoundTag compoundTag = this.getTag();
        Intrinsics.checkNotNull((Object)compoundTag);
        long[] amounts = compoundTag.m_128467_(STACK_AMOUNTS);
        CompoundTag compoundTag2 = this.getTag();
        Intrinsics.checkNotNull((Object)compoundTag2);
        ListTag tags = compoundTag2.m_128437_(STACK_KEYS, 10);
        if (amounts.length != tags.size()) {
            Object[] objectArray = new Object[]{amounts.length, tags.size()};
            AELog.warn((String)"Loading storage cell with mismatched amounts/tags: %d != %d", (Object[])objectArray);
        }
        int n = amounts.length;
        for (int i = 0; i < n; ++i) {
            long amount = amounts[i];
            AEKey key = AEKey.fromTagGeneric((CompoundTag)tags.m_128728_(i));
            if (amount <= 0L || key == null) {
                corruptedTag = true;
                continue;
            }
            Map<AEKey, Long> map = this.getCellItems();
            Intrinsics.checkNotNull(map);
            map.put(key, amount);
        }
        if (corruptedTag) {
            this.saveChanges();
        }
    }

    public void getAvailableStacks(@NotNull KeyCounter out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Map<AEKey, Long> map = this.getCellItems();
        Intrinsics.checkNotNull(map);
        for (Map.Entry<AEKey, Long> entry : map.entrySet()) {
            out.add(entry.getKey(), ((Number)entry.getValue()).longValue());
        }
    }

    public double getIdleDrain() {
        StorageCell storageCell = this.cellType;
        Intrinsics.checkNotNull((Object)storageCell);
        return storageCell.getIdleDrain();
    }

    @Nullable
    public FuzzyMode getFuzzyMode() {
        StorageCell storageCell = this.cellType;
        Intrinsics.checkNotNull((Object)storageCell);
        return storageCell.getFuzzyMode(this.itemStackLocal);
    }

    @Nullable
    public ConfigInventory getConfigInventory() {
        StorageCell storageCell = this.cellType;
        Intrinsics.checkNotNull((Object)storageCell);
        return storageCell.getConfigInventory(this.itemStackLocal);
    }

    @Nullable
    public IUpgradeInventory getUpgradesInventory() {
        StorageCell storageCell = this.cellType;
        Intrinsics.checkNotNull((Object)storageCell);
        return storageCell.getUpgrades(this.itemStackLocal);
    }

    public int getBytesPerType() {
        StorageCell storageCell = this.cellType;
        Intrinsics.checkNotNull((Object)storageCell);
        return storageCell.getBytesPerType(this.itemStackLocal);
    }

    public boolean canHoldNewItem() {
        long bytesFree = this.getFreeBytes();
        return (bytesFree > (long)this.getBytesPerType() || bytesFree == (long)this.getBytesPerType() && this.getUnusedItemCount() > 0) && this.getRemainingItemTypes() > 0L;
    }

    public final boolean isPreformatted() {
        IPartitionList iPartitionList = this.partitionList;
        Intrinsics.checkNotNull((Object)iPartitionList);
        return !iPartitionList.isEmpty();
    }

    public final long getTotalBytes() {
        StorageCell storageCell = this.cellType;
        Intrinsics.checkNotNull((Object)storageCell);
        return storageCell.getBytes(this.itemStackLocal);
    }

    public long getFreeBytes() {
        return this.getTotalBytes() - this.getUsedBytes();
    }

    public long getTotalItemTypes() {
        return this.maxItemTypes;
    }

    public long getStoredItemCount() {
        return this.storedItemCount;
    }

    public long getStoredItemTypes() {
        return this.getStoredItems();
    }

    public final long getRemainingItemTypes() {
        long baseOnTotal;
        long basedOnStorage = this.getFreeBytes() / (long)this.getBytesPerType();
        return basedOnStorage > (baseOnTotal = this.getTotalItemTypes() - this.getStoredItemTypes()) ? baseOnTotal : basedOnStorage;
    }

    public final long getUsedBytes() {
        long bytesForItemCount = (this.getStoredItemCount() + (long)this.getUnusedItemCount()) / (long)this.itemsPerByte;
        return this.getStoredItemTypes() * (long)this.getBytesPerType() + bytesForItemCount;
    }

    public final long getRemainingItemCount() {
        long remaining = this.getFreeBytes() * (long)this.itemsPerByte + (long)this.getUnusedItemCount();
        return remaining > 0L ? remaining : 0L;
    }

    public final int getUnusedItemCount() {
        int div = (int)(this.getStoredItemCount() % (long)8);
        return div == 0 ? 0 : this.itemsPerByte - div;
    }

    @Nullable
    public CellState getStatus() {
        if (this.getStoredItemTypes() == 0L) {
            return CellState.EMPTY;
        }
        if (this.canHoldNewItem()) {
            return CellState.NOT_EMPTY;
        }
        return this.getRemainingItemCount() > 0L ? CellState.TYPES_FULL : CellState.FULL;
    }

    private final boolean isStorageCell(AEItemKey key) {
        IAEAdditionsStorageCell type = AEAdditionsCellInventory.Companion.getStorageCell(key);
        return type != null && !type.storableInStorageCell();
    }

    public long insert(@Nullable AEKey what, long amount, @Nullable Actionable mode, @Nullable IActionSource source) {
        block6: {
            block5: {
                if (amount == 0L) break block5;
                AEKeyType aEKeyType = this.keyType;
                Intrinsics.checkNotNull((Object)aEKeyType);
                if (aEKeyType.contains(what)) break block6;
            }
            return 0L;
        }
        IPartitionList iPartitionList = this.partitionList;
        Intrinsics.checkNotNull((Object)iPartitionList);
        if (!iPartitionList.matchesFilter(what, this.partitionListMode)) {
            return 0L;
        }
        StorageCell storageCell = this.cellType;
        Intrinsics.checkNotNull((Object)storageCell);
        if (storageCell.isBlackListed(this.itemStackLocal, what)) {
            return 0L;
        }
        AEKey aEKey = what;
        Intrinsics.checkNotNull((Object)aEKey);
        Actionable actionable = mode;
        Intrinsics.checkNotNull((Object)actionable);
        IActionSource iActionSource = source;
        Intrinsics.checkNotNull((Object)iActionSource);
        long inserted = this.innerInsert(aEKey, amount, actionable, iActionSource);
        return this.hasVoidUpgrade ? amount : inserted;
    }

    private final long innerInsert(AEKey what, long amount, Actionable mode, IActionSource source) {
        long _amount;
        if (what instanceof AEItemKey && this.isStorageCell((AEItemKey)what)) {
            ItemStack itemStack = ((AEItemKey)what).toStack();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"what.toStack()");
            AEAdditionsCellInventory meInventory = Companion.createInventory(itemStack, null);
            if (!AEAdditionsCellInventory.Companion.isCellEmpty(meInventory)) {
                return 0L;
            }
        }
        Map<AEKey, Long> map = this.getCellItems();
        Intrinsics.checkNotNull(map);
        Long l = map.get(what);
        long currentAmount = l != null ? l : 0L;
        long remainingItemCount = this.getRemainingItemCount();
        if (currentAmount <= 0L) {
            if (!this.canHoldNewItem()) {
                return 0L;
            }
            long l2 = this.getBytesPerType();
            AEKeyType aEKeyType = this.keyType;
            Intrinsics.checkNotNull((Object)aEKeyType);
            if ((remainingItemCount -= l2 * (long)aEKeyType.getAmountPerByte()) <= 0L) {
                return 0L;
            }
        }
        if ((_amount = amount) > (remainingItemCount = Math.max(0L, Math.min(this.maxItemsPerType - currentAmount, remainingItemCount)))) {
            _amount = remainingItemCount;
        }
        if (mode == Actionable.MODULATE) {
            Map<AEKey, Long> map2 = this.getCellItems();
            Intrinsics.checkNotNull(map2);
            map2.put(what, currentAmount + _amount);
            this.saveChanges();
        }
        return amount;
    }

    public long extract(@Nullable AEKey what, long amount, @NotNull Actionable mode, @Nullable IActionSource source) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        long extractAmount = Math.min(Integer.MAX_VALUE, amount);
        Map<AEKey, Long> map = this.getCellItems();
        Intrinsics.checkNotNull(map);
        Long currentAmount = map.get(what);
        if (currentAmount != null && currentAmount > 0L) {
            if (extractAmount > currentAmount) {
                if (mode == Actionable.MODULATE) {
                    Map<AEKey, Long> map2 = this.getCellItems();
                    Intrinsics.checkNotNull(map2);
                    TypeIntrinsics.asMutableMap(map2).remove(what, currentAmount);
                    this.saveChanges();
                }
                return currentAmount;
            }
            if (mode == Actionable.MODULATE) {
                Map<AEKey, Long> map3 = this.getCellItems();
                Intrinsics.checkNotNull(map3);
                AEKey aEKey = what;
                Intrinsics.checkNotNull((Object)aEKey);
                map3.put(aEKey, currentAmount - extractAmount);
                this.saveChanges();
            }
            return extractAmount;
        }
        return 0L;
    }

    @NotNull
    public Component getDescription() {
        Component component = this.itemStackLocal.m_41786_();
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"itemStackLocal.hoverName");
        return component;
    }

    public final boolean isFuzzy() {
        return this.partitionList instanceof FuzzyPriorityList;
    }

    static {
        int n = MAX_ITEM_TYPES;
        for (int x = 0; x < n; ++x) {
            AEAdditionsCellInventory.ITEM_SLOT_KEYS[x] = ITEM_SLOT + x;
            AEAdditionsCellInventory.ITEM_SLOT_COUNT_KEYS[x] = ITEM_SLOT_COUNT + x;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0012\u0010\u001d\u001a\u00020\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0018\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/the9grounds/aeadditions/me/storage/AEAdditionsCellInventory$Companion;", "", "()V", "ITEM_COUNT_TAG", "", "ITEM_SLOT", "ITEM_SLOT_COUNT", "ITEM_SLOT_COUNT_KEYS", "", "[Ljava/lang/String;", "ITEM_SLOT_KEYS", "ITEM_TYPE_TAG", "MAX_ITEM_TYPES", "", "STACK_AMOUNTS", "STACK_KEYS", "createInventory", "Lcom/the9grounds/aeadditions/me/storage/AEAdditionsCellInventory;", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "container", "Lappeng/api/storage/cells/ISaveProvider;", "getStorageCell", "Lcom/the9grounds/aeadditions/api/IAEAdditionsStorageCell;", "itemKey", "Lappeng/api/stacks/AEItemKey;", "input", "isCell", "", "isCellEmpty", "cellInventory", "AEAdditions-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        private final IAEAdditionsStorageCell getStorageCell(ItemStack input) {
            if (input != null && input.m_41720_() instanceof StorageCell) {
                Item item2 = input.m_41720_();
                Intrinsics.checkNotNull((Object)item2, (String)"null cannot be cast to non-null type com.the9grounds.aeadditions.item.storage.StorageCell");
                return (StorageCell)item2;
            }
            return null;
        }

        private final IAEAdditionsStorageCell getStorageCell(AEItemKey itemKey) {
            if (itemKey.getItem() instanceof StorageCell) {
                Item item2 = itemKey.getItem();
                Intrinsics.checkNotNull((Object)item2, (String)"null cannot be cast to non-null type com.the9grounds.aeadditions.item.storage.StorageCell");
                return (StorageCell)item2;
            }
            return null;
        }

        private final boolean isCellEmpty(AEAdditionsCellInventory cellInventory) {
            if (cellInventory == null) {
                return true;
            }
            return cellInventory.getAvailableStacks().isEmpty();
        }

        public final boolean isCell(@Nullable ItemStack itemStack) {
            return this.getStorageCell(itemStack) != null;
        }

        @Nullable
        public final AEAdditionsCellInventory createInventory(@NotNull ItemStack itemStack, @Nullable ISaveProvider container) {
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            Item item2 = itemStack.m_41720_();
            if (!(item2 instanceof StorageCell)) {
                return null;
            }
            if (!((StorageCell)item2).isStorageCell(itemStack)) {
                return null;
            }
            return new AEAdditionsCellInventory((StorageCell)item2, itemStack, container);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

