/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.hollingsworth.arsnouveau.api.recipe.DispelEntityRecipe;
import com.hollingsworth.arsnouveau.common.datagen.SimpleDataProvider;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;

public class DispelEntityProvider
extends SimpleDataProvider {
    public List<DispelEntityRecipe> recipes = new ArrayList<DispelEntityRecipe>();

    public DispelEntityProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    @Override
    public void collectJsons(CachedOutput pOutput) {
        this.addEntries();
        for (DispelEntityRecipe recipe : this.recipes) {
            Path path = DispelEntityProvider.getRecipePath(this.output, recipe.m_6423_().m_135815_());
            this.saveStable(pOutput, recipe.asRecipe(), path);
        }
    }

    protected void addEntries() {
        this.recipes.add(new DispelEntityRecipe(new ResourceLocation("ars_nouveau", "blaze_powder"), EntityType.f_20551_, EntityType.f_20551_.m_20677_(), new LootItemCondition[]{LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36642_(EntityFlagsPredicate.Builder.m_33713_().m_33714_(Boolean.valueOf(true)).m_33716_())).m_6409_()}));
    }

    protected static Path getRecipePath(Path path, String id) {
        return path.resolve("data/ars_nouveau/recipes/dispel_entity/" + id + ".json");
    }

    public String m_6055_() {
        return "Dispel Entity Datagen";
    }
}

