/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.ShulkerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.LockRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.StorageRenderer;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

@OnlyIn(value=Dist.CLIENT)
public class ShulkerBoxRenderer
extends StorageRenderer<ShulkerBoxBlockEntity> {
    private static final String ENTITY_SHULKER_BOX_FOLDER = "entity/shulker_box/";
    public static final Material BASE_TIER_MATERIAL = new Material(Sheets.f_110735_, SophisticatedStorage.getRL("entity/shulker_box/base_tier"));
    public static final Material COPPER_TIER_MATERIAL = new Material(Sheets.f_110735_, SophisticatedStorage.getRL("entity/shulker_box/copper_tier"));
    public static final Material IRON_TIER_MATERIAL = new Material(Sheets.f_110735_, SophisticatedStorage.getRL("entity/shulker_box/iron_tier"));
    public static final Material GOLD_TIER_MATERIAL = new Material(Sheets.f_110735_, SophisticatedStorage.getRL("entity/shulker_box/gold_tier"));
    public static final Material DIAMOND_TIER_MATERIAL = new Material(Sheets.f_110735_, SophisticatedStorage.getRL("entity/shulker_box/diamond_tier"));
    public static final Material NETHERITE_TIER_MATERIAL = new Material(Sheets.f_110735_, SophisticatedStorage.getRL("entity/shulker_box/netherite_tier"));
    public static final Material TINTABLE_MAIN_MATERIAL = new Material(Sheets.f_110735_, SophisticatedStorage.getRL("entity/shulker_box/tintable_main"));
    public static final Material TINTABLE_ACCENT_MATERIAL = new Material(Sheets.f_110735_, SophisticatedStorage.getRL("entity/shulker_box/tintable_accent"));
    public static final Material NO_TINT_MATERIAL = new Material(Sheets.f_110735_, SophisticatedStorage.getRL("entity/shulker_box/no_tint"));
    private final ShulkerModel<?> model;
    private final DisplayItemRenderer displayItemRenderer = new DisplayItemRenderer(0.5, new Vec3(0.0, 0.0, -0.0075));

    public ShulkerBoxRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new ShulkerModel(context.m_173582_(ModelLayers.f_171180_));
    }

    public void render(ShulkerBoxBlockEntity shulkerBoxEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        VertexConsumer vertexconsumer;
        BlockState blockstate;
        BlockState blockState = shulkerBoxEntity.m_58900_();
        Direction direction = Direction.UP;
        if (shulkerBoxEntity.m_58898_() && (blockstate = shulkerBoxEntity.m_58904_().m_8055_(shulkerBoxEntity.m_58899_())).m_60734_() instanceof ShulkerBoxBlock) {
            direction = (Direction)blockstate.m_61143_(ShulkerBoxBlock.FACING);
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_85841_(0.9995f, 0.9995f, 0.9995f);
        poseStack.m_252781_(direction.m_253075_());
        poseStack.m_85841_(1.0f, -1.0f, -1.0f);
        poseStack.m_85837_(0.0, -1.0, 0.0);
        ModelPart lidPart = this.model.m_103742_();
        float lidProgress = shulkerBoxEntity.getProgress(partialTick);
        lidPart.m_104227_(0.0f, 24.0f - lidProgress * 0.5f * 16.0f, 0.0f);
        lidPart.f_104204_ = 270.0f * lidProgress * ((float)Math.PI / 180);
        int mainColor = shulkerBoxEntity.getStorageWrapper().getMainColor();
        int accentColor = shulkerBoxEntity.getStorageWrapper().getAccentColor();
        if (mainColor == -1 || accentColor == -1) {
            vertexconsumer = NO_TINT_MATERIAL.m_119194_(bufferSource, RenderType::m_110458_);
            this.model.m_7695_(poseStack, vertexconsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (mainColor > -1) {
            this.renderTintedModel(poseStack, bufferSource, packedLight, packedOverlay, mainColor, TINTABLE_MAIN_MATERIAL);
        }
        if (accentColor > -1) {
            this.renderTintedModel(poseStack, bufferSource, packedLight, packedOverlay, accentColor, TINTABLE_ACCENT_MATERIAL);
        }
        if (shulkerBoxEntity.shouldShowTier()) {
            vertexconsumer = this.getTierMaterial(blockState.m_60734_()).m_119194_(bufferSource, RenderType::m_110458_);
            this.model.m_7695_(poseStack, vertexconsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        } else if (this.holdsItemThatShowsHiddenTiers()) {
            TextureAtlasSprite sprite = this.getTierMaterial(blockState.m_60734_()).m_119204_();
            VertexConsumer vertexconsumer2 = sprite.m_118381_(bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)sprite.m_247685_())));
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, -0.01, 0.0);
            poseStack.m_85841_(1.01f, 1.01f, 1.01f);
            this.model.m_7695_(poseStack, vertexconsumer2, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 0.5f);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_252781_(DisplayItemRenderer.getNorthBasedRotation(direction));
        float zOffset = 0.0f;
        if (lidProgress > 0.0f) {
            zOffset = lidProgress * 0.5f;
            poseStack.m_252781_(Axis.f_252403_.m_252977_(270.0f * lidProgress));
        }
        poseStack.m_85837_(-0.5, -0.5, -0.5 - (double)zOffset);
        if (shulkerBoxEntity.shouldShowUpgrades() || this.holdsItemThatShowsUpgrades()) {
            this.displayItemRenderer.renderUpgradeItems(shulkerBoxEntity, poseStack, bufferSource, packedLight, packedOverlay, this.holdsItemThatShowsUpgrades(), this.shouldShowDisabledUpgradesDisplay(shulkerBoxEntity));
        }
        this.displayItemRenderer.renderDisplayItem(shulkerBoxEntity, poseStack, bufferSource, packedLight, packedOverlay);
        LockRenderer.renderLock(shulkerBoxEntity, poseStack, bufferSource, packedLight, packedOverlay, 0.9375f, this::holdsToolInToggleLockOrLockDisplay);
        poseStack.m_85849_();
    }

    private Material getTierMaterial(Block block) {
        if (block == ModBlocks.COPPER_SHULKER_BOX.get()) {
            return COPPER_TIER_MATERIAL;
        }
        if (block == ModBlocks.IRON_SHULKER_BOX.get()) {
            return IRON_TIER_MATERIAL;
        }
        if (block == ModBlocks.GOLD_SHULKER_BOX.get()) {
            return GOLD_TIER_MATERIAL;
        }
        if (block == ModBlocks.DIAMOND_SHULKER_BOX.get()) {
            return DIAMOND_TIER_MATERIAL;
        }
        if (block == ModBlocks.NETHERITE_SHULKER_BOX.get()) {
            return NETHERITE_TIER_MATERIAL;
        }
        return BASE_TIER_MATERIAL;
    }

    private void renderTintedModel(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, int mainColor, Material material) {
        float tintRed = (float)(mainColor >> 16 & 0xFF) / 255.0f;
        float tingGreen = (float)(mainColor >> 8 & 0xFF) / 255.0f;
        float tintBlue = (float)(mainColor & 0xFF) / 255.0f;
        VertexConsumer vertexconsumer = material.m_119194_(bufferSource, RenderType::m_110458_);
        this.model.m_7695_(poseStack, vertexconsumer, packedLight, packedOverlay, tintRed, tingGreen, tintBlue, 1.0f);
    }
}

