/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.p3pp3rf1y.sophisticatedcore.controller.ControllerBlockEntityBase;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllerBoundable;
import net.p3pp3rf1y.sophisticatedcore.controller.ILinkable;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ControllerBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class StorageIOBlockEntity
extends BlockEntity
implements IControllerBoundable,
ILinkable {
    @Nullable
    private BlockPos controllerPos = null;
    private boolean isLinkedToController = false;
    private boolean chunkBeingUnloaded = false;
    private Map<Capability<?>, Map<Direction, LazyOptional<?>>> capabilitySideCache = new HashMap();

    protected StorageIOBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public StorageIOBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlocks.STORAGE_IO_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    public Set<BlockPos> getConnectablePositions() {
        return Collections.emptySet();
    }

    public boolean connectLinkedSelf() {
        return true;
    }

    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
        this.invalidateAllCapabilityCache();
        this.m_6596_();
    }

    public Optional<BlockPos> getControllerPos() {
        return Optional.ofNullable(this.controllerPos);
    }

    public boolean isLinked() {
        return this.isLinkedToController && this.getControllerPos().isPresent();
    }

    public void linkToController(BlockPos controllerPos) {
        if (this.getControllerPos().isPresent()) {
            return;
        }
        this.isLinkedToController = true;
        super.linkToController(controllerPos);
        this.m_6596_();
    }

    public void setNotLinked() {
        super.setNotLinked();
        this.isLinkedToController = false;
        this.removeControllerPos();
        this.m_6596_();
    }

    public void removeControllerPos() {
        this.controllerPos = null;
        this.invalidateAllCapabilityCache();
        this.capabilitySideCache.clear();
        this.m_6596_();
    }

    private void invalidateAllCapabilityCache() {
        this.capabilitySideCache.forEach((cap, map) -> {
            HashMap<Direction, LazyOptional> copy = new HashMap<Direction, LazyOptional>((Map<Direction, LazyOptional>)map);
            copy.forEach((side, lazyOptional) -> lazyOptional.invalidate());
        });
        this.capabilitySideCache.clear();
    }

    public BlockPos getStorageBlockPos() {
        return this.m_58899_();
    }

    public Level getStorageBlockLevel() {
        return this.m_58904_();
    }

    public boolean canConnectStorages() {
        return false;
    }

    public void addToController(Level level, BlockPos pos, BlockPos controllerPos) {
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)controllerPos, ControllerBlockEntityBase.class).ifPresent(c -> c.addStorage(pos));
    }

    public boolean canBeConnected() {
        return this.isLinked() || this.getControllerPos().isEmpty();
    }

    public void registerController(ControllerBlockEntityBase controllerBlockEntity) {
        this.setControllerPos(controllerBlockEntity.m_58899_());
    }

    public void unregisterController() {
        this.removeControllerPos();
    }

    public void removeFromController() {
        if (!this.f_58857_.m_5776_()) {
            this.getControllerPos().flatMap(p -> WorldHelper.getBlockEntity((BlockGetter)this.f_58857_, (BlockPos)p, ControllerBlockEntityBase.class)).ifPresent(c -> c.removeNonConnectingBlock(this.m_58899_()));
            this.removeControllerPos();
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.saveControllerPos(tag);
        if (this.isLinkedToController) {
            tag.m_128379_("isLinkedToController", this.isLinkedToController);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.loadControllerPos(tag);
        this.isLinkedToController = NBTHelper.getBoolean((CompoundTag)tag, (String)"isLinkedToController").orElse(false);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (this.getControllerPos().isEmpty()) {
            return super.getCapability(cap, side);
        }
        if (!this.capabilitySideCache.containsKey(cap) || !this.capabilitySideCache.get(cap).containsKey(side)) {
            LazyOptional lazyOptional = this.getControllerPos().flatMap(p -> WorldHelper.getLoadedBlockEntity((Level)this.m_58904_(), (BlockPos)p, ControllerBlockEntity.class)).map(c -> this.getControllerCapability(cap, side, (ControllerBlockEntity)c)).orElseGet(() -> super.getCapability(cap, side));
            this.capabilitySideCache.computeIfAbsent(cap, k -> new HashMap()).put(side, lazyOptional);
        }
        return this.capabilitySideCache.get(cap).get(side).cast();
    }

    private <T> void removeCapabilityCacheOnSide(Capability<T> cap, @Nullable Direction side) {
        if (this.capabilitySideCache.containsKey(cap) && this.capabilitySideCache.get(cap).containsKey(side)) {
            this.capabilitySideCache.get(cap).get(side).invalidate();
            this.capabilitySideCache.get(cap).remove(side);
        }
    }

    protected <T> LazyOptional<T> getControllerCapability(Capability<T> cap, @Nullable Direction side, ControllerBlockEntity c) {
        LazyOptional controllerCap = c.getCapability(cap, this.getAdjustedCapabilitySide(cap, side));
        return controllerCap.map(capability -> {
            controllerCap.addListener(l -> this.removeCapabilityCacheOnSide(cap, side));
            return LazyOptional.of(() -> this.wrapCapability(cap, capability));
        }).orElseGet(LazyOptional::empty);
    }

    @Nullable
    protected <T> Direction getAdjustedCapabilitySide(Capability<T> cap, @Nullable Direction side) {
        return side;
    }

    protected <T> T wrapCapability(Capability<T> cap, T capability) {
        return capability;
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.chunkBeingUnloaded = true;
    }

    public void m_7651_() {
        if (!this.chunkBeingUnloaded && this.f_58857_ != null) {
            this.unlinkFromController();
        }
        super.m_7651_();
    }
}

