/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.api.ApiConst;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreArmor;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.gear.trait.SimpleTrait;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.util.TimeUtils;
import net.silentchaos512.utils.EnumUtils;

public class WielderEffectTrait
extends SimpleTrait {
    public static final ITraitSerializer<WielderEffectTrait> SERIALIZER = new SimpleTrait.Serializer<WielderEffectTrait>(ApiConst.WIELDER_EFFECT_TRAIT_ID, WielderEffectTrait::new, WielderEffectTrait::deserializeJson, WielderEffectTrait::readFromNetwork, WielderEffectTrait::writeToNetwork);
    private final Map<String, List<PotionData>> potions = new HashMap<String, List<PotionData>>();

    private WielderEffectTrait(ResourceLocation id) {
        this(id, (ITraitSerializer<? extends WielderEffectTrait>)SERIALIZER);
    }

    protected WielderEffectTrait(ResourceLocation id, ITraitSerializer<? extends WielderEffectTrait> serializer) {
        super(id, serializer);
    }

    @Override
    public void onUpdate(TraitActionContext context, boolean isEquipped) {
        if (!isEquipped || context.getPlayer() == null || context.getPlayer().f_19797_ % 10 != 0) {
            return;
        }
        GearType gearType = ((ICoreItem)context.getGear().m_41720_()).getGearType();
        for (Map.Entry<String, List<PotionData>> entry : this.potions.entrySet()) {
            String type = entry.getKey();
            List<PotionData> list = entry.getValue();
            this.applyEffects(context, gearType, type, list);
        }
    }

    private void applyEffects(TraitActionContext context, GearType gearType, String type, Iterable<PotionData> effects) {
        Player player = context.getPlayer();
        assert (player != null);
        if (gearType.matches(type) || "all".equals(type)) {
            int setPieceCount = this.getSetPieceCount(type, player);
            boolean hasFullSet = !"armor".equals(type) || setPieceCount >= 4;
            for (PotionData potionData : effects) {
                MobEffectInstance effect = potionData.getEffect(context.getTraitLevel(), setPieceCount, hasFullSet);
                if (effect == null) continue;
                player.m_7292_(effect);
            }
        }
    }

    private int getSetPieceCount(String type, Player player) {
        if (!"armor".equals(type)) {
            return 1;
        }
        int count = 0;
        for (ItemStack stack : player.m_6168_()) {
            if (!(stack.m_41720_() instanceof ICoreArmor) || !TraitHelper.hasTrait(stack, this)) continue;
            ++count;
        }
        return count;
    }

    static void deserializeJson(WielderEffectTrait trait, JsonObject json) {
        if (!json.has("potion_effects")) {
            throw new JsonParseException("Wielder effect trait '" + trait.getId() + "' is missing 'potion_effects' object");
        }
        JsonObject jsonEffects = json.getAsJsonObject("potion_effects");
        for (Map.Entry entry : jsonEffects.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if (!element.isJsonArray()) {
                throw new JsonParseException("Expected array, found " + element.getClass().getSimpleName());
            }
            JsonArray array = element.getAsJsonArray();
            ArrayList<PotionData> list = new ArrayList<PotionData>();
            for (JsonElement elem : array) {
                if (!elem.isJsonObject()) {
                    throw new JsonParseException("Expected object, found " + elem.getClass().getSimpleName());
                }
                list.add(PotionData.from(elem.getAsJsonObject()));
            }
            if (list.isEmpty()) continue;
            trait.potions.put(key, list);
        }
    }

    static void readFromNetwork(WielderEffectTrait trait, FriendlyByteBuf buffer) {
        trait.potions.clear();
        int gearTypeCount = buffer.readByte();
        for (int typeIndex = 0; typeIndex < gearTypeCount; ++typeIndex) {
            ArrayList<PotionData> list = new ArrayList<PotionData>();
            String gearType = buffer.m_130277_();
            int potionDataCount = buffer.readByte();
            for (int potionIndex = 0; potionIndex < potionDataCount; ++potionIndex) {
                list.add(PotionData.read(buffer));
            }
            trait.potions.put(gearType, list);
        }
    }

    static void writeToNetwork(WielderEffectTrait trait, FriendlyByteBuf buffer) {
        buffer.writeByte(trait.potions.size());
        for (Map.Entry<String, List<PotionData>> entry : trait.potions.entrySet()) {
            buffer.m_130070_(entry.getKey());
            buffer.writeByte(entry.getValue().size());
            for (PotionData potionData : entry.getValue()) {
                potionData.write(buffer);
            }
        }
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        Collection<String> ret = super.getExtraWikiLines();
        this.potions.forEach((type, list) -> {
            ret.add("  - " + type);
            list.forEach(mod -> ret.add("    - " + mod.getWikiLine()));
        });
        return ret;
    }

    public static class PotionData {
        private LevelType type;
        private ResourceLocation effectId;
        private int duration;
        private int[] levels;

        @Deprecated
        public static PotionData of(boolean requiresFullSet, MobEffect effect, int ... levels) {
            return PotionData.of(requiresFullSet ? LevelType.FULL_SET_ONLY : LevelType.PIECE_COUNT, effect, levels);
        }

        public static PotionData of(LevelType type, MobEffect effect, int ... levels) {
            PotionData ret = new PotionData();
            ret.type = type;
            ret.effectId = Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.getKey((Object)effect));
            ret.duration = TimeUtils.ticksFromSeconds((float)PotionData.getDefaultDuration(ret.effectId));
            ret.levels = (int[])levels.clone();
            return ret;
        }

        public JsonObject serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("type", this.type.getName());
            json.addProperty("effect", this.effectId.toString());
            JsonArray levelsArray = new JsonArray();
            Arrays.stream(this.levels).forEach(arg_0 -> ((JsonArray)levelsArray).add(arg_0));
            json.add("level", (JsonElement)levelsArray);
            return json;
        }

        static PotionData from(JsonObject json) {
            PotionData ret = new PotionData();
            ret.type = PotionData.deserializeType(json);
            ret.effectId = new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"effect", (String)"unknown"));
            float durationInSeconds = GsonHelper.m_13820_((JsonObject)json, (String)"duration", (float)PotionData.getDefaultDuration(ret.effectId));
            ret.duration = TimeUtils.ticksFromSeconds((float)durationInSeconds);
            JsonElement elementLevel = json.get("level");
            if (elementLevel == null) {
                throw new JsonParseException("level element not found, should be either int or array");
            }
            if (elementLevel.isJsonPrimitive()) {
                ret.levels = new int[]{GsonHelper.m_13824_((JsonObject)json, (String)"level", (int)1)};
            } else if (elementLevel.isJsonArray()) {
                JsonArray array = elementLevel.getAsJsonArray();
                ret.levels = new int[array.size()];
                for (int i = 0; i < ret.levels.length; ++i) {
                    ret.levels[i] = array.get(i).getAsInt();
                }
            } else {
                throw new JsonParseException("Expected level to be int or array, was " + elementLevel.getClass().getSimpleName());
            }
            return ret;
        }

        private static LevelType deserializeType(JsonObject json) {
            if (json.has("type")) {
                return (LevelType)EnumUtils.byName((String)GsonHelper.m_13906_((JsonObject)json, (String)"type"), (Enum)LevelType.FULL_SET_ONLY);
            }
            if (json.has("full_set")) {
                return GsonHelper.m_13912_((JsonObject)json, (String)"full_set") ? LevelType.FULL_SET_ONLY : LevelType.PIECE_COUNT;
            }
            return LevelType.TRAIT_LEVEL;
        }

        static PotionData read(FriendlyByteBuf buffer) {
            PotionData ret = new PotionData();
            ret.type = (LevelType)buffer.m_130066_(LevelType.class);
            ret.effectId = buffer.m_130281_();
            ret.duration = buffer.m_130242_();
            ret.levels = buffer.m_130100_();
            return ret;
        }

        void write(FriendlyByteBuf buffer) {
            buffer.m_130068_((Enum)this.type);
            buffer.m_130085_(this.effectId);
            buffer.m_130130_(this.duration);
            buffer.m_130089_(this.levels);
        }

        private static float getDefaultDuration(ResourceLocation effectId) {
            return new ResourceLocation("night_vision").equals((Object)effectId) ? 15.9f : 1.9f;
        }

        @Nullable
        MobEffectInstance getEffect(int traitLevel, int pieceCount, boolean hasFullSet) {
            if (this.type == LevelType.FULL_SET_ONLY && !hasFullSet) {
                return null;
            }
            MobEffect potion = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(this.effectId);
            if (potion == null) {
                return null;
            }
            int effectLevel = this.getEffectLevel(traitLevel, pieceCount, hasFullSet);
            if (effectLevel < 1) {
                return null;
            }
            return new MobEffectInstance(potion, this.duration, effectLevel - 1, true, false);
        }

        int getEffectLevel(int traitLevel, int pieceCount, boolean hasFullSet) {
            switch (this.type) {
                case TRAIT_LEVEL: {
                    return this.levels[Mth.m_14045_((int)(traitLevel - 1), (int)0, (int)(this.levels.length - 1))];
                }
                case PIECE_COUNT: {
                    return this.levels[Mth.m_14045_((int)(pieceCount - 1), (int)0, (int)(this.levels.length - 1))];
                }
                case FULL_SET_ONLY: {
                    return this.levels[0];
                }
            }
            throw new IllegalArgumentException("Unknown level type for wielder effect trait: " + this.type);
        }

        public String getWikiLine() {
            CharSequence[] levelsText = new String[this.levels.length];
            for (int i = 0; i < this.levels.length; ++i) {
                levelsText[i] = Integer.toString(this.levels[i]);
            }
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(this.effectId);
            String effectName = effect != null ? effect.m_19482_().getString() : this.effectId.toString();
            return String.format("%s: [%s] (%s)", effectName, String.join((CharSequence)", ", levelsText), this.type.wikiText);
        }
    }

    public static enum LevelType {
        TRAIT_LEVEL("by trait level"),
        PIECE_COUNT("by armor piece count"),
        FULL_SET_ONLY("requires full set of armor");

        final String wikiText;

        private LevelType(String wikiText) {
            this.wikiText = wikiText;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

