/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.compounder;

import java.util.HashSet;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.MaterialList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.block.IDroppableInventory;
import net.silentchaos512.gear.block.compounder.CompounderContainer;
import net.silentchaos512.gear.block.compounder.CompounderInfo;
import net.silentchaos512.gear.crafting.recipe.compounder.CompoundingRecipe;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.item.CompoundMaterialItem;
import net.silentchaos512.lib.tile.LockableSidedInventoryTileEntity;
import net.silentchaos512.lib.tile.SyncVariable;
import net.silentchaos512.lib.util.InventoryUtils;
import net.silentchaos512.lib.util.TimeUtils;

public class CompounderTileEntity<R extends CompoundingRecipe>
extends LockableSidedInventoryTileEntity
implements IDroppableInventory {
    public static final int STANDARD_INPUT_SLOTS = 4;
    static final int WORK_TIME = TimeUtils.ticksFromSeconds((float)(SilentGear.isDevBuild() ? 2.0f : 10.0f));
    private final CompounderInfo<R> info;
    private final int[] allSlots;
    @SyncVariable(name="Progress")
    private int progress = 0;
    @SyncVariable(name="WorkEnabled")
    private boolean workEnabled = true;
    private final ContainerData fields = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return CompounderTileEntity.this.progress;
                }
                case 1: {
                    return CompounderTileEntity.this.workEnabled ? 1 : 0;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    CompounderTileEntity.this.progress = value;
                    break;
                }
                case 1: {
                    CompounderTileEntity.this.workEnabled = value != 0;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public CompounderTileEntity(CompounderInfo<R> info, BlockPos pos, BlockState state) {
        super(info.getBlockEntityType(), info.getInputSlotCount() + 2, pos, state);
        this.info = info;
        this.allSlots = IntStream.range(0, this.items.size()).toArray();
    }

    protected RecipeType<R> getRecipeType() {
        return this.info.getRecipeType();
    }

    @Nullable
    public R getRecipe() {
        if (this.f_58857_ == null) {
            return null;
        }
        return (R)((CompoundingRecipe)this.f_58857_.m_7465_().m_44015_(this.getRecipeType(), (Container)this, this.f_58857_).orElse(null));
    }

    protected CompoundMaterialItem getOutputItem(MaterialList materials) {
        return this.info.getOutputItem();
    }

    protected ItemStack getWorkOutput(@Nullable R recipe, MaterialList materials) {
        if (recipe != null) {
            RegistryAccess registryAccess = this.f_58857_ != null ? this.f_58857_.m_9598_() : null;
            return ((CompoundingRecipe)recipe).assemble(this, registryAccess);
        }
        return this.getOutputItem(materials).create(materials);
    }

    public int getInputSlotCount() {
        return this.m_6643_() - 2;
    }

    public int getOutputSlotIndex() {
        return this.m_6643_() - 2;
    }

    public int getOutputHintSlotIndex() {
        return this.m_6643_() - 1;
    }

    public ItemStack getHintStack() {
        return this.m_8020_(this.getOutputHintSlotIndex());
    }

    public void encodeExtraData(FriendlyByteBuf buffer) {
        buffer.writeByte(this.items.size());
        buffer.writeByte(this.fields.m_6499_());
    }

    private boolean areInputsEmpty() {
        for (int i = 0; i < this.getInputSlotCount(); ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public static <R extends CompoundingRecipe> void tick(Level level, BlockPos pos, BlockState state, CompounderTileEntity<R> blockEntity) {
        if (blockEntity.areInputsEmpty()) {
            blockEntity.updateOutputHint(ItemStack.f_41583_);
            return;
        }
        R recipe = blockEntity.getRecipe();
        if (recipe != null) {
            blockEntity.doWork(recipe, MaterialList.empty());
        } else {
            MaterialList materials = blockEntity.getInputs();
            if (!CompounderTileEntity.hasMultipleMaterials(materials) || !blockEntity.canCompoundMaterials(materials)) {
                blockEntity.stopWork(true);
                return;
            }
            blockEntity.doWork(null, materials);
        }
    }

    private void doWork(@Nullable R recipe, MaterialList materials) {
        assert (this.f_58857_ != null);
        ItemStack current = this.m_8020_(this.getOutputSlotIndex());
        ItemStack output = this.getWorkOutput(recipe, materials);
        this.updateOutputHint(output);
        if (!current.m_41619_()) {
            int newCount = current.m_41613_() + output.m_41613_();
            if (!InventoryUtils.canItemsStack((ItemStack)current, (ItemStack)output) || newCount > output.m_41741_()) {
                this.stopWork(false);
                return;
            }
        }
        if (this.workEnabled) {
            if (this.progress < WORK_TIME) {
                ++this.progress;
            }
            if (this.progress >= WORK_TIME && !this.f_58857_.f_46443_) {
                this.finishWork(recipe, materials, current);
            }
        } else {
            this.stopWork(false);
        }
    }

    private void updateOutputHint(ItemStack hintStack) {
        this.m_6836_(this.getOutputHintSlotIndex(), hintStack);
    }

    private void stopWork(boolean clearHintItem) {
        this.progress = 0;
        if (clearHintItem) {
            this.m_6836_(this.getOutputHintSlotIndex(), ItemStack.f_41583_);
        }
    }

    private void finishWork(@Nullable R recipe, MaterialList materials, ItemStack current) {
        this.progress = 0;
        for (int i = 0; i < this.getInputSlotCount(); ++i) {
            this.m_7407_(i, 1);
        }
        ItemStack output = this.getWorkOutput(recipe, materials);
        if (!current.m_41619_()) {
            current.m_41769_(output.m_41613_());
        } else {
            this.m_6836_(this.getOutputSlotIndex(), output);
        }
    }

    private static boolean hasMultipleMaterials(List<IMaterialInstance> materials) {
        if (materials.size() < 2) {
            return false;
        }
        IMaterial first = (IMaterial)materials.get(0).get();
        for (int i = 1; i < materials.size(); ++i) {
            if (materials.get(i).get() == first) continue;
            return true;
        }
        return false;
    }

    private boolean canCompoundMaterials(Iterable<IMaterialInstance> materials) {
        HashSet<PartType> partTypes = new HashSet<PartType>(PartType.getValues());
        for (IMaterialInstance material : materials) {
            if (!material.hasAnyCategory(this.info.getCategories())) {
                return false;
            }
            partTypes.removeIf(pt -> !material.getPartTypes().contains(pt));
        }
        return !partTypes.isEmpty();
    }

    private MaterialList getInputs() {
        boolean allEmpty = true;
        for (int i = 0; i < this.getInputSlotCount(); ++i) {
            ItemStack stack = this.m_8020_(i);
            if (stack.m_41619_()) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            return MaterialList.empty();
        }
        MaterialList ret = MaterialList.empty();
        for (int i = 0; i < this.getInputSlotCount(); ++i) {
            ItemStack stack = this.m_8020_(i);
            if (stack.m_41619_()) continue;
            MaterialInstance material = MaterialInstance.from(stack);
            if (material != null && material.get().isSimple()) {
                ret.add(material);
                continue;
            }
            return MaterialList.empty();
        }
        return ret;
    }

    @Override
    public NonNullList<ItemStack> getItemsToDrop() {
        NonNullList ret = NonNullList.m_122779_();
        for (int i = 0; i < this.m_6643_() - 1; ++i) {
            ItemStack stack = this.m_8020_(i);
            if (stack.m_41619_()) continue;
            ret.add((Object)stack);
        }
        return ret;
    }

    public void m_6836_(int index, ItemStack stack) {
        super.m_6836_(index, stack);
    }

    public int[] m_7071_(Direction side) {
        return (int[])this.allSlots.clone();
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return index < this.getInputSlotCount();
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.m_7013_(index, itemStackIn);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return index == this.getOutputSlotIndex();
    }

    protected Component m_6820_() {
        ResourceLocation key = ForgeRegistries.BLOCKS.getKey((Object)this.info.getBlock());
        return Component.m_237115_((String)Util.m_137492_((String)"container", (ResourceLocation)key));
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new CompounderContainer(this.info.getContainerType(), id, player, (Container)this, this.fields, this.info.getCategories());
    }

    public void m_142466_(CompoundTag tags) {
        super.m_142466_(tags);
        SyncVariable.Helper.readSyncVars((Object)this, (CompoundTag)tags);
    }

    public void m_183515_(CompoundTag tags) {
        super.m_183515_(tags);
        SyncVariable.Helper.writeSyncVars((Object)this, (CompoundTag)tags, (SyncVariable.Type)SyncVariable.Type.WRITE);
    }

    public CompoundTag m_5995_() {
        CompoundTag tags = super.m_5995_();
        SyncVariable.Helper.writeSyncVars((Object)this, (CompoundTag)tags, (SyncVariable.Type)SyncVariable.Type.PACKET);
        return tags;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        super.onDataPacket(net, packet);
        CompoundTag tags = packet.m_131708_();
        SyncVariable.Helper.readSyncVars((Object)this, (CompoundTag)tags);
    }
}

