/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia;

import com.epherical.croptopia.ClientFunctions;
import com.epherical.croptopia.CroptopiaMod;
import com.epherical.croptopia.ForgeAdapter;
import com.epherical.croptopia.biome.CropModifier;
import com.epherical.croptopia.biome.SaltModifier;
import com.epherical.croptopia.biome.TreeModifier;
import com.epherical.croptopia.blocks.CroptopiaCropBlock;
import com.epherical.croptopia.config.CroptopiaConfig;
import com.epherical.croptopia.items.GuideBookItem;
import com.epherical.croptopia.items.SeedItem;
import com.epherical.croptopia.listeners.BlockBreakEvent;
import com.epherical.croptopia.listeners.EntitySpawn;
import com.epherical.croptopia.listeners.Harvest;
import com.epherical.croptopia.listeners.LootTableModification;
import com.epherical.croptopia.loot.AdditionalTableModifier;
import com.epherical.croptopia.loot.EntityModifier;
import com.epherical.croptopia.loot.SpawnChestModifier;
import com.epherical.croptopia.register.Content;
import com.epherical.croptopia.register.helpers.FarmlandCrop;
import com.epherical.croptopia.register.helpers.TreeCrop;
import com.epherical.croptopia.register.helpers.Utensil;
import com.epherical.epherolib.libs.org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import com.epherical.epherolib.libs.org.spongepowered.configurate.loader.AbstractConfigurationLoader;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.EventListenerHelper;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="croptopia")
public class CroptopiaForge {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_SERIALIZER = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"croptopia");
    public static final DeferredRegister<BiomeModifier> BIOME_MODIFIER = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (String)"croptopia");
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> GLM = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"croptopia");
    public static CreativeModeTab CROPTOPIA_ITEM_GROUP = null;
    public static CroptopiaMod mod;
    public static MinecraftServer server;
    private static boolean hasRun;

    public CroptopiaForge() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        bus.addListener(this::enqueueIMC);
        bus.addListener(this::processIMC);
        bus.addListener(this::doClientStuff);
        BIOME_MODIFIER.register(bus);
        BIOME_SERIALIZER.register(bus);
        BIOME_SERIALIZER.register("trees", TreeModifier::makeCodec);
        BIOME_SERIALIZER.register("crops", CropModifier::makeCodec);
        BIOME_SERIALIZER.register("salt", SaltModifier::makeCodec);
        GLM.register(bus);
        GLM.register("spawn_loot", SpawnChestModifier.CODEC);
        GLM.register("entity_modifier", EntityModifier.CODEC);
        GLM.register("table_adder", AdditionalTableModifier.CODEC);
        MinecraftForge.EVENT_BUS.addListener(CroptopiaForge::onWorldLoad);
        MinecraftForge.EVENT_BUS.register((Object)new LootTableModification());
        MinecraftForge.EVENT_BUS.register((Object)new Harvest());
        MinecraftForge.EVENT_BUS.register((Object)new BlockBreakEvent());
        MinecraftForge.EVENT_BUS.register((Object)new EntitySpawn());
        EventListenerHelper.getListenerList(PlayerInteractEvent.RightClickBlock.class);
        mod = new CroptopiaMod(new ForgeAdapter(), new CroptopiaConfig((AbstractConfigurationLoader.Builder<?, ?>)HoconConfigurationLoader.builder(), "croptopia_v3.conf"));
    }

    private void setup(FMLCommonSetupEvent event) {
        mod.registerCompost();
        ArrayList<Item> chickenItems = new ArrayList<Item>(CroptopiaMod.seeds);
        chickenItems.addAll(Arrays.stream(Chicken.f_28233_.m_43908_()).map(ItemStack::m_41720_).collect(Collectors.toList()));
        Chicken.f_28233_ = Ingredient.m_43929_((ItemLike[])chickenItems.toArray(new ItemLike[0]));
        ArrayList<Item> parrotItems = new ArrayList<Item>(Parrot.f_29357_);
        parrotItems.addAll(CroptopiaMod.seeds);
        Parrot.f_29357_ = Sets.newHashSet(parrotItems);
        ArrayList<FarmlandCrop> pigItems = new ArrayList<FarmlandCrop>(Arrays.asList(Content.YAM, Content.SWEETPOTATO));
        pigItems.addAll(Arrays.stream(Pig.f_29458_.m_43908_()).map(ItemStack::m_41720_).collect(Collectors.toList()));
        Pig.f_29458_ = Ingredient.m_43929_((ItemLike[])pigItems.toArray(new ItemLike[0]));
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        ClientFunctions functions = new ClientFunctions();
        functions.registerBlockLayers(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110457_()));
        BlockColors colors = Minecraft.m_91087_().m_91298_();
        colors.m_92589_(functions.registerLeafColors(), functions.leaves());
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterTool", () -> new ItemStack((ItemLike)Content.COOKING_POT));
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterTool", () -> new ItemStack((ItemLike)Content.FOOD_PRESS));
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterTool", () -> new ItemStack((ItemLike)Content.FRYING_PAN));
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterTool", () -> new ItemStack((ItemLike)Content.MORTAR_AND_PESTLE));
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterWaterItem", () -> new ItemStack((ItemLike)Content.WATER_BOTTLE));
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterMilkItem", () -> new ItemStack((ItemLike)Content.MILK_BOTTLE));
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(FMLDedicatedServerSetupEvent event) {
    }

    public static ResourceLocation createIdentifier(String name) {
        return new ResourceLocation("croptopia", name);
    }

    private static void modifyVillagerFoodItems() {
    }

    private static void modifyVillagerGatherables() {
    }

    public static void onWorldLoad(LevelEvent.Load event) {
        if (!hasRun) {
            CroptopiaForge.modifyVillagerFoodItems();
            CroptopiaForge.modifyVillagerGatherables();
            hasRun = true;
        }
    }

    public MinecraftServer getServer() {
        return server;
    }

    public void setServer(MinecraftServer server) {
        CroptopiaForge.server = server;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerTag(BuildCreativeModeTabContentsEvent event) {
            if (event.getTab().equals(CreativeModeTabs.f_256776_)) {
                event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_220175_), (Object)new ItemStack((ItemLike)Content.CINNAMON.getSapling()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                TreeCrop.TREE_CROPS.stream().map(TreeCrop::getSaplingItem).map(ItemStack::new).forEachOrdered(stack -> event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_151013_), stack, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
                FarmlandCrop.FARMLAND_CROPS.stream().map(FarmlandCrop::getSeedItem).map(ItemStack::new).forEachOrdered(stack -> event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_42588_), stack, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
                event.getEntries().putBefore((Object)new ItemStack((ItemLike)Items.f_41835_), (Object)new ItemStack((ItemLike)Content.SALT_ORE), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            } else if (event.getTab().equals(CreativeModeTabs.f_256869_)) {
                Utensil.copy().stream().map(ItemStack::new).forEachOrdered(stack -> event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_42409_), stack, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
            }
        }

        @SubscribeEvent
        public static void onRegister(RegisterEvent event) {
            if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.ITEMS)) {
                CROPTOPIA_ITEM_GROUP = CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.croptopia")).m_257501_((featureFlagSet, output) -> BuiltInRegistries.f_257033_.m_6579_().stream().filter(entry -> ((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals("croptopia")).sorted(Comparator.comparing(entry -> BuiltInRegistries.f_257033_.m_7447_((Object)((Item)entry.getValue())))).forEach(entry -> output.m_246326_((ItemLike)entry.getValue()))).m_257737_(() -> new ItemStack((ItemLike)Content.COFFEE)).m_257652_();
                Registry.m_122965_((Registry)BuiltInRegistries.f_279662_, (ResourceLocation)new ResourceLocation("croptopia", "croptopia"), (Object)CROPTOPIA_ITEM_GROUP);
                Content.GUIDE = new GuideBookItem(CroptopiaMod.createGroup());
                event.register(ForgeRegistries.Keys.ITEMS, CroptopiaForge.createIdentifier("guide"), () -> Content.GUIDE);
                Content.registerItems((id, itemSupplier) -> {
                    if (Content.ITEM_REGISTER.getManipulations().containsKey(id)) {
                        itemSupplier = Content.ITEM_REGISTER.getManipulations().get(id);
                    }
                    Item item = (Item)itemSupplier.get();
                    event.register(ForgeRegistries.Keys.ITEMS, id, () -> item);
                    if (item instanceof ItemNameBlockItem) {
                        ((ItemNameBlockItem)item).m_6192_(Item.f_41373_, item);
                    }
                    if (item instanceof SeedItem) {
                        SeedItem it = (SeedItem)item;
                        CroptopiaCropBlock block = (CroptopiaCropBlock)it.m_40614_();
                        block.setSeed(it);
                    }
                    return item;
                });
            }
            if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.BLOCKS)) {
                Content.registerBlocks((id, supplier) -> {
                    if (Content.BLOCK_REGISTER.getManipulations().containsKey(id)) {
                        supplier = Content.BLOCK_REGISTER.getManipulations().get(id);
                    }
                    Block block = (Block)supplier.get();
                    event.register(ForgeRegistries.Keys.BLOCKS, id, () -> block);
                    return block;
                });
                mod.platform().registerFlammableBlocks();
            }
        }
    }
}

