/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.cityassets;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import mcjty.lostcities.api.ILostCityBuilding;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.ConditionContext;
import mcjty.lostcities.worldgen.lost.cityassets.Palette;
import mcjty.lostcities.worldgen.lost.regassets.BuildingRE;
import mcjty.lostcities.worldgen.lost.regassets.data.DataTools;
import mcjty.lostcities.worldgen.lost.regassets.data.PartRef;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.CommonLevelAccessor;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class Building
implements ILostCityBuilding {
    private final ResourceLocation name;
    private int minFloors = -1;
    private int minCellars = -1;
    private int maxFloors = -1;
    private int maxCellars = -1;
    private Boolean allowDoors = true;
    private Boolean allowFillers = true;
    private final char fillerBlock;
    private final Character rubbleBlock;
    private float prefersLonely = 0.0f;
    private Palette localPalette = null;
    private String refPaletteName;
    private final List<Pair<Predicate<ConditionContext>, String>> parts = new ArrayList<Pair<Predicate<ConditionContext>, String>>();
    private final List<Pair<Predicate<ConditionContext>, String>> parts2 = new ArrayList<Pair<Predicate<ConditionContext>, String>>();

    public Building(BuildingRE object) {
        this.name = object.getRegistryName();
        this.minFloors = object.getMinFloors();
        this.minCellars = object.getMinCellars();
        this.maxFloors = object.getMaxFloors();
        this.maxCellars = object.getMaxCellars();
        this.allowDoors = object.getAllowDoors();
        this.allowFillers = object.getAllowFillers();
        this.prefersLonely = object.getPrefersLonely();
        this.fillerBlock = object.getFillerBlock();
        this.rubbleBlock = object.getRubbleBlock();
        if (object.getLocalPalette() != null) {
            this.localPalette = new Palette("__local__" + object.getRegistryName().m_135815_());
            this.localPalette.parsePaletteArray(object.getLocalPalette());
        } else if (object.getRefPaletteName() != null) {
            this.refPaletteName = object.getRefPaletteName();
        }
        this.readParts(this.parts, object.getParts());
        this.readParts(this.parts2, object.getParts2());
    }

    @Override
    public String getName() {
        return DataTools.toName(this.name);
    }

    @Override
    public ResourceLocation getId() {
        return this.name;
    }

    @Override
    public Palette getLocalPalette(CommonLevelAccessor level) {
        if (this.localPalette == null && this.refPaletteName != null) {
            this.localPalette = AssetRegistries.PALETTES.getOrThrow(level, this.refPaletteName);
        }
        return this.localPalette;
    }

    public void readParts(List<Pair<Predicate<ConditionContext>, String>> p, List<PartRef> partRefs) {
        p.clear();
        if (partRefs == null) {
            return;
        }
        for (PartRef partRef : partRefs) {
            String partName = partRef.getPart();
            Predicate<ConditionContext> test = ConditionContext.parseTest(partRef);
            p.add((Pair<Predicate<ConditionContext>, String>)Pair.of(test, (Object)partName));
        }
    }

    @Override
    public float getPrefersLonely() {
        return this.prefersLonely;
    }

    @Override
    public int getMaxFloors() {
        return this.maxFloors;
    }

    @Override
    public int getMaxCellars() {
        return this.maxCellars;
    }

    @Override
    public int getMinFloors() {
        return this.minFloors;
    }

    @Override
    public int getMinCellars() {
        return this.minCellars;
    }

    @Override
    public Boolean getAllowDoors() {
        return this.allowDoors;
    }

    @Override
    public Boolean getAllowFillers() {
        return this.allowFillers;
    }

    @Override
    public char getFillerBlock() {
        return this.fillerBlock;
    }

    @Override
    @Nullable
    public Character getRubbleBlock() {
        return this.rubbleBlock;
    }

    public String getRandomPart(Random random, ConditionContext info) {
        ArrayList<String> partNames = new ArrayList<String>();
        for (Pair<Predicate<ConditionContext>, String> pair : this.parts) {
            if (!((Predicate)pair.getLeft()).test(info)) continue;
            partNames.add((String)pair.getRight());
        }
        if (partNames.isEmpty()) {
            return null;
        }
        return (String)partNames.get(random.nextInt(partNames.size()));
    }

    public String getRandomPart2(Random random, ConditionContext info) {
        ArrayList<String> partNames = new ArrayList<String>();
        for (Pair<Predicate<ConditionContext>, String> pair : this.parts2) {
            if (!((Predicate)pair.getLeft()).test(info)) continue;
            partNames.add((String)pair.getRight());
        }
        if (partNames.isEmpty()) {
            return null;
        }
        return (String)partNames.get(random.nextInt(partNames.size()));
    }
}

