/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen;

import mcjty.lostcities.config.LandscapeType;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;

public class ChunkHeightmap {
    private int height;
    private final LandscapeType type;
    private final int groundLevel;
    private int minHeight;
    private int maxHeight;

    public ChunkHeightmap(LandscapeType type, int groundLevel) {
        this.groundLevel = groundLevel;
        this.type = type;
        this.height = Short.MIN_VALUE;
    }

    public void update(int y) {
        int current = this.height;
        if (y <= current) {
            return;
        }
        if (this.type == LandscapeType.CAVERN || this.type == LandscapeType.CAVERNSPHERES) {
            int base = Math.max(this.groundLevel - 20, 1);
            if (y > 100 || y < base) {
                return;
            }
            if (y == 100) {
                y = 127;
            }
        }
        this.height = y;
    }

    public int getHeight() {
        if (this.height < -4000) {
            return this.groundLevel;
        }
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void calculateAccurateHeight(WorldGenLevel region, int chunkX, int chunkZ) {
        ServerChunkCache chunkProvider = region.m_6018_().m_7726_();
        ChunkGenerator generator = chunkProvider.m_8481_();
        int cx = chunkX << 4;
        int cz = chunkZ << 4;
        RandomState randomState = chunkProvider.m_214994_();
        int height0 = generator.m_214096_(cx + 2, cz + 2, Heightmap.Types.OCEAN_FLOOR_WG, (LevelHeightAccessor)region, randomState);
        int height1 = generator.m_214096_(cx + 2, cz + 14, Heightmap.Types.OCEAN_FLOOR_WG, (LevelHeightAccessor)region, randomState);
        int height2 = generator.m_214096_(cx + 14, cz + 2, Heightmap.Types.OCEAN_FLOOR_WG, (LevelHeightAccessor)region, randomState);
        int height3 = generator.m_214096_(cx + 14, cz + 14, Heightmap.Types.OCEAN_FLOOR_WG, (LevelHeightAccessor)region, randomState);
        this.minHeight = Math.min(this.height, Math.min(height0, Math.min(height1, Math.min(height2, height3))));
        this.maxHeight = Math.max(this.height, Math.max(height0, Math.max(height1, Math.max(height2, height3))));
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }
}

