/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.api;

import mcjty.lostcities.api.ILostCities;
import mcjty.lostcities.api.LostChunkCharacteristics;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public class LostCityEvent
extends Event {
    private final WorldGenLevel world;
    private final ILostCities lostCities;
    private final int chunkX;
    private final int chunkZ;

    public LostCityEvent(WorldGenLevel world, ILostCities lostCities, int chunkX, int chunkZ) {
        this.world = world;
        this.lostCities = lostCities;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
    }

    public WorldGenLevel getWorld() {
        return this.world;
    }

    public ILostCities getLostCities() {
        return this.lostCities;
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    @Cancelable
    public static class PreExplosionEvent
    extends LostCityEvent {
        private final ChunkAccess primer;

        public PreExplosionEvent(WorldGenLevel world, ILostCities lostCities, int chunkX, int chunkZ, ChunkAccess primer) {
            super(world, lostCities, chunkX, chunkZ);
            this.primer = primer;
        }

        public ChunkAccess getChunkAccess() {
            return this.primer;
        }
    }

    public static class PostGenOutsideChunkEvent
    extends LostCityEvent {
        private final ChunkAccess primer;

        public PostGenOutsideChunkEvent(WorldGenLevel world, ILostCities lostCities, int chunkX, int chunkZ, ChunkAccess primer) {
            super(world, lostCities, chunkX, chunkZ);
            this.primer = primer;
        }

        public ChunkAccess getChunkAccess() {
            return this.primer;
        }
    }

    public static class PostGenCityChunkEvent
    extends LostCityEvent {
        private final ChunkAccess primer;

        public PostGenCityChunkEvent(WorldGenLevel world, ILostCities lostCities, int chunkX, int chunkZ, ChunkAccess primer) {
            super(world, lostCities, chunkX, chunkZ);
            this.primer = primer;
        }

        public ChunkAccess getChunkAccess() {
            return this.primer;
        }
    }

    @Cancelable
    public static class PreGenCityChunkEvent
    extends LostCityEvent {
        private final ChunkAccess primer;

        public PreGenCityChunkEvent(WorldGenLevel world, ILostCities lostCities, int chunkX, int chunkZ, ChunkAccess primer) {
            super(world, lostCities, chunkX, chunkZ);
            this.primer = primer;
        }

        public ChunkAccess getChunkAccess() {
            return this.primer;
        }
    }

    public static class CharacteristicsEvent
    extends LostCityEvent {
        private final LostChunkCharacteristics characteristics;

        public CharacteristicsEvent(WorldGenLevel world, ILostCities lostCities, int chunkX, int chunkZ, LostChunkCharacteristics characteristics) {
            super(world, lostCities, chunkX, chunkZ);
            this.characteristics = characteristics;
        }

        public LostChunkCharacteristics getCharacteristics() {
            return this.characteristics;
        }
    }
}

