/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.entities.vehicles;

import com.teamresourceful.resourcefullib.common.network.Packet;
import earth.terrarium.adastra.api.systems.GravityApi;
import earth.terrarium.adastra.common.container.VehicleContainer;
import earth.terrarium.adastra.common.entities.multipart.MultipartEntity;
import earth.terrarium.adastra.common.entities.multipart.MultipartPartEntity;
import earth.terrarium.adastra.common.entities.vehicles.VehiclePart;
import earth.terrarium.adastra.common.network.NetworkHandler;
import earth.terrarium.adastra.common.network.messages.ServerboundVehicleControlPacket;
import earth.terrarium.adastra.mixins.common.LivingEntityAccessor;
import earth.terrarium.botarium.common.menu.ExtraDataMenuProvider;
import earth.terrarium.botarium.common.menu.MenuHooks;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public abstract class Vehicle
extends Entity
implements PlayerRideable,
ExtraDataMenuProvider,
MultipartEntity,
HasCustomInventoryScreen {
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private float xxa;
    private float zza;
    protected final VehicleContainer inventory = new VehicleContainer(this.getInventorySize());
    protected final List<VehiclePart> parts = new ArrayList<VehiclePart>();
    private final List<MultipartPartEntity<?>> multipartParts = new ArrayList();

    public Vehicle(EntityType<?> type, Level level) {
        super(type, level);
    }

    protected void addPart(float width, float height, Vector3f offset, BiFunction<Player, InteractionHand, InteractionResult> handler) {
        VehiclePart part = new VehiclePart(this, width, height, offset, handler);
        this.parts.add(part);
        this.multipartParts.add(part);
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
        this.inventory.m_7797_(compound.m_128437_("Inventory", 10));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128365_("Inventory", (Tag)this.inventory.m_7927_());
    }

    public boolean m_7337_(Entity entity) {
        return Boat.m_38323_((Entity)this, (Entity)entity);
    }

    public boolean m_5829_() {
        return true;
    }

    public void m_6453_(double x, double y, double z, float yRot, float xRot, int lerpSteps, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYRot = yRot;
        this.lerpXRot = xRot;
        this.lerpSteps = lerpSteps;
    }

    public void m_8119_() {
        super.m_8119_();
        this.tickLerp();
        if (!this.m_20068_()) {
            this.tickGravity();
        }
        this.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        if (this.m_6109_()) {
            LivingEntity livingEntity;
            if (this.m_9236_().m_5776_() && this.m_20160_() && (livingEntity = this.m_6688_()) instanceof Player) {
                Player player = (Player)livingEntity;
                NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundVehicleControlPacket(player.f_20900_, player.f_20902_));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.tickFriction();
        }
        for (VehiclePart part : this.parts) {
            part.tickPart();
        }
    }

    public void tickLerp() {
        if (this.m_6109_()) {
            this.lerpSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.lerpSteps > 0) {
            double x = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double y = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double z = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            double g = Mth.m_14175_((double)(this.lerpYRot - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + (float)g / (float)this.lerpSteps);
            this.m_146926_(this.m_146909_() + (float)(this.lerpXRot - (double)this.m_146909_()) / (float)this.lerpSteps);
            --this.lerpSteps;
            this.m_6034_(x, y, z);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
    }

    public void tickGravity() {
        Vec3 velocity = this.m_20184_();
        double gravity = 0.05 * (double)GravityApi.API.getGravity(this);
        this.m_20334_(velocity.f_82479_, velocity.f_82480_ - gravity, velocity.f_82481_);
    }

    public void tickFriction() {
        float friction = this.m_9236_().m_8055_(this.m_20099_()).m_60734_().m_49958_();
        float speed = this.m_20096_() ? friction * 0.91f : 0.91f;
        Vec3 deltaMovement = this.m_20184_();
        this.m_20334_(deltaMovement.f_82479_ * (double)speed, deltaMovement.f_82480_, deltaMovement.f_82481_ * (double)speed);
    }

    @Nullable
    public LivingEntity m_6688_() {
        LivingEntity e;
        Entity entity = this.m_146895_();
        return entity instanceof LivingEntity ? (e = (LivingEntity)entity) : null;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Player player;
        Entity entity;
        if (this.m_6673_(source)) {
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268524_)) {
            return false;
        }
        if (amount >= 0.0f && (entity = source.m_7639_()) instanceof Player && ((player = (Player)entity).m_20202_() == null || !player.m_20202_().equals((Object)this))) {
            this.m_216990_(SoundEvents.f_12198_);
            if (!player.m_150110_().f_35937_) {
                this.drop();
            }
            this.m_146870_();
            return true;
        }
        return false;
    }

    public void drop() {
        Containers.m_18992_((Level)this.m_9236_(), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (ItemStack)this.getDropStack());
        if (this.inventory.m_6643_() > 0) {
            Containers.m_19002_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (Container)this.inventory);
        }
    }

    public abstract ItemStack getDropStack();

    @NotNull
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!this.m_9236_().m_5776_()) {
            if (player.m_36341_()) {
                this.m_213583_(player);
                return InteractionResult.SUCCESS;
            }
            return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_213583_(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MenuHooks.openMenu((ServerPlayer)serverPlayer, (ExtraDataMenuProvider)this);
        }
    }

    public void updateInput(float xxa, float zza) {
        this.xxa = xxa;
        this.zza = zza;
    }

    public abstract int getInventorySize();

    public boolean shouldSit() {
        return true;
    }

    public boolean hideRider() {
        return false;
    }

    public boolean zoomOutCameraInThirdPerson() {
        return false;
    }

    public boolean isSafeToDismount(Player player) {
        return true;
    }

    public float xxa() {
        LivingEntity controllingPassenger = this.m_6688_();
        if (controllingPassenger == null) {
            return 0.0f;
        }
        return this.m_9236_().m_5776_() ? controllingPassenger.f_20900_ : this.xxa;
    }

    public float zza() {
        LivingEntity controllingPassenger = this.m_6688_();
        if (controllingPassenger == null) {
            return 0.0f;
        }
        return this.m_9236_().m_5776_() ? controllingPassenger.f_20902_ : this.zza;
    }

    public boolean passengerHasSpaceDown() {
        LivingEntity controllingPassenger = this.m_6688_();
        if (!(controllingPassenger instanceof LivingEntityAccessor)) {
            return false;
        }
        LivingEntityAccessor entity = (LivingEntityAccessor)controllingPassenger;
        return entity.isJumping();
    }

    public VehicleContainer inventory() {
        return this.inventory;
    }

    public void writeExtraData(ServerPlayer player, FriendlyByteBuf buffer) {
        buffer.m_130130_(this.m_19879_());
    }

    @Override
    public List<MultipartPartEntity<?>> getParts() {
        return this.multipartParts;
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        for (int i = 0; i < this.parts.size(); ++i) {
            this.parts.get(i).m_20234_(i + 1 + packet.m_131496_());
        }
    }
}

