/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.pipez.corelib.client.RenderUtils;
import de.maxhenkel.pipez.corelib.helpers.AbstractStack;
import de.maxhenkel.pipez.corelib.helpers.WrappedFluidStack;
import de.maxhenkel.pipez.utils.GasUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WrappedGasStack
extends AbstractStack<ChemicalStack> {
    public WrappedGasStack(ChemicalStack stack) {
        super(stack);
    }

    @Nullable
    public static WrappedGasStack dummyStack(Object o) {
        if (o instanceof Chemical) {
            ChemicalStack stack = GasUtils.createChemicalStack((Chemical)o, 1000L);
            return new WrappedGasStack(stack);
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics guiGraphics, int x, int y) {
        TextureAtlasSprite texture = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(((ChemicalStack)this.stack).getType().getIcon());
        RenderSystem.setShader(GameRenderer::m_172817_);
        int chemicalTint = ((ChemicalStack)this.stack).getChemicalTint();
        RenderSystem.setShaderColor((float)RenderUtils.getRedFloat(chemicalTint), (float)RenderUtils.getGreenFloat(chemicalTint), (float)RenderUtils.getBlueFloat(chemicalTint), (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture.m_247685_());
        WrappedFluidStack.fluidBlit(guiGraphics, x, y, 16, 16, texture, ((ChemicalStack)this.stack).getType().getTint());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Component> getTooltip() {
        ResourceLocation registryName;
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add(this.getDisplayName());
        if (Minecraft.m_91087_().f_91066_.f_92125_ && (registryName = GasUtils.getResourceLocation(((ChemicalStack)this.stack).getType())) != null) {
            tooltip.add((Component)Component.m_237113_((String)registryName.toString()).m_130940_(ChatFormatting.DARK_GRAY));
        }
        return tooltip;
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237119_().m_7220_(((ChemicalStack)this.stack).getTextComponent());
    }

    @Override
    public boolean isEmpty() {
        return ((ChemicalStack)this.stack).isEmpty();
    }
}

