/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.config;

import ca.teamdman.sfm.common.config.SFMClientConfig;
import ca.teamdman.sfm.common.config.SFMClientProgramEditorConfig;
import ca.teamdman.sfm.common.config.SFMServerConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class SFMConfig {
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final SFMServerConfig SERVER;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final SFMClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_PROGRAM_EDITOR_SPEC;
    public static final SFMClientProgramEditorConfig CLIENT_PROGRAM_EDITOR;

    public static <T> T getOrDefault(ForgeConfigSpec.ConfigValue<T> configValue) {
        try {
            return (T)configValue.get();
        }
        catch (Exception e) {
            return (T)configValue.getDefault();
        }
    }

    public static <T> T getOrFallback(ForgeConfigSpec.ConfigValue<T> configValue, T fallback) {
        try {
            return (T)configValue.get();
        }
        catch (Exception e) {
            return fallback;
        }
    }

    public static void register(ModLoadingContext context) {
        context.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_SPEC);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_PROGRAM_EDITOR_SPEC, "sfm-client-program-editor.toml");
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(SFMServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)pair.getRight();
        SERVER = (SFMServerConfig)pair.getLeft();
        pair = new ForgeConfigSpec.Builder().configure(SFMClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)pair.getRight();
        CLIENT = (SFMClientConfig)pair.getLeft();
        pair = new ForgeConfigSpec.Builder().configure(SFMClientProgramEditorConfig::new);
        CLIENT_PROGRAM_EDITOR_SPEC = (ForgeConfigSpec)pair.getRight();
        CLIENT_PROGRAM_EDITOR = (SFMClientProgramEditorConfig)pair.getLeft();
    }
}

