/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.block;

import ca.teamdman.sfm.common.block.CableBlock;
import ca.teamdman.sfm.common.block.IFacadableBlock;
import ca.teamdman.sfm.common.block.shape.ShapeCache;
import ca.teamdman.sfm.common.cablenetwork.ICableBlock;
import ca.teamdman.sfm.common.facade.FacadeTransparency;
import ca.teamdman.sfm.common.registry.SFMBlocks;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.util.NotStored;
import ca.teamdman.sfm.common.util.Stored;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FancyCableBlock
extends CableBlock
implements IFacadableBlock {
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");
    public static final VoxelShape SHAPE_CORE = Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    public static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)5.0);
    public static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0, (double)16.0);
    public static final VoxelShape SHAPE_EAST = Block.m_49796_((double)11.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
    public static final VoxelShape SHAPE_WEST = Block.m_49796_((double)0.0, (double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0);
    public static final VoxelShape SHAPE_UP = Block.m_49796_((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final VoxelShape SHAPE_DOWN = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0);
    public static final Map<Direction, BooleanProperty> DIRECTION_PROPERTIES = ImmutableMap.of((Object)Direction.NORTH, (Object)NORTH, (Object)Direction.SOUTH, (Object)SOUTH, (Object)Direction.EAST, (Object)EAST, (Object)Direction.WEST, (Object)WEST, (Object)Direction.UP, (Object)UP, (Object)Direction.DOWN, (Object)DOWN);

    public FancyCableBlock() {
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public IFacadableBlock getNonFacadeBlock() {
        return (IFacadableBlock)SFMBlocks.FANCY_CABLE_BLOCK.get();
    }

    @Override
    public IFacadableBlock getFacadeBlock() {
        return (IFacadableBlock)SFMBlocks.FANCY_CABLE_FACADE_BLOCK.get();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return this.getState(this.m_49966_(), (LevelAccessor)ctx.m_43725_(), ctx.m_8083_());
    }

    public void m_6861_(BlockState state, Level level, @Stored BlockPos pos, Block block, @Stored BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        level.m_46597_(pos, this.getState(level.m_8055_(pos), (LevelAccessor)level, pos));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, @NotStored BlockPos pos, CollisionContext ctx) {
        return ShapeCache.getOrCompute(state, FancyCableBlock::getShape);
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState facingState, LevelAccessor world, @NotStored BlockPos pos, @NotStored BlockPos facingPos) {
        return this.getState(state, world, pos);
    }

    @Override
    public BlockState getStateForPlacementByFacadePlan(LevelAccessor level, @NotStored BlockPos pos, @Nullable FacadeTransparency facadeTransparency) {
        return this.getState(this.m_49966_(), level, pos);
    }

    protected static VoxelShape getShape(BlockState state) {
        VoxelShape shape = SHAPE_CORE;
        shape = FancyCableBlock.combineShapes(shape, SHAPE_NORTH, () -> (Boolean)state.m_61143_((Property)NORTH));
        shape = FancyCableBlock.combineShapes(shape, SHAPE_SOUTH, () -> (Boolean)state.m_61143_((Property)SOUTH));
        shape = FancyCableBlock.combineShapes(shape, SHAPE_EAST, () -> (Boolean)state.m_61143_((Property)EAST));
        shape = FancyCableBlock.combineShapes(shape, SHAPE_WEST, () -> (Boolean)state.m_61143_((Property)WEST));
        shape = FancyCableBlock.combineShapes(shape, SHAPE_UP, () -> (Boolean)state.m_61143_((Property)UP));
        shape = FancyCableBlock.combineShapes(shape, SHAPE_DOWN, () -> (Boolean)state.m_61143_((Property)DOWN));
        return shape;
    }

    protected static VoxelShape combineShapes(VoxelShape shape1, VoxelShape shape2, Supplier<Boolean> condition) {
        return condition.get() != false ? Shapes.m_83110_((VoxelShape)shape1, (VoxelShape)shape2) : shape1;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{NORTH, SOUTH, EAST, WEST, UP, DOWN});
    }

    protected BlockState getState(BlockState currentState, LevelAccessor level, @NotStored BlockPos pos) {
        boolean north = this.hasConnection(level, pos, Direction.NORTH);
        boolean south = this.hasConnection(level, pos, Direction.SOUTH);
        boolean east = this.hasConnection(level, pos, Direction.EAST);
        boolean west = this.hasConnection(level, pos, Direction.WEST);
        boolean up = this.hasConnection(level, pos, Direction.UP);
        boolean down = this.hasConnection(level, pos, Direction.DOWN);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)currentState.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(north))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(south))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(east))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(west))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(up))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(down));
    }

    protected boolean hasConnection(LevelAccessor level, @NotStored BlockPos pos, Direction direction) {
        BlockPos relative = pos.m_121945_(direction);
        if (level.m_8055_(relative).m_60734_() instanceof ICableBlock) {
            return true;
        }
        BlockEntity blockEntity = level.m_7702_(relative);
        if (blockEntity == null) {
            return false;
        }
        return SFMResourceTypes.getCapabilities().anyMatch(cap -> blockEntity.getCapability(cap, direction).isPresent());
    }
}

