/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.screen;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.ClientTranslationHelpers;
import ca.teamdman.sfm.client.ProgramSyntaxHighlightingHelper;
import ca.teamdman.sfm.client.gui.screen.ProgramEditorScreen;
import ca.teamdman.sfm.client.gui.screen.SFMFontUtils;
import ca.teamdman.sfm.client.gui.screen.SFMScreenRenderUtils;
import ca.teamdman.sfm.client.gui.widget.SFMButtonBuilder;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.diagnostics.SFMDiagnostics;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.logging.TranslatableLogEvent;
import ca.teamdman.sfm.common.net.ServerboundManagerClearLogsPacket;
import ca.teamdman.sfm.common.net.ServerboundManagerLogDesireUpdatePacket;
import ca.teamdman.sfm.common.net.ServerboundManagerSetLogLevelPacket;
import ca.teamdman.sfm.common.registry.SFMPackets;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.MultilineTextField;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.core.time.MutableInstant;
import org.joml.Matrix4f;

public class LogsScreen
extends Screen {
    private final ManagerContainerMenu MENU;
    private MyMultiLineEditBox textarea;
    private List<MutableComponent> content = Collections.emptyList();
    private int lastSize = 0;
    private Map<Level, Button> levelButtons = new HashMap<Level, Button>();
    private String lastKnownLogLevel;

    public LogsScreen(ManagerContainerMenu menu) {
        super((Component)LocalizationKeys.LOGS_SCREEN_TITLE.getComponent());
        this.MENU = menu;
        this.lastKnownLogLevel = this.MENU.logLevel;
    }

    public boolean m_7043_() {
        return false;
    }

    private boolean shouldRebuildText() {
        return this.MENU.logs.size() != this.lastSize;
    }

    private void rebuildText() {
        ArrayList<MutableComponent> processedLogs = new ArrayList<MutableComponent>();
        ArrayDeque<TranslatableLogEvent> toProcess = this.MENU.logs;
        if (toProcess.isEmpty() && this.MENU.logLevel.equals(Level.OFF.name())) {
            MutableInstant instant = new MutableInstant();
            instant.initFromEpochMilli(System.currentTimeMillis(), 0);
            toProcess.add(new TranslatableLogEvent(Level.INFO, (Instant)instant, LocalizationKeys.LOGS_GUI_NO_CONTENT.get()));
        }
        for (TranslatableLogEvent log : toProcess) {
            int seconds = (int)(System.currentTimeMillis() - log.instant().getEpochMillisecond()) / 1000;
            int minutes = seconds / 60;
            MutableComponent ago = Component.m_237113_((String)(minutes + "m" + (seconds %= 60) + "s ago")).m_130940_(ChatFormatting.GRAY);
            MutableComponent level = Component.m_237113_((String)(" [" + log.level() + "] "));
            if (log.level() == Level.ERROR) {
                level = level.m_130940_(ChatFormatting.RED);
            } else if (log.level() == Level.WARN) {
                level = level.m_130940_(ChatFormatting.YELLOW);
            } else if (log.level() == Level.INFO) {
                level = level.m_130940_(ChatFormatting.GREEN);
            } else if (log.level() == Level.DEBUG) {
                level = level.m_130940_(ChatFormatting.AQUA);
            } else if (log.level() == Level.TRACE) {
                level = level.m_130940_(ChatFormatting.DARK_GRAY);
            }
            String[] lines = ClientTranslationHelpers.resolveTranslation(log.contents()).split("\n", -1);
            StringBuilder codeBlock = new StringBuilder();
            boolean insideCodeBlock = false;
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (line.equals("```")) {
                    if (insideCodeBlock) {
                        List<MutableComponent> codeLines = ProgramSyntaxHighlightingHelper.withSyntaxHighlighting(codeBlock.toString(), false);
                        processedLogs.addAll(codeLines);
                        codeBlock = new StringBuilder();
                        continue;
                    }
                    insideCodeBlock = true;
                    continue;
                }
                if (insideCodeBlock) {
                    codeBlock.append(line).append("\n");
                    continue;
                }
                MutableComponent lineComponent = Component.m_237113_((String)line).m_130940_(ChatFormatting.WHITE);
                if (i == 0) {
                    lineComponent = ago.m_7220_((Component)level).m_7220_((Component)lineComponent);
                }
                processedLogs.add(lineComponent);
            }
        }
        this.content = processedLogs;
        StringBuilder sb = new StringBuilder();
        for (MutableComponent line : this.content) {
            sb.append(line.getString()).append("\n");
        }
        this.textarea.m_240159_(sb.toString());
        this.lastSize = this.MENU.logs.size();
    }

    public boolean isReadOnly() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return player == null || player.m_5833_();
    }

    public void onLogLevelChange() {
        for (Map.Entry<Level, Button> entry : this.levelButtons.entrySet()) {
            Level level = entry.getKey();
            Button button = entry.getValue();
            button.f_93623_ = !this.MENU.logLevel.equals(level.name());
        }
        this.lastKnownLogLevel = this.MENU.logLevel;
    }

    protected void m_7856_() {
        Level[] levelArray;
        super.m_7856_();
        assert (this.f_96541_ != null);
        this.textarea = (MyMultiLineEditBox)this.m_142416_((GuiEventListener)new MyMultiLineEditBox());
        this.rebuildText();
        this.m_264313_((GuiEventListener)this.textarea);
        if (this.isReadOnly()) {
            levelArray = new Level[]{};
        } else {
            Level[] levelArray2 = new Level[6];
            levelArray2[0] = Level.OFF;
            levelArray2[1] = Level.TRACE;
            levelArray2[2] = Level.DEBUG;
            levelArray2[3] = Level.INFO;
            levelArray2[4] = Level.WARN;
            levelArray = levelArray2;
            levelArray2[5] = Level.ERROR;
        }
        Level[] buttons = levelArray;
        int buttonWidth = 60;
        int buttonHeight = 20;
        int spacing = 5;
        int startX = (this.f_96543_ - (buttonWidth * buttons.length + spacing * 4)) / 2;
        int startY = this.f_96544_ / 2 - 115;
        int buttonIndex = 0;
        this.levelButtons = new HashMap<Level, Button>();
        for (Level level : buttons) {
            Button levelButton = new SFMButtonBuilder().setSize(buttonWidth, buttonHeight).setPosition(startX + (buttonWidth + spacing) * buttonIndex, startY).setText((Component)Component.m_237113_((String)level.name())).setOnPress(button -> {
                String logLevel = level.name();
                SFMPackets.sendToServer(new ServerboundManagerSetLogLevelPacket(this.MENU.f_38840_, this.MENU.MANAGER_POSITION, logLevel));
                this.MENU.logLevel = logLevel;
                this.onLogLevelChange();
            }).build();
            this.levelButtons.put(level, levelButton);
            this.m_142416_((GuiEventListener)levelButton);
            ++buttonIndex;
        }
        this.onLogLevelChange();
        this.m_142416_((GuiEventListener)new SFMButtonBuilder().setPosition(this.f_96543_ / 2 - 200, this.f_96544_ / 2 - 100 + 195).setSize(80, 20).setText(LocalizationKeys.LOGS_GUI_COPY_LOGS_BUTTON).setOnPress(this::onCopyLogsClicked).setTooltip((Screen)this, this.f_96547_, LocalizationKeys.LOGS_GUI_COPY_LOGS_BUTTON_TOOLTIP).build());
        this.m_142416_((GuiEventListener)new SFMButtonBuilder().setPosition(this.f_96543_ / 2 - 2 - 100, this.f_96544_ / 2 - 100 + 195).setSize(200, 20).setText(CommonComponents.f_130655_).setOnPress(p_97691_ -> this.m_7379_()).setTooltip((Screen)this, this.f_96547_, LocalizationKeys.PROGRAM_EDIT_SCREEN_DONE_BUTTON_TOOLTIP).build());
        if (!this.isReadOnly()) {
            this.m_142416_((GuiEventListener)new SFMButtonBuilder().setPosition(this.f_96543_ / 2 - 2 + 115, this.f_96544_ / 2 - 100 + 195).setSize(80, 20).setText(LocalizationKeys.LOGS_GUI_CLEAR_LOGS_BUTTON).setOnPress(button -> {
                SFMPackets.sendToServer(new ServerboundManagerClearLogsPacket(this.MENU.f_38840_, this.MENU.MANAGER_POSITION));
                this.MENU.logs.clear();
            }).build());
        }
    }

    private void onCopyLogsClicked(Button button) {
        StringBuilder clip = new StringBuilder();
        clip.append(SFMDiagnostics.getDiagnosticsSummary(this.MENU.getDisk()));
        clip.append("\n-- LOGS --\n");
        if (LogsScreen.m_96638_()) {
            for (TranslatableLogEvent log : this.MENU.logs) {
                clip.append(log.level().name()).append(" ");
                clip.append(log.instant().toString()).append(" ");
                clip.append(log.contents().m_237508_());
                for (Object arg : log.contents().m_237523_()) {
                    clip.append(" ").append(arg);
                }
                clip.append("\n");
            }
        } else {
            for (MutableComponent line : this.content) {
                clip.append(line.getString()).append("\n");
            }
        }
        Minecraft.m_91087_().f_91068_.m_90911_(clip.toString());
    }

    public void m_7379_() {
        SFMPackets.sendToServer(new ServerboundManagerLogDesireUpdatePacket(this.MENU.f_38840_, this.MENU.MANAGER_POSITION, false));
        super.m_7379_();
    }

    public void scrollToBottom() {
        this.textarea.scrollToBottom();
    }

    public void m_6574_(Minecraft mc, int x, int y) {
        String prev = this.textarea.m_239249_();
        this.m_6575_(mc, x, y);
        super.m_6574_(mc, x, y);
        this.textarea.m_240159_(prev);
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        if (!this.MENU.logLevel.equals(this.lastKnownLogLevel)) {
            this.onLogLevelChange();
        }
    }

    private class MyMultiLineEditBox
    extends MultiLineEditBox {
        public MyMultiLineEditBox() {
            super(LogsScreen.this.f_96547_, LogsScreen.this.f_96543_ / 2 - 200, LogsScreen.this.f_96544_ / 2 - 90, 400, 180, (Component)Component.m_237113_((String)""), (Component)Component.m_237113_((String)""));
        }

        public void scrollToBottom() {
            this.m_240206_(Double.MAX_VALUE);
        }

        public void m_240159_(String p_240160_) {
            this.f_238540_.m_239677_(p_240160_);
        }

        public boolean m_6375_(double p_239101_, double p_239102_, int p_239103_) {
            try {
                return super.m_6375_(p_239101_, p_239102_, p_239103_);
            }
            catch (Exception e) {
                SFM.LOGGER.error("Error in LogsScreen.MyMultiLineEditBox.mouseClicked", (Throwable)e);
                return false;
            }
        }

        public int m_239019_() {
            Objects.requireNonNull(this.f_238790_);
            return 9 * (LogsScreen.this.content.size() + 2);
        }

        protected void m_239197_(GuiGraphics pGuiGraphics, int mx, int my, float partialTicks) {
            PoseStack poseStack = pGuiGraphics.m_280168_();
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            if (LogsScreen.this.shouldRebuildText()) {
                LogsScreen.this.rebuildText();
            }
            boolean isCursorVisible = this.m_93696_() && this.f_238824_ / 6 % 2 == 0;
            boolean isCursorAtEndOfLine = false;
            int cursorIndex = this.f_238540_.m_239456_();
            int lineX = SFMScreenRenderUtils.getX((AbstractWidget)this) + this.m_239244_();
            int lineY = SFMScreenRenderUtils.getY((AbstractWidget)this) + this.m_239244_();
            int charCount = 0;
            int cursorX = 0;
            int cursorY = 0;
            MultilineTextField.StringView selectedRange = this.f_238540_.m_239982_();
            int selectionStart = selectedRange.f_238590_();
            int selectionEnd = selectedRange.f_238654_();
            for (int line = Math.max(0, LogsScreen.this.content.size() - 500); line < LogsScreen.this.content.size(); ++line) {
                MutableComponent componentColoured = LogsScreen.this.content.get(line);
                int lineLength = componentColoured.getString().length();
                Objects.requireNonNull(this.f_238790_);
                int lineHeight = 9 + (line == 0 ? 2 : 0);
                boolean cursorOnThisLine = isCursorVisible && cursorIndex >= charCount && cursorIndex <= charCount + lineLength;
                MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                if (cursorOnThisLine) {
                    isCursorAtEndOfLine = cursorIndex == charCount + lineLength;
                    cursorY = lineY;
                    cursorX = SFMFontUtils.drawInBatch((Component)ProgramEditorScreen.substring(componentColoured, 0, cursorIndex - charCount), this.f_238790_, (float)lineX, (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer) - 1;
                    SFMFontUtils.drawInBatch((Component)ProgramEditorScreen.substring(componentColoured, cursorIndex - charCount, lineLength), this.f_238790_, (float)cursorX, (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer);
                } else {
                    SFMFontUtils.drawInBatch((Component)componentColoured, this.f_238790_, (float)lineX, (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer);
                }
                buffer.m_109911_();
                if (selectionStart <= charCount + lineLength && selectionEnd > charCount) {
                    int lineSelectionStart = Math.max(selectionStart - charCount, 0);
                    int lineSelectionEnd = Math.min(selectionEnd - charCount, lineLength);
                    int highlightStartX = this.f_238790_.m_92852_((FormattedText)ProgramEditorScreen.substring(componentColoured, 0, lineSelectionStart));
                    int highlightEndX = this.f_238790_.m_92852_((FormattedText)ProgramEditorScreen.substring(componentColoured, 0, lineSelectionEnd));
                    SFMScreenRenderUtils.renderHighlight(pGuiGraphics, lineX + highlightStartX, lineY, lineX + highlightEndX, lineY + lineHeight);
                }
                lineY += lineHeight;
                charCount += lineLength + 1;
            }
            if (isCursorAtEndOfLine) {
                SFMFontUtils.draw(pGuiGraphics, this.f_238790_, "_", cursorX, cursorY, -1, true);
            } else {
                pGuiGraphics.m_280509_(cursorX, cursorY - 1, cursorX + 1, cursorY + 1 + 9, -1);
            }
        }
    }
}

